/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.util.Escape;

class Dipole {
    String thisID = "";
    short mad;
    short colix = 0;
    short type;
    Point3f origin;
    Point3f center;
    Vector3f vector;
    String dipoleInfo = "";
    float dipoleValue;
    boolean isUserValue;
    float offsetSide;
    float offsetAngstroms;
    int offsetPercent;
    int visibilityFlags;
    int modelIndex;
    boolean visible;
    boolean noCross;
    boolean haveAtoms;
    boolean isValid;
    Atom[] atoms = new Atom[2];
    Point3f[] coords = new Point3f[2];
    Bond bond;
    static final short DIPOLE_TYPE_UNKNOWN = 0;
    static final short DIPOLE_TYPE_POINTS = 1;
    static final short DIPOLE_TYPE_ATOMS = 2;
    static final short DIPOLE_TYPE_BOND = 3;
    static final short DIPOLE_TYPE_MOLECULAR = 4;
    static final short DIPOLE_TYPE_POINTVECTOR = 5;

    Dipole() {
    }

    Dipole(int n, String string, String string2, short s, short s2, boolean bl) {
        this.modelIndex = n;
        this.thisID = string;
        this.dipoleInfo = string2;
        this.colix = s;
        this.mad = s2;
        this.visible = bl;
        this.type = 0;
    }

    void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, bl, f);
    }

    void set(String string, String string2, Atom[] atomArray, float f, short s, float f2, int n, float f3, Point3f point3f, Vector3f vector3f) {
        this.thisID = string;
        this.dipoleInfo = string2;
        this.dipoleValue = f;
        this.mad = s;
        this.offsetAngstroms = f2;
        this.offsetPercent = n;
        this.offsetSide = f3;
        this.vector = new Vector3f(vector3f);
        this.origin = new Point3f(point3f);
        boolean bl = this.haveAtoms = atomArray[0] != null;
        if (this.haveAtoms) {
            this.atoms[0] = atomArray[0];
            this.atoms[1] = atomArray[1];
            this.centerDipole();
        } else {
            this.center = null;
        }
    }

    private void set(Point3f point3f, Point3f point3f2) {
        this.coords[0] = new Point3f(point3f);
        this.coords[1] = new Point3f(point3f2);
        boolean bl = this.isValid = this.coords[0].distance(this.coords[1]) > 0.1f;
        if (this.dipoleValue < 0.0f) {
            this.origin = new Point3f(point3f2);
            this.vector = new Vector3f(point3f);
            this.dipoleValue = -this.dipoleValue;
        } else {
            this.origin = new Point3f(point3f);
            this.vector = new Vector3f(point3f2);
        }
        this.dipoleInfo = "" + this.origin + this.vector;
        this.vector.sub(this.origin);
        if (this.dipoleValue == 0.0f) {
            this.dipoleValue = this.vector.length();
        } else {
            this.vector.scale(this.dipoleValue / this.vector.length());
        }
        this.type = 1;
    }

    void set(float f) {
        float f2 = this.dipoleValue;
        this.dipoleValue = f;
        if (f == 0.0f) {
            this.isValid = false;
        }
        if (this.vector == null) {
            return;
        }
        this.vector.scale(this.dipoleValue / this.vector.length());
        if (f2 * this.dipoleValue < 0.0f) {
            this.origin.sub(this.vector);
        }
    }

    void set(Point3f point3f, Point3f point3f2, float f) {
        this.dipoleValue = f;
        this.atoms[0] = null;
        this.set(point3f, point3f2);
    }

    void set(Point3f point3f, Vector3f vector3f) {
        this.set(vector3f.length());
        Point3f point3f2 = new Point3f(point3f);
        point3f2.add(vector3f);
        this.set(point3f, point3f2);
        this.type = (short)5;
    }

    void set(Atom atom, Atom atom2, float f) {
        this.set(f);
        this.set((Point3f)atom, atom2);
        this.offsetSide = 0.4f;
        this.mad = (short)5;
        this.atoms[0] = atom;
        this.atoms[1] = atom2;
        this.haveAtoms = true;
        this.centerDipole();
    }

    void centerDipole() {
        boolean bl = this.isValid = this.atoms[0] != this.atoms[1] && this.dipoleValue != 0.0f;
        if (!this.isValid) {
            return;
        }
        float f = this.atoms[0].distance(this.atoms[1]) / (2.0f * this.dipoleValue) - 0.5f;
        this.origin.scaleAdd(f, this.vector, this.atoms[0]);
        this.center = new Point3f();
        this.center.scaleAdd(0.5f, this.vector, this.origin);
        this.bond = this.atoms[0].getBond(this.atoms[1]);
        this.type = (short)(this.bond == null ? 2 : 3);
    }

    boolean isBondType() {
        return this.type == 2 || this.type == 3;
    }

    public String getShapeState() {
        if (!this.isValid) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dipole ").append(this.thisID);
        if (this.haveAtoms) {
            stringBuffer.append(" ({").append(this.atoms[0].getAtomIndex()).append(" ").append(this.atoms[1].getAtomIndex()).append("})");
        } else {
            if (this.coords[0] == null) {
                return "";
            }
            stringBuffer.append(" ").append(Escape.escape(this.coords[0])).append(" ").append(Escape.escape(this.coords[1]));
        }
        if (this.isUserValue) {
            stringBuffer.append(" value ").append(this.dipoleValue);
        }
        if (this.mad != 5) {
            stringBuffer.append(" width ").append((float)this.mad / 1000.0f);
        }
        if (this.offsetAngstroms != 0.0f) {
            stringBuffer.append(" offset ").append(this.offsetAngstroms);
        } else if (this.offsetPercent != 0) {
            stringBuffer.append(" offset ").append(this.offsetPercent);
        }
        if (this.offsetSide != 0.4f) {
            stringBuffer.append(" offsetSide ").append(this.offsetSide);
        }
        if (this.noCross) {
            stringBuffer.append(" nocross");
        }
        if (!this.visible) {
            stringBuffer.append(" off");
        }
        stringBuffer.append(";\n");
        return stringBuffer.toString();
    }
}

