/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jcamp;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Container;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.jcamp.GraphCharacteristics;
import org.jmol.jcamp.SaisieDlg;
import org.jmol.jcamp.ZoneVisu;
import org.jmol.jcamp.utils.NumericDataUtils;
import org.jmol.jcamp.utils.StringDataUtils;

public class Visua
extends Applet
implements Runnable {
    ZoneVisu My_ZoneVisu;
    Thread My_Thread;
    private GraphCharacteristics _graphDataUtils;
    public Vector texte;
    public int nbLignes;
    int shitty_starting_constant = 66666;
    public double Firstx;
    public double Lastx;
    public double YFactor;
    public int Nbpoints;
    public double nmr_observe_frequency;
    public String TexteTitre;
    public String x_units;
    public String y_units;
    public String Datatype;
    Button Load_File;
    Button Zoom_In;
    Button Zoom_Back;
    Button Zoom_Out;
    Checkbox Reverse;
    Checkbox Grid;
    Checkbox Integrate;
    Button Find_Peak;
    Button JCamp;
    Frame Fenetre_Load_File;
    SaisieDlg Dialogue_Load_File;
    AppletContext contexte;
    String clickable_peaks_frame_name;
    boolean Flag_Zoomin = false;
    boolean Flag_Zoomback = false;
    boolean Flag_Zoomout = false;
    boolean Flag_Reverse = false;
    boolean Flag_Integrate = false;
    boolean Flag_Dialogue_File_Enabled = false;
    boolean Flag_Redraw = false;
    boolean Flag_Find_Peak = false;
    boolean Flag_Write_JCamp = false;
    boolean isActive = false;
    boolean hasPrivilege = false;
    boolean inNavigator = false;
    boolean inExplorer = false;
    FileDialog openDialog;
    FileDialog saveDialog;
    String Current_Error = "";

    public void init() {
        Container container;
        this.showStatus("Initializing jcamp/spc visualizer, please wait...");
        System.out.println("jcamp/spc visualizer v2.0.0 (c) G. Cottenceau 1998");
        if (this.inNavigator) {
            for (container = this.getParent(); container != null && !(container instanceof Frame); container = container.getParent()) {
            }
            this.saveDialog = new FileDialog((Frame)container, "Save JCAMP", 1);
        }
        this.setLayout(new BorderLayout());
        container = new Panel();
        container.setLayout(new GridLayout(1, 1));
        if (this.getParameter("INTEGRATE") != null && this.getParameter("INTEGRATE").compareTo("TRUE") == 0) {
            this.Integrate = new Checkbox("Integrate");
            container.add(this.Integrate);
        }
        if (this.getParameter("LOAD_FILE") != null && this.getParameter("LOAD_FILE").compareTo("SHOW") == 0) {
            container.add(this.Load_File);
        }
        this.add("South", container);
        this.My_ZoneVisu = new ZoneVisu();
        this.initGraphParameters();
        this.add("Center", this.My_ZoneVisu);
        this.layout();
        this.contexte = this.getAppletContext();
        this.clickable_peaks_frame_name = this.getParameter("CLICKABLE_PEAKS_FRAME_NAME");
        this.My_ZoneVisu.Y_Values = this.getParameter("Y_VALUES");
        this.My_ZoneVisu.ShowTitle = this.getParameter("TITLE");
        this.My_ZoneVisu.Flag_Clickable_Peaks = this.Load_Clickable_Peaks_Source_File(this.getParameter("CLICKABLE_PEAKS_SOURCE_FILE"));
        this.My_ZoneVisu.init();
        this.My_ZoneVisu.setGraphDataUtils(this._graphDataUtils);
        this.Really_Load_File(this.getParameter("SOURCE_FILE"));
        if (this.getParameter("CLICKABLE_PEAKS_FIRST_FRAME") != null) {
            this.My_ZoneVisu.Flag_Load_Now_Html = true;
            this.My_ZoneVisu.Name_Load_Now_Html = this.getParameter("CLICKABLE_PEAKS_FIRST_FRAME");
        }
    }

    private void initGraphParameters() {
        this._graphDataUtils = new GraphCharacteristics();
        if (this.getParameter("GRID") != null && this.getParameter("GRID").compareTo("TRUE") == 0) {
            this._graphDataUtils.setGrid(true);
            this.My_ZoneVisu.Flag_Grid = true;
        } else {
            this._graphDataUtils.setGrid(false);
        }
        if (this.getParameter("INTEGRATION_VALUES") != null) {
            this._graphDataUtils.setUnsortedIntegrationValues(this.getParameter("INTEGRATION_VALUES"));
        }
        if (this.getParameter("REVERSE") != null && this.getParameter("REVERSE").compareTo("TRUE") == 0) {
            this._graphDataUtils.setReverse(true);
            this.Flag_Reverse = true;
            this.My_ZoneVisu.reverse = true;
        }
        if (this.getParameter("AXIS_COLOR") != null) {
            this._graphDataUtils.setAxisColor(this.getParameter("AXIS_COLOR"));
        }
        if (this.getParameter("AXIS_TEXT_COLOR") != null) {
            this._graphDataUtils.setAxisTextColor(this.getParameter("AXIS_TEXT_COLOR"));
        }
        if (this.getParameter("INTEGRATE_CURVE_COLOR") != null) {
            this._graphDataUtils.setIntegrateCurveColor(this.getParameter("INTEGRATE_CURVE_COLOR"));
        }
        if (this.getParameter("INTEGRATE_TEXT_COLOR") != null) {
            this._graphDataUtils.setIntegrateTextColor(this.getParameter("INTEGRATE_TEXT_COLOR"));
        }
        if (this.getParameter("GRAPH_CURVE_COLOR") != null) {
            this._graphDataUtils.setGraphCurveColor(this.getParameter("GRAPH_CURVE_COLOR"));
        }
        if (this.getParameter("TEXT_COLOR") != null) {
            this._graphDataUtils.setTextColor(this.getParameter("TEXT_COLOR"));
        }
    }

    public void start() {
        if (this.My_Thread == null) {
            this.My_Thread = new Thread(this);
            this.My_Thread.start();
        }
        this.showStatus("Ready");
    }

    public void stop() {
        if (this.My_Thread != null) {
            this.My_Thread.stop();
            this.My_Thread = null;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.Flag_Zoomin) {
                System.out.println("Zooming in!");
                this.My_ZoneVisu.Zoomin();
                this.Flag_Zoomin = false;
            }
            if (this.Flag_Zoomback) {
                this.My_ZoneVisu.Zoomback();
                this.Flag_Zoomback = false;
            }
            if (this.Flag_Zoomout) {
                this.My_ZoneVisu.Zoomout();
                this.Flag_Zoomout = false;
            }
            if (this.Flag_Reverse) {
                this.My_ZoneVisu.Reverse();
                this.Flag_Reverse = false;
            }
            if (this.Flag_Integrate) {
                this.My_ZoneVisu.Flag_Integrate = true;
                this.My_ZoneVisu.Redraw();
                this.Flag_Integrate = false;
            }
            if (this.Flag_Find_Peak) {
                this.My_ZoneVisu.Find_Peak();
                this.Flag_Find_Peak = false;
            }
            if (this.Flag_Write_JCamp && this.getParameter("SOURCE_FILE").toLowerCase().endsWith("dx")) {
                this.Write_JCamp();
                this.Flag_Write_JCamp = false;
            }
            if (this.Flag_Redraw) {
                this.My_ZoneVisu.Redraw();
                this.Flag_Redraw = false;
            }
            if (this.My_ZoneVisu.Flag_Load_Now_Html) {
                this.My_ZoneVisu.Flag_Load_Now_Html = false;
                try {
                    this.contexte.showDocument(new URL(this.getDocumentBase(), this.My_ZoneVisu.Name_Load_Now_Html), this.clickable_peaks_frame_name);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!this.Flag_Dialogue_File_Enabled || !this.Dialogue_Load_File.fin) continue;
            this.Flag_Dialogue_File_Enabled = false;
            this.Dialogue_Load_File.fin = false;
            if (!this.Dialogue_Load_File.OkStatus) continue;
            this.Really_Load_File(this.Dialogue_Load_File.lisSaisie());
        }
    }

    public boolean Load_Clickable_Peaks_Source_File(String string) {
        String string2;
        Object object;
        if (string == null) {
            return false;
        }
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            InputStream inputStream = uRL.openStream();
            object = new DataInputStream(inputStream);
            this.texte = new Vector();
            while ((string2 = ((DataInputStream)object).readLine()) != null) {
                this.texte.addElement(string2);
            }
            this.My_ZoneVisu.Nb_Clickable_Peaks = this.texte.size();
        }
        catch (Exception exception) {
            return false;
        }
        this.My_ZoneVisu.Peak_Start = new double[this.My_ZoneVisu.Nb_Clickable_Peaks];
        this.My_ZoneVisu.Peak_Stop = new double[this.My_ZoneVisu.Nb_Clickable_Peaks];
        this.My_ZoneVisu.Peak_Html = new String[this.My_ZoneVisu.Nb_Clickable_Peaks];
        int n = 0;
        int n2 = 0;
        while (n < this.My_ZoneVisu.Nb_Clickable_Peaks) {
            do {
                string2 = (String)this.texte.elementAt(n);
                object = new StringTokenizer(string2, " ");
            } while (++n < this.My_ZoneVisu.Nb_Clickable_Peaks && !((StringTokenizer)object).hasMoreTokens());
            if (((StringTokenizer)object).hasMoreTokens()) {
                this.My_ZoneVisu.Peak_Start[n2] = Double.valueOf(((StringTokenizer)object).nextToken());
                this.My_ZoneVisu.Peak_Stop[n2] = Double.valueOf(((StringTokenizer)object).nextToken());
                if (this.My_ZoneVisu.Peak_Start[n2] > this.My_ZoneVisu.Peak_Stop[n2]) {
                    double d = this.My_ZoneVisu.Peak_Start[n2];
                    this.My_ZoneVisu.Peak_Start[n2] = this.My_ZoneVisu.Peak_Stop[n2];
                    this.My_ZoneVisu.Peak_Stop[n2] = d;
                }
                this.My_ZoneVisu.Peak_Html[n2] = ((StringTokenizer)object).nextToken();
            }
            ++n2;
        }
        return true;
    }

    public String Move_Points_To_Tableau() {
        String string;
        String string2;
        double[] dArray;
        int n;
        int n2 = 0;
        int n3 = this.Nbpoints;
        if (this.Datatype.compareTo("XYDATA") == 0) {
            while (StringDataUtils.jcampSubString((String)this.texte.elementAt(n2), 0, 8).compareTo("##XYDATA") != 0) {
                ++n2;
            }
            ++n2;
            n = 0;
            this.My_ZoneVisu.tableau_points = new double[this.Nbpoints];
            dArray = new double[this.Nbpoints];
            while (n3 > 0 && n2 < this.nbLignes) {
                StringTokenizer stringTokenizer;
                do {
                    string2 = (String)this.texte.elementAt(n2);
                    stringTokenizer = new StringTokenizer(string2, " ");
                } while (++n2 < this.nbLignes && !stringTokenizer.hasMoreTokens());
                if (!stringTokenizer.hasMoreTokens()) continue;
                string = stringTokenizer.nextToken();
                while (n3 > 0 && (stringTokenizer.hasMoreTokens() || string.indexOf(45) > 1)) {
                    string = string.indexOf(45) <= 1 ? stringTokenizer.nextToken() : string.substring(string.indexOf(45) + 1);
                    while (string.indexOf(45) > 1) {
                        --n3;
                        try {
                            this.My_ZoneVisu.tableau_points[n] = Double.valueOf(string.substring(0, string.indexOf(45)));
                        }
                        catch (Exception exception) {
                            return ", wrong number format";
                        }
                        ++n;
                        string = string.substring(string.indexOf(45) + 1);
                    }
                    --n3;
                    try {
                        this.My_ZoneVisu.tableau_points[n] = Double.valueOf(string);
                    }
                    catch (Exception exception) {
                        return ", wrong number format";
                    }
                    ++n;
                }
            }
            if (this.Firstx > this.Lastx) {
                int n4;
                for (n4 = 0; n4 < this.Nbpoints; ++n4) {
                    dArray[n4] = this.My_ZoneVisu.tableau_points[n4];
                }
                for (n4 = 0; n4 < this.Nbpoints; ++n4) {
                    this.My_ZoneVisu.tableau_points[n4] = dArray[this.Nbpoints - n4 - 1];
                }
                double d = this.Firstx;
                this.Firstx = this.Lastx;
                this.Lastx = d;
            }
        }
        if (this.Datatype.compareTo("PEAK TABLE") == 0) {
            while (((String)this.texte.elementAt(n2)).substring(0, 6).compareTo("##PEAK") != 0) {
                ++n2;
            }
            ++n2;
            n = 0;
            this.My_ZoneVisu.tableau_points = new double[this.Nbpoints * 2];
            dArray = new double[this.Nbpoints * 2];
            while (n3 > 0 && n2 < this.nbLignes) {
                StringTokenizer stringTokenizer;
                do {
                    string2 = (String)this.texte.elementAt(n2);
                    stringTokenizer = new StringTokenizer(string2, " ");
                } while (++n2 < this.nbLignes && !stringTokenizer.hasMoreTokens());
                if (!stringTokenizer.hasMoreTokens()) continue;
                while (n3 > 0 && stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    --n3;
                    this.My_ZoneVisu.tableau_points[n] = Double.valueOf(string.substring(0, string.indexOf(44)));
                    this.My_ZoneVisu.tableau_points[++n] = string.indexOf(44) == string.length() - 1 ? Double.valueOf(stringTokenizer.nextToken()).doubleValue() : Double.valueOf(string.substring(string.indexOf(44) + 1)).doubleValue();
                    ++n;
                }
            }
            if (this.Firstx == (double)this.shitty_starting_constant) {
                this.Firstx = this.My_ZoneVisu.tableau_points[0];
            }
            if (this.Lastx == (double)this.shitty_starting_constant) {
                this.Lastx = this.My_ZoneVisu.tableau_points[(this.Nbpoints - 1) * 2];
            }
            if (this.Firstx > this.Lastx) {
                int n5;
                for (n5 = 0; n5 < this.Nbpoints; ++n5) {
                    dArray[n5 * 2] = this.My_ZoneVisu.tableau_points[n5 * 2];
                }
                for (n5 = 0; n5 < this.Nbpoints; ++n5) {
                    this.My_ZoneVisu.tableau_points[n5 * 2] = dArray[this.Nbpoints * 2 - n5 * 2 - 1];
                }
                for (n5 = 0; n5 < this.Nbpoints; ++n5) {
                    dArray[n5 * 2 + 1] = this.My_ZoneVisu.tableau_points[n5 * 2 + 1];
                }
                for (n5 = 0; n5 < this.Nbpoints; ++n5) {
                    this.My_ZoneVisu.tableau_points[n5 * 2 + 1] = dArray[this.Nbpoints * 2 - n5 * 2];
                }
                double d = this.Firstx;
                this.Firstx = this.Lastx;
                this.Lastx = d;
            }
        }
        if (n3 > 0) {
            return ", file corrupted or unsupported file format";
        }
        return "OK";
    }

    public boolean initFile(String string) {
        String string2;
        Object object;
        Object object2;
        this.showStatus("Loading the file, please wait...");
        this.x_units = "?";
        this.y_units = "ARBITRARY";
        this.Datatype = "UNKNOWN";
        if (string.toLowerCase().endsWith(".spc")) {
            try {
                int n;
                URL uRL = new URL(this.getDocumentBase(), string);
                InputStream inputStream = uRL.openStream();
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                if (by != 0 && by != 32 || by2 != 75) {
                    this.Current_Error = ", support only Evenly Spaced new version 4B";
                    return false;
                }
                byte by3 = dataInputStream.readByte();
                if (by3 != 128) {
                    this.YFactor = Math.pow(2.0, by3) / Math.pow(2.0, 32.0);
                }
                this.Nbpoints = NumericDataUtils.convToIntelInt(dataInputStream.readInt());
                if (this.Firstx == (double)this.shitty_starting_constant) {
                    this.Firstx = NumericDataUtils.convToIntelDouble(dataInputStream.readLong());
                    this.Lastx = NumericDataUtils.convToIntelDouble(dataInputStream.readLong());
                }
                byte by4 = dataInputStream.readByte();
                switch (by4) {
                    case 0: {
                        this.x_units = "Arbitrary";
                        break;
                    }
                    case 1: {
                        this.x_units = "Wavenumber (cm -1)";
                        break;
                    }
                    case 2: {
                        this.x_units = "Micrometers";
                        break;
                    }
                    case 3: {
                        this.x_units = "Nanometers";
                        break;
                    }
                    case 4: {
                        this.x_units = "Seconds";
                        break;
                    }
                    case 5: {
                        this.x_units = "Minuts";
                        break;
                    }
                    case 6: {
                        this.x_units = "Hertz";
                        break;
                    }
                    case 7: {
                        this.x_units = "Kilohertz";
                        break;
                    }
                    case 8: {
                        this.x_units = "Megahertz";
                        break;
                    }
                    case 9: {
                        this.x_units = "Mass (M/z)";
                        break;
                    }
                    case 10: {
                        this.x_units = "Parts per million";
                        break;
                    }
                    case 11: {
                        this.x_units = "Days";
                        break;
                    }
                    case 12: {
                        this.x_units = "Years";
                        break;
                    }
                    case 13: {
                        this.x_units = "Raman Shift (cm -1)";
                        break;
                    }
                    case 14: {
                        this.x_units = "Electron Volt (eV)";
                        break;
                    }
                    case 16: {
                        this.x_units = "Diode Number";
                        break;
                    }
                    case 17: {
                        this.x_units = "Channel";
                        break;
                    }
                    case 18: {
                        this.x_units = "Degrees";
                        break;
                    }
                    case 19: {
                        this.x_units = "Temperature (F)";
                        break;
                    }
                    case 20: {
                        this.x_units = "Temperature (C)";
                        break;
                    }
                    case 21: {
                        this.x_units = "Temperature (K)";
                        break;
                    }
                    case 22: {
                        this.x_units = "Data Points";
                        break;
                    }
                    case 23: {
                        this.x_units = "Milliseconds (mSec)";
                        break;
                    }
                    case 24: {
                        this.x_units = "Microseconds (uSec)";
                        break;
                    }
                    case 25: {
                        this.x_units = "Nanoseconds (nSec)";
                        break;
                    }
                    case 26: {
                        this.x_units = "Gigahertz (GHz)";
                        break;
                    }
                    case 27: {
                        this.x_units = "Centimeters (cm)";
                        break;
                    }
                    case 28: {
                        this.x_units = "Meters (m)";
                        break;
                    }
                    case 29: {
                        this.x_units = "Millimeters (mm)";
                        break;
                    }
                    case 30: {
                        this.x_units = "Hours";
                        break;
                    }
                    case -1: {
                        this.x_units = "(double interferogram)";
                    }
                }
                byte by5 = dataInputStream.readByte();
                switch (by5) {
                    case 0: {
                        this.y_units = "Arbitrary Intensity";
                        break;
                    }
                    case 1: {
                        this.y_units = "Interfeogram";
                        break;
                    }
                    case 2: {
                        this.y_units = "Absorbance";
                        break;
                    }
                    case 3: {
                        this.y_units = "Kubelka-Munk";
                        break;
                    }
                    case 4: {
                        this.y_units = "Counts";
                        break;
                    }
                    case 5: {
                        this.y_units = "Volts";
                        break;
                    }
                    case 6: {
                        this.y_units = "Degrees";
                        break;
                    }
                    case 7: {
                        this.y_units = "Milliamps";
                        break;
                    }
                    case 8: {
                        this.y_units = "Millimeters";
                        break;
                    }
                    case 9: {
                        this.y_units = "Millivolts";
                        break;
                    }
                    case 10: {
                        this.y_units = "Log (1/R)";
                        break;
                    }
                    case 11: {
                        this.y_units = "Percent";
                        break;
                    }
                    case 12: {
                        this.y_units = "Intensity";
                        break;
                    }
                    case 13: {
                        this.y_units = "Relative Intensity";
                        break;
                    }
                    case 14: {
                        this.y_units = "Energy";
                        break;
                    }
                    case 16: {
                        this.y_units = "Decibel";
                        break;
                    }
                    case 19: {
                        this.y_units = "Temperature (F)";
                        break;
                    }
                    case 20: {
                        this.y_units = "Temperature (C)";
                        break;
                    }
                    case 21: {
                        this.y_units = "Temperature (K)";
                        break;
                    }
                    case 22: {
                        this.y_units = "Index of Refraction [N]";
                        break;
                    }
                    case 23: {
                        this.y_units = "Extinction Coeff. [K]";
                        break;
                    }
                    case 24: {
                        this.y_units = "Real";
                        break;
                    }
                    case 25: {
                        this.y_units = "Imaginary";
                        break;
                    }
                    case 26: {
                        this.y_units = "Complex";
                        break;
                    }
                    case -128: {
                        this.y_units = "Transmission";
                        break;
                    }
                    case -127: {
                        this.y_units = "Reflectance";
                        break;
                    }
                    case -126: {
                        this.y_units = "Arbitrary or Single Beam with Valley Peaks";
                        break;
                    }
                    case -125: {
                        this.y_units = "Emission";
                    }
                }
                if (by == 0) {
                    dataInputStream.skipBytes(482);
                } else {
                    dataInputStream.skipBytes(188);
                    int n2 = 0;
                    this.x_units = "";
                    do {
                        n = dataInputStream.readByte();
                        this.x_units = this.x_units + (char)n;
                        ++n2;
                    } while (n != 0);
                    int n3 = 0;
                    this.y_units = "";
                    do {
                        n = dataInputStream.readByte();
                        this.y_units = this.y_units + (char)n;
                        ++n3;
                    } while (n != 0);
                    dataInputStream.skipBytes(294 - n2 - n3);
                }
                dataInputStream.skipBytes(32);
                this.My_ZoneVisu.tableau_points = new double[this.Nbpoints];
                if (by3 == 128) {
                    for (n = 0; n < this.Nbpoints; ++n) {
                        this.My_ZoneVisu.tableau_points[n] = NumericDataUtils.convToIntelFloat(dataInputStream.readInt());
                    }
                } else {
                    for (n = 0; n < this.Nbpoints; ++n) {
                        this.My_ZoneVisu.tableau_points[n] = NumericDataUtils.convToIntelInt(dataInputStream.readInt());
                    }
                }
            }
            catch (Exception exception) {
                this.Current_Error = "SPC file corrupted";
                return false;
            }
            this.Datatype = "XYDATA";
            return true;
        }
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            object2 = uRL.openStream();
            object = new BufferedReader(new InputStreamReader((InputStream)object2));
            this.texte = new Vector();
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                this.texte.addElement(string2);
            }
            this.nbLignes = this.texte.size();
        }
        catch (Exception exception) {
            return false;
        }
        int n = 0;
        object2 = "";
        while (n < this.nbLignes) {
            try {
                do {
                    object2 = (String)this.texte.elementAt(n);
                    object = new StringTokenizer((String)object2, " ");
                } while (++n < this.nbLignes && !((StringTokenizer)object).hasMoreTokens());
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object).nextToken();
                if (StringDataUtils.compareStrings(string2, "##TITLE=") == 0) {
                    this.TexteTitre = ((String)object2).substring(9);
                }
                if (StringDataUtils.compareStrings(string2, "##FIRSTX=") == 0) {
                    this.Firstx = Double.valueOf(((StringTokenizer)object).nextToken());
                }
                if (StringDataUtils.compareStrings(string2, "##LASTX=") == 0) {
                    this.Lastx = Double.valueOf(((StringTokenizer)object).nextToken());
                }
                if (StringDataUtils.compareStrings(string2, "##YFACTOR=") == 0) {
                    this.YFactor = Double.valueOf(((StringTokenizer)object).nextToken());
                }
                if (StringDataUtils.compareStrings(string2, "##NPOINTS=") == 0) {
                    this.Nbpoints = Integer.valueOf(((StringTokenizer)object).nextToken());
                }
                if (StringDataUtils.compareStrings(string2, "##XUNITS=") == 0) {
                    this.x_units = ((String)object2).substring(10);
                }
                if (StringDataUtils.compareStrings(string2, "##YUNITS=") == 0) {
                    this.y_units = ((String)object2).substring(10);
                }
                if (StringDataUtils.compareStrings(string2, "##.OBSERVE") == 0 && StringDataUtils.compareStrings(((StringTokenizer)object).nextToken(), "FREQUENCY=") == 0) {
                    this.nmr_observe_frequency = Double.valueOf(((StringTokenizer)object).nextToken());
                }
                if (StringDataUtils.compareStrings(string2, "##XYDATA=") == 0 && StringDataUtils.compareStrings(((StringTokenizer)object).nextToken(), "(X++(Y..Y))") == 0) {
                    this.Datatype = "XYDATA";
                }
                if (StringDataUtils.compareStrings(string2, "##XYDATA=(X++(Y..Y))") == 0) {
                    this.Datatype = "XYDATA";
                }
                if (StringDataUtils.compareStrings(string2, "##PEAK") == 0 && StringDataUtils.compareStrings(((StringTokenizer)object).nextToken(), "TABLE=") == 0 && StringDataUtils.compareStrings(((StringTokenizer)object).nextToken(), "(XY..XY)") == 0) {
                    this.Datatype = "PEAK TABLE";
                }
                if (StringDataUtils.compareStrings(string2, "##PEAK") != 0 || StringDataUtils.compareStrings(((StringTokenizer)object).nextToken(), "TABLE=(XY..XY)") != 0) continue;
                this.Datatype = "PEAK TABLE";
            }
            catch (Exception exception) {}
        }
        if (this.Datatype.compareTo("UNKNOWN") == 0) {
            return false;
        }
        if (this.Datatype.compareTo("PEAK TABLE") == 0 && this.x_units.compareTo("?") == 0) {
            this.x_units = "M/Z";
        }
        if (StringDataUtils.truncateEndBlanks(this.x_units).compareTo("HZ") == 0 && this.nmr_observe_frequency != (double)this.shitty_starting_constant) {
            this.Firstx /= this.nmr_observe_frequency;
            this.Lastx /= this.nmr_observe_frequency;
            this.x_units = "PPM.";
        }
        if (((String)(object = this.Move_Points_To_Tableau())).compareTo("OK") != 0) {
            this.Current_Error = object;
            return false;
        }
        return true;
    }

    public void Really_Load_File(String string) {
        this.Firstx = this.shitty_starting_constant;
        this.Lastx = this.shitty_starting_constant;
        this.Nbpoints = this.shitty_starting_constant;
        this.nmr_observe_frequency = this.shitty_starting_constant;
        this.TexteTitre = "";
        this.YFactor = 1.0;
        this.My_ZoneVisu.Draw_Texte("Drawing graphics, please wait...");
        if (this.initFile(string)) {
            this.My_ZoneVisu.Init_File();
            if (this.Flag_Reverse) {
                this.My_ZoneVisu.Flag_Reverse = true;
            } else {
                this.Flag_Redraw = true;
            }
        } else {
            this.My_ZoneVisu.Draw_Texte("Bad file or filename" + this.Current_Error);
        }
    }

    public void Write_JCamp() {
        String string = this.getParameter("SOURCE_FILE").toLowerCase();
        int n = string.lastIndexOf("/") + 1;
        if (n == -1) {
            n = 0;
        }
        string = string.substring(n, string.length());
        System.out.println("FileName : " + string);
        try {
            if (this.inNavigator) {
                this.saveDialog.setFile(string);
                this.saveDialog.show();
                String string2 = this.saveDialog.getDirectory();
                string = string2 + this.saveDialog.getFile();
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            for (int i = 0; i < this.texte.size(); ++i) {
                String string3 = (String)this.texte.elementAt(i);
                printWriter.println(string3);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println("\nClient: Unable to write local JCAMP-DX file. " + exception);
        }
    }

    public void Do_Zoomin() {
        this.My_ZoneVisu.Draw_Texte("Zooming in, please wait...");
        this.Flag_Zoomin = true;
    }

    public void Do_Zoomback() {
        this.My_ZoneVisu.Draw_Texte("Zooming back, please wait...");
        this.Flag_Zoomback = true;
    }

    public void Do_Zoomout() {
        this.My_ZoneVisu.Draw_Texte("Drawing whole graphics, please wait...");
        this.Flag_Zoomout = true;
    }

    public void Do_Grid() {
        this.My_ZoneVisu.Draw_Texte("Redrawing with grid, please wait...");
        this.Flag_Redraw = true;
    }

    public void Do_Reverse() {
        this.My_ZoneVisu.Draw_Texte("Reversing graphics, please wait...");
        this.My_ZoneVisu.Flag_Reverse = this.Reverse.getState();
        this.Flag_Reverse = true;
    }

    public void Do_Integrate() {
        if (this.Integrate.getState()) {
            this.My_ZoneVisu.Draw_Texte("Integrating peaks, please wait...");
            this.Flag_Integrate = true;
        } else {
            this.My_ZoneVisu.Flag_Integrate = false;
            this.My_ZoneVisu.Draw_Texte("Redrawing graphics, please wait...");
            this.Flag_Redraw = true;
        }
    }

    public void Do_Find_Peak() {
        this.My_ZoneVisu.Draw_Texte("Finding peak, please wait...");
        this.Flag_Find_Peak = true;
    }

    public void Do_Write_JCamp() {
        this.Flag_Write_JCamp = true;
    }

    public void Do_Load_File() {
        Frame frame = (Frame)this.getParent();
        this.Dialogue_Load_File = new SaisieDlg(frame, "Load file...", "Enter the filename :");
        this.Dialogue_Load_File.show();
        this.Flag_Dialogue_File_Enabled = true;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.Load_File && event.id == 1001) {
            this.Do_Load_File();
            return true;
        }
        if (event.target == this.Zoom_In && event.id == 1001) {
            this.Do_Zoomin();
            return true;
        }
        if (event.target == this.Zoom_Back && event.id == 1001) {
            this.Do_Zoomback();
            return true;
        }
        if (event.target == this.Zoom_Out && event.id == 1001) {
            this.Do_Zoomout();
            return true;
        }
        if (event.target == this.Reverse && event.id == 1001) {
            this.Do_Reverse();
            return true;
        }
        if (event.target == this.Grid && event.id == 1001) {
            this.Do_Grid();
            return true;
        }
        if (event.target == this.Integrate && event.id == 1001) {
            this.Do_Integrate();
            return true;
        }
        if (event.target == this.Find_Peak && event.id == 1001) {
            this.Do_Find_Peak();
            return true;
        }
        if (event.target == this.JCamp && event.id == 1001) {
            this.Do_Write_JCamp();
            return true;
        }
        return super.handleEvent(event);
    }
}

