/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.jep.FableJep;
import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FabioFile;
import fable.framework.toolbox.Peak;
import fable.framework.toolbox.PeakSearchSpt;
import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.actions.ImageCopyAction;
import fable.imageviewer.actions.ImageInfoAction;
import fable.imageviewer.actions.InputSummaryAction;
import fable.imageviewer.actions.ResetZoomAction;
import fable.imageviewer.actions.Slice2DAction;
import fable.imageviewer.actions.ZoomAreaAction;
import fable.imageviewer.actions.ZoomLineAction;
import fable.imageviewer.actions.ZoomProfileAction;
import fable.imageviewer.actions.ZoomReliefAction;
import fable.imageviewer.actions.ZoomRockingAction;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.CustomCoordinatesDialog;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.PaletteUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IPropertyChangeListener,
IImagesVarKeys,
ISelectionListener {
    private static final boolean RESET_IMAGEMODEL = false;
    private static final boolean debug = false;
    private static final float ZOOMFACTOR_LARGE = 0.5f;
    public static final String ID = "fable.imageviewer.views.ImageView";
    public static ImageView view = null;
    private SampleController controller = SampleController.getController();
    private Display display;
    private FabioFile fabioFile = null;
    private ImageModel imageModel = null;
    private ImageModel imageDiffModel = null;
    private ImageModel savedImageModel = null;
    private String fileNameSaved = "";
    private Composite canvasComposite;
    private Canvas imageCanvas;
    private boolean imageChanged = true;
    private GC imageCanvasGC;
    private int xCanvas;
    private int yCanvas;
    private Image image = null;
    private ImageData imageData;
    private Vector<Float> peaks;
    double xScale;
    double yScale;
    private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private Rectangle origRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedOrigRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedRect = new Rectangle(0, 0, 0, 0);
    private int coordOrigin = 0;
    private Coordinates coordinates = new Coordinates();
    private static double x0Save = 0.0;
    private static double y0Save = 0.0;
    private static double pixelWidthSave = 1.0;
    private static double pixelHeightSave = 1.0;
    private static String xNameSave = "x";
    private static String yNameSave = "y";
    static boolean customSavedParametersInitialized = false;
    private int orientation = 0;
    private ZoomSelection zoomSelection = ZoomSelection.AREA;
    private Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    private Boolean selectingOn = false;
    private Boolean selectOn = false;
    private Boolean peaksOn = false;
    private Boolean autoscale = true;
    private Boolean newSelection = true;
    private Composite controlComposite = null;
    private boolean controlCompositeShowing = false;
    private int linePeakWidth = 3;
    private Button autoscaleButton;
    private Button peaksButton;
    private Button aspectButton;
    private Button imageNextButton;
    private Button imagePreviousButton;
    private Button imageFirstButton;
    private Button imageLastButton;
    private Button imagePauseButton;
    private float minimum;
    private float maximum;
    private float mean;
    private float currentMinimum;
    private float currentMaximum;
    private Label minimumLabel;
    private Label maximumLabel;
    private Label statusLabel;
    private Text minimumText;
    private Text maximumText;
    private Text fileNumberText;
    private Combo coordCombo;
    private Combo orientCombo;
    private Combo lutCombo;
    private PaletteData palette = null;
    private static PaletteData[] palettes = new PaletteData[paletteNameValues.length];
    private int currentPalette = 0;
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;
    private boolean listening = true;
    private Logger logger;
    public static int secondaryId = 2;
    protected boolean imageDiffOn = false;
    private int xSelectionStart;
    private int ySelectionStart;
    private static NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    private boolean jobRunning = false;
    private boolean advancePlay = false;
    private int currentFileIndex = 0;
    private int playStep = 1;
    private int playWait = 3000;
    private Thread playThread = null;
    private boolean keepAspect = true;

    public void createPartControl(Composite parent) {
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
            }
        });
        this.logger = FableLogger.getLogger(ImageView.class);
        this.logger.setLevel(Level.ERROR);
        this.display = parent.getDisplay();
        if (view == null) {
            view = this;
        }
        GridLayout parentField = new GridLayout();
        parentField.numColumns = 1;
        parent.setLayout((Layout)parentField);
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        GridLayout grid5Cols = new GridLayout();
        grid5Cols.numColumns = 5;
        grid5Cols.makeColumnsEqualWidth = true;
        this.controlComposite = new Composite(parent, 0);
        this.controlComposite.setLayout((Layout)grid5Cols);
        GridData gd = new GridData(4, 4, true, false);
        gd.exclude = !this.controlCompositeShowing;
        this.controlComposite.setLayoutData((Object)gd);
        this.controlComposite.getAccessible().getControl();
        this.orientCombo = new Combo(this.controlComposite, 0);
        String[] items = new String[8];
        int i = 0;
        while (i < 8) {
            items[i] = orientNameValues[i][0];
            ++i;
        }
        this.orientCombo.setItems(items);
        this.orientCombo.setLayoutData((Object)new GridData(1808));
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageView.this.orientCombo.getSelectionIndex();
                ImageView.this.setOrientation(idx);
            }
        });
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        this.orientation = prefs.getInt("orientationPreference");
        this.orientCombo.select(this.orientation);
        if (!customSavedParametersInitialized) {
            String processing = "xName";
            try {
                xNameSave = prefs.getString("coordinatesXNamePreference");
                processing = "yName";
                yNameSave = prefs.getString("coordinatesYNamePreference");
                processing = "x0";
                x0Save = Double.parseDouble(prefs.getString("coordinatesX0Preference"));
                processing = "y0";
                y0Save = Double.parseDouble(prefs.getString("coordinatesY0Preference"));
                processing = "pixelHeight";
                pixelWidthSave = Double.parseDouble(prefs.getString("coordinatesPixelWidthPreference"));
                processing = "pixelHeight";
                pixelHeightSave = Double.parseDouble(prefs.getString("coordinatesPixelHeightPreference"));
                customSavedParametersInitialized = true;
            }
            catch (NumberFormatException ex) {
                SWTUtils.errMsgAsync((String)("Error setting custom coordinates from preferences for " + processing + "\n" + ex + "\n" + ex.getMessage()));
            }
        }
        this.coordCombo = new Combo(this.controlComposite, 0);
        items = new String[5];
        int i2 = 0;
        while (i2 < 5) {
            items[i2] = coordNameValues[i2][0];
            ++i2;
        }
        this.coordCombo.setItems(items);
        this.coordCombo.setLayoutData((Object)new GridData(1808));
        this.coordCombo.setToolTipText("Select the origin of the coordinate system for mouse movement");
        this.coordCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageView.this.coordCombo.getSelectionIndex();
                int coordOriginSave = ImageView.this.coordOrigin;
                ImageView.this.setCoordOrigin(idx);
                if (idx == 4) {
                    CustomCoordinatesDialog dlg = ImageView.this.coordinates.getType() == 4 ? new CustomCoordinatesDialog(ImageView.this.display.getActiveShell(), ImageView.this.coordinates.getX0(), ImageView.this.coordinates.getY0(), ImageView.this.coordinates.getPixelWidth(), ImageView.this.coordinates.getPixelHeight(), ImageView.this.coordinates.getXName(), ImageView.this.coordinates.getYName()) : new CustomCoordinatesDialog(ImageView.this.display.getActiveShell(), x0Save, y0Save, pixelWidthSave, pixelHeightSave, xNameSave, yNameSave);
                    boolean result = dlg.open();
                    if (result) {
                        x0Save = dlg.getX0();
                        y0Save = dlg.getY0();
                        pixelWidthSave = dlg.getPixelWidth();
                        pixelHeightSave = dlg.getPixelHeight();
                        xNameSave = dlg.getXName();
                        yNameSave = dlg.getYName();
                        ImageView.this.coordinates.reset(ImageView.this.coordOrigin, x0Save, y0Save, pixelWidthSave, pixelHeightSave, xNameSave, yNameSave);
                    } else {
                        ImageView.this.setCoordOrigin(coordOriginSave);
                    }
                } else {
                    ImageView.this.resetCoordinates();
                }
            }
        });
        this.coordOrigin = prefs.getInt("coordinatesPreference");
        this.coordCombo.select(this.coordOrigin);
        if (this.coordOrigin == 4) {
            try {
                this.coordinates.reset(this.coordOrigin, x0Save, y0Save, pixelWidthSave, pixelHeightSave, xNameSave, yNameSave);
            }
            catch (NumberFormatException ex) {
                SWTUtils.errMsgAsync((String)("Error setting custom coordinates from preferences\n" + ex + "\n" + ex.getMessage()));
                this.coordinates.resetToDefault();
            }
        } else {
            this.resetCoordinates();
        }
        this.lutCombo = new Combo(this.controlComposite, 0);
        int len = paletteNameValues.length;
        items = new String[len];
        int i3 = 0;
        while (i3 < len) {
            items[i3] = paletteNameValues[i3][0];
            ++i3;
        }
        this.lutCombo.setItems(items);
        this.lutCombo.setLayoutData((Object)new GridData(1808));
        this.lutCombo.setToolTipText("Set the Color Map");
        this.lutCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int paletteIndex = ImageView.this.lutCombo.getSelectionIndex();
                ImageView.this.setPalette(paletteIndex);
            }
        });
        int paletteIndex = prefs.getInt("palettePreference");
        this.setPalette(paletteIndex);
        this.setZoomSelection(ZoomSelection.AREA);
        this.peaksButton = new Button(this.controlComposite, 0x1000020);
        this.peaksButton.setText("Peaks");
        this.peaksButton.setLayoutData((Object)new GridData(1040));
        this.peaksButton.setToolTipText("Display peaks");
        this.peaksButton.setSelection(false);
        this.peaksButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.peaksButton.getSelection()) {
                    ImageView.this.peaksOn = true;
                    ImageView.this.displayImage();
                    ImageView.this.showPeaks();
                } else {
                    ImageView.this.peaksOn = false;
                    ImageView.this.displayImage();
                }
            }
        });
        this.aspectButton = new Button(this.controlComposite, 0x1000020);
        this.aspectButton.setText("Aspect");
        this.aspectButton.setLayoutData((Object)new GridData(1040));
        this.aspectButton.setToolTipText("Keep aspect ratio when displaying image");
        this.aspectButton.setSelection(true);
        this.aspectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.aspectButton.getSelection()) {
                    ImageView.this.keepAspect = true;
                    ImageView.this.clearCanvas();
                    ImageView.this.displayImage();
                } else {
                    ImageView.this.keepAspect = false;
                    ImageView.this.clearCanvas();
                    ImageView.this.displayImage();
                }
            }
        });
        this.autoscaleButton = new Button(this.controlComposite, 0x1000020);
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setLayoutData((Object)new GridData(1040));
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.autoscaleButton.getSelection()) {
                    ImageView.this.autoscale = true;
                    if (!ImageView.this.imageDiffOn && ImageView.this.fabioFile != null) {
                        try {
                            ImageView.this.minimum = ImageView.this.fabioFile.getMinimum();
                            ImageView.this.mean = ImageView.this.fabioFile.getMean();
                            ImageView.this.maximum = ImageView.this.minimum + 2.0f * (ImageView.this.mean - ImageView.this.minimum);
                        }
                        catch (JepException ex) {
                            ex.printStackTrace();
                        }
                    }
                    ImageView.this.minimumText.setEnabled(false);
                    ImageView.this.maximumText.setEnabled(false);
                    ImageView.this.minimumText.setText(Float.toString(ImageView.this.minimum));
                    ImageView.this.maximumText.setText(Float.toString(ImageView.this.maximum));
                    ImageView.this.currentMinimum = ImageView.this.minimum;
                    ImageView.this.currentMaximum = ImageView.this.maximum;
                    ImageView.this.minimumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.maximumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.displayImage();
                } else {
                    ImageView.this.autoscale = false;
                    ImageView.this.minimumText.setEnabled(true);
                    ImageView.this.maximumText.setEnabled(true);
                    try {
                        ImageView.this.currentMinimum = decimalFormat.parse(ImageView.this.minimumText.getText()).floatValue();
                        ImageView.this.currentMaximum = decimalFormat.parse(ImageView.this.maximumText.getText()).floatValue();
                    }
                    catch (ParseException ex) {
                        SWTUtils.errMsgAsync((String)("Unable to read minimum and/or maximum\n" + ex + "\n" + ex.getMessage()));
                        ex.printStackTrace();
                    }
                    ImageView.this.minimumText.setBackground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.maximumText.setBackground(ImageView.this.display.getSystemColor(1));
                }
            }
        });
        this.minimumLabel = new Label(this.controlComposite, 0);
        this.minimumLabel.setText("Minimum");
        this.minimumLabel.setLayoutData((Object)new GridData(1808));
        this.minimumText = new Text(this.controlComposite, 0);
        this.minimumText.setLayoutData((Object)new GridData(1808));
        this.minimumText.setText("0");
        this.minimumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageView.this.currentMinimum = decimalFormat.parse(ImageView.this.minimumText.getText()).floatValue();
                }
                catch (ParseException ex) {
                    SWTUtils.errMsgAsync((String)("Unable to read minimum\n" + ex + "\n" + ex.getMessage()));
                    ex.printStackTrace();
                }
                ImageView.this.displayImage();
            }
        });
        this.minimumText.setEnabled(false);
        this.maximumLabel = new Label(this.controlComposite, 0);
        this.maximumLabel.setText("Maximum");
        this.maximumLabel.setLayoutData((Object)new GridData(1808));
        this.maximumText = new Text(this.controlComposite, 0);
        this.maximumText.setLayoutData((Object)new GridData(1808));
        this.maximumText.setText("0");
        this.maximumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageView.this.currentMaximum = decimalFormat.parse(ImageView.this.maximumText.getText()).floatValue();
                }
                catch (ParseException ex) {
                    SWTUtils.errMsgAsync((String)("Unable to read maximum\n" + ex + "\n" + ex.getMessage()));
                    ex.printStackTrace();
                }
                ImageView.this.displayImage();
            }
        });
        this.maximumText.setEnabled(false);
        GridLayout grid2Cols = new GridLayout();
        grid2Cols.numColumns = 2;
        this.canvasComposite = new Composite(parent, 0);
        this.canvasComposite.setLayout((Layout)grid2Cols);
        this.canvasComposite.setLayoutData((Object)new GridData(1808));
        this.imageCanvas = new Canvas(this.canvasComposite, 0);
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xCanvas = bounds.width;
        this.yCanvas = bounds.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageView.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Rectangle bounds = ImageView.this.imageCanvas.getBounds();
                event.gc.fillRectangle(0, 0, bounds.width, bounds.height);
                if (ImageView.this.image != null) {
                    if (ImageView.this.xCanvas != bounds.width || ImageView.this.yCanvas != bounds.height) {
                        double imageXScale = ImageView.this.xScale;
                        double imageYScale = ImageView.this.yScale;
                        ImageView.this.loadImage(ImageView.this.imageData);
                        ImageView.this.drawImage();
                        ((ImageView)ImageView.this).selectedArea.width = (int)Math.round((double)((ImageView)ImageView.this).selectedArea.width * (imageXScale /= ImageView.this.xScale));
                        ((ImageView)ImageView.this).selectedArea.height = (int)Math.round((double)((ImageView)ImageView.this).selectedArea.height * (imageYScale /= ImageView.this.yScale));
                        ((ImageView)ImageView.this).selectedArea.x = (int)Math.round((double)((ImageView)ImageView.this).selectedArea.x * imageXScale);
                        ((ImageView)ImageView.this).selectedArea.y = (int)Math.round((double)((ImageView)ImageView.this).selectedArea.y * imageYScale);
                        ImageView.this.showSelection();
                    } else {
                        GC gc = event.gc;
                        gc.drawImage(ImageView.this.image, 0, 0);
                        ImageView.this.showSelection();
                    }
                    ImageView.this.showPeaks();
                    ImageView.this.xCanvas = bounds.width;
                    ImageView.this.yCanvas = bounds.height;
                }
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (ImageView.this.image != null) {
                    ImageView.this.showPixelAtCursor(event.x, event.y);
                    if (ImageView.this.selectingOn.booleanValue()) {
                        int width = event.x - ImageView.this.xSelectionStart;
                        int height = event.y - ImageView.this.ySelectionStart;
                        ImageView.this.imageCanvasGC.setForeground(ImageView.this.display.getSystemColor(1));
                        ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                        if (ImageView.this.getZoomSelection() == ZoomSelection.AREA || ImageView.this.getZoomSelection() == ZoomSelection.PROFILE || ImageView.this.getZoomSelection() == ZoomSelection.RELIEF || ImageView.this.getZoomSelection() == ZoomSelection.ROCKINGCURVE) {
                            Rectangle selectedRectangle = new Rectangle(ImageView.this.xSelectionStart, ImageView.this.ySelectionStart, width, height);
                            ImageView.this.imageCanvasGC.setLineWidth(1);
                            ImageView.this.imageCanvasGC.drawRectangle(selectedRectangle);
                        } else if (ImageView.this.getZoomSelection() == ZoomSelection.LINE) {
                            ImageView.this.imageCanvasGC.setLineWidth(ImageView.this.linePeakWidth);
                            ImageView.this.imageCanvasGC.setXORMode(true);
                            ImageView.this.imageCanvasGC.drawLine(ImageView.this.xSelectionStart, ImageView.this.ySelectionStart, event.x, event.y);
                            ImageView.this.imageCanvasGC.setXORMode(false);
                        }
                    }
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageView.this.statusLabel.setText("");
                if (ImageView.this.selectingOn.booleanValue()) {
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ev) {
                switch (ev.keyCode) {
                    case 27: {
                        if (!ImageView.this.selectingOn.booleanValue()) break;
                        ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                        ImageView.this.selectingOn = false;
                    }
                }
            }

            public void keyReleased(KeyEvent ev) {
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (ImageView.this.selectingOn.booleanValue()) {
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.selectingOn = false;
                }
            }

            public void mouseDown(MouseEvent ev) {
                if (ImageView.this.image == null) {
                    return;
                }
                if (ev.button == 1) {
                    if ((ev.stateMask & 0x40000) != 0) {
                        ImageView.this.selectingOn = false;
                        ImageView.this.selectOn = false;
                        ImageView.this.showZoom(ev, true);
                    } else if ((ev.stateMask & 0x20000) != 0) {
                        ImageView.this.selectingOn = false;
                        ImageView.this.selectOn = false;
                        ImageView.this.showZoom(ev, false);
                    } else {
                        ImageView.this.selectingOn = true;
                        ImageView.this.xSelectionStart = ev.x;
                        ImageView.this.ySelectionStart = ev.y;
                    }
                }
            }

            public void mouseUp(MouseEvent ev) {
                if (ImageView.this.image == null) {
                    return;
                }
                if (!ImageView.this.selectingOn.booleanValue()) {
                    return;
                }
                if (ImageView.this.xSelectionStart != ev.x || ImageView.this.ySelectionStart != ev.y) {
                    ((ImageView)ImageView.this).selectedArea.x = ImageView.this.xSelectionStart;
                    ((ImageView)ImageView.this).selectedArea.y = ImageView.this.ySelectionStart;
                    ((ImageView)ImageView.this).selectedArea.width = ev.x - ((ImageView)ImageView.this).selectedArea.x;
                    ((ImageView)ImageView.this).selectedArea.height = ev.y - ((ImageView)ImageView.this).selectedArea.y;
                    ImageView.this.imageCanvasGC.setForeground(ImageView.this.display.getSystemColor(1));
                    ImageView.this.imageCanvasGC.drawImage(ImageView.this.image, 0, 0);
                    ImageView.this.imageChanged = true;
                    ImageView.this.newSelection = true;
                    ImageView.this.showSelection();
                }
                ImageView.this.selectingOn = false;
            }
        });
        this.createDropTarget();
        Composite statusGroup = new Composite(parent, 0);
        GridLayout statusGridLayout = new GridLayout();
        statusGridLayout.numColumns = 8;
        statusGroup.setLayout((Layout)statusGridLayout);
        statusGroup.setLayoutData((Object)new GridData(768));
        this.statusLabel = new Label(statusGroup, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.fileNumberText = new Text(statusGroup, 2048);
        this.fileNumberText.setToolTipText("go to image number");
        this.fileNumberText.setEnabled(true);
        this.fileNumberText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                int size;
                int fileIndex = Integer.parseInt(ImageView.this.fileNumberText.getText());
                if (fileIndex > (size = ImageView.this.controller.getCurrentsample().getFilteredfiles().size())) {
                    fileIndex = size - 1;
                }
                ImageView.this.controller.setCurrentFileIndex(fileIndex);
            }
        });
        this.imageFirstButton = new Button(statusGroup, 8);
        this.imageFirstButton.setText("<<");
        this.imageFirstButton.setToolTipText("go to first image");
        this.imageFirstButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(-1, 300);
                } else {
                    ImageView.this.controller.setCurrentFileIndex(0);
                    ImageView.this.controller.getFirstImage();
                }
            }
        });
        this.imagePreviousButton = new Button(statusGroup, 8);
        this.imagePreviousButton.setText("<");
        this.imagePreviousButton.setToolTipText("go to previous image");
        this.imagePreviousButton.setEnabled(true);
        this.imagePreviousButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(-1, 3000);
                } else {
                    int fileIndex = ImageView.this.controller.getCurrentFileIndex() - 1;
                    if (fileIndex >= 0) {
                        ImageView.this.controller.setCurrentFileIndex(fileIndex);
                    } else {
                        if (ImageView.this.controller.getCurrentsample() != null) {
                            ImageView.this.controller.setCurrentFileIndex(ImageView.this.controller.getCurrentsample().getFilteredfiles().size() - 1);
                        }
                        ImageView.this.controller.getNext(-1);
                    }
                }
            }
        });
        this.imagePauseButton = new Button(statusGroup, 8);
        this.imagePauseButton.setText("play");
        this.imagePauseButton.setToolTipText("play");
        this.imagePauseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImageView.this.advancePlay = !ImageView.this.advancePlay;
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(1, 3000);
                    ImageView.this.imagePauseButton.setText("||");
                    ImageView.this.imagePauseButton.setToolTipText("pause");
                } else {
                    ImageView.this.imagePauseButton.setText("play");
                    ImageView.this.imagePauseButton.setToolTipText("play");
                }
            }
        });
        this.imageNextButton = new Button(statusGroup, 8);
        this.imageNextButton.setText(">");
        this.imageNextButton.setToolTipText("go to next image");
        this.imageNextButton.setEnabled(true);
        this.imageNextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(1, 3000);
                } else {
                    int fileIndex = ImageView.this.controller.getCurrentFileIndex() + 1;
                    if (ImageView.this.controller.getCurrentsample() != null) {
                        if (fileIndex >= ImageView.this.controller.getCurrentsample().getFilteredfiles().size()) {
                            fileIndex = 0;
                        }
                        ImageView.this.controller.setCurrentFileIndex(fileIndex);
                    }
                    ImageView.this.controller.getNext(1);
                }
            }
        });
        this.imageLastButton = new Button(statusGroup, 8);
        this.imageLastButton.setText(">>");
        this.imageLastButton.setToolTipText("go to last image");
        this.imageLastButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ImageView.this.advancePlay) {
                    ImageView.this.startPlay(1, 300);
                } else {
                    if (ImageView.this.controller.getCurrentsample() != null) {
                        int lastFileIndex = ImageView.this.controller.getCurrentsample().getFilteredfiles().size();
                        ImageView.this.controller.setCurrentFileIndex(lastFileIndex - 1);
                    }
                    ImageView.this.controller.getLastImage();
                }
            }
        });
        this.createContextMenu();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void selectZoom(ZoomSelection zoomselect) {
        this.logger.debug((Object)("set zoom to " + zoomselect.getName()));
        this.setZoomSelection(zoomselect);
        this.selectingOn = false;
        this.selectOn = false;
    }

    public void setViewType(ImageViewType viewtype) {
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                String text;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && (text = (String)event.data).startsWith("samplefile")) {
                    ImageView.this.fabioFile = null;
                    FabioFile _fabioFile = ImageView.this.controller.getCurrentFile();
                    ImageView.this.loadFile(_fabioFile);
                    ImageView.this.displayImage();
                    ImageView.this.fileNumberText.setText(Integer.toString(ImageView.this.controller.getCurrentFileIndex()));
                }
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public void showSelection() {
        if (this.selectingOn.booleanValue() || this.selectOn.booleanValue()) {
            this.logger.debug((Object)("selectingOn " + this.selectingOn + " selectOn " + this.selectOn + " zoomSelection " + this.getZoomSelection().getName()));
            if (this.getZoomSelection() == ZoomSelection.AREA || this.getZoomSelection() == ZoomSelection.RELIEF || this.getZoomSelection() == ZoomSelection.ROCKINGCURVE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                this.showSelectedArea(this.selectedArea, true);
                this.selectOn = true;
            } else if (this.getZoomSelection() == ZoomSelection.LINE) {
                this.imageCanvasGC.setXORMode(true);
                this.imageCanvasGC.setLineWidth(this.linePeakWidth);
                this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.setXORMode(false);
                if (this.imageChanged) {
                    this.showSelectedLine();
                }
                this.selectOn = true;
            } else if (this.getZoomSelection() == ZoomSelection.PROFILE) {
                this.imageCanvasGC.drawRectangle(this.selectedArea);
                if (this.imageChanged) {
                    this.showProfile();
                }
                this.selectOn = true;
            }
            this.newSelection = false;
        }
    }

    public void showZoom(MouseEvent ev, boolean in) {
        float scale = in ? 2.0f : 0.5f;
        Rectangle bounds = this.imageCanvas.getBounds();
        int width = (int)((float)bounds.width * scale + 0.5f);
        int height = (int)((float)bounds.height * scale + 0.5f);
        int x = ev.x - width / 2;
        int y = ev.y - height / 2;
        Rectangle rect = new Rectangle(x, y, width, height);
        this.showSelectedArea(rect, true);
    }

    public void resetZoom() {
        if (this.image == null) {
            return;
        }
        this.selectingOn = false;
        this.selectOn = false;
        this.showSelectedArea(this.origRect, false);
    }

    public void showPeaks() {
        if (this.peaks != null) {
            this.imageCanvasGC.setForeground(this.display.getSystemColor(3));
            int i = 0;
            while (i < this.peaks.size() / 2) {
                Point point = this.tcToScreen(this.peaks.elementAt(i * 2).floatValue(), this.peaks.elementAt(i * 2 + 1).floatValue());
                int x = point.x;
                int y = point.y;
                Rectangle rect = new Rectangle(x -= this.linePeakWidth / 2, y -= this.linePeakWidth / 2, this.linePeakWidth, this.linePeakWidth);
                this.imageCanvasGC.setLineWidth(1);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    void showPixelAtCursor(int mx, int my) {
        int x4 = (int)((double)mx * this.xScale);
        int y4 = (int)((double)my * this.yScale);
        if (x4 < 0 || x4 >= this.orientedRect.width || y4 < 0 || y4 >= this.orientedRect.height) {
            this.statusLabel.setText("");
            return;
        }
        Point p = this.orientedToImage(new Point(x4, y4));
        int x1 = p.x;
        int y1 = p.y;
        if (x1 < 0 || x1 >= this.imageModel.getWidth() || y1 < 0 || y1 >= this.imageModel.getHeight()) {
            this.statusLabel.setText("");
            return;
        }
        float pixel = 0.0f;
        pixel = !this.imageDiffOn ? this.imageModel.getData(y1, x1) : this.imageDiffModel.getData(y1, x1);
        this.statusLabel.setText(this.coordinates.getCoordinateString(x4 + this.orientedRect.x, y4 + this.orientedRect.y, pixel));
    }

    void showSelectedArea(Rectangle rect, boolean screen) {
        Rectangle origRect = screen ? this.screenRectangleToImageRectangle(rect, true) : rect;
        try {
            float[] zoomAreaAsFloat;
            float[] statistics = null;
            if (!this.imageDiffOn) {
                zoomAreaAsFloat = this.imageModel.getData(origRect);
                statistics = this.imageModel.getStatistics(origRect);
            } else {
                zoomAreaAsFloat = this.imageDiffModel.getData(origRect);
                statistics = this.imageDiffModel.getStatistics(origRect);
            }
            float areaMinimum = statistics[0];
            float areaMaximum = statistics[1];
            float areaMean = statistics[2];
            if (this.getZoomSelection() == ZoomSelection.AREA) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID, "100", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference(ID, "100")) != null) {
                    this.zoomAreaView = (ImageView)viewReference.getView(true);
                    if (this.zoomAreaView != null) {
                        this.zoomAreaView.setCoordOrigin(this.coordOrigin);
                        this.zoomAreaView.setOrientation(this.orientation);
                        this.zoomAreaView.changeImageRect(origRect, zoomAreaAsFloat, this.imageModel.getFileName(), this.imageModel);
                        this.zoomAreaView.setPartName("Zoom area " + this.getFileName());
                        this.zoomAreaView.stopListening();
                        this.zoomAreaView.setViewType(ImageViewType.IMAGE_ZOOM);
                        if (this.coordOrigin == 4) {
                            this.zoomAreaView.getCoordinates().reset(this.coordOrigin, this.coordinates.getX0(), this.coordinates.getY0(), this.coordinates.getPixelWidth(), this.coordinates.getPixelHeight(), this.coordinates.getXName(), this.coordinates.getYName());
                        } else {
                            this.zoomAreaView.resetCoordinates();
                        }
                        this.zoomAreaView.setMinMax(this.getMinMax());
                        this.zoomAreaView.setPalette(this.currentPalette);
                    }
                }
            } else if (this.getZoomSelection() == ZoomSelection.RELIEF) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ReliefView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ReliefView", "0")) != null) {
                    this.zoomReliefView = (ReliefView)viewReference.getView(true);
                    if (this.zoomReliefView != null) {
                        this.zoomReliefView.setImageAsFloat(zoomAreaAsFloat, origRect.width, origRect.height, areaMinimum, areaMaximum, areaMean, this.imageModel.getFileName());
                    }
                }
            } else if (this.getZoomSelection() == ZoomSelection.ROCKINGCURVE) {
                IViewReference viewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.RockingCurveView", "0", 1);
                }
                if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.RockingCurveView", "0")) != null) {
                    this.zoomRockingCurveView = (RockingCurveView)viewReference.getView(true);
                    if (this.zoomRockingCurveView != null) {
                        int x2 = origRect.width == 0 ? origRect.x : origRect.x + origRect.width - 1;
                        int y2 = origRect.height == 0 ? origRect.y : origRect.y + origRect.height - 1;
                        this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.getFileName(), SampleController.getController().getCurrentFileIndex(), origRect.x, origRect.y, x2, y2);
                    }
                }
            }
        }
        catch (PartInitException ex) {
            SWTUtils.errMsgAsync((String)("Unable to show selected area\n" + (Object)((Object)ex) + "\n" + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    void showSelectedLine() {
        Rectangle lineRect = this.screenRectangleToOrientedImageRectangle(this.selectedArea, false);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        Level oldLevel = this.logger.getLevel();
        this.logger.debug((Object)("integrate for selectedArea x=" + this.selectedArea.x + " y=" + this.selectedArea.y + " width=" + this.selectedArea.width + " height=" + this.selectedArea.height));
        this.logger.debug((Object)("integrate for x1=" + x1 + " y1=" + y1 + " to x2=" + x2 + " y2=" + y2));
        this.logger.setLevel(oldLevel);
        Point p = new Point(0, 0);
        double[] vals = new double[]{0.0, 0.0};
        boolean inverted = false;
        try {
            IViewReference viewReference;
            int y;
            int x;
            float[] intensity;
            float[] pixels;
            int len;
            int temp;
            String yTitle;
            String xTitle;
            float slope = Float.NaN;
            if (Math.abs(x2 - x1) >= Math.abs(y2 - y1)) {
                xTitle = "Pixels in " + this.coordinates.getXName();
                yTitle = "Intensity";
                inverted = this.coordinates.isXInverted();
                if (x2 < x1) {
                    temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = x2 - x1 + 1;
                pixels = new float[len];
                intensity = new float[len];
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                int i = 0;
                while (i < len) {
                    x = x1 + i;
                    y = (int)((double)((float)y1 + slope * (float)i) + 0.5);
                    if (y < 0) {
                        y = 0;
                    }
                    if (y > this.orientedOrigRect.height - 1) {
                        y = this.orientedOrigRect.height - 1;
                    }
                    intensity[i] = 0.0f;
                    int j = y - this.linePeakWidth / 2;
                    while (j < y + this.linePeakWidth / 2 + 1) {
                        p.x = x;
                        p.y = y;
                        vals = this.coordinates.getCoordinatesFromOriented(p);
                        pixels[i] = (float)vals[0];
                        p = this.orientedToImage(p);
                        if (!this.imageDiffOn) {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageModel.getData(p.y, p.x);
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageDiffModel.getData(p.y, p.x);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                xTitle = "Pixels in " + this.coordinates.getYName();
                yTitle = "Intensity";
                inverted = this.coordinates.isYInverted();
                if (y2 < y1) {
                    temp = x1;
                    x1 = x2;
                    x2 = temp;
                    temp = y1;
                    y1 = y2;
                    y2 = temp;
                }
                len = y2 - y1 + 1;
                pixels = new float[len];
                intensity = new float[len];
                if (x2 - x1 != 0) {
                    slope = (float)(y2 - y1) / (float)(x2 - x1);
                }
                this.logger.debug((Object)("slope " + slope));
                int i = 0;
                while (i < len) {
                    y = y1 + i;
                    x = x2 - x1 != 0 ? (int)((double)((float)x1 + (float)i / slope) + 0.5) : x1;
                    if (x < 0) {
                        x = 0;
                    }
                    if (x > this.orientedOrigRect.width - 1) {
                        x = this.orientedOrigRect.width - 1;
                    }
                    intensity[i] = 0.0f;
                    int j = x - this.linePeakWidth / 2;
                    while (j < x + this.linePeakWidth / 2 + 1) {
                        p.x = x;
                        p.y = y;
                        vals = this.coordinates.getCoordinatesFromOriented(p);
                        pixels[i] = (float)vals[1];
                        p = this.orientedToImage(p);
                        if (!this.imageDiffOn) {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageModel.getData(p.y, p.x);
                        } else {
                            int n = i;
                            intensity[n] = intensity[n] + this.imageDiffModel.getData(p.y, p.x);
                        }
                        ++j;
                    }
                    this.logger.setLevel(Level.ERROR);
                    ++i;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView", "0")) != null) {
                this.lineView = (LineView)viewReference.getView(true);
                if (this.lineView != null) {
                    String from = "unknown";
                    String to = "unknown";
                    p.x = x1;
                    p.y = y1;
                    from = this.coordinates.getCoordinateString(p.x, p.y);
                    p.x = x2;
                    p.y = y2;
                    to = this.coordinates.getCoordinateString(p.x, p.y);
                    xTitle = String.valueOf(xTitle) + " from (" + from + ") to (" + to + ") for " + this.getCoordinatesName();
                    this.lineView.setData(this.getFileName(), xTitle, inverted, pixels, yTitle, intensity);
                }
            }
        }
        catch (PartInitException ex) {
            SWTUtils.errMsgAsync((String)("Unable to show selected line\n" + (Object)((Object)ex) + "\n" + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    void showProfile() {
        int temp;
        Rectangle lineRect = this.screenRectangleToImageRectangle(this.selectedArea, true);
        int x1 = lineRect.x;
        int y1 = lineRect.y;
        int x2 = lineRect.x + lineRect.width - 1;
        int y2 = lineRect.y + lineRect.height - 1;
        if (x1 > x2) {
            temp = y1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        try {
            IViewReference viewReference;
            int j;
            int[] pixels_x = new int[x2 - x1];
            float[] intensity_x = new float[x2 - x1];
            int i = 0;
            while (i < x2 - x1) {
                int x;
                pixels_x[i] = x = x1 + i;
                intensity_x[i] = 0.0f;
                j = y1;
                while (j < y2) {
                    if (!this.imageDiffOn) {
                        int n = i;
                        intensity_x[n] = intensity_x[n] + this.imageModel.getData(j, x);
                    } else {
                        int n = i;
                        intensity_x[n] = intensity_x[n] + this.imageDiffModel.getData(j, x);
                    }
                    ++j;
                }
                ++i;
            }
            int[] pixels_y = new int[y2 - y1];
            float[] intensity_y = new float[y2 - y1];
            i = 0;
            while (i < y2 - y1) {
                int y;
                pixels_y[i] = y = y1 + i;
                intensity_y[i] = 0.0f;
                j = y1;
                while (j < y2) {
                    if (!this.imageDiffOn) {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.imageModel.getData(y, j);
                    } else {
                        int n = i;
                        intensity_y[n] = intensity_y[n] + this.imageDiffModel.getData(y, j);
                    }
                    ++j;
                }
                ++i;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", "0", 1);
            }
            if ((viewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView", "0")) != null) {
                this.profileView = (ProfileView)viewReference.getView(true);
                if (this.profileView != null) {
                    this.profileView.setData(this.getFileName(), pixels_x, intensity_x, pixels_y, intensity_y);
                }
            }
        }
        catch (PartInitException ex) {
            SWTUtils.errMsgAsync((String)("Unable to show profile\n" + (Object)((Object)ex) + "\n" + ex.getMessage()));
            ex.printStackTrace();
        }
    }

    public void changeImageRect(Rectangle rect, float[] areaAsFloat, String fileName, ImageModel _imageModel) {
        if (this.imageRect.width != rect.width || this.imageRect.height != rect.height) {
            this.clearCanvas();
        } else {
            this.selectingOn = false;
            this.selectOn = false;
        }
        if (_imageModel == null) {
            this.imageModel = new ImageModel(fileName, rect.width, rect.height, areaAsFloat);
        } else if (_imageModel != this.imageModel) {
            this.imageModel = _imageModel;
        }
        this.imageChanged = true;
        this.imageRect = rect;
        this.calculateMainRectangles();
        this.resetCoordinates();
        float[] statistics = this.imageModel.getStatistics(this.imageRect);
        this.minimum = statistics[0];
        this.maximum = statistics[1];
        this.mean = statistics[2];
        this.maximum = this.mean + 2.0f * (this.mean - this.minimum);
        if (this.maximum - this.minimum < 0.01f) {
            this.maximum = this.minimum + 0.01f;
        }
        this.displayImage();
    }

    public void stopListening() {
        if (this.listening) {
            this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void loadFile(FabioFile _fabioFile) {
        if (_fabioFile != this.fabioFile) {
            this.peaks = null;
            this.fabioFile = _fabioFile;
            try {
                this.imageModel = new ImageModel(this.fabioFile);
            }
            catch (JepException ex) {
                SWTUtils.errMsgAsync((String)("loadFile: Unable to load file:\n" + (Object)((Object)ex) + "\n" + ex.getMessage()));
                ex.printStackTrace();
                this.clearCanvas();
                return;
            }
            this.statusLabel.setText("Loading file " + this.fabioFile.getFileName() + " ... ");
            this.imageChanged = true;
            if (this.imageRect.width != this.imageModel.getWidth() || this.imageRect.height != this.imageModel.getHeight()) {
                Rectangle bounds = this.imageCanvas.getBounds();
                this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
            }
            this.imageRect.width = this.imageModel.getWidth();
            this.imageRect.height = this.imageModel.getHeight();
            this.calculateMainRectangles();
            this.resetCoordinates();
            float[] statistics = this.imageModel.getStatistics(this.imageRect);
            this.minimum = statistics[0];
            this.maximum = statistics[1];
            this.mean = statistics[2];
            this.maximum = this.minimum + 2.0f * (this.mean - this.minimum);
            if (this.maximum - this.minimum < 0.01f) {
                this.maximum = this.minimum + 0.01f;
            }
            this.updateStatusLabel("loading file " + this.fabioFile.getFileName() + " ... took " + this.fabioFile.getTimeToReadImage() + " ms");
            if (this.imageDiffOn) {
                float[] savedArray;
                int savedLen;
                long start = System.currentTimeMillis();
                float[] newArray = this.imageModel.getData();
                int newLen = newArray.length;
                if (newLen != (savedLen = (savedArray = this.savedImageModel.getData()).length)) {
                    SWTUtils.errMsgAsync((String)"Cannot create difference:\nnewWidth=%d savedWidth=%d\nnewHeight=%d savedHeight=%d");
                    this.setPartName("Image " + this.fabioFile.getFileName());
                    return;
                }
                float[] imageDiffArray = new float[savedLen];
                int i = 0;
                while (i < savedLen) {
                    imageDiffArray[i] = newArray[i] - savedArray[i];
                    ++i;
                }
                this.imageDiffModel = new ImageModel(String.valueOf(this.imageModel.getFileName()) + " - minus - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), imageDiffArray);
                this.imageDiffModel.reset(String.valueOf(this.imageModel.getFileName()) + " - minus - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), imageDiffArray);
                statistics = this.imageDiffModel.getStatistics(this.imageRect);
                this.minimum = statistics[0];
                this.minimum = statistics[1];
                this.mean = statistics[2];
                if (this.minimum == this.maximum) {
                    this.maximum = this.minimum + 1.0f;
                }
                long elapsed = System.currentTimeMillis() - start;
                this.updateStatusLabel(String.valueOf(this.getFileName()) + " - minus - " + this.fileNameSaved + " took " + elapsed + " ms");
                this.setPartName("Difference " + this.fabioFile.getFileName());
            } else {
                this.setPartName("Image " + this.fabioFile.getFileName());
            }
        }
    }

    public void updateStatusLabel(String _status) {
        final String status = _status;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageView.this.statusLabel.setText(status);
            }
        });
    }

    public void setPeaks(Vector<Float> vals) {
        this.peaks = vals;
    }

    public void displayImage() {
        if (this.imageModel == null || this.imageModel.getData() == null) {
            return;
        }
        if (this.autoscale.booleanValue()) {
            this.currentMinimum = this.minimum;
            this.currentMaximum = this.maximum;
            this.minimumText.setText(Float.toString(this.minimum));
            this.maximumText.setText(Float.toString(this.maximum));
        } else {
            try {
                this.currentMinimum = decimalFormat.parse(this.minimumText.getText()).floatValue();
                this.currentMaximum = decimalFormat.parse(this.maximumText.getText()).floatValue();
            }
            catch (ParseException ex) {
                SWTUtils.errMsgAsync((String)("Unable to read minimum and/or maximum\n" + ex + "\n" + ex.getMessage()));
                ex.printStackTrace();
            }
        }
        if (this.currentMinimum - this.currentMaximum == 0.0f) {
            this.currentMinimum = this.currentMaximum + 0.01f;
        } else {
            this.createImageData(this.currentMinimum, this.currentMaximum, this.palette);
            this.imageData = !this.imageDiffOn ? this.createImageData(this.currentMinimum, this.currentMaximum, this.palette) : this.createImageData(this.currentMinimum, this.currentMaximum, this.palette);
            this.loadImage(this.imageData);
            this.drawImage();
        }
        if (this.selectOn.booleanValue()) {
            this.showSelection();
        }
        if (this.peaksOn.booleanValue()) {
            this.showPeaks();
        }
        this.imageChanged = false;
    }

    public ImageData createImageData(float _minimum, float _maximum, PaletteData palette) {
        float[] screenImageData = !this.imageDiffOn ? this.imageModel.getData(this.imageRect) : this.imageDiffModel.getData(this.imageRect);
        int len = screenImageData.length;
        if (len == 0) {
            return null;
        }
        this.calculateMainRectangles();
        this.resetCoordinates();
        float scale_8bit = 255.0f / (_maximum - _minimum);
        byte[] scaledImageAsByte = new byte[len];
        float maxPixel = _maximum - _minimum;
        int i = 0;
        while (i < len) {
            float scaled_pixel = screenImageData[i] < _minimum ? 0.0f : (screenImageData[i] > _maximum ? maxPixel : screenImageData[i] - _minimum);
            byte pixel = (byte)(0xFF & (int)(scaled_pixel *= scale_8bit));
            switch (this.orientation) {
                default: {
                    scaledImageAsByte[i] = pixel;
                    break;
                }
                case 1: {
                    int x1 = this.imageRect.width - i % this.imageRect.width - 1;
                    int y1 = i / this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 2: {
                    int x1 = i % this.imageRect.width;
                    int y1 = this.imageRect.height - i / this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 3: {
                    scaledImageAsByte[len - i - 1] = pixel;
                    break;
                }
                case 6: {
                    int x1 = i / this.imageRect.width;
                    int y1 = i % this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 4: {
                    int x1 = i / this.imageRect.width;
                    int y1 = this.imageRect.width - i % this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 5: {
                    int x1 = this.imageRect.height - i / this.imageRect.width - 1;
                    int y1 = i % this.imageRect.width;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                    break;
                }
                case 7: {
                    int x1 = this.imageRect.height - i / this.imageRect.width - 1;
                    int y1 = this.imageRect.width - i % this.imageRect.width - 1;
                    scaledImageAsByte[y1 * this.orientedRect.width + x1] = pixel;
                }
            }
            ++i;
        }
        ImageData imageData = new ImageData(this.orientedRect.width, this.orientedRect.height, 8, palette, 1, scaledImageAsByte);
        return imageData;
    }

    public Image loadImage(ImageData data) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle bounds = this.imageCanvas.getBounds();
        this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        if (this.keepAspect) {
            if (this.xScale > this.yScale) {
                this.yScale = this.xScale;
            } else {
                this.xScale = this.yScale;
            }
        }
        if ((double)this.orientedRect.width / this.xScale < 1.0) {
            this.xScale = (double)this.orientedRect.width / (double)bounds.width;
        }
        if ((double)this.orientedRect.height / this.yScale < 1.0) {
            this.yScale = (double)this.orientedRect.height / (double)bounds.height;
        }
        int xscaledTo = (int)((double)this.orientedRect.width / this.xScale);
        int yscaledTo = (int)((double)this.orientedRect.height / this.yScale);
        if (data == null) {
            this.logger.debug((Object)"data is null !");
            this.image = null;
        } else {
            this.image = new Image((Device)Display.getCurrent(), data.scaledTo(xscaledTo, yscaledTo));
        }
        return this.image;
    }

    public void setFocus() {
    }

    void drawImage() {
        if (this.imageCanvasGC != null && this.image != null) {
            this.imageCanvasGC.drawImage(this.image, 0, 0);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getProperty().equals("CurrentFile")) {
            Object val = evt.getNewValue();
            FabioFile _fabioFile = (FabioFile)val;
            this.loadFile(_fabioFile);
            this.displayImage();
            this.fileNumberText.setText(Integer.toString(this.controller.getCurrentFileIndex()));
            final int sampleIndex = this.controller.getCurrentsample().getFilteredfiles().indexOf(val);
            int sampleSize = this.controller.getCurrentsample().getFilteredfiles().size();
            if (sampleIndex >= 0 && sampleIndex < sampleSize && !this.jobRunning) {
                final int fileReadFrom = Math.max(0, sampleIndex - 3);
                final int fileReadTo = Math.min(sampleIndex + 3, sampleSize - 1);
                this.jobRunning = true;
                Job job = new Job("Read files ahead "){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Read files ahead", 7);
                        ImageView.this.logger.debug((Object)("start job to read file " + fileReadFrom + " to " + fileReadTo + " ahead"));
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        try {
                            FableJep fableJep = new FableJep();
                            int i = fileReadFrom;
                            while (i <= fileReadTo) {
                                if (i >= 0 && i < ImageView.this.controller.getCurrentsample().getFilteredfiles().size() && i != sampleIndex) {
                                    ((FabioFile)ImageView.this.controller.getCurrentsample().getFilteredfiles().get(i)).readImageAsFloat(fableJep);
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            fableJep.getJep().close();
                        }
                        catch (JepException ex) {
                            SWTUtils.errMsgAsync((String)("Read files ahead: Unable to access fabioFile:\n " + (Object)((Object)ex) + "\n" + ex.getMessage()));
                            ex.printStackTrace();
                        }
                        monitor.done();
                        ImageView.this.jobRunning = false;
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void dispose() {
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void colorPeaks(float[] peakToColor) {
        this.showPeaks();
        if (peakToColor != null) {
            float[] orig = new float[]{0.0f, 0.0f};
            this.imageCanvasGC.setForeground(this.display.getSystemColor(5));
            int i = 0;
            while (i < peakToColor.length / 2) {
                int index = i * 2;
                orig[0] = peakToColor[index];
                orig[1] = peakToColor[index + 1];
                float[] point = this.imageToOriented(orig);
                int x = (int)((double)point[0] / this.xScale + 0.5);
                int y = (int)((double)point[1] / this.yScale + 0.5);
                Rectangle rect = new Rectangle(x -= this.linePeakWidth / 2, y -= this.linePeakWidth / 2, this.linePeakWidth, this.linePeakWidth);
                this.imageCanvasGC.drawRectangle(rect);
                ++i;
            }
        }
    }

    public void initWithShowPeaks() {
        this.peaksButton.setSelection(true);
        this.peaksButton.notifyListeners(13, new Event());
    }

    public void startPlay(int step, int wait) {
        this.playStep = step;
        this.playWait = wait;
        if (this.playThread == null) {
            this.playThread = this.PlayThread();
            this.playThread.start();
        }
    }

    public Thread PlayThread() {
        return new Thread(){

            @Override
            public void run() {
                ImageView.this.currentFileIndex = ImageView.this.controller.getCurrentFileIndex();
                while (ImageView.this.advancePlay) {
                    try {
                        ImageView imageView = ImageView.this;
                        imageView.currentFileIndex = imageView.currentFileIndex + ImageView.this.playStep;
                        ImageView.this.controller.getNext(ImageView.this.playStep);
                        if (ImageView.this.controller.getCurrentsample() != null) {
                            if (ImageView.this.currentFileIndex >= ImageView.this.controller.getCurrentsample().getFilteredfiles().size()) {
                                ImageView.this.currentFileIndex = 0;
                            } else if (ImageView.this.currentFileIndex < 0) {
                                ImageView.this.currentFileIndex = ImageView.this.controller.getCurrentsample().getFilteredfiles().size() - 1;
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ImageView.this.controller.setCurrentFileIndex(ImageView.this.currentFileIndex);
                                }
                            });
                        }
                        Thread.sleep(ImageView.this.playWait);
                    }
                    catch (InterruptedException ex) {
                        SWTUtils.errMsgAsync((String)("PlayThread Interrupted:\n" + ex + "\n" + ex.getMessage()));
                        ex.printStackTrace();
                    }
                }
                ImageView.this.playThread = null;
            }
        };
    }

    public void setName(String string) {
        this.setPartName(string);
    }

    public Point tcToScreen(float y, float z) {
        Point point = new Point(0, 0);
        point.x = (int)((double)(y - (float)this.imageRect.x) / this.xScale);
        point.y = (int)((double)(z - (float)this.imageRect.y) / this.yScale);
        return point;
    }

    public Point orientedToImage(Point point) {
        int x3 = point.x + this.orientedRect.x;
        int y3 = point.y + this.orientedRect.y;
        int x2 = x3;
        int y2 = y3;
        switch (this.orientation) {
            default: {
                break;
            }
            case 1: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 2: {
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 3: {
                x2 = this.orientedOrigRect.width - x3 - 1;
                y2 = this.orientedOrigRect.height - y3 - 1;
                break;
            }
            case 6: {
                x2 = y3;
                y2 = x3;
                break;
            }
            case 4: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = x3;
                break;
            }
            case 5: {
                x2 = y3;
                y2 = this.orientedOrigRect.width - x3 - 1;
                break;
            }
            case 7: {
                x2 = this.orientedOrigRect.height - y3 - 1;
                y2 = this.orientedOrigRect.width - x3 - 1;
            }
        }
        Point converted = new Point(x2, y2);
        return converted;
    }

    public Point imageToOriented(Point point) {
        float[] array = this.imageToOriented(new float[]{point.x, point.y});
        return new Point((int)((double)array[0] + 0.5), (int)((double)array[1] + 0.5));
    }

    public float[] imageToOriented(float[] point) {
        float x2 = point[0];
        float y2 = point[1];
        float x3 = x2;
        float y3 = y2;
        switch (this.orientation) {
            default: {
                break;
            }
            case 1: {
                x3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                break;
            }
            case 2: {
                y3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                break;
            }
            case 3: {
                x3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                y3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                break;
            }
            case 6: {
                x3 = y2;
                y3 = x2;
                break;
            }
            case 4: {
                x3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                y3 = x2;
                break;
            }
            case 5: {
                x3 = y2;
                y3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
                break;
            }
            case 7: {
                x3 = (float)this.orientedOrigRect.height - y2 - 1.0f;
                y3 = (float)this.orientedOrigRect.width - x2 - 1.0f;
            }
        }
        float[] converted = new float[]{x3 - (float)this.orientedRect.x, y3 - (float)this.orientedRect.y};
        return converted;
    }

    private void calculateMainRectangles() {
        this.origRect = this.imageModel.getRect();
        this.orientedOrigRect.x = 0;
        this.orientedOrigRect.y = 0;
        switch (this.orientation) {
            default: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 1: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 2: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 3: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 6: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 4: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 5: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 7: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
            }
        }
    }

    public Rectangle screenRectangleToImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        Point p1 = this.orientedToImage(new Point(x1, y1));
        Point p2 = this.orientedToImage(new Point(x2, y2));
        x1 = p1.x;
        y1 = p1.y;
        x2 = p2.x;
        y2 = p2.y;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.origRect.width) {
            x1 = this.origRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.origRect.width) {
            x2 = this.origRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.origRect.height) {
            y1 = this.origRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.origRect.height) {
            y2 = this.origRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public Rectangle screenRectangleToOrientedImageRectangle(Rectangle screenRect, boolean ordered) {
        int x0 = screenRect.x - this.imageData.x;
        int y0 = screenRect.y - this.imageData.y;
        int x1 = (int)((double)x0 * this.xScale);
        int y1 = (int)((double)y0 * this.yScale);
        int x2 = screenRect.width != 0 ? (int)((double)(x0 + screenRect.width - 1) * this.xScale) : x1;
        int y2 = screenRect.height != 0 ? (int)((double)(y0 + screenRect.height - 1) * this.yScale) : y1;
        if (ordered) {
            int temp;
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
            }
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
            }
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.orientedRect.width) {
            x1 = this.orientedRect.width - 1;
        }
        if (x2 < 0) {
            x2 = 0;
        }
        if (x2 >= this.orientedRect.width) {
            x2 = this.orientedRect.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.orientedRect.height) {
            y1 = this.orientedRect.height - 1;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y2 >= this.orientedRect.height) {
            y2 = this.orientedRect.height - 1;
        }
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        Rectangle newRect = new Rectangle(x1, y1, width, height);
        return newRect;
    }

    public void clearCanvas() {
        if (this.imageCanvas != null && this.imageCanvasGC != null) {
            Rectangle bounds = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, bounds.width, bounds.height);
        }
        this.selectingOn = false;
    }

    public void resetCoordinates() {
        if (this.coordOrigin != 4) {
            this.coordinates.reset(this.coordOrigin, this.orientedOrigRect.width, this.orientedOrigRect.height);
        }
    }

    public int getCoordOrigin() {
        return this.coordOrigin;
    }

    public void setCoordOrigin(int coordOrigin) {
        if (coordOrigin < 0 || coordOrigin >= coordNameValues.length) {
            return;
        }
        if (this.coordOrigin != coordOrigin) {
            this.coordOrigin = coordOrigin;
            this.coordCombo.select(coordOrigin);
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation < 0 || orientation >= 8) {
            return;
        }
        if (orientation == this.orientation) {
            return;
        }
        this.orientation = orientation;
        this.orientCombo.select(orientation);
        this.resetCoordinates();
        this.clearCanvas();
        this.displayImage();
    }

    public int getPalette() {
        return this.currentPalette;
    }

    public void setPalette(int index) {
        if (index < 0 || index >= paletteNameValues.length) {
            return;
        }
        if (palettes[index] == null) {
            switch (index) {
                case 0: {
                    ImageView.palettes[index] = PaletteUtils.makeGrayScalePalette();
                    break;
                }
                case 1: {
                    ImageView.palettes[index] = PaletteUtils.makeColorPalette();
                    break;
                }
                case 2: {
                    ImageView.palettes[index] = PaletteUtils.makeRainbow1Palette();
                    break;
                }
                case 3: {
                    ImageView.palettes[index] = PaletteUtils.makeRainbow2Palette();
                }
            }
        }
        this.palette = palettes[index];
        this.lutCombo.select(index);
        this.currentPalette = index;
        this.displayImage();
    }

    public float[] getMinMax() {
        float[] minmax = new float[]{this.currentMinimum, this.currentMaximum};
        return minmax;
    }

    public void setMinMax(float[] minmax) {
        this.minimumText.setText(Float.toString(minmax[0]));
        this.maximumText.setText(Float.toString(minmax[1]));
        this.autoscaleButton.setSelection(false);
        this.autoscale = false;
        this.displayImage();
    }

    private void createContextMenu() {
        final ImageView thisView = this;
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                this.fillContextMenu(mgr);
            }

            private void fillContextMenu(IMenuManager manager) {
                Action controlPanelAction = new Action("Control Panel", 8){

                    public void run() {
                        if (ImageView.this.controlComposite == null) {
                            return;
                        }
                        ImageView.this.controlCompositeShowing = !ImageView.this.controlCompositeShowing;
                        ImageView.this.controlComposite.setVisible(ImageView.this.controlCompositeShowing);
                        GridData data = (GridData)ImageView.this.controlComposite.getLayoutData();
                        data.exclude = !ImageView.this.controlCompositeShowing;
                        Composite parent = ImageView.this.controlComposite.getParent();
                        if (parent != null) {
                            parent.layout(false);
                        }
                    }
                };
                controlPanelAction.setChecked(ImageView.this.controlCompositeShowing);
                controlPanelAction.setToolTipText("Toggle Control Panel");
                manager.add((IAction)controlPanelAction);
                manager.add((IContributionItem)new Separator());
                ZoomAreaAction zoomAreaAction = new ZoomAreaAction("Zoom Area");
                zoomAreaAction.init((IViewPart)thisView);
                if (ImageView.this.getZoomSelection() == ZoomSelection.AREA) {
                    zoomAreaAction.setChecked(true);
                }
                manager.add((IAction)zoomAreaAction);
                ZoomLineAction zoomLineAction = new ZoomLineAction("Zoom Line");
                zoomLineAction.init((IViewPart)thisView);
                if (ImageView.this.getZoomSelection() == ZoomSelection.LINE) {
                    zoomLineAction.setChecked(true);
                }
                manager.add((IAction)zoomLineAction);
                ZoomProfileAction zoomProfileAction = new ZoomProfileAction("Zoom Profile");
                zoomProfileAction.init((IViewPart)thisView);
                if (ImageView.this.getZoomSelection() == ZoomSelection.PROFILE) {
                    zoomProfileAction.setChecked(true);
                }
                manager.add((IAction)zoomProfileAction);
                ZoomReliefAction zoomReliefAction = new ZoomReliefAction("Zoom Relief");
                zoomReliefAction.init((IViewPart)thisView);
                if (ImageView.this.getZoomSelection() == ZoomSelection.RELIEF) {
                    zoomReliefAction.setChecked(true);
                }
                manager.add((IAction)zoomReliefAction);
                ZoomRockingAction zoomRockingAction = new ZoomRockingAction("Zoom Rocking");
                zoomRockingAction.init((IViewPart)thisView);
                if (ImageView.this.getZoomSelection() == ZoomSelection.ROCKINGCURVE) {
                    zoomRockingAction.setChecked(true);
                }
                manager.add((IAction)zoomRockingAction);
                ResetZoomAction resetZoomAction = new ResetZoomAction("Reset Zoom");
                resetZoomAction.init((IViewPart)thisView);
                resetZoomAction.setToolTipText("Reset zoom to original image size");
                manager.add((IAction)resetZoomAction);
                manager.add((IContributionItem)new Separator());
                ImageCopyAction copyImageAction = new ImageCopyAction("Copy Image");
                copyImageAction.init((IViewPart)thisView);
                copyImageAction.setToolTipText("Show a copy of this view in another view");
                manager.add((IAction)copyImageAction);
                Slice2DAction slice2DAction = new Slice2DAction("2D Slice");
                slice2DAction.init((IViewPart)thisView);
                slice2DAction.setToolTipText("Make a new 2D image by stacking the zoomed area of the selected images");
                manager.add((IAction)slice2DAction);
                manager.add((IContributionItem)new Separator());
                ImageInfoAction imageInfoAction = new ImageInfoAction("Image Info");
                imageInfoAction.init((IViewPart)thisView);
                imageInfoAction.setToolTipText("Display image info");
                manager.add((IAction)imageInfoAction);
                InputSummaryAction inputSummaryAction = new InputSummaryAction("Input Summary");
                inputSummaryAction.init((IViewPart)thisView);
                inputSummaryAction.setToolTipText("Display a summary of mouse operations");
                manager.add((IAction)inputSummaryAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.imageCanvas.getAccessible().getControl());
        this.imageCanvas.getAccessible().getControl().setMenu(menu);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            Object[] selections = sSelection.toArray();
            if (first instanceof PeakSearchSpt) {
                PeakSearchSpt peakFile = (PeakSearchSpt)first;
                FabioFile f = peakFile.getImageFile();
                if (f != null) {
                    this.loadFile(f);
                    this.displayImage();
                    Vector vals = peakFile.getTabChildren();
                    if (vals != null) {
                        this.setPeaks(vals);
                        this.showPeaks();
                    }
                }
            } else if (first instanceof Peak) {
                PeakSearchSpt parent = ((Peak)first).getParent();
                int nPeaksToDisplay = selections.length;
                float[] coloredPeak = new float[nPeaksToDisplay * 2];
                int k = 0;
                int ip = 0;
                while (ip < selections.length) {
                    Peak peak = (Peak)selections[ip];
                    if (peak.isVisible()) {
                        int j = k + 1;
                        coloredPeak[k] = Float.valueOf(peak.getS()).floatValue();
                        coloredPeak[j] = Float.valueOf(peak.getF()).floatValue();
                        k += 2;
                    }
                    ++ip;
                }
                Vector vals = parent.getTabChildren();
                if (vals != null) {
                    this.setPeaks(vals);
                }
                this.displayImage();
                this.colorPeaks(coloredPeak);
            }
        }
    }

    public String getFileName() {
        String fileName = null;
        if (this.imageModel != null) {
            fileName = this.imageModel.getFileName();
        }
        return fileName == null ? "" : fileName;
    }

    public ImageModel getImageModel() {
        return this.imageModel;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public void setZoomSelection(ZoomSelection zoomSelection) {
        this.zoomSelection = zoomSelection;
    }

    public ZoomSelection getZoomSelection() {
        return this.zoomSelection;
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public String getCoordinatesName() {
        if (this.coordOrigin < 0 || this.coordOrigin > 4) {
            return "Unknown";
        }
        return coordNameValues[this.coordOrigin][0].split("[\\s\\.]", 2)[0];
    }
}

