package fable.framework.xmltest;

import static org.junit.Assert.fail;

import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import fable.framework.xmlparser.object.FableXmlContentHandler;

public class FableImageD11parser {
	private FableXmlContentHandler xmlContentHanlder ;
	private XMLReader saxReader;

	
	@Test
	public void parseXmlFile(){
		System.out.println("Test if xml parser can run");
		
		xmlContentHanlder=new FableXmlContentHandler();
		String path="xmlContent/test_fable.xml";

		try {
			saxReader = XMLReaderFactory.createXMLReader();
			try {
				//saxReader.setContentHandler(this);
				saxReader.setContentHandler(xmlContentHanlder);
				saxReader.parse(path );
				
				System.out.print(xmlContentHanlder.getOptions().toArray().toString());
		
			} catch (IOException e) {

				fail("xml file not found" + e.getMessage());
									//e.printStackTrace();
			} catch (SAXException e) {

				fail(e.getMessage());
					

			}
		} catch (SAXException e) {
			fail(e.getMessage());
		}

	}
	@Test
	public void checkXmlFile(){
		System.out.println("Test if xml file has a good synthax for imagd11");
	}

@Test
public void initXmlFile(){
	Bundle bundle = Platform.getBundle(fable.framework.xmlparser.Activator.PLUGIN_ID);
	Path path_root = new Path("/");
	String path ="";
	URL xmlOptionsURL;
	try {
		xmlOptionsURL = Platform.resolve(FileLocator.find(bundle, path_root, null));

		path = xmlOptionsURL.getPath();

		if (path.startsWith("file:")) {

			path = path.replaceFirst("file:","") + "xmlContent/test_fable.xml";

		}
		else {

			path += "xmlContent/test_fable.xml";//path.CMD_SPD_LIN_FROM_ECLIPSE;

		}

//		defaults.put(PeaksearchPreferencesPage.XML_OPTION_PEAKSEARCH, path);
	} catch (IOException e) {

		fail(e.getMessage());
	}
	System.out.print(path);
}

}
