import sys
import numpy as N

from Fabric import integrateclass
from optparse import OptionParser
from Fabric import plothstclass

def get_options(parser):
    parser = OptionParser()

    parser.add_option("-n", "--stem", action="store",
                      dest="stem", type="string",
                      help="Stem of the harvest files")
    parser.add_option("-D", "--dir", action="store",
                      dest="direc", type="string",default='.',
                      help="directory of the harvest files")
    parser.add_option("-g", "--grain", action="store",
                      dest="grainno", type="int",default=0,
                      help="Grain number")
    parser.add_option("-r", "--reflection", action="store",
                      dest="reflno", type="int",default=0,
                      help="Reflection number")
    parser.add_option("-z", "--zoom", action="store",
                      dest="zoom", type="int",default=5,
                      help="Zoom factor for images")
    parser.add_option("-d", "--debug", action="store_true",
                      dest="debug",default =False,
                      help="Run in debug mode")
    options , args = parser.parse_args()
   
    return options

def run(options):
    if options.stem == None:
        parser.print_help()
        logging.info("No stem (part of file name before the file number) provided [-n stem]\n")
        sys.exit()
        

    plot = plothstclass.plothst(direc=options.direc,stem=options.stem,grainno=options.grainno,reflno=options.reflno)
    