/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.EvalutationReference;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.internal.navigator.extensions.OverridePolicy;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NavigatorContentDescriptorManager {
    private static final NavigatorContentDescriptorManager INSTANCE = new NavigatorContentDescriptorManager();
    private final Map firstClassDescriptorsMap = new HashMap();
    private final Map allDescriptors = new HashMap();
    private final Map cachedTriggerPointEvaluations = new WeakHashMap();
    private final Map cachedPossibleChildrenEvaluations = new WeakHashMap();
    private ImageRegistry imageRegistry;
    private final Set overridingDescriptors = new HashSet();
    private final Set saveablesProviderDescriptors = new HashSet();
    private final Set firstClassDescriptorsSet = new HashSet();

    public static NavigatorContentDescriptorManager getInstance() {
        return INSTANCE;
    }

    private NavigatorContentDescriptorManager() {
        new NavigatorContentDescriptorRegistry().readRegistry();
    }

    public NavigatorContentDescriptor[] getAllContentDescriptors() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.allDescriptors.size()];
        finalDescriptors = this.allDescriptors.values().toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionPriorityComparator.INSTANCE);
        return finalDescriptors;
    }

    public NavigatorContentDescriptor[] getContentDescriptorsWithSaveables() {
        NavigatorContentDescriptor[] finalDescriptors = new NavigatorContentDescriptor[this.saveablesProviderDescriptors.size()];
        this.saveablesProviderDescriptors.toArray(finalDescriptors);
        Arrays.sort(finalDescriptors, ExtensionPriorityComparator.INSTANCE);
        return finalDescriptors;
    }

    public Set findDescriptorsForTriggerPoint(Object anElement, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache cache = this.getEvaluationCache(this.cachedTriggerPointEvaluations, aVisibilityAssistant);
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        NavigatorContentDescriptor[] cachedDescriptors = null;
        cachedDescriptors = cache.getDescriptors(anElement);
        if (cachedDescriptors != null) {
            descriptors.addAll(Arrays.asList(cachedDescriptors));
        }
        Iterator contentDescriptorsItr = this.firstClassDescriptorsMap.values().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!aVisibilityAssistant.isActive(descriptor) || !aVisibilityAssistant.isVisible(descriptor) || !descriptor.isTriggerPoint(anElement)) continue;
            descriptors.add(descriptor);
        }
        cache.setDescriptors(anElement, descriptors.toArray(new NavigatorContentDescriptor[descriptors.size()]));
        return descriptors;
    }

    private EvaluationCache getEvaluationCache(Map anEvaluationMap, VisibilityAssistant aVisibilityAssistant) {
        EvaluationCache c = (EvaluationCache)anEvaluationMap.get(aVisibilityAssistant);
        if (c == null) {
            c = new EvaluationCache(aVisibilityAssistant);
            anEvaluationMap.put(aVisibilityAssistant, c);
        }
        return c;
    }

    public Set findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant) {
        return this.findDescriptorsForPossibleChild(anElement, aVisibilityAssistant, true);
    }

    public Set findDescriptorsForPossibleChild(Object anElement, VisibilityAssistant aVisibilityAssistant, boolean toComputeOverrides) {
        EvaluationCache cache = this.getEvaluationCache(this.cachedPossibleChildrenEvaluations, aVisibilityAssistant);
        TreeSet<NavigatorContentDescriptor> descriptors = new TreeSet<NavigatorContentDescriptor>(ExtensionPriorityComparator.INSTANCE);
        NavigatorContentDescriptor[] cachedDescriptors = null;
        cachedDescriptors = cache.getDescriptors(anElement, toComputeOverrides);
        if (cachedDescriptors != null) {
            descriptors.addAll(Arrays.asList(cachedDescriptors));
        }
        if (toComputeOverrides) {
            this.addDescriptorsForPossibleChild(anElement, this.firstClassDescriptorsSet, aVisibilityAssistant, descriptors);
        } else {
            Iterator contentDescriptorsItr = this.allDescriptors.values().iterator();
            while (contentDescriptorsItr.hasNext()) {
                boolean isApplicable;
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
                boolean bl = isApplicable = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && descriptor.isPossibleChild(anElement);
                if (!isApplicable) continue;
                descriptors.add(descriptor);
            }
        }
        cache.setDescriptors(anElement, descriptors.toArray(new NavigatorContentDescriptor[descriptors.size()]), toComputeOverrides);
        return descriptors;
    }

    private boolean addDescriptorsForPossibleChild(Object anElement, Set theChildDescriptors, VisibilityAssistant aVisibilityAssistant, Set theFoundDescriptors) {
        int initialSize = theFoundDescriptors.size();
        Iterator contentDescriptorsItr = theChildDescriptors.iterator();
        while (contentDescriptorsItr.hasNext()) {
            boolean isApplicable;
            NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            boolean bl = isApplicable = aVisibilityAssistant.isActive(descriptor) && aVisibilityAssistant.isVisible(descriptor) && descriptor.isPossibleChild(anElement);
            if (descriptor.hasOverridingExtensions()) {
                boolean isOverridden = this.addDescriptorsForPossibleChild(anElement, descriptor.getOverriddingExtensions(), aVisibilityAssistant, theFoundDescriptors);
                if (isOverridden || !isApplicable) continue;
                theFoundDescriptors.add(descriptor);
                continue;
            }
            if (!isApplicable) continue;
            theFoundDescriptors.add(descriptor);
        }
        return initialSize < theFoundDescriptors.size();
    }

    public NavigatorContentDescriptor getContentDescriptor(String id) {
        return (NavigatorContentDescriptor)this.allDescriptors.get(id);
    }

    public String getText(String descriptorId) {
        NavigatorContentDescriptor descriptor = this.getContentDescriptor(descriptorId);
        if (descriptor != null) {
            return descriptor.getName();
        }
        return descriptorId;
    }

    public Image getImage(String descriptorId) {
        return this.retrieveAndStoreImage(descriptorId);
    }

    protected Image retrieveAndStoreImage(String descriptorId) {
        ImageDescriptor imageDescriptor;
        String icon;
        NavigatorContentDescriptor contentDescriptor = this.getContentDescriptor(descriptorId);
        Image image = null;
        if (contentDescriptor != null && (icon = contentDescriptor.getIcon()) != null && ((image = this.getImageRegistry().get(icon)) == null || image.isDisposed()) && (imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)contentDescriptor.getContribution().getPluginId(), (String)icon)) != null && (image = imageDescriptor.createImage()) != null) {
            this.getImageRegistry().put(icon, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNavigatorContentDescriptor(NavigatorContentDescriptor desc) {
        if (desc == null) {
            return;
        }
        Map map = this.firstClassDescriptorsMap;
        synchronized (map) {
            if (this.firstClassDescriptorsMap.containsKey(desc.getId())) {
                NavigatorPlugin.logError(0, "An extension already exists with id \"" + desc.getId() + "\".", null);
            } else {
                if (desc.getSuppressedExtensionId() == null) {
                    this.firstClassDescriptorsMap.put(desc.getId(), desc);
                    this.firstClassDescriptorsSet.add(desc);
                } else {
                    this.overridingDescriptors.add(desc);
                }
                this.allDescriptors.put(desc.getId(), desc);
                if (desc.hasSaveablesProvider()) {
                    this.saveablesProviderDescriptors.add(desc);
                }
            }
        }
    }

    private void computeOverrides() {
        if (this.overridingDescriptors.size() > 0) {
            Iterator overridingIterator = this.overridingDescriptors.iterator();
            while (overridingIterator.hasNext()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)overridingIterator.next();
                NavigatorContentDescriptor overriddenDescriptor = (NavigatorContentDescriptor)this.allDescriptors.get(descriptor.getSuppressedExtensionId());
                if (overriddenDescriptor != null) {
                    overriddenDescriptor.getOverriddingExtensions().add(descriptor);
                    descriptor.setOverriddenDescriptor(overriddenDescriptor);
                    if (descriptor.getOverridePolicy() != OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt) continue;
                    this.firstClassDescriptorsMap.put(descriptor.getId(), descriptor);
                    this.firstClassDescriptorsSet.add(descriptor);
                    continue;
                }
                NavigatorPlugin.logError(0, "Invalid suppressedExtensionId (\"" + descriptor.getSuppressedExtensionId() + "\" specified from " + descriptor.getContribution().getPluginId() + ". No extension with matching id found.", null);
            }
        }
    }

    private ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
        }
        return this.imageRegistry;
    }

    private class EvaluationCache
    implements VisibilityAssistant.VisibilityListener {
        private final Map evaluations = new HashMap();
        private final Map evaluationsWithOverrides = new HashMap();

        EvaluationCache(VisibilityAssistant anAssistant) {
            anAssistant.addListener(this);
        }

        protected final NavigatorContentDescriptor[] getDescriptors(Object anElement) {
            return this.getDescriptors(anElement, true);
        }

        protected final void setDescriptors(Object anElement, NavigatorContentDescriptor[] theDescriptors) {
            this.setDescriptors(anElement, theDescriptors, true);
        }

        protected final NavigatorContentDescriptor[] getDescriptors(Object anElement, boolean toComputeOverrides) {
            if (anElement == null) {
                return null;
            }
            NavigatorContentDescriptor[] cachedDescriptors = null;
            if (toComputeOverrides) {
                SoftReference cache = (SoftReference)this.evaluations.get(anElement);
                if (cache != null && (cachedDescriptors = (NavigatorContentDescriptor[])cache.get()) == null) {
                    this.evaluations.remove(anElement);
                }
                return cachedDescriptors;
            }
            SoftReference cache = (SoftReference)this.evaluationsWithOverrides.get(anElement);
            if (cache != null && (cachedDescriptors = (NavigatorContentDescriptor[])cache.get()) == null) {
                this.evaluationsWithOverrides.remove(anElement);
            }
            return cachedDescriptors;
        }

        protected final void setDescriptors(Object anElement, NavigatorContentDescriptor[] theDescriptors, boolean toComputeOverrides) {
            if (anElement != null) {
                if (toComputeOverrides) {
                    this.evaluations.put(new EvalutationReference(anElement), new SoftReference<NavigatorContentDescriptor[]>(theDescriptors));
                } else {
                    this.evaluationsWithOverrides.put(new EvalutationReference(anElement), new SoftReference<NavigatorContentDescriptor[]>(theDescriptors));
                }
            }
        }

        public void onVisibilityOrActivationChange() {
            this.evaluations.clear();
            this.evaluationsWithOverrides.clear();
        }
    }

    private class NavigatorContentDescriptorRegistry
    extends NavigatorContentRegistryReader {
        private NavigatorContentDescriptorRegistry() {
        }

        public void readRegistry() {
            super.readRegistry();
            NavigatorContentDescriptorManager.this.computeOverrides();
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if ("navigatorContent".equals(anElement.getName())) {
                try {
                    NavigatorContentDescriptorManager.this.addNavigatorContentDescriptor(new NavigatorContentDescriptor(anElement));
                }
                catch (WorkbenchException e) {
                    NavigatorPlugin.log(e.getStatus());
                }
            }
            return super.readElement(anElement);
        }
    }
}

