/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.actions.ColumnEditorAction;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.views.FableIOConsole;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenColumnFileResourceAction
implements IObjectActionDelegate {
    private ISelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IFile iFile = null;
        if (this.selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)this.selection).iterator();
            while (it.hasNext()) {
                iFile = null;
                Object element = it.next();
                if (element instanceof IFile) {
                    iFile = (IFile)element;
                } else if (element instanceof IAdaptable) {
                    iFile = (IFile)((IAdaptable)element).getAdapter(IFile.class);
                }
                if (iFile == null) continue;
                this.loadFile(iFile);
            }
        }
    }

    private void loadFile(IFile iFile) {
        final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            try {
                final String fileToLoad = iFile.getLocation().toString();
                Job j = new Job("Load column file job " + fileToLoad){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Please wait while loading file in editor " + fileToLoad, -1);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ColumnFileEditorInput input = new ColumnFileEditorInput(fileToLoad);
                        IWorkbenchPage page = window.getActivePage();
                        monitor.done();
                        ColumnEditorAction.openEditors(input, page);
                        return Status.OK_STATUS;
                    }
                };
                j.setUser(true);
                j.schedule();
                j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        if (event.getResult().isOK()) {
                            if (FableIOConsole.console != null) {
                                FableIOConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " completed successfully");
                            }
                        } else if (FableIOConsole.console != null) {
                            FableIOConsole.console.displayOut(String.valueOf(event.getJob().getName()) + " did not complete successfully");
                        }
                    }
                });
            }
            catch (Exception ex) {
                FableUtils.excMsg((Object)this, (String)"Error opening ColFile", (Throwable)ex);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

