/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.rcp;

import fable.framework.database.DerbyDatabase;
import fable.framework.toolbox.FableUtils;
import java.sql.SQLException;
import java.util.Dictionary;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final boolean DEBUG_FLOW = false;
    public static final String GRAINS_NAME = "grains";
    public static final String GRAINFITS_NAME = "grainfits";
    public static final String FILES_NAME = "files";
    public static final String PLUGIN_ID = "fable.grainspotter";
    public static String VERSION = "0.0.0";
    private static Activator plugin;
    public static DerbyDatabase database;

    static {
        database = null;
    }

    public Activator() {
        plugin = this;
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        Dictionary bundleHeaders = bundle.getHeaders();
        VERSION = (String)bundleHeaders.get("Bundle-Version");
        try {
            database = DerbyDatabase.getDatabase();
        }
        catch (SQLException ex) {
            String msg = "Problems getting the Derby database: " + ex.getMessage();
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)msg, (Throwable)ex);
            database = null;
        }
        if (database != null) {
            this.createTables();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void createTables() {
        block8: {
            String msg;
            block7: {
                block6: {
                    try {
                        database.createTable("grains (fid int, grain int, gve_expected int, gve_measured int, ia double, u11 double, u12 double, u13 double, u21 double, u22 double, u23 double, u31 double, u32 double, u33 double)");
                    }
                    catch (SQLException ex) {
                        if (ex.getSQLState().equals("X0Y32")) break block6;
                        msg = "Problems creating table grains: " + ex.getMessage();
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)msg, (Throwable)ex);
                    }
                }
                try {
                    database.createTable("grainfits (fid int, grain int, gvector int, h int, k int, l int,h_pred double,k_pred double, l_pred double, dh double, dk double, dl double, tth_meas double, tth_pred double, dtth double, omega_meas double, omega_pred double, domega double, eta_meas double, eta_pred double, deta double, ia double)");
                }
                catch (SQLException ex) {
                    if (ex.getSQLState().equals("X0Y32")) break block7;
                    msg = "Problems creating table grainfits: " + ex.getMessage();
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)msg, (Throwable)ex);
                }
            }
            try {
                database.createTable("files (fid int, filename varchar(32672), timestamp timestamp)");
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals("X0Y32")) break block8;
                msg = "Problems creating table files: " + ex.getMessage();
                FableUtils.excNoTraceMsg((Object)((Object)this), (String)msg, (Throwable)ex);
            }
        }
    }
}

