/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.grainspotter.internal.GrainSpotterListener;
import fable.grainspotter.providers.GrainSpotterContentProvider;
import fable.grainspotter.providers.GrainSpotterLabelProvider;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.LogFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;

public class GrainSpotterLogFileTable
extends Composite {
    private static final boolean DEBUG_FLOW = false;
    private String grainsName = "grains";
    private String grainFitsName = "grainfits";
    private TreeViewer viewer;
    private LogFile logFile;
    private GrainSpotterListener listener;
    public static final int MAX_TREE_LEVEL = 4;
    private int treeLevel = 1;
    private Action collapseAction;
    private Action expandAction;

    public GrainSpotterLogFileTable(Composite parent, int style, LogFile logFile) {
        super(parent, style);
        this.setLogFile(logFile);
        this.createContents();
    }

    private void createContents() {
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.createTree(this);
        this.makeActions();
        this.hookContextMenu(this.viewer.getControl());
    }

    private void hookContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GrainSpotterLogFileTable.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.collapseAction);
        manager.add((IAction)this.expandAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.collapseAction = new Action("Collapse Tree"){

            public void run() {
                GrainSpotterLogFileTable.this.collapseTreeToNextLevel();
            }
        };
        this.collapseAction.setToolTipText("Collapse the tree one level");
        this.collapseAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/collapseall.gif"));
        this.expandAction = new Action("Expand Tree"){

            public void run() {
                GrainSpotterLogFileTable.this.expandTreeToNextLevel();
            }
        };
        this.expandAction.setToolTipText("Expand the tree one level");
        this.expandAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"icons/expandall.gif"));
    }

    private void collapseTreeToNextLevel() {
        if (this.treeLevel > 1) {
            --this.treeLevel;
            this.viewer.collapseAll();
            this.viewer.expandToLevel(this.treeLevel);
        }
    }

    private void expandTreeToNextLevel() {
        if (this.treeLevel <= 4) {
            ++this.treeLevel;
            this.viewer.expandToLevel(this.treeLevel);
        }
    }

    private void createTree(Composite parent) {
        this.viewer = new TreeViewer(parent, 783);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setLayout((Layout)new GridLayout());
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn col = new TreeColumn(this.viewer.getTree(), 0x1000000);
        this.viewer.getTree().setHeaderVisible(true);
        col.setText("Text");
        col.setWidth(400);
        TreeColumn col2 = new TreeColumn(this.viewer.getTree(), 0x1000000);
        col2.setText("Values");
        col2.setWidth(100);
        this.viewer.setContentProvider((IContentProvider)new GrainSpotterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GrainSpotterLabelProvider());
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    private void setLogFile(LogFile logFile) {
        if (logFile == this.logFile || logFile == null) {
            return;
        }
        this.logFile = logFile;
        if (!logFile.getLogFileRead()) {
            if (this.viewer != null) {
                this.viewer.setInput(null);
            }
        } else {
            this.getParent().setCursor(null);
            if (this.viewer != null) {
                this.viewer.setInput((Object)this.logFile.getGrains());
            }
        }
        this.treeLevel = 1;
        if (this.logFile != null && this.listener != null) {
            this.logFile.removeGrainSpotterListener(this.listener);
            this.listener = null;
        }
        logFile.addGrainSpotterListener(new GrainSpotterListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (GrainSpotterLogFileTable.this.viewer != null) {
                    GrainSpotterLogFileTable.this.viewer.setInput((Object)GrainSpotterLogFileTable.this.logFile.getGrains());
                }
                GrainSpotterLogFileTable.this.treeLevel = 1;
            }
        });
    }

    public int getTreeLevel() {
        return this.treeLevel;
    }

    public void setTreeLevel(int treeLevel) {
        this.treeLevel = treeLevel;
    }

    public String getGrainsName() {
        return this.grainsName;
    }

    public String getGrainfitsName() {
        return this.grainFitsName;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public Action getCollapseAction() {
        return this.collapseAction;
    }

    public Action getExpandAction() {
        return this.expandAction;
    }
}

