/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.log.LogFactory;
import org.mortbay.util.ByteArrayISO8859Writer;

public abstract class AbstractHttpHandler
implements HttpHandler {
    private static Log log = LogFactory.getLog(AbstractHttpHandler.class);
    private String _name;
    private transient HttpContext _context;
    private transient boolean _started = false;

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!log.isDebugEnabled()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public HttpContext getHttpContext() {
        return this._context;
    }

    public void initialize(HttpContext context) {
        if (this._context == null) {
            this._context = context;
        } else if (this._context != context) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
    }

    public void start() throws Exception {
        if (this._context == null) {
            throw new IllegalStateException("No context for " + this);
        }
        this._started = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started " + this));
        }
    }

    public void stop() throws InterruptedException {
        this._started = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopped " + this));
        }
    }

    public boolean isStarted() {
        return this._started;
    }

    public String toString() {
        return this.getName() + " in " + this._context;
    }

    public void handleTrace(HttpRequest request, HttpResponse response) throws IOException {
        boolean trace = this.getHttpContext().getHttpServer().getTrace();
        response.setField("Content-Type", "message/http");
        if (trace) {
            OutputStream out = response.getOutputStream();
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
            writer.write(request.toString());
            writer.flush();
            response.setIntField("Content-Length", writer.size());
            writer.writeTo(out);
            out.flush();
        }
        request.setHandled(true);
    }
}

