/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.IntroGroup;
import org.eclipse.ui.internal.intro.impl.model.IntroHTML;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroSeparator;
import org.eclipse.ui.internal.intro.impl.model.IntroText;
import org.eclipse.ui.internal.intro.impl.model.loader.ContentProviderManager;
import org.eclipse.ui.internal.intro.impl.model.url.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class PageWidgetFactory {
    protected HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            String url = (String)e.getHref();
            IntroURLParser parser = new IntroURLParser(url);
            if (parser.hasIntroUrl()) {
                parser.getIntroURL().execute();
                return;
            }
            if (parser.hasProtocol()) {
                Util.openBrowser(url);
                return;
            }
            DialogUtil.displayInfoMessage(((Control)e.getSource()).getShell(), String.valueOf(Messages.HyperlinkAdapter_urlIs) + " " + url);
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }
    };
    protected FormToolkit toolkit;
    protected PageStyleManager styleManager;
    protected IIntroContentProviderSite site;

    protected PageWidgetFactory(FormToolkit toolkit, PageStyleManager styleManager) {
        this.toolkit = toolkit;
        this.styleManager = styleManager;
    }

    public void setContentProviderSite(IIntroContentProviderSite site) {
        this.site = site;
    }

    public void createIntroElement(Composite parent, AbstractIntroElement element) {
        boolean isFiltered = this.getFilterState(element);
        if (isFiltered) {
            return;
        }
        Composite c = null;
        switch (element.getType()) {
            case 16: {
                IntroGroup group = (IntroGroup)element;
                c = this.createGroup(parent, group);
                this.updateLayoutData((Control)c, element);
                Composite newParent = c;
                if (c instanceof Section) {
                    newParent = (Composite)((Section)newParent).getClient();
                }
                AbstractIntroElement[] children = group.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.createIntroElement(newParent, children[i]);
                    ++i;
                }
                break;
            }
            case 64: {
                IntroLink link = (IntroLink)element;
                c = this.createImageHyperlink(parent, link);
                this.updateLayoutData((Control)c, element);
                break;
            }
            case 512: {
                IntroText text = (IntroText)element;
                c = this.createText(parent, text);
                this.updateLayoutData((Control)c, element);
                break;
            }
            case 128: {
                IntroImage image = (IntroImage)element;
                c = this.createImage(parent, image);
                if (c == null) break;
                this.updateLayoutData((Control)c, element);
                break;
            }
            case 32: {
                IntroHTML html = (IntroHTML)element;
                if (html.isInlined()) {
                    IntroText htmlText = html.getIntroText();
                    if (htmlText != null) {
                        c = this.createText(parent, htmlText);
                    } else {
                        IntroImage htmlImage = html.getIntroImage();
                        if (htmlImage != null) {
                            c = this.createImage(parent, htmlImage);
                        }
                    }
                } else {
                    String embddedLink = html.getSrc();
                    if (embddedLink == null) break;
                    String linkText = StringUtil.concat("<p><a href=\"http://org.eclipse.ui.intro/openBrowser?url=", embddedLink, "\">", Messages.HTML_embeddedLink, "</a></p>").toString();
                    linkText = this.generateFormText(linkText);
                    c = this.createFormText(parent, linkText, null);
                }
                if (c == null) break;
                this.updateLayoutData((Control)c, element);
                break;
            }
            case 16384: {
                IntroContentProvider provider = (IntroContentProvider)element;
                c = this.createContentProvider(parent, provider);
                this.updateLayoutData((Control)c, element);
                break;
            }
            case 524288: {
                IntroSeparator sep = (IntroSeparator)element;
                c = this.createSeparator(parent, sep);
                this.updateLayoutData((Control)c, element);
                break;
            }
        }
    }

    private void updateLayoutData(Control c, AbstractIntroElement element) {
        TableWrapData currentTd = (TableWrapData)c.getLayoutData();
        if (currentTd == null) {
            currentTd = new TableWrapData(128, 128);
            currentTd.grabHorizontal = true;
            c.setLayoutData((Object)currentTd);
        }
        currentTd.colspan = this.styleManager.getColSpan((AbstractBaseIntroElement)element);
        currentTd.rowspan = this.styleManager.getRowSpan((AbstractBaseIntroElement)element);
    }

    private Composite createGroup(Composite parent, IntroGroup group) {
        String label = group.getLabel();
        String description = this.styleManager.getDescription(group);
        boolean expandable = group.isExpandable();
        boolean expanded = group.isExpanded();
        Composite client = null;
        Composite control = null;
        if (description != null || label != null || expandable) {
            int style;
            int n = style = description != null ? 128 : 0;
            if (expandable) {
                style |= 0x1A;
            }
            if (expanded) {
                style |= 0x40;
            }
            Section section = this.toolkit.createSection(parent, style);
            if (label != null) {
                section.setText(label);
            }
            if (description != null) {
                section.setDescription(description);
            }
            this.colorControl((Control)section, group);
            client = this.toolkit.createComposite((Composite)section, 64);
            section.setClient((Control)client);
            control = section;
        } else {
            control = client = this.toolkit.createComposite(parent, 64);
        }
        TableWrapLayout layout = new TableWrapLayout();
        int numColumns = this.styleManager.getNumberOfColumns(group);
        layout.numColumns = numColumns = numColumns < 1 ? 1 : numColumns;
        layout.makeColumnsEqualWidth = this.styleManager.getEqualWidth(group);
        layout.verticalSpacing = this.styleManager.getVerticalSpacing(group);
        layout.horizontalSpacing = this.styleManager.getHorizantalSpacing(group);
        client.setLayout((Layout)layout);
        return control;
    }

    private Control createImageHyperlink(Composite parent, IntroLink link) {
        ImageHyperlink control;
        ImageHyperlink linkControl;
        boolean showLinkDescription = this.styleManager.getShowLinkDescription();
        Image linkImage = this.styleManager.getImage(link, "link-icon", "link");
        if (showLinkDescription && link.getText() != null) {
            Composite container = this.toolkit.createComposite(parent);
            TableWrapLayout layout = new TableWrapLayout();
            layout.rightMargin = 0;
            layout.leftMargin = 0;
            layout.bottomMargin = 0;
            layout.topMargin = 0;
            layout.verticalSpacing = 0;
            layout.numColumns = 2;
            container.setLayout((Layout)layout);
            ImageHyperlink ilabel = this.toolkit.createImageHyperlink(container, 0);
            ilabel.setImage(linkImage);
            ilabel.setHoverImage(this.styleManager.getImage(link, "hover-icon", null));
            ilabel.setHref((Object)link.getUrl());
            ilabel.addHyperlinkListener((IHyperlinkListener)this.hyperlinkAdapter);
            TableWrapData td = new TableWrapData();
            td.valign = 16;
            td.rowspan = 2;
            ilabel.setLayoutData((Object)td);
            linkControl = this.toolkit.createHyperlink(container, null, 64);
            td = new TableWrapData(2, 64);
            td.grabVertical = true;
            linkControl.setLayoutData((Object)td);
            Control desc = this.createText(container, link.getIntroText());
            td = new TableWrapData(128, 16);
            td.grabHorizontal = true;
            td.grabVertical = true;
            desc.setLayoutData((Object)td);
            control = container;
        } else {
            ImageHyperlink imageLink = this.toolkit.createImageHyperlink(parent, 0x1000040);
            imageLink.setImage(linkImage);
            imageLink.setHoverImage(this.styleManager.getImage(link, "hover-icon", null));
            TableWrapData td = new TableWrapData();
            td.grabHorizontal = true;
            imageLink.setLayoutData((Object)td);
            control = linkControl = imageLink;
        }
        linkControl.setText(link.getLabel());
        linkControl.setFont(PageStyleManager.getBannerFont());
        this.colorControl((Control)linkControl, link);
        linkControl.setHref((Object)link.getUrl());
        linkControl.addHyperlinkListener((IHyperlinkListener)this.hyperlinkAdapter);
        return control;
    }

    protected Control createText(Composite parent, IntroText text) {
        Color fg = this.styleManager.getColor(this.toolkit, text);
        boolean isBold = this.styleManager.isBold(text);
        if (text.isFormatted()) {
            return this.createFormText(parent, this.generateFormText(text.getText()), fg);
        }
        if (isBold) {
            return this.createFormText(parent, this.generateBoldFormText(text.getText()), fg);
        }
        return this.createText(parent, text.getText(), fg);
    }

    private Control createFormText(Composite parent, String text, Color fg) {
        FormText formText = this.toolkit.createFormText(parent, false);
        formText.addHyperlinkListener((IHyperlinkListener)this.hyperlinkAdapter);
        try {
            formText.setText(text, true, true);
        }
        catch (SWTError e) {
            Log.error(e.getMessage(), e);
            return this.createText(parent, text, fg);
        }
        if (fg != null) {
            formText.setForeground(fg);
        }
        return formText;
    }

    private Control createText(Composite parent, String text, Color fg) {
        Label label = this.toolkit.createLabel(parent, text, 64);
        if (fg != null) {
            label.setForeground(fg);
        }
        return label;
    }

    protected Control createImage(Composite parent, IntroImage image) {
        Label ilabel = null;
        Image imageFile = this.styleManager.getImage(image);
        if (imageFile != null) {
            ilabel = this.toolkit.createLabel(parent, null, 16384);
            ilabel.setImage(imageFile);
            if (image.getAlt() != null) {
                ilabel.setToolTipText(image.getAlt());
            }
        }
        if (ilabel != null) {
            TableWrapData td = new TableWrapData();
            ilabel.setLayoutData((Object)td);
        }
        return ilabel;
    }

    public Control createContentProvider(Composite parent, IntroContentProvider provider) {
        IntroText text;
        Composite container = this.toolkit.createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        container.setLayout((Layout)layout);
        container.setData((Object)provider);
        IIntroContentProvider providerClass = ContentProviderManager.getInst().getContentProvider(provider);
        if (providerClass == null) {
            providerClass = ContentProviderManager.getInst().createContentProvider(provider, this.site);
        }
        if (providerClass != null) {
            try {
                providerClass.createContent(provider.getId(), container, this.toolkit);
            }
            catch (Exception e) {
                Log.error("Failed to create the content of Intro model content provider: " + provider.getClassName(), e);
                providerClass = null;
            }
        }
        if (providerClass == null && (text = provider.getIntroText()) != null) {
            this.createText(container, text);
        }
        return container;
    }

    protected Control createSeparator(Composite parent, IntroSeparator sep) {
        String key = String.valueOf(sep.getParentPage().getId()) + ".separator.fg";
        Color fg = this.styleManager.getColor(this.toolkit, key);
        Composite l = new Composite(parent, 0);
        if (fg != null) {
            l.setBackground(fg);
        } else {
            l.setBackground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        }
        TableWrapData td = new TableWrapData(128, 128);
        td.grabHorizontal = true;
        td.maxHeight = 1;
        l.setLayoutData((Object)td);
        return l;
    }

    private void colorControl(Control elementControl, AbstractBaseIntroElement element) {
        Color bg;
        Color fg = this.styleManager.getColor(this.toolkit, element);
        if (fg != null) {
            elementControl.setForeground(fg);
        }
        if ((bg = this.styleManager.getBackgrond(this.toolkit, element)) != null) {
            elementControl.setBackground(bg);
        }
    }

    private String generateFormText(String text) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<form>");
        if (text.startsWith("<p>")) {
            sbuf.append(text);
        } else {
            sbuf.append("<p>");
            sbuf.append(text);
            sbuf.append("</p>");
        }
        sbuf.append("</form>");
        return sbuf.toString();
    }

    private String generateBoldFormText(String text) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<form>");
        sbuf.append("<p>");
        sbuf.append("<b>");
        sbuf.append(text);
        sbuf.append("</b>");
        sbuf.append("</p>");
        sbuf.append("</form>");
        return sbuf.toString();
    }

    private boolean getFilterState(AbstractIntroElement element) {
        if (element.isOfType(21245)) {
            return ((AbstractBaseIntroElement)element).isFiltered();
        }
        return false;
    }
}

