/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.ColumnFileId;
import fable.framework.toolbox.FableUtils;
import fable.python.jep.FableJep;
import java.io.File;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class ColumnFile {
    private FableJep fableJep;
    protected HashMap<String, double[]> columns = new HashMap();
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private Logger logger;
    private String fullFileName;
    private String fileName;
    int nCols = 0;
    int nRows = 0;
    float[] unitCell;
    public String[] titles;
    private float[] table_data;
    private HashMap<String, Integer> column_index;
    private int sortedColumnIndex;
    private int sortedDirection;
    private float[] bigArraySorted;

    public ColumnFile() throws JepException {
        this.fableJep = new FableJep();
        this.importModules();
        this.logger = Logger.getLogger(ColumnFile.class);
    }

    public ColumnFile(FableJep jep_as_parameter) throws JepException {
        this.fableJep = jep_as_parameter;
        this.importModules();
        this.logger = Logger.getLogger(ColumnFile.class);
        this.fireAddColumnFile();
    }

    private void importModules() {
        try {
            FableJep.jepImportModules(this.fableJep.getJep(), "numpy");
            FableJep.jepImportSpecificDefinition(this.fableJep.getJep(), "ImageD11", "columnfile");
        }
        catch (JepException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Error importing modules", (Throwable)ex);
        }
    }

    public ColumnFile(String _fileName) throws JepException {
        this();
        this.loadColumnFile(_fileName);
    }

    public void loadColumnFile(String _fileName) {
        try {
            this.fableJep.set("name", _fileName);
            this.setFileName(_fileName);
            this.fableJep.eval("column_object=columnfile.columnfile(name)");
            this.fableJep.eval("column_object.readfile(name)");
            this.loadRows();
            this.sortedColumnIndex = this.getColumnIDIndex();
            this.setSortedIndex(this.sortedColumnIndex, 128);
            if (this.sortedColumnIndex < 0) {
                this.sortedColumnIndex = 0;
            }
            this.fireAddColumnFile();
        }
        catch (JepException e) {
            this.logger.debug((Object)e.getMessage());
        }
    }

    public void setFileName(String name) {
        this.fullFileName = name;
        this.fileName = this.fullFileName != null && this.fullFileName.length() > 1 ? this.fullFileName.substring(this.fullFileName.lastIndexOf(File.separatorChar) + 1) : "";
    }

    public String getFullFileName() {
        return this.fullFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setPythonObject(FableJep jep_as_parameter) throws JepException {
        this.fableJep = jep_as_parameter;
        this.logger = Logger.getLogger(ColumnFile.class);
        this.fullFileName = (String)this.fableJep.getValue("column_object.filename");
    }

    public void loadRows() {
        try {
            float f = 0.0f;
            Object objRows = this.fableJep.getValue("column_object.nrows");
            if (objRows instanceof Integer) {
                FableLogger.getLogger().debug((Object)"Integer");
                this.nRows = (Integer)this.fableJep.getValue("column_object.nrows");
            } else if (objRows instanceof Float) {
                FableLogger.getLogger().debug((Object)"Float");
                f = ((Float)this.fableJep.getValue("column_object.nrows")).floatValue();
                this.nRows = (int)f;
            }
            f = 0.0f;
            Object objCols = this.fableJep.getValue("column_object.ncols");
            if (objCols instanceof Integer) {
                FableLogger.getLogger().debug((Object)"Integer");
                this.nCols = (Integer)this.fableJep.getValue("column_object.ncols");
            } else if (objCols instanceof Float) {
                FableLogger.getLogger().debug((Object)"Float");
                f = ((Float)this.fableJep.getValue("column_object.ncols")).floatValue();
                this.nCols = (int)f;
            }
            this.titles = new String[this.nCols];
            this.column_index = new HashMap();
            int i = 0;
            while (i < this.nCols) {
                this.fableJep.set("i", i);
                this.titles[i] = (String)this.fableJep.getValue("column_object.titles[i]");
                this.column_index.put(this.titles[i], i);
                ++i;
            }
            this.table_data = this.fableJep.getValue_floatarray("column_object.bigarray.astype(numpy.float32).tostring()");
        }
        catch (JepException e) {
            this.logger.error((Object)("can not create loadRows : " + e.getMessage()));
        }
    }

    public String getColumnfileId() {
        String id = "";
        if (this.fileName != null && this.fileName.toLowerCase().endsWith(ColumnFileId.getString((String)"ColumnFile.flt"))) {
            id = ColumnFileId.getString((String)"ColumnFile.idflt");
        }
        return id;
    }

    public int getColumnIDIndex() {
        int i = 0;
        boolean found = false;
        i = 0;
        while (!found && i < this.titles.length) {
            if (this.titles[i].equals(this.getColumnfileId())) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            i = -1;
        }
        return i - 1;
    }

    public float[] getSortedIndex(int columnIndex) {
        try {
            this.fableJep.set("i", columnIndex);
            if (this.sortedDirection == 128) {
                return this.fableJep.getValue_floatarray("numpy.argsort(column_object.bigarray[i,:]).astype(numpy.float32).tostring()");
            }
            return this.fableJep.getValue_floatarray("numpy.argsort(column_object.bigarray[i,:])[::-1].astype(numpy.float32).tostring()");
        }
        catch (JepException e) {
            this.logger.debug((Object)e.getMessage());
            return null;
        }
    }

    public boolean saveColumnFile(String filename) {
        boolean bok = true;
        try {
            this.fableJep.set("filename", filename);
            this.fableJep.eval("column_object.writefile(filename)");
            this.setFileName(filename);
            this.fireSaveDone();
        }
        catch (JepException jepException) {
            bok = false;
        }
        return bok;
    }

    public HashMap<String, double[]> getColumnstoPlot() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnFile.this.columns.clear();
                    if (ColumnFile.this.fableJep == null) {
                        throw new InvalidObjectException("FableJep is null");
                    }
                    Object val = ColumnFile.this.fableJep.getValue("column_object.ncols");
                    if (val == null) {
                        throw new InvalidObjectException("Value received from FableJep is null");
                    }
                    ColumnFile.this.nCols = (Integer)val;
                    ColumnFile.this.titles = new String[ColumnFile.this.nCols];
                    int i = 0;
                    while (i < ColumnFile.this.nCols) {
                        ColumnFile.this.fableJep.set("i", i);
                        String name = (String)ColumnFile.this.fableJep.getValue("column_object.titles[i]");
                        ColumnFile.this.fableJep.eval("filteredValues=column_object.getcolumn(column_object.titles[i])");
                        float[] myData = ColumnFile.this.fableJep.getValue_floatarray("filteredValues.astype(numpy.float32).tostring()");
                        double[] myDoubleToplot = new double[myData.length];
                        ColumnFile.this.nRows = myData.length;
                        int j = 0;
                        while (j < myData.length) {
                            myDoubleToplot[j] = myData[j];
                            ++j;
                        }
                        ColumnFile.this.titles[i] = name;
                        ColumnFile.this.columns.put(name, myDoubleToplot);
                        ++i;
                    }
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Cannot create columns to plot", (Throwable)ex);
                }
                catch (Exception ex) {
                    FableUtils.excTraceMsg((Object)this, (String)"Unexpected error creating columns to plot", (Throwable)ex);
                }
            }
        });
        return this.columns;
    }

    public float getColumnFileCell(int index, String colName) {
        float returnValue = 0.0f;
        Integer indexColumn = this.column_index.get(colName);
        if (indexColumn != null && (index += indexColumn * this.nRows) < this.table_data.length) {
            returnValue = this.table_data[index];
        }
        return returnValue;
    }

    public void update() {
        this.fireColumnHasBeenUpdated();
    }

    public void AddUnitCell(float[] values) {
        this.unitCell = values;
        this.fireAddUnitCell();
    }

    public float[] getUnitCell() {
        return this.unitCell;
    }

    public int getNRows() {
        return this.nRows;
    }

    public int getNCols() {
        return this.nCols;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireAddColumnFile() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "AddColumn", null, (Object)this));
        }
    }

    public void fireColumnHasBeenUpdated() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "updateColumn", null, (Object)this));
        }
    }

    private void fireSaveDone() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "propdirty", (Object)true, (Object)false));
        }
    }

    public void fireAddUnitCell() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "AddUnitCell", null, (Object)this));
        }
    }

    public void removeDots(String key1, double key1min, double key1max, String key2, double key2min, double key2max) throws JepException {
        if (this.fableJep != null) {
            this.fableJep.set("key1min", key1min);
            this.fableJep.set("key1max", key1max);
            this.fableJep.set("key2min", key2min);
            this.fableJep.set("key2max", key2max);
            this.fableJep.eval("column_object." + key1);
            this.fableJep.eval("mask = (column_object." + key1 + " > key1min) & " + "(column_object." + key1 + "<key1max) & " + "(column_object." + key2 + " > key2min) & " + "(column_object." + key2 + "< key2max)");
            this.fableJep.eval("column_object.filter(~mask)");
            this.loadRows();
            this.initBigArraySorted();
            this.update();
        }
    }

    public void removeRow(Object[] idlist, String id) {
        if (this.fableJep != null) {
            this.makeMaskForSelectedRows(idlist, id);
            try {
                this.fableJep.eval("column_object.filter(~mask)");
                this.loadRows();
                this.initBigArraySorted();
            }
            catch (JepException e) {
                this.logger.debug((Object)"filter on selected rows canno be apply.");
                this.logger.debug((Object)e.getMessage());
            }
            this.update();
        }
    }

    public void keepRow(Object[] rows, String id) {
        if (this.fableJep != null) {
            this.makeMaskForSelectedRows(rows, id);
            try {
                this.fableJep.eval("column_object.filter(mask)");
                this.loadRows();
                this.initBigArraySorted();
            }
            catch (JepException e) {
                this.logger.debug((Object)"filter on selected rows cannot be apply.");
                this.logger.debug((Object)e.getMessage());
            }
            this.update();
        }
    }

    private void initBigArraySorted() {
        this.bigArraySorted = new float[this.nRows];
        this.bigArraySorted = this.getSortedIndex(this.sortedColumnIndex);
    }

    private void makeMaskForSelectedRows(Object[] rows, String id) {
        try {
            this.fableJep.eval("myid = column_object." + id + ".copy().astype(numpy.int32)");
            this.fableJep.eval("mask = numpy.zeros(myid.shape, numpy.int32)");
        }
        catch (JepException e1) {
            this.logger.debug((Object)"mask can not be instantiate.");
            this.logger.debug((Object)e1.getMessage());
        }
        int i = 0;
        while (i < rows.length) {
            try {
                this.fableJep.eval("numpy.add(mask, myid == " + rows[i] + ", mask)");
            }
            catch (JepException e) {
                this.logger.debug((Object)"mask can not be build.");
                this.logger.debug((Object)e.getMessage());
            }
            ++i;
        }
        try {
            this.fableJep.eval("mask = (mask != 0)");
        }
        catch (JepException e) {
            this.logger.debug((Object)"mask can not be converted into a logical type.");
            this.logger.debug((Object)e.getMessage());
        }
    }

    public void keepDots(String key1, double key1min, double key1max, String key2, double key2min, double key2max) throws JepException {
        if (this.fableJep != null) {
            this.fableJep.set("key1min", key1min);
            this.fableJep.set("key1max", key1max);
            this.fableJep.set("key2min", key2min);
            this.fableJep.set("key2max", key2max);
            this.fableJep.eval("mask = (column_object." + key1 + " > key1min) & " + "(column_object." + key1 + "<key1max) & " + "(column_object." + key2 + " > key2min) & " + "(column_object." + key2 + "< key2max)");
            this.fableJep.eval("column_object.filter(mask)");
            this.loadRows();
            this.initBigArraySorted();
            this.update();
        }
    }

    public void displayComputedData(String[] xyLabel) {
        this.firePlotData(xyLabel);
    }

    private void firePlotData(String[] xyLabel) {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "PlotData", null, (Object)xyLabel));
        }
    }

    public void fireRemoveAll() {
        for (IPropertyChangeListener element : this.listeners) {
            if (element == null) continue;
            element.propertyChange(new PropertyChangeEvent((Object)this, "removeAll", null, null));
        }
    }

    public float[] getData() {
        return this.table_data;
    }

    public void setSortedIndex(int index, int dir) {
        this.sortedColumnIndex = index;
        this.sortedDirection = dir;
        this.initBigArraySorted();
    }

    public float[] getRowAt(int index) {
        float[] f = null;
        try {
            this.fableJep.set("col", this.bigArraySorted[index]);
        }
        catch (JepException e) {
            this.logger.debug((Object)("getRowAt/bigArraySorted" + e.getMessage()));
        }
        try {
            f = this.fableJep.getValue_floatarray("column_object.bigarray[:,col].astype(numpy.float32).tostring()");
        }
        catch (JepException e) {
            this.logger.debug((Object)("getRowAt/getValue_floatarray" + e.getMessage()));
        }
        return f;
    }
}

