/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.run;

import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorViewPart;

public class ReadGveThread
implements Runnable {
    String outputMessage;
    private int nGvectors = 0;
    String gvectorFile = null;
    public ArrayList<double[]> gveXYZ = new ArrayList();

    @Override
    public void run() {
        block11: {
            if (this.gvectorFile != null) {
                this.gveXYZ.clear();
                assert (this.gvectorFile != null);
                this.nGvectors = 0;
                boolean regexmatched = false;
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayIn("Start reading gve file " + this.gvectorFile);
                }
                Pattern pattern = Pattern.compile("(.*?xr\\s+yr\\s+zr.*?$)||(.*?gx\\s+gy\\s+gz.*?$)");
                try {
                    String line;
                    File f = new File(this.gvectorFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                    while ((line = reader.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        Matcher matcher = pattern.matcher(line);
                        if (matcher.matches()) {
                            regexmatched = true;
                        }
                        if (!regexmatched || matcher.matches()) continue;
                        double[] xyz = new double[3];
                        ++this.nGvectors;
                        try {
                            String[] outTokens = line.split("\\s+");
                            xyz[0] = Double.valueOf(outTokens[0]);
                            xyz[1] = Double.valueOf(outTokens[1]);
                            xyz[2] = Double.valueOf(outTokens[2]);
                            this.gveXYZ.add(xyz);
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("A problem occured while parsing gve at line:" + line);
                            if (FableMessageConsole.console == null) continue;
                            FableMessageConsole.console.displayError("An error occured while parsing file " + f.getName() + " at line " + line);
                        }
                    }
                    reader.close();
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayIn("Finished reading gve file " + this.gvectorFile + " found " + this.nGvectors + " vectors");
                    }
                    this.open3Dview();
                }
                catch (IOException iOException) {
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error while opening or reading gve file = " + this.gvectorFile);
                    }
                    if (FableMessageConsole.console == null) break block11;
                    FableMessageConsole.console.displayError("Make sure the path and file name are correct and verify the contents");
                }
            }
        }
    }

    public void open3Dview() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Object viewPart = null;
                try {
                    IWorkbenchPage activePage;
                    IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                        activePage.showView("fable.grainspotter.grains3dview");
                    }
                }
                catch (PartInitException e) {
                    FableMessageConsole.console.displayError("Exception occurred showing Grains3DView: " + (Object)((Object)e) + "\n" + e.getMessage());
                    e.printStackTrace();
                }
                if (viewPart instanceof ErrorViewPart) {
                    FableMessageConsole.console.displayError("Error showing Grains3DView");
                }
            }
        });
    }

    public int getNGvectors() {
        return this.nGvectors;
    }

    public void setNGvectors(int gvectors) {
        this.nGvectors = gvectors;
    }

    public String getGvectorFile() {
        return this.gvectorFile;
    }

    public void setGvectorFile(String gvectorFile) {
        this.gvectorFile = gvectorFile;
    }

    public ArrayList<double[]> getGveXYZ() {
        return this.gveXYZ;
    }

    public void setGveXYZ(ArrayList<double[]> array) {
        this.gveXYZ = array;
    }
}

