/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import java.util.Locale;

class CECalendar
extends Calendar {
    private static final long serialVersionUID = -999547623066414271L;
    private static final int[][] LIMITS;
    protected int jdEpochOffset = -1;

    static {
        int[][] nArrayArray = new int[22][];
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 1, 5828963, 5838270};
        int[] nArray2 = new int[4];
        nArray2[2] = 12;
        nArray2[3] = 12;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{1, 1, 52, 53};
        int[] nArray3 = new int[4];
        nArray3[3] = 6;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = new int[]{1, 1, 5, 30};
        nArrayArray[6] = new int[]{1, 1, 365, 366};
        nArrayArray[7] = new int[0];
        nArrayArray[8] = new int[]{-1, -1, 1, 5};
        nArrayArray[9] = new int[0];
        nArrayArray[10] = new int[0];
        nArrayArray[11] = new int[0];
        nArrayArray[12] = new int[0];
        nArrayArray[13] = new int[0];
        nArrayArray[14] = new int[0];
        nArrayArray[15] = new int[0];
        nArrayArray[16] = new int[0];
        nArrayArray[17] = new int[]{-5838270, -5838270, 5828964, 5838271};
        nArrayArray[18] = new int[0];
        nArrayArray[19] = new int[]{-5838269, -5838269, 5828963, 5838270};
        nArrayArray[20] = new int[0];
        nArrayArray[21] = new int[0];
        LIMITS = nArrayArray;
    }

    protected int handleGetLimit(int field, int limitType) {
        return LIMITS[field][limitType];
    }

    protected CECalendar() {
        this(TimeZone.getDefault(), ULocale.getDefault());
    }

    protected CECalendar(TimeZone zone) {
        this(zone, ULocale.getDefault());
    }

    protected CECalendar(Locale aLocale) {
        this(TimeZone.getDefault(), aLocale);
    }

    protected CECalendar(ULocale locale) {
        this(TimeZone.getDefault(), locale);
    }

    protected CECalendar(TimeZone zone, Locale aLocale) {
        super(zone, aLocale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(TimeZone zone, ULocale locale) {
        super(zone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    protected CECalendar(int year, int month, int date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(year, month, date);
    }

    protected CECalendar(Date date) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.setTime(date);
    }

    protected CECalendar(int year, int month, int date, int hour, int minute, int second) {
        super(TimeZone.getDefault(), ULocale.getDefault());
        this.set(year, month, date, hour, minute, second);
    }

    protected int handleComputeMonthStart(int eyear, int emonth, boolean useMonth) {
        return CECalendar.ceToJD(eyear, emonth, 0, this.jdEpochOffset);
    }

    protected int handleGetExtendedYear() {
        int year = this.newerField(19, 1) == 19 ? this.internalGet(19, 1) : this.internalGet(1, 1);
        return year;
    }

    protected void handleComputeFields(int julianDay) {
        Integer[] date = CECalendar.getDateFromJD(julianDay, this.jdEpochOffset);
        int _year = date[0];
        int _month = date[1];
        int _day = date[2];
        int ceyear = 0;
        int era = 1;
        if (_year < 0) {
            era = 0;
            ceyear = 1 - _year;
        } else {
            ceyear = _year;
        }
        this.internalSet(2, _month);
        this.internalSet(5, _day);
        this.internalSet(6, 30 * _month + _day);
        this.internalSet(19, ceyear);
        this.internalSet(0, era);
        this.internalSet(1, _year);
    }

    public static int ceToJD(long year, int month, int date, int jdEpochOffset) {
        return (int)((long)(jdEpochOffset + 365) + 365L * (year - 1L) + (long)CECalendar.quotient(year, 4) + (long)(30 * (month + 1)) + (long)date - 31L);
    }

    public static Integer[] getDateFromJD(int julianDay, int jdEpochOffset) {
        long r4 = CECalendar.mod(julianDay - jdEpochOffset, 1461);
        long n = CECalendar.mod(r4, 365) + 365 * CECalendar.quotient(r4, 1460);
        long aprime = 4 * CECalendar.quotient(julianDay - jdEpochOffset, 1461) + CECalendar.quotient(r4, 365) - CECalendar.quotient(r4, 1460) - 1;
        int _year = (int)(aprime + 1L);
        int _month = CECalendar.quotient(n, 30);
        int _day = CECalendar.mod(n, 30) + 1;
        return new Integer[]{new Integer(_year), new Integer(_month), new Integer(_day)};
    }

    static int mod(long i, int j) {
        return (int)(i - (long)j * (long)CECalendar.quotient(i, j));
    }

    static int quotient(long i, int j) {
        return (int)Math.floor((double)i / (double)j);
    }
}

