/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import java.io.Serializable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.ietf.jgss.Oid;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.ATLASPolicyValues;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.ObjectUtil;
import org.omg.ATLAS.ATLASLocator;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;

public class SASComponentInterceptor
extends LocalObject
implements IORInterceptor {
    private Configuration config;
    private Logger logger;
    private ORB orb;
    private Codec codec;
    private TaggedComponent tc;
    private ISASContext sasContext;

    public SASComponentInterceptor(ORBInitInfo oRBInitInfo) {
        Serializable serializable;
        Object object;
        block8: {
            this.config = null;
            this.logger = null;
            this.orb = null;
            this.codec = null;
            this.tc = null;
            this.sasContext = null;
            this.orb = ((ORBInitInfoImpl)oRBInitInfo).getORB();
            this.config = this.orb.getConfiguration();
            this.logger = this.config.getNamedLogger("jacorb.SAS.IOR");
            try {
                object = new Encoding(0, 1, 0);
                serializable = (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
                this.codec = serializable.create_codec((Encoding)object);
            }
            catch (Exception exception) {
                if (!this.logger.isErrorEnabled()) break block8;
                this.logger.error("Error initing SASComponentInterceptor: ", exception);
            }
        }
        object = null;
        try {
            object = this.config.getAttribute("jacorb.security.sas.contextClass");
            try {
                serializable = ObjectUtil.classForName((String)object);
                this.sasContext = (ISASContext)((Class)serializable).newInstance();
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not instantiate SAS Context class " + (String)object + ": " + exception);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (this.sasContext == null && this.logger.isErrorEnabled()) {
            this.logger.error("Could not load SAS context class: " + (String)object);
        }
    }

    public String name() {
        return "SASComponentCreator";
    }

    public void destroy() {
    }

    public void establish_components(IORInfo iORInfo) {
        block21: {
            IDLEntity iDLEntity;
            IDLEntity iDLEntity2;
            SASPolicyValues sASPolicyValues;
            block20: {
                block19: {
                    if (this.sasContext == null) {
                        return;
                    }
                    sASPolicyValues = null;
                    try {
                        iDLEntity2 = (SASPolicy)((IORInfoImpl)iORInfo).get_effective_policy(100);
                        if (iDLEntity2 != null) {
                            sASPolicyValues = iDLEntity2.value();
                        }
                    }
                    catch (BAD_PARAM bAD_PARAM) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("No SAS Policy");
                        }
                    }
                    catch (Exception exception) {
                        if (!this.logger.isWarnEnabled()) break block19;
                        this.logger.warn("Error fetching SAS policy: " + exception);
                    }
                }
                if (sASPolicyValues == null) {
                    return;
                }
                if (sASPolicyValues.targetRequires == 0 && sASPolicyValues.targetSupports == 0) {
                    return;
                }
                iDLEntity2 = null;
                try {
                    iDLEntity = (ATLASPolicy)iORInfo.get_effective_policy(101);
                    if (iDLEntity != null) {
                        iDLEntity2 = iDLEntity.value();
                    }
                }
                catch (BAD_PARAM bAD_PARAM) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("No ATLAS Policy");
                    }
                }
                catch (Exception exception) {
                    if (!this.logger.isWarnEnabled()) break block20;
                    this.logger.warn("Error fetching ATLAS policy: " + exception);
                }
            }
            try {
                if (this.tc == null) {
                    Object object;
                    CompoundSecMech[] compoundSecMechArray;
                    IDLEntity iDLEntity3;
                    iDLEntity = new TaggedComponent(34, new byte[0]);
                    byte[] byArray = this.sasContext.getClientPrincipal().getBytes();
                    ServiceConfiguration[] serviceConfigurationArray = null;
                    if (iDLEntity2 == null) {
                        serviceConfigurationArray = new ServiceConfiguration[]{};
                    } else {
                        if (((ATLASPolicyValues)iDLEntity2).atlasCache == null) {
                            ((ATLASPolicyValues)iDLEntity2).atlasCache = "";
                        }
                        iDLEntity3 = new ATLASLocator();
                        iDLEntity3.the_url(((ATLASPolicyValues)iDLEntity2).atlasURL);
                        ATLASProfile aTLASProfile = new ATLASProfile();
                        aTLASProfile.the_cache_id = ((ATLASPolicyValues)iDLEntity2).atlasCache.getBytes();
                        aTLASProfile.the_locator = iDLEntity3;
                        compoundSecMechArray = (CompoundSecMech[])new byte[0];
                        object = this.orb.create_any();
                        ATLASProfileHelper.insert((Any)object, aTLASProfile);
                        compoundSecMechArray = (CompoundSecMech[])this.codec.encode((Any)object);
                        serviceConfigurationArray = new ServiceConfiguration[]{new ServiceConfiguration(3, (byte[])compoundSecMechArray)};
                    }
                    iDLEntity3 = new SAS_ContextSec(0, 0, serviceConfigurationArray, new byte[0][0], 0);
                    boolean bl = this.config.getAttributeAsBoolean("jacorb.security.sas.stateful", true);
                    compoundSecMechArray = new CompoundSecMech[1];
                    object = new Oid(this.sasContext.getMechOID());
                    byte[] byArray2 = ((Oid)object).getDER();
                    AS_ContextSec aS_ContextSec = new AS_ContextSec(sASPolicyValues.targetSupports, sASPolicyValues.targetRequires, byArray2, byArray);
                    compoundSecMechArray[0] = new CompoundSecMech(sASPolicyValues.targetRequires, (TaggedComponent)iDLEntity, aS_ContextSec, (SAS_ContextSec)iDLEntity3);
                    CompoundSecMechList compoundSecMechList = new CompoundSecMechList(bl, compoundSecMechArray);
                    CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
                    cDROutputStream.beginEncapsulatedArray();
                    CompoundSecMechListHelper.write(cDROutputStream, compoundSecMechList);
                    this.tc = new TaggedComponent(33, cDROutputStream.getBufferCopy());
                    cDROutputStream.close();
                    cDROutputStream = null;
                }
                iORInfo.add_ior_component_to_profile(this.tc, 0);
            }
            catch (Exception exception) {
                if (!this.logger.isErrorEnabled()) break block21;
                this.logger.error("establish_components error: ", exception);
            }
        }
    }
}

