/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoConst;
import fr.esrf.TacoApi.TacoData;
import fr.esrf.TacoApi.TacoDevice;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.StringTokenizer;

public class TacoTangoDevice
implements TangoConst,
TacoConst {
    private String devname;
    private TacoDevice dev;
    private AttributeConfig[] att_config = null;

    TacoTangoDevice(String string) throws DevFailed {
        try {
            this.dev = new TacoDevice(string);
            this.devname = string;
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.TacoTangoDevice(" + string + ")");
        }
    }

    DeviceData command_inout(String string, DeviceData deviceData) throws DevFailed {
        DeviceData deviceData2 = null;
        try {
            TacoData tacoData = this.dataToTaco(deviceData);
            TacoData tacoData2 = this.dev.putGet(this.dev.getCommandCode(string), tacoData);
            deviceData2 = this.dataToTango(tacoData2);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.command_inout() for " + this.devname);
        }
        return deviceData2;
    }

    CommandInfo[] commandListQuery() throws DevFailed {
        CommandInfo[] commandInfoArray = null;
        try {
            TacoCommand[] tacoCommandArray = this.dev.commandQuery();
            commandInfoArray = this.dataToTango(tacoCommandArray);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.commandListQuery() for " + this.devname);
        }
        return commandInfoArray;
    }

    CommandInfo commandQuery(String string) throws DevFailed {
        CommandInfo commandInfo = null;
        CommandInfo[] commandInfoArray = this.commandListQuery();
        for (int i = 0; i < commandInfoArray.length && commandInfo == null; ++i) {
            if (!commandInfoArray[i].cmd_name.equals(string)) continue;
            commandInfo = commandInfoArray[i];
        }
        if (commandInfo == null) {
            Except.throw_exception("Api_TacoFailed", "Command '" + string + "' Not Found", "TacoTangoDevice.commandQuery() for " + this.devname);
        }
        return commandInfo;
    }

    void set_rpc_protocol(int n) throws DevFailed {
        if (n != 0 && n != 1) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Bad parameter for dev_rpc_protocol command", "TacoTangoDevice.dev_rpc_protocol()");
        }
        try {
            this.dev.setProtocol(n);
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.commandListQuery() for " + this.devname);
        }
    }

    int get_rpc_protocol() throws DevFailed {
        return this.dev.getProtocol();
    }

    int get_rpc_timeout() throws DevFailed {
        int n = -1;
        try {
            n = this.dev.getTimeout();
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.get_rpc_timeout() for " + this.devname);
        }
        return n;
    }

    void set_rpc_timeout(int n) throws DevFailed {
        this.dev.setTimeout(n);
    }

    String[] dev_inform() throws DevFailed {
        String[] stringArray = null;
        try {
            stringArray = this.infoToTango(this.dev.getInfo());
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.dev_inform() for " + this.devname);
        }
        return stringArray;
    }

    public DbDatum[] get_property(String[] stringArray) throws DevFailed {
        DbDatum[] dbDatumArray = null;
        try {
            String[] stringArray2 = this.dev.getResources(stringArray);
            dbDatumArray = new DbDatum[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dbDatumArray[i] = new DbDatum(stringArray[i]);
                if (stringArray2[i] == null || stringArray2[i].equals("N_DEF")) continue;
                dbDatumArray[i].insert(stringArray2[i]);
            }
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.get_property() for " + this.devname);
        }
        return dbDatumArray;
    }

    private String onlyAttName(String string) throws DevFailed {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if ((n = string.indexOf(47, n)) < 0) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found in " + string, "TacoTangoDevice.onlyAttName()");
            }
            ++n2;
            ++n;
        }
        return string.substring(n).trim();
    }

    private String fullName(String string) {
        return new String(this.devname + "/" + string);
    }

    String[] get_attribute_list() throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        String[] stringArray = new String[this.att_config.length];
        for (int i = 0; i < this.att_config.length; ++i) {
            stringArray[i] = this.att_config[i].name;
        }
        return stringArray;
    }

    AttributeConfig[] get_attribute_config(String[] stringArray) throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        if (stringArray[0].equals("All attributes")) {
            return this.att_config;
        }
        AttributeConfig[] attributeConfigArray = new AttributeConfig[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.att_config.length; ++j) {
                if (!this.att_config[j].name.equals(stringArray[i])) continue;
                attributeConfigArray[i] = this.att_config[j];
            }
        }
        if (attributeConfigArray[0] == null) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + stringArray[0] + " not found !", "TacoTangoDevice.get_attribute_config() for " + this.devname);
        }
        return attributeConfigArray;
    }

    DeviceAttribute[] read_attribute(String[] stringArray) throws DevFailed {
        if (this.att_config == null) {
            this.initializeAttributeConfig();
        }
        DeviceData deviceData = this.command_inout("DevReadSigValues", null);
        CommandInfo commandInfo = this.commandQuery("DevReadSigValues");
        int n = commandInfo.out_type;
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        switch (n) {
            case 11: {
                nArray = deviceData.extractLongArray();
                break;
            }
            case 12: {
                fArray = deviceData.extractFloatArray();
                break;
            }
            case 13: {
                dArray = deviceData.extractDoubleArray();
            }
        }
        DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[stringArray.length];
        block10: for (int i = 0; i < stringArray.length; ++i) {
            int n2 = -1;
            for (int j = 0; j < this.att_config.length; ++j) {
                if (!this.att_config[j].name.toLowerCase().equals(stringArray[i].toLowerCase())) continue;
                n2 = j;
            }
            if (n2 == -1) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute " + stringArray[i] + " not found for this device", "TacoTangoDevice.read_attribute()  for " + this.devname);
            }
            switch (n) {
                case 11: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], nArray[n2]);
                    continue block10;
                }
                case 12: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], fArray[n2]);
                    continue block10;
                }
                case 13: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], dArray[n2]);
                }
            }
        }
        return deviceAttributeArray;
    }

    private void initializeAttributeConfig() throws DevFailed {
        String[] stringArray;
        int n = 1;
        int n2 = 0;
        int n3 = 5;
        String[] stringArray2 = new String[]{};
        try {
            DeviceData deviceData = this.command_inout("DevGetSigConfig", null);
            stringArray2 = deviceData.extractStringArray();
            stringArray = this.commandQuery("DevReadSigValues");
            n3 = this.getAttrDataType(stringArray.out_type);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("TACO_CMD_UNAVAILABLE")) {
                this.att_config = new AttributeConfig[0];
                return;
            }
            throw devFailed;
        }
        int n4 = Integer.parseInt(stringArray2[0]);
        this.att_config = new AttributeConfig[stringArray2.length / n4];
        stringArray = new String[stringArray2.length / n4];
        int n5 = 0;
        for (int i = 1; i < stringArray2.length; i += n4) {
            stringArray[n5++] = this.onlyAttName(stringArray2[i]);
        }
        this.att_config = new AttributeConfig[stringArray.length];
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            String string = this.fullName(stringArray[n5]);
            boolean bl = false;
            for (int i = 1; i < stringArray2.length; i += n4) {
                if (!stringArray2[i].equals(string)) continue;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String[] stringArray3 = null;
                bl = true;
                String string13 = "No Description";
                if (!stringArray2[i + 4].equals(string13)) {
                    string2 = stringArray2[i + 4];
                }
                if (!stringArray2[i + 1].equals(string13 = "Not specified")) {
                    string3 = stringArray2[i + 1];
                }
                if (!stringArray2[i + 2].equals(string13)) {
                    string4 = stringArray2[i + 2];
                    string6 = stringArray2[i + 2];
                }
                if (!stringArray2[i + 3].equals(string13)) {
                    string7 = stringArray2[i + 3];
                }
                if (!stringArray2[i + 5].equals(string13)) {
                    string9 = stringArray2[i + 5];
                }
                if (!stringArray2[i + 6].equals(string13)) {
                    string8 = stringArray2[i + 6];
                }
                if (!stringArray2[i + 7].equals(string13)) {
                    string11 = stringArray2[i + 7];
                }
                if (!stringArray2[i + 8].equals(string13)) {
                    string10 = stringArray2[i + 8];
                }
                this.att_config[n5] = new AttributeConfig(stringArray[n5], AttrWriteType.READ, AttrDataFormat.SCALAR, n3, n, n2, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, stringArray3);
            }
            if (bl) continue;
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found for this device", "TacoTangoDevice.initializeAttributeConfig()");
        }
    }

    private int getAttrDataType(int n) throws DevFailed {
        int n2 = 0;
        switch (n) {
            case 11: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 4;
                break;
            }
            case 13: {
                n2 = 5;
                break;
            }
            default: {
                try {
                    Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Output parameter not supported.", "TacoTangoDevice.getAttrDataType()");
                    break;
                }
                catch (DevFailed devFailed) {
                    devFailed.printStackTrace();
                    throw devFailed;
                }
            }
        }
        return n2;
    }

    int tangoType(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 70: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 71: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 8;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 5: {
                n2 = 5;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            case 72: {
                n2 = 14;
                break;
            }
            case 11: {
                n2 = 11;
                break;
            }
            case 69: {
                n2 = 15;
                break;
            }
            case 12: {
                n2 = 12;
                break;
            }
            case 68: {
                n2 = 13;
                break;
            }
            case 24: {
                n2 = 16;
                break;
            }
            case 8: {
                n2 = 12;
            }
        }
        return n2;
    }

    private TacoData dataToTaco(DeviceData deviceData) throws DevFailed {
        TacoData tacoData = new TacoData();
        if (deviceData == null) {
            return tacoData;
        }
        int n = deviceData.getType();
        switch (n) {
            case -1: 
            case 0: {
                break;
            }
            case 2: {
                tacoData.insert(deviceData.extractShort());
                break;
            }
            case 10: {
                tacoData.insert(deviceData.extractShortArray());
                break;
            }
            case 6: {
                tacoData.insertUShort(deviceData.extractUShort());
                break;
            }
            case 14: {
                tacoData.insertUShortArray(deviceData.extractUShortArray());
                break;
            }
            case 3: {
                tacoData.insert(deviceData.extractLong());
                break;
            }
            case 11: {
                tacoData.insert(deviceData.extractLongArray());
                break;
            }
            case 7: {
                tacoData.insertULong((long)deviceData.extractLong());
                break;
            }
            case 15: {
                break;
            }
            case 4: {
                tacoData.insert(deviceData.extractFloat());
                break;
            }
            case 12: {
                tacoData.insert(deviceData.extractFloatArray());
                break;
            }
            case 13: {
                tacoData.insert(deviceData.extractDouble());
                break;
            }
            case 5: {
                tacoData.insert(deviceData.extractDoubleArray());
                break;
            }
            case 8: {
                tacoData.insert(deviceData.extractString());
                break;
            }
            case 16: {
                tacoData.insert(deviceData.extractStringArray());
                break;
            }
            default: {
                Except.throw_exception("Api_TacoFailed", "Argument type " + TangoConst.Tango_CmdArgTypeName[n] + "Not supported for TACO interface", "TacoTangoDevice.dataToTaco() for " + this.devname);
            }
        }
        return tacoData;
    }

    private DeviceData dataToTango(TacoData tacoData) throws DevFailed {
        int n = tacoData.getType();
        DeviceData deviceData = new DeviceData();
        try {
            switch (n) {
                case -1: 
                case 0: {
                    break;
                }
                case 2: {
                    deviceData.insert(tacoData.extractShort());
                    break;
                }
                case 70: {
                    deviceData.insert_us(tacoData.extractUShort());
                    break;
                }
                case 3: {
                    deviceData.insert(tacoData.extractLong());
                    break;
                }
                case 71: {
                    deviceData.insert_ul(tacoData.extractULong());
                    break;
                }
                case 6: {
                    deviceData.insert(tacoData.extractString());
                    break;
                }
                case 4: {
                    deviceData.insert(tacoData.extractFloat());
                    break;
                }
                case 5: {
                    deviceData.insert(tacoData.extractDouble());
                    break;
                }
                case 10: {
                    deviceData.insert(tacoData.extractShortArray());
                    break;
                }
                case 72: {
                    deviceData.insert_us(tacoData.extractUShortArray());
                    break;
                }
                case 11: {
                    deviceData.insert(tacoData.extractLongArray());
                    break;
                }
                case 69: {
                    deviceData.insert_ul(tacoData.extractULongArray());
                    break;
                }
                case 12: {
                    deviceData.insert(tacoData.extractFloatArray());
                    break;
                }
                case 68: {
                    deviceData.insert(tacoData.extractDoubleArray());
                    break;
                }
                case 24: {
                    deviceData.insert(tacoData.extractStringArray());
                    break;
                }
                case 8: {
                    deviceData.insert(tacoData.extractStateFloatReadPoint());
                }
            }
        }
        catch (TacoException tacoException) {
            Except.throw_exception("Api_TacoFailed", tacoException.getErrorString(), "TacoTangoDevice.dataToTango() for " + this.devname);
        }
        return deviceData;
    }

    CommandInfo[] dataToTango(TacoCommand[] tacoCommandArray) {
        CommandInfo[] commandInfoArray = new CommandInfo[tacoCommandArray.length];
        for (int i = 0; i < tacoCommandArray.length; ++i) {
            commandInfoArray[i] = new CommandInfo(tacoCommandArray[i].cmdName, 0, this.tangoType(tacoCommandArray[i].inType), this.tangoType(tacoCommandArray[i].outType), tacoCommandArray[i].inName, tacoCommandArray[i].outName);
        }
        return commandInfoArray;
    }

    String[] infoToTango(String string) {
        String[] stringArray = new String[5];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        for (int i = 0; i < 5 && stringTokenizer.hasMoreTokens(); ++i) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(":");
            if (n <= 0) continue;
            stringArray[i] = string2.substring(n + 1).trim();
        }
        return stringArray;
    }
}

