/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DevVarCmdArray;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.T2Ttypes;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.StringTokenizer;

public class TacoDevice
implements TangoConst {
    private String devname;
    private int dev;
    public DevVarCmdArray cmd_info = null;
    private String[] attr_strconfig;
    private int attr_data_type = -1;
    private int attr_orig_type = -1;

    native int importDevice(String var1) throws DevFailed;

    native Object[] commandListQuery(int var1) throws DevFailed;

    native Object[] devInform(int var1) throws DevFailed;

    native void rpcProtocol(int var1, int var2) throws DevFailed;

    native int getRpcTimeout(int var1) throws DevFailed;

    native int setRpcTimeout(int var1, int var2) throws DevFailed;

    native void tacoInsertObject(int var1, Object var2, int var3) throws DevFailed;

    native void tacoInsertByteArray(int var1, byte[] var2, int var3) throws DevFailed;

    native void tacoInsertShortArray(int var1, short[] var2, int var3) throws DevFailed;

    native void tacoInsertIntArray(int var1, int[] var2, int var3) throws DevFailed;

    native void tacoInsertFloatArray(int var1, float[] var2, int var3) throws DevFailed;

    native void tacoInsertDoubleArray(int var1, double[] var2, int var3) throws DevFailed;

    native void tacoInsertObjArray(int var1, Object[] var2) throws DevFailed;

    native Object commandInout(int var1, String var2) throws DevFailed;

    native Object[] commandInoutObjArray(int var1, String var2) throws DevFailed;

    native byte[] commandInoutByteArray(int var1, String var2) throws DevFailed;

    native short[] commandInoutShortArray(int var1, String var2) throws DevFailed;

    native int[] commandInoutIntArray(int var1, String var2) throws DevFailed;

    native float[] commandInoutFloatArray(int var1, String var2) throws DevFailed;

    native double[] commandInoutDoubleArray(int var1, String var2) throws DevFailed;

    public TacoDevice(String string) throws DevFailed {
        this.devname = string;
        this.dev = this.importDevice(string);
        this.read_commandListQuery();
    }

    private void read_commandListQuery() throws DevFailed {
        Object[] objectArray = this.commandListQuery(this.dev);
        DevCmdInfo[] devCmdInfoArray = new DevCmdInfo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            devCmdInfoArray[i] = (DevCmdInfo)objectArray[i];
        }
        this.cmd_info = new DevVarCmdArray(this.devname, devCmdInfoArray);
    }

    public CommandInfo[] commandListQuery() throws DevFailed {
        if (this.cmd_info == null) {
            this.read_commandListQuery();
        }
        return this.cmd_info.getInfoArray();
    }

    public CommandInfo commandQuery(String string) throws DevFailed {
        if (this.cmd_info == null) {
            this.read_commandListQuery();
        }
        CommandInfo[] commandInfoArray = this.cmd_info.getInfoArray();
        CommandInfo commandInfo = null;
        for (int i = 0; i < commandInfoArray.length; ++i) {
            if (!commandInfoArray[i].cmd_name.equals(string)) continue;
            commandInfo = commandInfoArray[i];
        }
        if (commandInfo == null) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Command name not found for " + this.devname, "TacoDevice.commandQuery()");
        }
        return commandInfo;
    }

    public String[] dev_inform() throws DevFailed {
        Object[] objectArray = this.devInform(this.dev);
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public void dev_rpc_protocol(int n) throws DevFailed {
        if (n != 999 && n != 888) {
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Bad parameter for dev_rpc_protocol command", "TacoDevice.dev_rpc_protocol()");
        }
        this.rpcProtocol(this.dev, n);
    }

    public int get_rpc_timeout() throws DevFailed {
        return this.getRpcTimeout(this.dev);
    }

    public int set_rpc_timeout(int n) throws DevFailed {
        return this.setRpcTimeout(this.dev, n);
    }

    public DeviceData command_inout(String string, DeviceData deviceData) throws DevFailed {
        int n;
        Object[] objectArray;
        Object object;
        DeviceData deviceData2 = new DeviceData();
        int n2 = this.cmd_info.arginType(string);
        int n3 = this.cmd_info.argoutType(string);
        if (n2 < 0) {
            Except.throw_wrong_syntax_exception("TangoApi_ARG_NOT_SUPPORTED", "Input argument type not supported", "TacoDevice.command_inout()");
        }
        if (n3 < 0) {
            Except.throw_wrong_syntax_exception("TangoApi_ARG_NOT_SUPPORTED", "Output argument type not supported", "TacoDevice.command_inout()");
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                object = null;
                if (n2 != 0) {
                    object = new Object();
                    object = deviceData;
                }
                this.tacoInsertObject(this.dev, object, T2Ttypes.tacoType(n2));
                break;
            }
            case 8: {
                object = null;
                object = new Object();
                object = deviceData.extractString();
                this.tacoInsertObject(this.dev, object, T2Ttypes.tacoType(n2));
                break;
            }
            case 9: {
                object = deviceData.extractByteArray();
                this.tacoInsertByteArray(this.dev, (byte[])object, ((byte[])object).length);
                break;
            }
            case 10: {
                object = deviceData.extractShortArray();
                this.tacoInsertShortArray(this.dev, (short[])object, ((byte[])object).length);
                break;
            }
            case 11: {
                object = deviceData.extractLongArray();
                this.tacoInsertIntArray(this.dev, (int[])object, ((byte[])object).length);
                break;
            }
            case 12: {
                object = deviceData.extractFloatArray();
                this.tacoInsertFloatArray(this.dev, (float[])object, ((byte[])object).length);
                break;
            }
            case 13: {
                object = deviceData.extractDoubleArray();
                this.tacoInsertDoubleArray(this.dev, (double[])object, ((byte[])object).length);
                break;
            }
            case 16: {
                object = deviceData.extractStringArray();
                objectArray = new Object[((byte[])object).length];
                for (n = 0; n < ((byte[])object).length; ++n) {
                    objectArray[n] = object[n];
                }
                this.tacoInsertObjArray(this.dev, objectArray);
            }
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                object = this.commandInout(this.dev, string);
                if (object == null) {
                    return null;
                }
                deviceData2 = (DeviceData)object;
                break;
            }
            case 9: {
                deviceData2.insert(this.commandInoutByteArray(this.dev, string));
                break;
            }
            case 10: {
                deviceData2.insert(this.commandInoutShortArray(this.dev, string));
                break;
            }
            case 11: {
                deviceData2.insert(this.commandInoutIntArray(this.dev, string));
                break;
            }
            case 12: {
                deviceData2.insert(this.commandInoutFloatArray(this.dev, string));
                break;
            }
            case 13: {
                deviceData2.insert(this.commandInoutDoubleArray(this.dev, string));
                break;
            }
            case 16: {
                object = this.commandInoutObjArray(this.dev, string);
                objectArray = new String[((byte[])object).length];
                for (n = 0; n < ((byte[])object).length; ++n) {
                    objectArray[n] = (String)object[n];
                }
                deviceData2.insert((String[])objectArray);
            }
        }
        return deviceData2;
    }

    private boolean isWildcard(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
        switch (stringTokenizer.countTokens()) {
            case 0: {
                return true;
            }
            case 1: {
                String string3 = stringTokenizer.nextToken();
                return string.indexOf(string3) >= 0;
            }
            case 2: {
                String[] stringArray = new String[]{stringTokenizer.nextToken(), stringTokenizer.nextToken()};
                int n = string.indexOf(stringArray[0]);
                if (n < 0) {
                    return false;
                }
                return string.indexOf(stringArray[1], n) >= 0;
            }
        }
        return false;
    }

    private String onlyAttName(String string) throws DevFailed {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if ((n = string.indexOf(47, n)) < 0) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", new String("Attribute name not found in " + string), "TacoDevice.onlyAttName()");
            }
            ++n2;
            ++n;
        }
        return string.substring(n);
    }

    private String fullName(String string) {
        return new String(this.devname + "/" + string);
    }

    String[] get_attribute_list() throws DevFailed {
        String[] stringArray = null;
        DeviceData deviceData = this.command_inout("DevGetSigConfig", null);
        String[] stringArray2 = deviceData.extractStringArray();
        int n = Integer.parseInt(stringArray2[0]);
        int n2 = stringArray2.length / n;
        stringArray = new String[n2];
        int n3 = 0;
        for (int i = 1; i < stringArray2.length; i += n) {
            stringArray[n3++] = this.onlyAttName(stringArray2[i]);
        }
        return stringArray;
    }

    AttributeConfig[] get_attribute_config(String[] stringArray) throws DevFailed {
        int n;
        AttributeConfig[] attributeConfigArray;
        int n2 = 1;
        int n3 = 0;
        if (this.attr_strconfig == null) {
            try {
                DeviceData deviceData = this.command_inout("DevGetSigConfig", null);
                this.attr_strconfig = deviceData.extractStringArray();
                this.setAttrDataType();
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.equals("TACO_CMD_UNAVAILABLE")) {
                    return new AttributeConfig[0];
                }
                throw devFailed;
            }
        }
        int n4 = Integer.parseInt(this.attr_strconfig[0]);
        if (stringArray[0].equals("All attributes")) {
            attributeConfigArray = new AttributeConfig[this.attr_strconfig.length / n4];
            stringArray = new String[this.attr_strconfig.length / n4];
            n = 0;
            for (int i = 1; i < this.attr_strconfig.length; i += n4) {
                stringArray[n++] = this.onlyAttName(this.attr_strconfig[i]);
            }
        } else {
            attributeConfigArray = new AttributeConfig[stringArray.length];
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = this.fullName(stringArray[n]);
            boolean bl = false;
            for (int i = 1; i < this.attr_strconfig.length; i += n4) {
                if (!this.attr_strconfig[i].equals(string)) continue;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String[] stringArray2 = null;
                bl = true;
                String string13 = "No Description";
                if (!this.attr_strconfig[i + 4].equals(string13)) {
                    string2 = this.attr_strconfig[i + 4];
                }
                if (!this.attr_strconfig[i + 1].equals(string13 = "Not specified")) {
                    string3 = this.attr_strconfig[i + 1];
                }
                if (!this.attr_strconfig[i + 2].equals(string13)) {
                    string4 = this.attr_strconfig[i + 2];
                    string6 = this.attr_strconfig[i + 2];
                }
                if (!this.attr_strconfig[i + 3].equals(string13)) {
                    string7 = this.attr_strconfig[i + 3];
                }
                if (!this.attr_strconfig[i + 5].equals(string13)) {
                    string9 = this.attr_strconfig[i + 5];
                }
                if (!this.attr_strconfig[i + 6].equals(string13)) {
                    string8 = this.attr_strconfig[i + 6];
                }
                if (!this.attr_strconfig[i + 7].equals(string13)) {
                    string11 = this.attr_strconfig[i + 7];
                }
                if (!this.attr_strconfig[i + 8].equals(string13)) {
                    string10 = this.attr_strconfig[i + 8];
                }
                attributeConfigArray[n] = new AttributeConfig(stringArray[n], AttrWriteType.READ, AttrDataFormat.SCALAR, this.attr_data_type, n2, n3, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, stringArray2);
            }
            if (bl) continue;
            Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found for this device", "TacoDevice.get_attribute_config()");
        }
        return attributeConfigArray;
    }

    private void setAttrDataType() throws DevFailed {
        switch (this.cmd_info.argoutType("DevReadSigValues")) {
            case 11: {
                this.attr_orig_type = 3;
                this.attr_data_type = 3;
                break;
            }
            case 12: {
                this.attr_orig_type = 4;
                this.attr_data_type = 5;
                break;
            }
            case 13: {
                this.attr_orig_type = 5;
                this.attr_data_type = 5;
                break;
            }
            default: {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Output parameter not supported.", "TacoDevice.setAttrDataType()");
            }
        }
    }

    private String tangoFormat(String string) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = "";
        switch (this.attr_data_type) {
            case 11: {
                break;
            }
            default: {
                int n = string.indexOf("%");
                if (n < 0) break;
                if (string.toUpperCase().indexOf(69) >= 0 || string.toUpperCase().indexOf(71) >= 0) {
                    string2 = "scientific";
                }
                stringBuffer.append(string2);
                n = string.indexOf(".");
                if (n <= 0) break;
                int n2 = ++n;
                while (string.charAt(n2) >= '0' && string.charAt(n2) <= '9') {
                    ++n2;
                }
                String string3 = string.substring(n, n2);
                int n3 = Integer.parseInt(string3);
                if (n3 <= 0) break;
                if (string2.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(new String("setprecision(" + n3 + ")"));
            }
        }
        return stringBuffer.toString();
    }

    DeviceAttribute[] read_attribute(String[] stringArray) throws DevFailed {
        DeviceData deviceData;
        if (this.attr_strconfig == null) {
            deviceData = this.command_inout("DevGetSigConfig", null);
            this.attr_strconfig = deviceData.extractStringArray();
            this.setAttrDataType();
        }
        deviceData = this.command_inout("DevReadSigValues", null);
        int[] nArray = null;
        float[] fArray = null;
        double[] dArray = null;
        switch (this.attr_orig_type) {
            case 3: {
                nArray = deviceData.extractLongArray();
                break;
            }
            case 4: {
                fArray = deviceData.extractFloatArray();
                break;
            }
            case 5: {
                dArray = deviceData.extractDoubleArray();
            }
        }
        DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[stringArray.length];
        int n = Integer.parseInt(this.attr_strconfig[0]);
        block10: for (int i = 0; i < stringArray.length; ++i) {
            String string = this.fullName(stringArray[i]);
            int n2 = -1;
            for (int j = 1; j < this.attr_strconfig.length; j += n) {
                if (!this.attr_strconfig[j].equals(string)) continue;
                n2 = j / n;
            }
            if (n2 == -1) {
                Except.throw_wrong_syntax_exception("BAD_PARAMETER", "Attribute name not found for this device", "TacoDevice.read_attribute()");
            }
            switch (this.attr_orig_type) {
                case 3: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], nArray[n2]);
                    continue block10;
                }
                case 4: {
                    if (this.attr_data_type == 5) {
                        double d = fArray[n2];
                        deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], d);
                        continue block10;
                    }
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], fArray[n2]);
                    continue block10;
                }
                case 5: {
                    deviceAttributeArray[i] = new DeviceAttribute(stringArray[i], dArray[n2]);
                }
            }
        }
        return deviceAttributeArray;
    }

    static {
        System.loadLibrary("jtaco");
    }
}

