/**
 * 
 */
package fable.framework.xmlparser.object;

import java.util.Vector;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
//import org.xml.sax.helpers.LocatorImpl;

/**
 * @author suchet
 * 
 */
public class FableXmlContentHandler extends DefaultHandler {

	//private Locator locator;
	// private HashMap <String, String> hmBalise; //balise and value
	private Vector<Xmloption> myoptions;
	String currentValue, currentTag;
	final static String OPTION = "option";
	String programName;

	/**
	 * 
	 */
	public FableXmlContentHandler() {
		super();
		//locator = new LocatorImpl();

		myoptions = new Vector<Xmloption>();
	}

	public Vector<Xmloption> getOptions() {
		return myoptions;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.xml.sax.helpers.DefaultHandler#endDocument()
	 */
	@Override
	public void endDocument() throws SAXException {
		super.endDocument();
		// System.out.println("end Document");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.xml.sax.helpers.DefaultHandler#endElement(java.lang.String,
	 * java.lang.String, java.lang.String)
	 */
	@Override
	public void endElement(String uri, String localName, String name)
			throws SAXException {

		super.endElement(uri, localName, name);
		if (myoptions.size() > 0 && !name.equals(OPTION)) {
			myoptions.lastElement().putTag(currentTag, currentValue);
		}

		// System.out.println("end endElement");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.xml.sax.helpers.DefaultHandler#error(org.xml.sax.SAXParseException)
	 */
	@Override
	public void error(SAXParseException e) throws SAXException {
		// TODO Auto-generated method stub
		super.error(e);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.xml.sax.helpers.DefaultHandler#setDocumentLocator(org.xml.sax.Locator
	 * )
	 */
	@Override
	public void setDocumentLocator(Locator locator) {
		// TODO Auto-generated method stub
		super.setDocumentLocator(locator);
	//	this.locator = locator;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.xml.sax.helpers.DefaultHandler#startDocument()
	 */
	@Override
	public void startDocument() throws SAXException {
		myoptions.removeAllElements();

		super.startDocument();

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.xml.sax.helpers.DefaultHandler#startElement(java.lang.String,
	 * java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	@Override
	public void startElement(String uri, String localName, String name,
			Attributes attributes) throws SAXException {

		super.startElement(uri, localName, name, attributes);
		// System.out.println("startElement:" + name );
		if (name.equals(OPTION)) {
			myoptions.add(new Xmloption());
			for (int i = 0; i < attributes.getLength(); i++) {
				// System.out.println("attribut:" + attributes.getLocalName(i) +
				// " " + attributes.getValue(i));
				myoptions.lastElement().putTag(name, attributes.getValue(i));

			}
		} else if (myoptions.size() > 0) {
			// System.out.println("name:" + name);
			currentTag = name;
		}
	}

	@Override
	public void ignorableWhitespace(char[] arg0, int arg1, int arg2)
			throws SAXException {

		super.ignorableWhitespace(arg0, arg1, arg2);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.xml.sax.helpers.DefaultHandler#characters(char[], int, int)
	 */
	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {

		// super.characters(ch, start, length);
		// TODO GS : Find out the rigth regex !!
		if (myoptions.size() > 0) {
			currentValue = new String(ch, start, length);
			currentValue = currentValue.replaceFirst("\\n    ", "");

		}
	}

}
