/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Date;
import java.util.Vector;
import org.omg.CORBA.Any;

public class PollRing
extends Vector
implements TangoConst {
    private int max_elt;

    PollRing() {
        this.max_elt = 10;
    }

    PollRing(int n) {
        this.max_elt = n <= 0 ? 10 : n;
    }

    void insert_data(Any any, TimeVal timeVal) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(any, timeVal));
    }

    void insert_data(AttributeValue attributeValue, TimeVal timeVal) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(attributeValue, timeVal));
    }

    void insert_except(DevFailed devFailed, TimeVal timeVal) {
        if (this.size() >= this.max_elt) {
            this.remove(0);
        }
        this.add(new RingElt(devFailed, timeVal));
    }

    double[] get_delta_t(int n) throws DevFailed {
        if (this.size() < 2) {
            Except.throw_exception("API_PollRingBufferEmpty", "Not enough data stored yet in polling ring buffer", "PollRing.get_delta_t");
        }
        if (n >= this.size()) {
            n = this.size() - 1;
        }
        double[] dArray = new double[n];
        int n2 = this.size() - n - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        int n4 = 0;
        while (n3 < this.size() - 1) {
            RingElt ringElt = (RingElt)this.elementAt(n3 + 1);
            RingElt ringElt2 = (RingElt)this.elementAt(n3);
            double d = (double)ringElt.when.tv_sec + (double)ringElt.when.tv_usec / 1000000.0;
            double d2 = (double)ringElt2.when.tv_sec + (double)ringElt2.when.tv_usec / 1000000.0;
            dArray[n4] = d - d2;
            ++n3;
            ++n4;
        }
        return dArray;
    }

    TimeVal get_last_insert_date() {
        return this.get_last_element().when;
    }

    boolean is_last_an_error() {
        return this.get_last_element().except != null;
    }

    DevFailed get_last_except() {
        return this.get_last_element().except;
    }

    Any get_last_cmd_result() throws DevFailed {
        RingElt ringElt = this.get_last_element();
        if (ringElt.except == null) {
            return ringElt.cmd_result;
        }
        throw ringElt.except;
    }

    AttributeValue get_last_attr_value() throws DevFailed {
        RingElt ringElt = this.get_last_element();
        if (ringElt.except == null) {
            return ringElt.attr_value;
        }
        throw ringElt.except;
    }

    DevCmdHistory[] get_cmd_history(int n) {
        int n2;
        DevCmdHistory[] devCmdHistoryArray = new DevCmdHistory[n];
        for (int i = n2 = this.size() - n; i < this.size(); ++i) {
            DevError[] devErrorArray;
            boolean bl;
            RingElt ringElt = (RingElt)this.elementAt(i);
            TimeVal timeVal = ringElt.when;
            Any any = ringElt.cmd_result;
            if (ringElt.except == null) {
                bl = false;
                devErrorArray = new DevError[]{};
            } else {
                bl = true;
                devErrorArray = ringElt.except.errors;
            }
            devCmdHistoryArray[i - n2] = new DevCmdHistory(timeVal, bl, any, devErrorArray);
        }
        return devCmdHistoryArray;
    }

    DevAttrHistory[] get_attr_history(int n, int n2) {
        int n3;
        DevAttrHistory[] devAttrHistoryArray = new DevAttrHistory[n];
        for (int i = n3 = this.size() - n; i < this.size(); ++i) {
            DevError[] devErrorArray;
            boolean bl;
            RingElt ringElt = (RingElt)this.elementAt(i);
            TimeVal timeVal = ringElt.when;
            AttributeValue attributeValue = ringElt.attr_value;
            if (ringElt.except == null) {
                bl = false;
                devErrorArray = new DevError[]{};
            } else {
                bl = true;
                devErrorArray = ringElt.except.errors;
            }
            devAttrHistoryArray[i - n3] = new DevAttrHistory(bl, attributeValue, devErrorArray);
        }
        return devAttrHistoryArray;
    }

    private RingElt get_last_element() {
        return (RingElt)this.lastElement();
    }

    boolean is_empty() {
        return this.size() == 0;
    }

    class RingElt {
        Any cmd_result;
        DevFailed except;
        TimeVal when;
        AttributeValue attr_value;

        public RingElt() {
            this.when = new TimeVal(0, 0, 0);
            this.cmd_result = null;
            this.attr_value = null;
            this.except = null;
        }

        public RingElt(Any any, TimeVal timeVal) {
            this.when = timeVal;
            this.when.tv_sec += 1002000000;
            this.cmd_result = any;
            this.attr_value = null;
            this.except = null;
        }

        public RingElt(AttributeValue attributeValue, TimeVal timeVal) {
            this.when = timeVal;
            this.when.tv_sec += 1002000000;
            this.cmd_result = null;
            this.attr_value = attributeValue;
            this.attr_value.time = this.when;
            this.except = null;
        }

        public RingElt(DevFailed devFailed, TimeVal timeVal) {
            this.when = timeVal;
            this.when.tv_sec += 1002000000;
            this.cmd_result = null;
            try {
                this.cmd_result = ApiUtil.get_orb().create_any();
            }
            catch (DevFailed devFailed2) {
                // empty catch block
            }
            this.attr_value = new AttributeValue(this.cmd_result, AttrQuality.ATTR_INVALID, this.when, "", 0, 0);
            this.except = devFailed;
        }

        public String toString() {
            long l = (long)(this.when.tv_sec + 1002000000) * 1000L + (long)(this.when.tv_usec / 1000);
            Date date = new Date(l);
            return "\t" + date.toString();
        }
    }
}

