/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.PaletteUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImagePlay;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.ImageViewImage;
import fable.python.FabioFile;
import fable.python.Peak;
import fable.python.PeakSearchSpt;
import fable.python.jep.FableJep;
import java.util.Vector;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IPropertyChangeListener,
IImagesVarKeys,
ISelectionListener {
    public static final String ID = "fable.imageviewer.views.ImageView";
    public static ImageView mainImageView = null;
    private SampleController controller = SampleController.getController();
    private ImageViewControls controls = null;
    public ImageViewImage image = null;
    private Display display;
    private FabioFile fabioFile = null;
    private ImageModel imageModel = null;
    private ImageModel imageDiffModel = null;
    private ImageModel savedImageModel = null;
    private String fileNameSaved = "";
    private Vector<Float> peaks;
    private Coordinates coordinates = new Coordinates();
    double x0Save = 0.0;
    double y0Save = 0.0;
    double pixelWidthSave = 1.0;
    double pixelHeightSave = 1.0;
    String xNameSave = "x";
    String yNameSave = "y";
    private int orientation = 0;
    private ZoomSelection zoomSelection = ZoomSelection.AREA;
    private int coordOrigin = 0;
    private boolean peaksOn = false;
    private int peakMarkerSize = 3;
    private boolean autoscale = true;
    private float minimum;
    private float maximum;
    private float mean;
    private float currentMinimum;
    private float currentMaximum;
    private static PaletteData[] palettes = new PaletteData[paletteNameValues.length];
    private PaletteData palette = null;
    private int paletteIndex = 0;
    private boolean keepAspect = false;
    private boolean listening = true;
    public static int secondaryId = 2;
    protected boolean imageDiffOn = false;
    private boolean jobRunning = false;
    private IWorkbenchListener workbenchListener = null;

    public void setPartName(String partName) {
        super.setPartName(partName);
    }

    public void createPartControl(Composite parent) {
        if (mainImageView == null) {
            mainImageView = this;
            ImagePlay.iv = this;
        }
        this.display = parent.getDisplay();
        this.controls = new ImageViewControls(this);
        this.controls.createControls(parent);
        this.workbenchListener = new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                IWorkbenchPage[] pages;
                block7: {
                    pages = workbench.getActiveWorkbenchWindow().getPages();
                    if (pages != null) break block7;
                    return true;
                }
                try {
                    IWorkbenchPage[] iWorkbenchPageArray = pages;
                    int n = pages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage page = iWorkbenchPageArray[n2];
                        IViewReference[] references = page.getViewReferences();
                        if (references != null) {
                            IViewReference[] iViewReferenceArray = references;
                            int n3 = references.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IViewReference reference = iViewReferenceArray[n4];
                                if (reference.getId().equals(ImageView.ID) && !reference.getSecondaryId().equals("0")) {
                                    page.hideView(reference);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    FableLogger.error((Object)ImageView.this, (Throwable)ex);
                }
                return true;
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.workbenchListener);
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            Object[] selections = sSelection.toArray();
            if (first instanceof PeakSearchSpt) {
                PeakSearchSpt peakFile = (PeakSearchSpt)first;
                FabioFile f = peakFile.getImageFile();
                if (f != null) {
                    this.loadFile(f);
                    this.setPeaksOn(true);
                    this.image.displayImage();
                    Vector vals = peakFile.getTabChildren();
                    if (vals != null) {
                        this.setPeaks(vals);
                        this.image.showPeaks();
                    }
                }
            } else if (first instanceof Peak) {
                PeakSearchSpt parent = ((Peak)first).getParent();
                int nPeaksToDisplay = selections.length;
                float[] coloredPeak = new float[nPeaksToDisplay * 2];
                int k = 0;
                int ip = 0;
                while (ip < selections.length) {
                    Peak peak = (Peak)selections[ip];
                    if (peak.isVisible()) {
                        int j = k + 1;
                        coloredPeak[k] = Float.valueOf(peak.getS()).floatValue();
                        coloredPeak[j] = Float.valueOf(peak.getF()).floatValue();
                        k += 2;
                    }
                    ++ip;
                }
                Vector vals = parent.getTabChildren();
                if (vals != null) {
                    this.setPeaks(vals);
                }
                this.setPeaksOn(true);
                this.image.showSelectedPeaks(coloredPeak);
            }
        }
    }

    public void setViewType(ImageViewType viewtype) {
        if (viewtype == ImageViewType.IMAGE_MAIN_VIEW) {
            mainImageView = this;
            ImagePlay.setView(mainImageView);
        }
    }

    public void stopListening() {
        if (this.listening) {
            this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void loadFile(FabioFile _fabioFile) {
        if (_fabioFile == null) {
            this.imageModel = null;
            FableUtils.errMsg((Object)this, (String)"Unable to load null file");
            this.image.clearCanvas();
            return;
        }
        if (_fabioFile != this.fabioFile) {
            this.peaks = null;
            this.fabioFile = _fabioFile;
            try {
                this.imageModel = null;
                this.imageModel = new ImageModel(this.fabioFile);
            }
            catch (JepException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to load file", (Throwable)ex);
                this.image.clearCanvas();
                return;
            }
            if (this.controls != null) {
                this.controls.setStatusText("Loading file " + this.fabioFile.getFileName() + " ... ");
            }
            this.image.setImageChanged(true);
            if (this.image.getImageRect().width != this.imageModel.getWidth() || this.image.getImageRect().height != this.imageModel.getHeight()) {
                this.image.clearCanvas();
            }
            this.image.setImageRect(new Rectangle(this.image.getImageRect().x, this.image.getImageRect().y, this.imageModel.getWidth(), this.imageModel.getHeight()));
            this.image.calculateMainRectangles();
            this.resetCoordinates();
            float[] statistics = this.imageModel.getStatistics(this.image.getImageRect());
            this.minimum = statistics[0];
            this.maximum = statistics[1];
            this.mean = statistics[2];
            this.maximum = this.minimum + 2.0f * (this.mean - this.minimum);
            if (this.controls != null) {
                this.controls.resetAutoscale();
            }
            this.updateStatusLabel("loading file " + this.fabioFile.getFileName() + " ... took " + this.fabioFile.getTimeToReadImage() + " ms");
            if (this.imageDiffOn) {
                this.calcImageDiff();
            } else {
                this.setPartName("Image " + this.fabioFile.getFileName());
            }
            if (this.controls != null && this.isAutoscale()) {
                this.controls.setMinMaxText(new float[]{this.minimum, this.maximum});
            }
        }
    }

    public void calcImageDiff() {
        long start = System.currentTimeMillis();
        if (this.savedImageModel == null) {
            this.setImageDiffOn(false);
            this.updateStatusLabel("cannot create difference image - no difference image set");
            FableUtils.errMsg((Object)this, (String)"Cannot create difference: no difference image set\n");
            this.setPartName("Image " + this.fabioFile.getFileName());
            return;
        }
        FableLogger.debug((Object)("caculate difference of " + this.imageModel.getFileName() + " and background image " + this.savedImageModel.getFileName()));
        float[] newArray = this.imageModel.getData();
        float[] savedArray = this.savedImageModel.getData();
        int newLen = newArray.length;
        int savedLen = savedArray.length;
        if (newLen != savedLen) {
            FableUtils.errMsg((Object)this, (String)"Cannot create difference:\nnewWidth=%d savedWidth=%d\nnewHeight=%d savedHeight=%d");
            this.setPartName("Image " + this.fabioFile.getFileName());
            return;
        }
        float[] imageDiffArray = new float[savedLen];
        int i = 0;
        while (i < savedLen) {
            imageDiffArray[i] = newArray[i] - savedArray[i];
            ++i;
        }
        this.imageDiffModel = new ImageModel(String.valueOf(this.imageModel.getFileName()) + " - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), imageDiffArray);
        this.imageDiffModel.reset(String.valueOf(this.imageModel.getFileName()) + " - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), imageDiffArray);
        float[] statistics = this.imageDiffModel.getStatistics(this.image.getImageRect());
        this.minimum = statistics[0];
        this.minimum = statistics[1];
        this.mean = statistics[2];
        long elapsed = System.currentTimeMillis() - start;
        this.updateStatusLabel(String.valueOf(this.getFileName()) + " - " + this.fileNameSaved + " took " + elapsed + " ms");
        this.setPartName("Difference " + this.fabioFile.getFileName());
    }

    public void dropFile() {
        this.fabioFile = null;
        FabioFile _fabioFile = this.controller.getCurrentFile();
        this.loadFile(_fabioFile);
        this.image.displayImage();
        this.controls.setFileNumberText(Integer.toString(this.controller.getCurrentFileIndex()));
    }

    public void updateStatusLabel(String _status) {
        final String status = _status;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ImageView.this.controls != null) {
                    ImageView.this.controls.setStatusText(status);
                }
            }
        });
    }

    public void setPeaks(Vector<Float> vals) {
        this.peaks = vals;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getProperty().equals("CurrentFile")) {
            Object val = evt.getNewValue();
            FabioFile _fabioFile = (FabioFile)val;
            this.loadFile(_fabioFile);
            this.image.displayImage();
            this.controls.setFileNumberText(Integer.toString(this.controller.getCurrentFileIndex()));
            final int sampleIndex = this.controller.getCurrentsample().getFilteredfiles().indexOf(val);
            int sampleSize = this.controller.getCurrentsample().getFilteredfiles().size();
            if (sampleIndex >= 0 && sampleIndex < sampleSize && !this.jobRunning) {
                final int fileReadFrom = Math.max(0, sampleIndex - 3);
                final int fileReadTo = Math.min(sampleIndex + 3, sampleSize - 1);
                this.jobRunning = true;
                Job job = new Job("Read files ahead "){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Read files ahead", 7);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Reading files ahead interrupted", (Throwable)ex);
                        }
                        try {
                            FableJep fableJep = new FableJep();
                            int i = fileReadFrom;
                            while (i <= fileReadTo) {
                                if (i >= 0 && i < ImageView.this.controller.getCurrentsample().getFilteredfiles().size() && i != sampleIndex) {
                                    ((FabioFile)ImageView.this.controller.getCurrentsample().getFilteredfiles().get(i)).readImageAsFloat(fableJep);
                                }
                                monitor.worked(1);
                                ++i;
                            }
                            fableJep.getJep().close();
                        }
                        catch (JepException jepException) {}
                        monitor.done();
                        ImageView.this.jobRunning = false;
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.workbenchListener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.workbenchListener);
            this.workbenchListener = null;
        }
        super.dispose();
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void initWithShowPeaks() {
        if (this.controls == null) {
            return;
        }
        this.setPeaksOn(true);
        this.controls.getPeaksButton().notifyListeners(13, new Event());
    }

    public void setName(String string) {
        this.setPartName(string);
    }

    public void resetCoordinates() {
        if (this.coordOrigin != 4) {
            this.coordinates.reset(this.coordOrigin, this.image.getOrientedOrigRect().width, this.image.getOrientedOrigRect().height);
        }
    }

    public int getCoordOrigin() {
        return this.coordOrigin;
    }

    public void setCoordOrigin(int coordOrigin) {
        if (coordOrigin < 0 || coordOrigin >= coordNameValues.length) {
            return;
        }
        if (this.coordOrigin != coordOrigin) {
            this.coordOrigin = coordOrigin;
            if (this.controls != null) {
                this.controls.getCoordCombo().select(coordOrigin);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation < 0 || orientation >= 8) {
            return;
        }
        if (orientation == this.orientation) {
            return;
        }
        this.orientation = orientation;
        if (this.controls != null) {
            this.controls.getOrientCombo().select(orientation);
        }
        this.resetCoordinates();
        this.image.clearCanvas();
        this.image.displayImage();
    }

    public PaletteData getPalette() {
        return this.palette;
    }

    public void setPalette(int index) {
        if (index < 0 || index >= paletteNameValues.length) {
            return;
        }
        if (palettes[index] == null) {
            switch (index) {
                case 0: {
                    ImageView.palettes[index] = PaletteUtils.makeGrayScalePalette();
                    break;
                }
                case 1: {
                    ImageView.palettes[index] = PaletteUtils.makeColorPalette();
                    break;
                }
                case 2: {
                    ImageView.palettes[index] = PaletteUtils.makeRainbow1Palette();
                    break;
                }
                case 3: {
                    ImageView.palettes[index] = PaletteUtils.makeRainbow2Palette();
                    break;
                }
                case 4: {
                    ImageView.palettes[index] = PaletteUtils.makeBluesPalette();
                    break;
                }
                case 5: {
                    ImageView.palettes[index] = PaletteUtils.makeGreensPalette();
                    break;
                }
                case 6: {
                    ImageView.palettes[index] = PaletteUtils.makeRedsPalette();
                    break;
                }
                case 7: {
                    ImageView.palettes[index] = PaletteUtils.makePastel1Palette();
                    break;
                }
                case 8: {
                    ImageView.palettes[index] = PaletteUtils.makeSpringPalette();
                    break;
                }
                case 9: {
                    ImageView.palettes[index] = PaletteUtils.makeSummerPalette();
                    break;
                }
                case 10: {
                    ImageView.palettes[index] = PaletteUtils.makeAutumnPalette();
                    break;
                }
                case 11: {
                    ImageView.palettes[index] = PaletteUtils.makeWinterPalette();
                }
            }
        }
        this.palette = palettes[index];
        if (this.controls != null) {
            this.controls.getLutCombo().select(index);
        }
        this.paletteIndex = index;
        this.image.displayImage();
    }

    public float[] getMinMax() {
        float[] minmax = new float[]{this.currentMinimum, this.currentMaximum};
        return minmax;
    }

    public void setMinMax(float[] minmax) {
        if (this.controls != null) {
            this.controls.setMinMaxText(minmax);
            this.controls.getAutoscaleButton().setSelection(false);
        }
        this.autoscale = false;
        this.image.displayImage();
    }

    public String getFileName() {
        String fileName = null;
        if (this.imageModel != null) {
            fileName = this.imageModel.getFileName();
        }
        return fileName == null ? "" : fileName;
    }

    public ImageModel getImageModel() {
        return this.imageModel;
    }

    public void setImageModel(ImageModel imageModel) {
        this.imageModel = imageModel;
    }

    public ImageModel getImageDiffModel() {
        return this.imageDiffModel;
    }

    public void setImageDiffModel(ImageModel imageDiffModel) {
        this.imageDiffModel = imageDiffModel;
    }

    public void setImageBackgroundModel(ImageModel imageBackgroundModel) {
        this.savedImageModel = imageBackgroundModel;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCoordinatesName() {
        if (this.coordOrigin < 0 || this.coordOrigin > 4) {
            return "Unknown";
        }
        return coordNameValues[this.coordOrigin][0].split("[\\s\\.]", 2)[0];
    }

    public FabioFile getFabioFile() {
        return this.fabioFile;
    }

    public void setFabioFile(FabioFile fabioFile) {
        this.fabioFile = fabioFile;
    }

    public SampleController getController() {
        return this.controller;
    }

    public boolean isPeaksOn() {
        return this.peaksOn;
    }

    public void setPeaksOn(boolean peaksOn) {
        this.peaksOn = peaksOn;
        Button button = this.controls.getPeaksButton();
        if (this.controls != null && button != null && button.getSelection() != peaksOn) {
            button.setSelection(peaksOn);
        }
    }

    public int getPeakMarkerSize() {
        return this.peakMarkerSize;
    }

    public void setPeakMarkerSize(int peakMarkerSize) {
        this.peakMarkerSize = peakMarkerSize;
    }

    public boolean isKeepAspect() {
        return this.keepAspect;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
        Button button = this.controls.getAspectButton();
        if (this.controls != null && button != null && button.getSelection() != keepAspect) {
            button.setSelection(keepAspect);
        }
    }

    public boolean isAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(boolean autoscale) {
        this.autoscale = autoscale;
        Button button = this.controls.getAutoscaleButton();
        if (this.controls != null && button != null && button.getSelection() != autoscale) {
            button.setSelection(autoscale);
        }
    }

    public ImageViewControls getControls() {
        return this.controls;
    }

    public void setControls(ImageViewControls controls) {
        this.controls = controls;
    }

    public ImageViewImage getImage() {
        return this.image;
    }

    public void setImage(ImageViewImage image) {
        this.image = image;
    }

    public void setZoomSelection(ZoomSelection zoomSelection) {
        this.zoomSelection = zoomSelection;
    }

    public ZoomSelection getZoomSelection() {
        return this.zoomSelection;
    }

    public Vector<Float> getPeaks() {
        return this.peaks;
    }

    public boolean isImageDiffOn() {
        return this.imageDiffOn;
    }

    public void setImageDiffOn(boolean imageDiffOn) {
        this.imageDiffOn = imageDiffOn;
        if (imageDiffOn) {
            this.calcImageDiff();
        } else {
            this.setPartName("Image " + this.fabioFile.getFileName());
        }
        this.image.setImageChanged(true);
        this.image.displayImage();
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float minimum) {
        this.minimum = minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float maximum) {
        this.maximum = maximum;
    }

    public float getMean() {
        return this.mean;
    }

    public void setMean(float mean) {
        this.mean = mean;
    }

    public float getCurrentMinimum() {
        return this.currentMinimum;
    }

    public void setCurrentMinimum(float currentMinimum) {
        this.currentMinimum = currentMinimum;
    }

    public float getCurrentMaximum() {
        return this.currentMaximum;
    }

    public void setCurrentMaximum(float currentMaximum) {
        this.currentMaximum = currentMaximum;
    }

    public double getX0Save() {
        return this.x0Save;
    }

    public void setX0Save(double save) {
        this.x0Save = save;
    }

    public double getY0Save() {
        return this.y0Save;
    }

    public void setY0Save(double save) {
        this.y0Save = save;
    }

    public double getPixelWidthSave() {
        return this.pixelWidthSave;
    }

    public void setPixelWidthSave(double pixelWidthSave) {
        this.pixelWidthSave = pixelWidthSave;
    }

    public double getPixelHeightSave() {
        return this.pixelHeightSave;
    }

    public void setPixelHeightSave(double pixelHeightSave) {
        this.pixelHeightSave = pixelHeightSave;
    }

    public String getXNameSave() {
        return this.xNameSave;
    }

    public void setXNameSave(String nameSave) {
        this.xNameSave = nameSave;
    }

    public String getYNameSave() {
        return this.yNameSave;
    }

    public void setYNameSave(String nameSave) {
        this.yNameSave = nameSave;
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public void setPaletteIndex(int paletteIndex) {
        this.paletteIndex = paletteIndex;
    }

    public void setPalette(PaletteData palette) {
        this.palette = palette;
    }

    public Display getDisplay() {
        return this.display;
    }
}

