/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ImageSelection;
import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.actions.DisplayDifferenceAction;
import fable.imageviewer.actions.ImageCopyAction;
import fable.imageviewer.actions.ImageInfoAction;
import fable.imageviewer.actions.InputSummaryAction;
import fable.imageviewer.actions.ResetZoomAction;
import fable.imageviewer.actions.SetDifferenceAction;
import fable.imageviewer.actions.Slice1DAction;
import fable.imageviewer.actions.Slice2DAction;
import fable.imageviewer.actions.ZoomAreaAction;
import fable.imageviewer.actions.ZoomLineAction;
import fable.imageviewer.actions.ZoomProfileAction;
import fable.imageviewer.actions.ZoomReliefAction;
import fable.imageviewer.actions.ZoomRockingAction;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.ImageViewImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class ImageViewActions
implements IImagesVarKeys {
    ImageView iv = null;
    private ImageViewControls controls;
    public ImageViewImage image = null;
    public Action controlPanelAction;
    public Action resetMinMaxAction;
    public ZoomAreaAction zoomAreaAction;
    public ZoomLineAction zoomLineAction;
    public ZoomProfileAction zoomProfileAction;
    public ZoomReliefAction zoomReliefAction;
    public ZoomRockingAction zoomRockingAction;
    public ResetZoomAction resetZoomAction;
    public ImageCopyAction copyImageAction;
    public SetDifferenceAction setDifferenceAction;
    public DisplayDifferenceAction displayDifferenceAction;
    public Slice1DAction slice1DAction;
    public Slice2DAction slice2DAction;
    public Action printSetupAction;
    public Action printPreviewAction;
    public Action printAction;
    public Action copyAction;
    public ImageInfoAction imageInfoAction;
    public InputSummaryAction inputSummaryAction;

    public ImageViewActions(ImageView ivIn, ImageViewControls controlsIn, ImageViewImage imageIn) {
        this.iv = ivIn;
        this.controls = controlsIn;
        this.image = imageIn;
        this.controlPanelAction = new Action("Control Panel", 8){

            public void run() {
                if (ImageViewActions.this.controls.getControlComposite() == null) {
                    return;
                }
                ImageViewActions.this.controls.setControlCompositeShowing(!ImageViewActions.this.controls.getControlCompositeShowing());
                this.setChecked(ImageViewActions.this.controls.getControlCompositeShowing());
                ImageViewActions.this.controls.getControlComposite().setVisible(ImageViewActions.this.controls.getControlCompositeShowing());
                GridData data = (GridData)ImageViewActions.this.controls.getControlComposite().getLayoutData();
                data.exclude = !ImageViewActions.this.controls.getControlCompositeShowing();
                Composite parent = ImageViewActions.this.controls.getControlComposite().getParent();
                if (parent != null) {
                    parent.layout(false);
                }
            }
        };
        this.controlPanelAction.setChecked(this.controls.getControlCompositeShowing());
        this.controlPanelAction.setToolTipText("Toggle Control Panel");
        this.controlPanelAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.imageviewer", (String)"images/settings.gif"));
        this.resetMinMaxAction = new Action("Reset Min Max Intensity"){

            public void run() {
                if (ImageViewActions.this.iv == null || ImageViewActions.this.iv.getControls() == null) {
                    return;
                }
                ImageViewActions.this.iv.getControls().setMinMaxText(new float[]{ImageViewActions.this.iv.getMinimum(), ImageViewActions.this.iv.getMaximum()});
                ImageViewActions.this.iv.getControls().resetAutoscale();
                if (ImageViewActions.this.iv.getImage() != null) {
                    ImageViewActions.this.iv.getImage().displayImage();
                }
            }
        };
        this.resetMinMaxAction.setToolTipText("Reset the minimun and maximum for manual intensity scaling to be the image limits");
        this.zoomAreaAction = new ZoomAreaAction("Zoom Area");
        this.zoomAreaAction.init((IViewPart)this.iv);
        ZoomSelection zoomSelection = this.iv.getZoomSelection();
        if (zoomSelection == ZoomSelection.AREA) {
            this.zoomAreaAction.setChecked(true);
        }
        this.zoomLineAction = new ZoomLineAction("Zoom Line");
        this.zoomLineAction.init((IViewPart)this.iv);
        if (zoomSelection == ZoomSelection.LINE) {
            this.zoomLineAction.setChecked(true);
        }
        this.zoomProfileAction = new ZoomProfileAction("Zoom Profile");
        this.zoomProfileAction.init((IViewPart)this.iv);
        if (zoomSelection == ZoomSelection.PROFILE) {
            this.zoomProfileAction.setChecked(true);
        }
        this.zoomReliefAction = new ZoomReliefAction("Zoom Relief");
        this.zoomReliefAction.init((IViewPart)this.iv);
        if (zoomSelection == ZoomSelection.RELIEF) {
            this.zoomReliefAction.setChecked(true);
        }
        this.zoomRockingAction = new ZoomRockingAction("Zoom Rocking");
        this.zoomRockingAction.init((IViewPart)this.iv);
        if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
            this.zoomRockingAction.setChecked(true);
        }
        this.resetZoomAction = new ResetZoomAction("Reset Zoom");
        this.resetZoomAction.init((IViewPart)this.iv);
        this.resetZoomAction.setToolTipText("Reset zoom to original image size");
        this.copyImageAction = new ImageCopyAction("Copy Image");
        this.copyImageAction.init((IViewPart)this.iv);
        this.copyImageAction.setToolTipText("Show a copy of this view in another view");
        this.setDifferenceAction = new SetDifferenceAction("Set Difference");
        this.setDifferenceAction.init((IViewPart)this.iv);
        this.setDifferenceAction.setToolTipText("Set current image as reference image to subtract");
        this.displayDifferenceAction = new DisplayDifferenceAction("Display Difference");
        this.displayDifferenceAction.init((IViewPart)this.iv);
        this.displayDifferenceAction.setToolTipText("Display image with reference image subtracted");
        this.slice1DAction = new Slice1DAction("1D Slice");
        this.slice1DAction.init((IViewPart)this.iv);
        this.slice1DAction.setToolTipText("Make a new 2D image by stacking the zoomed line of the selected images");
        this.slice2DAction = new Slice2DAction("2D Slice");
        this.slice2DAction.init((IViewPart)this.iv);
        this.slice2DAction.setToolTipText("Make a new 2D image by stacking the zoomed area of the selected images");
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog dialog = new ImagePrintSetupDialog(ImageViewActions.this.iv.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog dialog = new ImagePrintPreviewDialog(ImageViewActions.this.iv.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings settings = dialog.open();
                if (settings != null) {
                    FableImagePrinter.settings = settings;
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage((Shell)ImageViewActions.this.iv.getDisplay().getActiveShell(), (org.eclipse.swt.graphics.Image)image, (Point)ImageViewActions.this.iv.getDisplay().getActiveShell().getDisplay().getDPI(), (PrintSettings)FableImagePrinter.settings);
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                org.eclipse.swt.graphics.Image image = ImageViewActions.this.controls.getImage().getImage();
                if (image == null) {
                    return;
                }
                try {
                    BufferedImage awtImage = SWTUtils.convertToAWT((ImageData)image.getImageData());
                    if (awtImage == null) {
                        FableUtils.errMsg((Object)((Object)this), (String)"Could not convert SWT image to AWT image");
                        return;
                    }
                    Clipboard awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    awtClipboard.setContents((Transferable)new ImageSelection((Image)awtImage), null);
                }
                catch (Throwable t) {
                    FableUtils.excMsg((Object)((Object)this), (String)"Problem copying to clipboard", (Throwable)t);
                }
            }
        };
        this.imageInfoAction = new ImageInfoAction("Image Info");
        this.imageInfoAction.init((IViewPart)this.iv);
        this.imageInfoAction.setToolTipText("Display image info");
        this.inputSummaryAction = new InputSummaryAction("Input Summary");
        this.inputSummaryAction.init((IViewPart)this.iv);
        this.inputSummaryAction.setToolTipText("Display a summary of mouse operations");
    }
}

