/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionWrapper;
import org.apache.tools.ant.types.resources.StringResource;
import org.apache.tools.ant.util.ConcatResourceInputStream;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.tools.ant.util.Tokenizer;

public class Tokens
extends BaseResourceCollectionWrapper {
    private Tokenizer tokenizer;
    private String encoding;

    protected synchronized Collection getCollection() {
        ResourceCollection rc = this.getResourceCollection();
        if (rc.size() == 0) {
            return Collections.EMPTY_SET;
        }
        if (this.tokenizer == null) {
            this.tokenizer = new LineTokenizer();
        }
        ConcatResourceInputStream cat = new ConcatResourceInputStream(rc);
        cat.setManagingComponent(this);
        InputStreamReader rdr = null;
        if (this.encoding == null) {
            rdr = new InputStreamReader(cat);
        } else {
            try {
                rdr = new InputStreamReader((InputStream)cat, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new BuildException(e);
            }
        }
        ArrayList<StringResource> result = new ArrayList<StringResource>();
        try {
            String s = this.tokenizer.getToken(rdr);
            while (s != null) {
                result.add(new StringResource(s));
                s = this.tokenizer.getToken(rdr);
            }
        }
        catch (IOException e) {
            throw new BuildException("Error reading tokens", e);
        }
        return result;
    }

    public synchronized void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public synchronized void add(Tokenizer tokenizer) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.tokenizer != null) {
            throw new BuildException("Only one nested tokenizer allowed.");
        }
        this.tokenizer = tokenizer;
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            if (this.tokenizer instanceof DataType) {
                stk.push(this.tokenizer);
                Tokens.invokeCircularReferenceCheck((DataType)((Object)this.tokenizer), stk, p);
            }
            this.setChecked(true);
        }
    }
}

