/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class JSmoothLabel
extends JComponent {
    public static int CENTER_ALIGNMENT = 1;
    public static int LEFT_ALIGNMENT = 2;
    public static int RIGHT_ALIGNMENT = 3;
    public static int CLASSIC_BEHAVIOR = 2;
    public static int MATRIX_BEHAVIOR = 1;
    private String text;
    private int off_y = 0;
    private int align;
    private int sizingBehavior;

    public JSmoothLabel() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.align = CENTER_ALIGNMENT;
        this.text = "";
        this.sizingBehavior = CLASSIC_BEHAVIOR;
    }

    public void setText(String txt) {
        this.text = txt == null ? "" : txt;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setVerticalOffset(int y) {
        this.off_y = y;
        this.repaint();
    }

    public int getVerticalOffset() {
        return this.off_y;
    }

    public void setValueOffsets(int x, int y) {
        System.out.println("JSmoothLabel.setValueOffsets() is deprecated and has no effects.");
    }

    public void setSizingBehavior(int s) {
        this.sizingBehavior = s;
    }

    public int getSizingBehavior() {
        return this.sizingBehavior;
    }

    public void setHorizontalAlignment(int a) {
        this.align = a;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
        }
        g.setColor(this.getForeground());
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g.getFont().getStringBounds(this.text, frc);
        double a = this.getFont().getLineMetrics(this.text, frc).getAscent();
        int y = (int)(((double)h - bounds.getHeight()) / 2.0 + a);
        int xpos = 0;
        switch (this.align) {
            case 1: {
                xpos = (w - (int)bounds.getWidth()) / 2;
                break;
            }
            case 2: {
                xpos = 3;
                break;
            }
            case 3: {
                xpos = w - (int)bounds.getWidth() - 3;
            }
        }
        g.drawString(this.text, xpos, this.off_y + y);
    }

    public Dimension getPreferredSize() {
        if (this.sizingBehavior == MATRIX_BEHAVIOR) {
            return super.getPreferredSize();
        }
        Dimension d = ATKGraphicsUtils.measureString(this.text, this.getFont());
        d.width += 6;
        d.height += 4;
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

