/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.database.tools;

import fable.framework.views.FableIOConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class DerbyIJConsole {
    FableIOConsole sqlConsole;
    RunConsoleThread runConsoleThread = new RunConsoleThread();
    static final String ijCommand = "java -cp /opt/europa/eclipse/plugins/org.apache.derby.core_10.3.1/derby.jar:/opt/europa/eclipse/plugins/org.apache.derby.core_10.3.1/derbytools.jar:/opt/europa/eclipse/plugins/org.apache.derby.core_10.3.1/derbyclient.jar:/opt/europa/eclipse/plugins/org.apache.derby.core_10.3.1/derbynet.jar org.apache.derby.tools.ij";

    public DerbyIJConsole() {
        this.sqlConsole = new FableIOConsole("SQL Console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.sqlConsole});
    }

    public void run() {
        new Thread(this.runConsoleThread).start();
    }

    class RunConsoleThread
    implements Runnable {
        final Runtime runtime = Runtime.getRuntime();
        String outputMessage;
        private Process ijProcess;

        RunConsoleThread() {
        }

        @Override
        public void run() {
            try {
                this.ijProcess = this.runtime.exec(DerbyIJConsole.ijCommand);
                StreamReaderThread outThread = new StreamReaderThread(this.ijProcess.getInputStream());
                StreamReaderThread errThread = new StreamReaderThread(this.ijProcess.getErrorStream());
                StreamWriterThread inThread = new StreamWriterThread(this.ijProcess.getOutputStream());
                inThread.start();
                errThread.start();
                outThread.start();
                this.ijProcess.waitFor();
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{DerbyIJConsole.this.sqlConsole});
                outThread.join();
                inThread.join();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{DerbyIJConsole.this.sqlConsole});
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream in) {
            this.inStream = in;
        }

        @Override
        public void run() {
            BufferedReader outputread = new BufferedReader(new InputStreamReader(this.inStream));
            try {
                int ch;
                while ((ch = outputread.read()) != -1) {
                    DerbyIJConsole.this.sqlConsole.displayOut(String.valueOf((char)ch));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("exit StreamReaderThread() ...");
        }
    }

    public class StreamWriterThread
    extends Thread {
        byte inMessage;
        OutputStream outStream;
        String newline = System.getProperty("line.separator");

        public StreamWriterThread(OutputStream out) {
            this.outStream = out;
        }

        @Override
        public void run() {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)DerbyIJConsole.this.sqlConsole.getInputStream()));
                String str = "";
                while (str != null) {
                    str = in.readLine();
                    if (str == null) continue;
                    this.outStream.write(str.getBytes());
                    this.outStream.write(this.newline.getBytes());
                    this.outStream.flush();
                }
            }
            catch (IOException iOException) {}
            System.out.println("exit StreamWriterThread() ...");
        }
    }
}

