/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.Activator;
import java.awt.Color;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ToolBox {
    public static String getPluginPath(String bundleName, String PluginId) throws IOException {
        Bundle bundle = Platform.getBundle((String)PluginId);
        IPath xmliniFile = Platform.getStateLocation((Bundle)bundle);
        String bundlePath = xmliniFile.toString();
        int lastIndex = bundlePath.lastIndexOf(bundleName);
        if (lastIndex >= 0 && lastIndex < bundlePath.length()) {
            bundlePath = bundlePath.substring(0, lastIndex);
        }
        return bundlePath;
    }

    public static boolean checkIfFileExists(String fileName) {
        File myFile;
        boolean bFileSet = false;
        if (fileName != null && !fileName.equals("") && (myFile = new File(fileName)).exists()) {
            bFileSet = true;
        }
        return bFileSet;
    }

    public static boolean checkExtension(String fileName, String extension) {
        String file = fileName.toLowerCase();
        String ext = extension.toLowerCase();
        return file.endsWith(ext);
    }

    public static boolean checkIfIsDirectory(String path) {
        boolean bok = false;
        File dir = new File(path);
        if (dir.isDirectory()) {
            bok = true;
        }
        return bok;
    }

    public static String[] getFilesFromDirectory(String directoryPath, String extension) {
        File dir = new File(directoryPath);
        final String ext = extension.toLowerCase();
        FilenameFilter myFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                File dirfilter = new File(directory, name);
                if (dirfilter.isDirectory()) {
                    return false;
                }
                name = name.toLowerCase();
                return name.endsWith(ext);
            }
        };
        return dir.list(myFilter);
    }

    public static void quicksort(File[] list, int begin, int end) {
        if (end > begin) {
            int indexPivot = ToolBox.partition(list, begin, end);
            ToolBox.quicksort(list, begin, indexPivot);
            ToolBox.quicksort(list, indexPivot + 1, end);
        }
    }

    private static int partition(File[] list, int begin, int end) {
        File temp;
        int indexPivot = begin + (end - begin) / 2;
        File valuePivot = list[indexPivot];
        int k = begin;
        int i = begin;
        while (i < end) {
            if (list[i].getAbsolutePath().compareTo(valuePivot.getAbsolutePath()) < 0) {
                temp = list[i];
                list[i] = list[k];
                list[k] = temp;
                if (k == indexPivot) {
                    indexPivot = i;
                }
                ++k;
            }
            ++i;
        }
        if (k < end) {
            temp = list[k];
            list[k] = valuePivot;
            list[indexPivot] = temp;
        }
        return k;
    }

    public static void quicksort(String[] list, int begin, int end) {
        if (end > begin) {
            int indexPivot = ToolBox.partition(list, begin, end);
            ToolBox.quicksort(list, begin, indexPivot);
            ToolBox.quicksort(list, indexPivot + 1, end);
        }
    }

    private static int partition(String[] list, int begin, int end) {
        String temp;
        int indexPivot = begin + (end - begin) / 2;
        String valuePivot = list[indexPivot];
        int k = begin;
        int i = begin;
        while (i < end) {
            if (list[i].compareTo(valuePivot) < 0) {
                temp = list[i];
                list[i] = list[k];
                list[k] = temp;
                if (k == indexPivot) {
                    indexPivot = i;
                }
                ++k;
            }
            ++i;
        }
        if (k < end) {
            temp = list[k];
            list[k] = valuePivot;
            list[indexPivot] = temp;
        }
        return k;
    }

    public static File[] getFilesByEntireRegex(String directoryPath, String regex, boolean bRetreive) {
        File dir = new File(directoryPath);
        String exp = regex;
        final boolean bGet = bRetreive;
        try {
            final Pattern pattern = Pattern.compile(exp);
            FilenameFilter myFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File dirfilter = new File(dir, name);
                    if (dirfilter.isDirectory()) {
                        return false;
                    }
                    return pattern.matcher(dirfilter.getName()).matches() == bGet;
                }
            };
            return dir.listFiles(myFilter);
        }
        catch (PatternSyntaxException pe) {
            Logger.getLogger(ToolBox.class).error((Object)pe.getMessage());
            System.out.println(pe.getMessage());
            return null;
        }
    }

    public static String[] getFileNamesByEntireRegex(String directoryPath, String regex, boolean bRetreive) {
        File dir = new File(directoryPath);
        String exp = regex;
        final boolean bGet = bRetreive;
        try {
            final Pattern pattern = Pattern.compile(exp);
            FilenameFilter myFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File dirfilter = new File(dir, name);
                    if (dirfilter.isDirectory()) {
                        return false;
                    }
                    return pattern.matcher(dirfilter.getName()).matches() == bGet;
                }
            };
            return dir.list(myFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static String[] getFilesByEntireRegexAndTime(String directoryPath, String regex, boolean bRetreive, long date) {
        File dir = new File(directoryPath);
        String exp = regex;
        final boolean bGet = bRetreive;
        final long f_downdate = date;
        try {
            final Pattern pattern = Pattern.compile(exp);
            FilenameFilter myFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File dirfilter = new File(dir, name);
                    if (dirfilter.isDirectory()) {
                        return false;
                    }
                    if (f_downdate > dirfilter.lastModified()) {
                        return false;
                    }
                    return pattern.matcher(dirfilter.getName()).matches() == bGet;
                }
            };
            return dir.list(myFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static Color getRandomColor() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public static String addQuotesForSpacesInName(String pathName, String regex, String sep) {
        String[] splitter = pathName.split(regex);
        String name = "";
        int i = 0;
        while (i < splitter.length - 1) {
            if (splitter[i].contains(" ")) {
                splitter[i] = "\"" + splitter[i] + "\"";
            }
            name = String.valueOf(name) + splitter[i] + sep;
            ++i;
        }
        name = String.valueOf(name) + splitter[splitter.length - 1];
        return name;
    }

    public static Date stringToDate(String sDate, String sFormat) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(sFormat);
        return sdf.parse(sDate);
    }

    public static String getPluginName(String pluginId) {
        String name = "Unknown-Name";
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return name;
        }
        String pluginName = bundle.getSymbolicName();
        if (pluginName != null) {
            name = pluginName;
        }
        return name;
    }

    public static String getPluginVersion(String pluginId) {
        String version = "Unknown-Version";
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            return version;
        }
        Dictionary bundleHeaders = bundle.getHeaders();
        if (bundleHeaders == null) {
            return version;
        }
        String pluginVersion = (String)bundleHeaders.get("Bundle-Version");
        if (pluginVersion != null) {
            version = pluginVersion;
        }
        return version;
    }

    public static String getStem(String filename) {
        String stem = new String();
        int index = filename.indexOf(".");
        int start = 0;
        if (index > -1) {
            stem = filename.substring(0, index);
        }
        if (!ToolBox.getFileType(filename).equals("bruker")) {
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(stem);
            while (matcher.find()) {
                start = matcher.start();
            }
            stem = stem.substring(0, start);
        }
        return stem;
    }

    public static String getFileType(String fileName) {
        String regex1 = ".+\\.\\d+.*";
        String type = "";
        Pattern pattern1 = Pattern.compile(regex1);
        if (pattern1.matcher(fileName).matches()) {
            type = "bruker";
        } else {
            int index = fileName.indexOf(".");
            if (index > -1 && index + 1 < fileName.length()) {
                type = fileName.substring(index + 1);
            }
        }
        return type;
    }

    public static String getFileNumber(String filename) {
        int indexCompress;
        String number = new String();
        int index = filename.indexOf(".");
        int start = 0;
        if (!ToolBox.getFileType(filename).equals("bruker")) {
            number = filename.substring(0, index);
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(number);
            while (matcher.find()) {
                start = matcher.start();
            }
            number = number.substring(start);
        } else if (index > -1 && index + 1 < filename.length() && (number = filename.substring(index + 1)).contains(".") && (indexCompress = number.indexOf(".")) > -1) {
            number = number.substring(0, indexCompress);
        }
        return number;
    }

    public static boolean isSmallPerspectiveSet() {
        boolean smallPerspective = true;
        String perspective = Activator.getDefault().getPreferenceStore().getString("configuration.perspective");
        if (perspective != null && perspective.equals("configuration.perspective.LargeScreen")) {
            smallPerspective = false;
        }
        return smallPerspective;
    }

    public static boolean isOsLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isOsWindows() {
        return System.getProperty("os.name").toLowerCase().contains("window");
    }

    public static String getHelpContextTooltip() {
        if (ToolBox.isOsLinux()) {
            return "CTRL+F1";
        }
        if (ToolBox.isOsWindows()) {
            return "F1";
        }
        return "Help";
    }
}

