/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint.test;

import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.SWTUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SWTImageViewer {
    private static final boolean useStartImage = true;
    private static final String startImageName1 = "C:/Documents and Settings/evans/My Documents/My Pictures/DAZ.Dogfight.15017.jpg";
    private static final String startImageName2 = "C:/users/evans/Pictures/DAZ.Dogfight.15017.jpg";
    private String startImageName;
    private Display display;
    private Shell shell;
    private PrintSettings settings;
    private Canvas canvas;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private Point origin;
    private Image image;
    private String fileName;

    public SWTImageViewer() {
        block7: {
            this.startImageName = startImageName2;
            this.display = new Display();
            this.shell = new Shell(this.display);
            this.shell.setText("SWT Image Viewer");
            this.shell.setLayout((Layout)new GridLayout(1, true));
            this.settings = new PrintSettings();
            if (System.getProperty("os.name", "Windows XP").equalsIgnoreCase("Windows XP")) {
                this.startImageName = startImageName1;
            }
            ToolBar toolBar = new ToolBar((Composite)this.shell, 0x800000);
            ToolItem itemOpen = new ToolItem(toolBar, 8);
            itemOpen.setText("Open");
            itemOpen.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(SWTImageViewer.this.shell, 4096);
                    String file = dialog.open();
                    if (file != null) {
                        if (SWTImageViewer.this.image != null) {
                            SWTImageViewer.this.image.dispose();
                        }
                        SWTImageViewer.this.image = null;
                        try {
                            SWTImageViewer.this.image = new Image((Device)SWTImageViewer.this.display, file);
                        }
                        catch (RuntimeException ex) {
                            SWTUtils.excMsgAsync("Failed to load image from file: " + file, ex);
                        }
                        if (SWTImageViewer.this.image != null) {
                            SWTImageViewer.this.fileName = file;
                            SWTImageViewer.this.shell.setText("SWT Image Viewer " + SWTImageViewer.this.fileName);
                            SWTImageViewer.this.canvas.redraw();
                        }
                    }
                }
            });
            ToolItem itemPrintSetup = new ToolItem(toolBar, 8);
            itemPrintSetup.setText("Print Setup");
            itemPrintSetup.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImagePrintSetupDialog dialog = new ImagePrintSetupDialog(SWTImageViewer.this.shell, SWTImageViewer.this.image, SWTImageViewer.this.settings);
                    SWTImageViewer.this.settings = dialog.open();
                }
            });
            ToolItem itemPrintPreview = new ToolItem(toolBar, 8);
            itemPrintPreview.setText("Preview");
            itemPrintPreview.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImagePrintPreviewDialog dialog = new ImagePrintPreviewDialog(SWTImageViewer.this.shell, SWTImageViewer.this.image, SWTImageViewer.this.settings);
                    SWTImageViewer.this.settings = dialog.open();
                }
            });
            ToolItem itemPrint = new ToolItem(toolBar, 8);
            itemPrint.setText("Print");
            itemPrint.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SWTImageViewer.this.print();
                }
            });
            this.origin = new Point(0, 0);
            this.canvas = new Canvas((Composite)this.shell, 0x100300);
            this.canvas.setBackground(this.display.getSystemColor(1));
            this.canvas.setLayoutData((Object)new GridData(1808));
            this.hBar = this.canvas.getHorizontalBar();
            this.hBar.addListener(13, new Listener(){

                public void handleEvent(Event ev) {
                    int hSelection = SWTImageViewer.this.hBar.getSelection();
                    int destX = -hSelection - ((SWTImageViewer)SWTImageViewer.this).origin.x;
                    Rectangle rect = SWTImageViewer.this.image.getBounds();
                    SWTImageViewer.this.canvas.scroll(destX, 0, 0, 0, rect.width, rect.height, false);
                    ((SWTImageViewer)SWTImageViewer.this).origin.x = -hSelection;
                }
            });
            this.vBar = this.canvas.getVerticalBar();
            this.vBar.addListener(13, new Listener(){

                public void handleEvent(Event ev) {
                    int vSelection = SWTImageViewer.this.vBar.getSelection();
                    int destY = -vSelection - ((SWTImageViewer)SWTImageViewer.this).origin.y;
                    Rectangle rect = SWTImageViewer.this.image.getBounds();
                    SWTImageViewer.this.canvas.scroll(0, destY, 0, 0, rect.width, rect.height, false);
                    ((SWTImageViewer)SWTImageViewer.this).origin.y = -vSelection;
                }
            });
            this.canvas.addListener(11, new Listener(){

                public void handleEvent(Event ev) {
                    if (SWTImageViewer.this.image == null || SWTImageViewer.this.image.isDisposed()) {
                        return;
                    }
                    Rectangle rect = SWTImageViewer.this.image.getBounds();
                    Rectangle client = SWTImageViewer.this.canvas.getClientArea();
                    SWTImageViewer.this.hBar.setMaximum(rect.width);
                    SWTImageViewer.this.vBar.setMaximum(rect.height);
                    SWTImageViewer.this.hBar.setThumb(Math.min(rect.width, client.width));
                    SWTImageViewer.this.vBar.setThumb(Math.min(rect.height, client.height));
                    int hPage = rect.width - client.width;
                    int vPage = rect.height - client.height;
                    int hSelection = SWTImageViewer.this.hBar.getSelection();
                    int vSelection = SWTImageViewer.this.vBar.getSelection();
                    if (hSelection >= hPage) {
                        if (hPage <= 0) {
                            hSelection = 0;
                        }
                        ((SWTImageViewer)SWTImageViewer.this).origin.x = -hSelection;
                    }
                    if (vSelection >= vPage) {
                        if (vPage <= 0) {
                            vSelection = 0;
                        }
                        ((SWTImageViewer)SWTImageViewer.this).origin.y = -vSelection;
                    }
                    SWTImageViewer.this.canvas.redraw();
                }
            });
            this.canvas.addListener(9, new Listener(){

                public void handleEvent(Event ev) {
                    int marginHeight;
                    if (SWTImageViewer.this.image == null || SWTImageViewer.this.image.isDisposed()) {
                        return;
                    }
                    GC gc = ev.gc;
                    gc.drawImage(SWTImageViewer.this.image, ((SWTImageViewer)SWTImageViewer.this).origin.x, ((SWTImageViewer)SWTImageViewer.this).origin.y);
                    Rectangle rect = SWTImageViewer.this.image.getBounds();
                    Rectangle client = SWTImageViewer.this.canvas.getClientArea();
                    int marginWidth = client.width - rect.width;
                    if (marginWidth > 0) {
                        gc.fillRectangle(rect.width, 0, marginWidth, client.height);
                    }
                    if ((marginHeight = client.height - rect.height) > 0) {
                        gc.fillRectangle(0, rect.height, client.width, marginHeight);
                    }
                }
            });
            try {
                try {
                    this.fileName = this.startImageName;
                    this.image = new Image((Device)this.display, this.startImageName);
                    this.shell.setText("SWT Image Viewer " + this.fileName);
                }
                catch (RuntimeException runtimeException) {
                    this.canvas.redraw();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.canvas.redraw();
                throw throwable;
            }
            this.canvas.redraw();
        }
        this.shell.setSize(800, 600);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    void print() {
        PrintDialog dialog = new PrintDialog(this.shell);
        PrinterData printerData = dialog.open();
        if (printerData == null) {
            return;
        }
        ImagePrintUtils.printImage(this.image, this.shell.getDisplay().getDPI(), null);
    }

    public static void main(String[] args) {
        new SWTImageViewer();
    }
}

