/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.object;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class PeakSelectionProvider
implements ISelectionProvider {
    private ArrayList<ISelectionChangedListener> selectionListeners = new ArrayList();
    private ISelectionProvider delegate;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == PeakSelectionProvider.this.delegate) {
                PeakSelectionProvider.this.fireSelectionChanged(event.getSelection());
            }
        }
    };

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.delegate.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }

    public void setSelectionProviderDelegate(ISelectionProvider newDelegate) {
        if (this.delegate == newDelegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            this.fireSelectionChanged(newDelegate.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    private void fireSelectionChanged(ArrayList<ISelectionChangedListener> list, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(this.delegate, selection);
        Object[] listeners = list.toArray();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }
}

