/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.List;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.engine.PushTypedOperation;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Any;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventTypeHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedEventComm.TypedPushConsumer;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierHelper;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPushSupplierPOATie;
import org.omg.PortableServer.Servant;

public class TypedProxyPushSupplierImpl
extends AbstractProxySupplier
implements TypedProxyPushSupplierOperations {
    private TypedPushConsumer pushConsumer_;
    private Object typedConsumer_;
    private static final TypeCode TYPE_CODE_VOID = ORB.init().get_primitive_tc(TCKind.tk_void);
    private String consumerInterface_;

    public TypedProxyPushSupplierImpl(String string) {
        this.consumerInterface_ = string;
    }

    public void disconnect_push_supplier() {
        this.dispose();
    }

    public void connect_typed_push_consumer(TypedPushConsumer typedPushConsumer) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_push_supplier");
        this.assertNotConnected();
        this.connectClient(typedPushConsumer);
        this.pushConsumer_ = typedPushConsumer;
        this.typedConsumer_ = this.pushConsumer_.get_typed_consumer();
        if (!this.typedConsumer_._is_a(this.consumerInterface_)) {
            throw new TypeError();
        }
    }

    public ProxyType MyType() {
        return ProxyType.PUSH_TYPED;
    }

    public boolean hasMessageConsumer() {
        return true;
    }

    public MessageConsumer getMessageConsumer() {
        return this;
    }

    public List getSubsequentFilterStages() {
        return null;
    }

    public Object activate() {
        return TypedProxyPushSupplierHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public void deliverPendingData() {
    }

    public void isIDLAssignable(String string) throws IllegalArgumentException {
        if (this.typedConsumer_._is_a(string)) {
            return;
        }
        if (string.indexOf("Pull") > 0) {
            int n = string.indexOf("Pull");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string.substring(n + 4));
            if (this.typedConsumer_._is_a(stringBuffer.toString())) {
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void deliverMessage(Message message) {
        try {
            String string;
            Property[] propertyArray = message.toTypedEvent();
            if ("operation".equals(propertyArray[0].name)) {
                string = propertyArray[0].value.extract_string();
            } else if ("event_type".equals(propertyArray[0].name)) {
                string = EventTypeHelper.extract((Any)propertyArray[0].value).type_name;
                String string2 = EventTypeHelper.extract((Any)propertyArray[0].value).domain_name;
                this.isIDLAssignable(string2);
            } else {
                throw new IllegalArgumentException();
            }
            int n = string.lastIndexOf("::");
            String string3 = string.substring(n + 2);
            Request request = this.typedConsumer_._request(string3);
            NVList nVList = request.arguments();
            for (int i = 1; i < propertyArray.length; ++i) {
                nVList.add_value(propertyArray[i].name, propertyArray[i].value, 1);
            }
            request.set_return_type(TYPE_CODE_VOID);
            try {
                request.invoke();
                this.resetErrorCounter();
            }
            catch (Throwable throwable) {
                PushTypedOperation pushTypedOperation = new PushTypedOperation(request);
                this.handleFailedPushOperation(pushTypedOperation, throwable);
            }
        }
        catch (NoTranslationException noTranslationException) {
            this.logger_.info("No Translation possible", noTranslationException);
        }
    }

    protected void disconnectClient() {
        if (this.pushConsumer_ != null) {
            this.pushConsumer_.disconnect_push_consumer();
            this.pushConsumer_ = null;
        }
    }

    public Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new TypedProxyPushSupplierPOATie(this);
        }
        return this.thisServant_;
    }
}

