/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import java.util.StringTokenizer;
import java.util.Vector;

public class Database
extends Connection {
    public Database() throws DevFailed {
    }

    public Database(String string, String string2) throws DevFailed {
        super(string, string2);
    }

    private String stringArray2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String get_info() throws DevFailed {
        DeviceData deviceData = this.command_inout("DbInfo");
        String[] stringArray = deviceData.extractStringArray();
        return this.stringArray2String(stringArray);
    }

    public String[] get_host_list() throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout("DbGetHostList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_host_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetHostList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_class_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceServerClassList", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        int n = stringArray.length == 0 ? 0 : stringArray.length - 1;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("DServer")) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray2;
    }

    public String[] get_server_name_list() throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout("DbGetServerNameList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_instance_name_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetInstanceNameList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_list() throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert("*");
        DeviceData deviceData2 = this.command_inout("DbGetServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_server_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_host_server_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetHostServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbServInfo get_server_info(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetServerInfo", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        return new DbServInfo(stringArray);
    }

    public void put_server_info(DbServInfo dbServInfo) throws DevFailed {
        String[] stringArray = new String[]{dbServInfo.name, dbServInfo.host, dbServInfo.controlled ? "1" : "0", new String("" + dbServInfo.startup_level)};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutServerInfo", deviceData);
    }

    public void delete_server_info(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbDeleteServerInfo", deviceData);
    }

    public void add_device(DbDevInfo dbDevInfo) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(dbDevInfo.toStringArray());
        this.command_inout("DbAddDevice", deviceData);
    }

    public void add_device(String string, String string2, String string3) throws DevFailed {
        DbDevInfo dbDevInfo = new DbDevInfo(string, string2, string3);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(dbDevInfo.toStringArray());
        this.command_inout("DbAddDevice", deviceData);
    }

    public void delete_device(String string) throws DevFailed {
        Object object;
        boolean bl = true;
        try {
            object = new DeviceProxy(string);
            ((Connection)object).ping();
            bl = false;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            object = new DeviceData();
            ((DeviceData)object).insert(string);
            this.command_inout("DbDeleteDevice", (DeviceData)object);
        } else {
            Except.throw_connection_failed("TangoApi_DEVICE_ALIVE", "Cannot delete a device which is ALIVE.", "delete_device()");
        }
    }

    public DeviceInfo get_device_info(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceInfo", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return new DeviceInfo(devVarLongStringArray);
    }

    public DbDevImportInfo import_device(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbImportDevice", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return new DbDevImportInfo(devVarLongStringArray);
    }

    public void unexport_device(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbUnExportDevice", deviceData);
    }

    public void export_device(DbDevExportInfo dbDevExportInfo) throws DevFailed {
        String[] stringArray = dbDevExportInfo.toStringArray();
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbExportDevice", deviceData);
    }

    public String[] get_device_class_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceClassList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_name(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_domain(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceDomainList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_family(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceFamilyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_member(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceMemberList", deviceData);
        return deviceData2.extractStringArray();
    }

    public void add_server(String string, DbDevInfo[] dbDevInfoArray) throws DevFailed {
        String[] stringArray = new String[1 + 2 * dbDevInfoArray.length];
        stringArray[0] = string;
        for (int i = 0; i < dbDevInfoArray.length; ++i) {
            stringArray[2 * i + 1] = dbDevInfoArray[i].name;
            stringArray[2 * i + 2] = dbDevInfoArray[i]._class;
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbAddServer", deviceData);
    }

    public void delete_server(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbDeleteServer", deviceData);
    }

    public void export_server(DbDevExportInfo[] dbDevExportInfoArray) throws DevFailed {
        String[] stringArray = new String[6 * dbDevExportInfoArray.length];
        for (int i = 0; i < dbDevExportInfoArray.length; ++i) {
            String[] stringArray2 = dbDevExportInfoArray[i].toStringArray();
            for (int j = 0; j < 6; ++j) {
                stringArray[6 * i + j] = new String(stringArray2[j]);
            }
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbExportServer", deviceData);
    }

    public void unexport_server(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbUnExportServer", deviceData);
    }

    private String[] dbdatum2StringArray(String string, DbDatum[] dbDatumArray) {
        int n = 2;
        for (int i = 0; i < dbDatumArray.length; ++i) {
            n += 2;
            n += dbDatumArray[i].size();
        }
        String[] stringArray = new String[n];
        stringArray[0] = string;
        stringArray[1] = String.valueOf(dbDatumArray.length);
        int n2 = 2;
        for (int i = 0; i < dbDatumArray.length; ++i) {
            String[] stringArray2 = dbDatumArray[i].toStringArray();
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray[n2++] = stringArray2[j];
            }
        }
        return stringArray;
    }

    private String[] dbdatum2StringArray(String string, String string2, DbDatum[] dbDatumArray) {
        int n = 4;
        for (int i = 0; i < dbDatumArray.length; ++i) {
            n += 2;
            n += dbDatumArray[i].size();
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        stringArray[n2++] = string;
        stringArray[n2++] = "1";
        stringArray[n2++] = string2;
        stringArray[n2++] = String.valueOf(dbDatumArray.length);
        int n3 = n2;
        for (int i = 0; i < dbDatumArray.length; ++i) {
            String[] stringArray2 = dbDatumArray[i].toStringArray();
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray[n3++] = stringArray2[j];
            }
        }
        return stringArray;
    }

    private DbDatum[] stringArray2DbDatum(String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        DbDatum[] dbDatumArray = new DbDatum[n];
        int n2 = 2;
        int n3 = 0;
        while (n2 < stringArray.length - 1) {
            int n4 = Integer.parseInt(stringArray[n2 + 1]);
            int n5 = n2 + 2;
            int n6 = n2 + 2 + n4;
            if (n4 > 0) {
                dbDatumArray[n3++] = new DbDatum(stringArray[n2], stringArray, n5, n6);
            } else {
                String string;
                dbDatumArray[n3++] = new DbDatum(stringArray[n2]);
                if (n5 + 1 < stringArray.length && ((string = stringArray[n5]).length() == 0 || string.equals(" "))) {
                    n6 = n5 + 1;
                }
            }
            n2 = n6;
        }
        return dbDatumArray;
    }

    private DbDatum[] get_obj_property(String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = new String[dbDatumArray.length];
        for (int i = 0; i < dbDatumArray.length; ++i) {
            stringArray[i] = dbDatumArray[i].name;
        }
        return this.get_obj_property(string, string2, stringArray);
    }

    private DbDatum get_obj_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        DbDatum[] dbDatumArray = this.get_obj_property(string, string2, stringArray);
        return dbDatumArray[0];
    }

    private DbDatum[] get_obj_property(String string, String string2, String[] stringArray) throws DevFailed {
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        for (int i = 1; i < stringArray.length + 1; ++i) {
            stringArray2[i] = stringArray[i - 1];
        }
        String string3 = new String("DbGet" + string2 + "Property");
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        DeviceData deviceData2 = this.command_inout(string3, deviceData);
        String[] stringArray3 = deviceData2.extractStringArray();
        return this.stringArray2DbDatum(stringArray3);
    }

    private void delete_obj_property(String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = new String[dbDatumArray.length];
        for (int i = 0; i < dbDatumArray.length; ++i) {
            stringArray[i] = dbDatumArray[i].name;
        }
        this.delete_obj_property(string, string2, stringArray);
    }

    private void delete_obj_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_obj_property(string, string2, stringArray);
    }

    private void delete_obj_property(String string, String string2, String[] stringArray) throws DevFailed {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        String string3 = new String("DbDelete" + string2 + "Property");
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout(string3, deviceData);
    }

    public String[] get_object_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetObjectList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_object_property_list(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout("DbGetPropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDatum[] get_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_property(String string, String string2) throws DevFailed {
        String string3 = "";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutProperty", deviceData);
    }

    public void delete_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_property(String string, String string2) throws DevFailed {
        String string3 = "";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public String[] get_class_property_list(String string, String string2) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetClassPropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_property_list(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        DeviceData deviceData2 = this.command_inout("DbGetDevicePropertyList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDatum[] get_device_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_device_property(String string, String string2) throws DevFailed {
        String string3 = "Device";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutDeviceProperty", deviceData);
    }

    public void delete_device_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_device_property(String string, String string2) throws DevFailed {
        String string3 = "Device";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public DbAttribute[] get_device_attribute_property(String string, String[] stringArray) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        DeviceData deviceData2 = null;
        int n = 2;
        try {
            deviceData.insert(ApiUtil.toStringArray(string, stringArray));
            deviceData2 = this.command_inout("DbGetDeviceAttributeProperty2", deviceData);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData2 = this.command_inout("DbGetDeviceAttributeProperty", deviceData);
                n = 1;
            }
            throw devFailed;
        }
        return ApiUtil.toDbAttributeArray(deviceData2.extractStringArray(), n);
    }

    public DbAttribute get_device_attribute_property(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string2};
        return this.get_device_attribute_property(string, stringArray)[0];
    }

    public void put_device_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        try {
            deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 2));
            this.command_inout("DbPutDeviceAttributeProperty2", deviceData);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 1));
                this.command_inout("DbPutDeviceAttributeProperty", deviceData);
            }
            throw devFailed;
        }
    }

    public void put_device_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{dbAttribute};
        this.put_device_attribute_property(string, dbAttributeArray);
    }

    public void delete_device_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        this.delete_device_attribute_property(string, dbAttribute.name, dbAttribute.get_property_list());
    }

    public void delete_device_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        for (int i = 0; i < dbAttributeArray.length; ++i) {
            this.delete_device_attribute_property(string, dbAttributeArray[i].name, dbAttributeArray[i].get_property_list());
        }
    }

    public void delete_device_attribute_property(String string, String string2, String[] stringArray) throws DevFailed {
        if (stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[2 + stringArray.length];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 2] = stringArray[i];
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout("DbDeleteDeviceAttributeProperty", deviceData);
    }

    public void delete_device_attribute_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_device_attribute_property(string, string2, stringArray);
    }

    public void delete_device_attribute(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbDeleteDeviceAttribute", deviceData);
    }

    public String[] get_class_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetClassList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbDatum[] get_class_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_class_property(String string, String string2) throws DevFailed {
        String string3 = "Class";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutClassProperty", deviceData);
    }

    public void delete_class_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_class_property(String string, String string2) throws DevFailed {
        String string3 = "Class";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public String[] get_class_attribute_list(String string, String string2) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(ApiUtil.toStringArray(string, string2));
        DeviceData deviceData2 = this.command_inout("DbGetClassAttributeList", deviceData);
        return deviceData2.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string2};
        return this.get_class_attribute_property(string, stringArray)[0];
    }

    public DbAttribute[] get_class_attribute_property(String string, String[] stringArray) throws DevFailed {
        DeviceData deviceData;
        DeviceData deviceData2 = new DeviceData();
        int n = 2;
        try {
            deviceData2.insert(ApiUtil.toStringArray(string, stringArray));
            deviceData = this.command_inout("DbGetClassAttributeProperty2", deviceData2);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                deviceData = this.command_inout("DbGetClassAttributeProperty", deviceData2);
                n = 1;
            }
            throw devFailed;
        }
        return ApiUtil.toDbAttributeArray(deviceData.extractStringArray(), n);
    }

    public void put_class_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(ApiUtil.toStringArray(string, dbAttributeArray, 1));
        this.command_inout("DbPutClassAttributeProperty", deviceData);
    }

    public void put_class_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{dbAttribute};
        this.put_class_attribute_property(string, dbAttributeArray);
    }

    public void delete_class_attribute_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_class_attribute_property(string, string2, stringArray);
    }

    public void delete_class_attribute_property(String string, String string2, String[] stringArray) throws DevFailed {
        String[] stringArray2 = new String[2 + stringArray.length];
        stringArray2[0] = string;
        stringArray2[1] = string2;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 2] = stringArray[i];
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray2);
        this.command_inout("DbDeleteClassAttributeProperty", deviceData);
    }

    public String[] get_device_exported(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceExportedList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_exported_for_class(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetExportdDeviceListForClass", deviceData);
        return deviceData2.extractStringArray();
    }

    public String[] get_device_alias_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceAliasList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String get_device_alias(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetDeviceAlias", deviceData);
        return deviceData2.extractString();
    }

    public String get_alias_device(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetAliasDevice", deviceData);
        return deviceData2.extractString();
    }

    public void put_device_alias(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutDeviceAlias", deviceData);
    }

    public void delete_device_alias(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbDeleteDeviceAlias", deviceData);
    }

    public String[] get_attribute_alias_list(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetAttributeAliasList", deviceData);
        return deviceData2.extractStringArray();
    }

    public String get_attribute_alias(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbGetAttributeAlias", deviceData);
        return deviceData2.extractString();
    }

    public void put_attribute_alias(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        DeviceData deviceData = new DeviceData();
        deviceData.insert(stringArray);
        this.command_inout("DbPutAttributeAlias", deviceData);
    }

    public void delete_attribute_alias(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        this.command_inout("DbDeleteAttributeAlias", deviceData);
    }

    public String[] getDevices(String string) throws DevFailed {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
            ++n;
        }
        if (vector.size() < 3) {
            Except.throw_exception("TangoApi_DeviceNameNotValid", "Device name not valid", "ATangoApi.Database.getDevices()");
        }
        String string2 = (String)vector.elementAt(0);
        String string3 = (String)vector.elementAt(1);
        String string4 = (String)vector.elementAt(2);
        String[] stringArray = this.get_device_domain(string2);
        if (stringArray.length == 0) {
            stringArray = new String[]{string2};
        }
        vector.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.get_device_family(stringArray[i] + "/" + string3);
            if (stringArray2.length == 0) {
                stringArray2 = new String[]{string3};
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3 = this.get_device_member(stringArray[i] + "/" + stringArray2[j] + "/" + string4);
                if (stringArray3.length == 0) {
                    stringArray3 = new String[]{string4};
                }
                for (int k = 0; k < stringArray3.length; ++k) {
                    vector.add(stringArray[i] + "/" + stringArray2[j] + "/" + stringArray3[k]);
                }
            }
        }
        String[] stringArray4 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray4[i] = (String)vector.elementAt(i);
        }
        return stringArray4;
    }

    public DbEventImportInfo import_event(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = this.command_inout("DbImportEvent", deviceData);
        DevVarLongStringArray devVarLongStringArray = deviceData2.extractLongStringArray();
        return new DbEventImportInfo(devVarLongStringArray);
    }
}

