/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.internal.MarkerView;

public class MarkerViewUtil {
    public static final String PATH_ATTRIBUTE = "org.eclipse.ui.views.markers.path";
    public static final String NAME_ATTRIBUTE = "org.eclipse.ui.views.markers.name";

    public static String getViewId(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return "org.eclipse.ui.views.TaskList";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return "org.eclipse.ui.views.ProblemView";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return "org.eclipse.ui.views.BookmarkView";
        }
        return null;
    }

    public static boolean showMarker(IWorkbenchPage page, IMarker marker, boolean showView) {
        boolean returnValue = false;
        try {
            IViewPart view;
            String viewId = MarkerViewUtil.getViewId(marker);
            if (viewId == null) {
                viewId = "org.eclipse.ui.views.ProblemView";
            }
            IViewPart iViewPart = view = showView ? page.showView(viewId) : page.findView(viewId);
            if (view != null) {
                returnValue = MarkerSupportInternalUtilities.showMarker(view, marker);
            }
            if ((viewId = MarkerViewUtil.getLegacyViewId(marker)) != null) {
                if (returnValue) {
                    view = page.findView(viewId);
                } else {
                    IViewPart iViewPart2 = view = showView ? page.showView(viewId) : page.findView(viewId);
                }
            }
            if (view != null && view instanceof MarkerView) {
                StructuredSelection selection = new StructuredSelection((Object)marker);
                MarkerView markerView = (MarkerView)view;
                markerView.setSelection((IStructuredSelection)selection, true);
                returnValue = true;
            }
        }
        catch (CoreException e) {
            Policy.handle(e);
        }
        return returnValue;
    }

    private static String getLegacyViewId(IMarker marker) throws CoreException {
        String viewId = MarkerViewUtil.getViewId(marker);
        if (viewId == null) {
            return null;
        }
        return String.valueOf(viewId) + ".old";
    }
}

