/*
 * Decompiled with CFR 0.152.
 */
package fable.fabric.view;

import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.python.jep.FableJep;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Integrate {
    FableJep jep;
    private int LP_lim;

    public void run(final String dir, final String stem, final int grainno, final int refl, final Float LPLim) {
        Job job = new Job("Integrate"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Integrate stem =" + stem + ", direc =" + dir + ", grainno =" + grainno + ", reflno=" + refl + " ", 100);
                try {
                    Integrate.this.jep = new FableJep();
                    Integrate.this.jep.eval("from Fabric import integrateclass");
                    Integrate.this.jep.eval("integrate = integrateclass.integrate()");
                    Integrate.this.jep.eval("integrate.stem=\"" + stem + "\"");
                    Integrate.this.jep.eval("integrate.reflno=" + refl);
                    Integrate.this.jep.eval("integrate.direc=\"" + dir + "\"");
                    Integrate.this.jep.eval("integrate.grainno=" + grainno);
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((Shell)Display.getDefault().getActiveShell(), (String)e.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError(e.getMessage());
                            }
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(25);
                monitor.subTask("read data now ...");
                try {
                    Integrate.this.jep.eval("integrate.read_data()");
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((Shell)Display.getDefault().getActiveShell(), (String)e.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError(e.getMessage());
                            }
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(25);
                monitor.subTask("running now...");
                try {
                    Integrate.this.jep.eval("integrate.run()");
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((Shell)Display.getDefault().getActiveShell(), (String)e.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError(e.getMessage());
                            }
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(25);
                monitor.subTask("filter(LP_limit=" + LPLim + " )");
                try {
                    Integrate.this.jep.eval("integrate.filter(LP_limit=" + LPLim + " )");
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((Shell)Display.getDefault().getActiveShell(), (String)e.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError(e.getMessage());
                            }
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(25);
                monitor.subTask("saving integration now in " + dir + System.getProperty("file.separator") + stem + "_gr" + grainno + ".hkl");
                try {
                    Integrate.this.jep.eval("integrate.save()");
                }
                catch (JepException e) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            SWTUtils.errMsg((Shell)Display.getDefault().getActiveShell(), (String)e.getMessage());
                            if (FableMessageConsole.console != null) {
                                FableMessageConsole.console.displayError(e.getMessage());
                            }
                        }
                    });
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

