/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import org.jmol.i18n.GT;

public class ImageTyper
extends JPanel {
    private final String[] Choices = new String[]{"JPEG", "PNG", "PPM", "SPT"};
    final String[] Extensions = new String[]{"jpg", "png", "ppm", "spt"};
    private static int def = 0;
    String result = this.Choices[def];
    String extension = this.Extensions[def];
    JSlider qSlider;
    private JComboBox cb;
    JFileChooser fileChooser;

    public ImageTyper(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setBorder(new TitledBorder(GT._("Image Type")));
        this.cb = new JComboBox();
        for (int i = 0; i < this.Choices.length; ++i) {
            this.cb.addItem(this.Choices[i]);
        }
        jPanel.add(this.cb);
        this.cb.setSelectedIndex(def);
        this.cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                ImageTyper.this.result = (String)jComboBox.getSelectedItem();
                if (ImageTyper.this.result.equals("JPEG")) {
                    ImageTyper.this.qSlider.setEnabled(true);
                } else {
                    ImageTyper.this.qSlider.setEnabled(false);
                }
                File file = ImageTyper.this.fileChooser.getSelectedFile();
                if (file != null && file.getName() != null && file.getName().endsWith("." + ImageTyper.this.extension)) {
                    String string = file.getName();
                    string = string.substring(0, string.length() - ImageTyper.this.extension.length());
                    string = string + ImageTyper.this.Extensions[jComboBox.getSelectedIndex()];
                    File file2 = new File(file.getPath(), string);
                    ImageTyper.this.fileChooser.setSelectedFile(file2);
                }
                ImageTyper.this.extension = ImageTyper.this.Extensions[jComboBox.getSelectedIndex()];
            }
        });
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new TitledBorder(GT._("JPEG Quality")));
        this.qSlider = new JSlider(0, 50, 100, 90);
        this.qSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.qSlider.setPaintTicks(true);
        this.qSlider.setMajorTickSpacing(10);
        this.qSlider.setPaintLabels(true);
        this.qSlider.setEnabled(true);
        jPanel2.add((Component)this.qSlider, "South");
        this.add((Component)jPanel2, "South");
    }

    public void memorizeDefaultType() {
        if (this.cb != null && this.cb.getSelectedIndex() >= 0) {
            def = this.cb.getSelectedIndex();
        }
    }

    public String getType() {
        return this.result;
    }

    public String getExtension() {
        return this.extension;
    }

    public int getQuality() {
        return this.qSlider.getValue();
    }
}

