/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainSpotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenIniFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
        this.window = arg0;
    }

    public void run(IAction arg0) {
        if (this.window != null) {
            FileDialog fileDlg = new FileDialog(new Shell(), 4096);
            try {
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null) {
                    activeWindow.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", activeWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening perspective Grainspotter: " + e.getMessage()));
            }
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
            fileDlg.setText("Select an ini file.");
            String fileName = fileDlg.open();
            if (fileName != null) {
                File file;
                if (!fileName.endsWith(".ini")) {
                    fileName = String.valueOf(fileName) + ".ini";
                }
                if ((file = new File(fileName)).exists()) {
                    this.input = SWTUtils.createEditorInput((File)file);
                    String editorId = GrainSpotterInputEditor.getID();
                    try {
                        this.window.getActivePage().openEditor(this.input, editorId);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file: " + e.getMessage()));
                    }
                } else {
                    FableUtils.errMsg((Object)this, (String)("Error opening ini file: " + file.getName()));
                }
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }
}

