/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TacoApi.xdr;

import fr.esrf.TacoApi.TacoConst;
import fr.esrf.TacoApi.xdr.XdrDoubleReadPoint;
import fr.esrf.TacoApi.xdr.XdrFloatReadPoint;
import fr.esrf.TacoApi.xdr.XdrFloatReadPoints;
import fr.esrf.TacoApi.xdr.XdrIntFloat;
import fr.esrf.TacoApi.xdr.XdrLongReadPoint;
import fr.esrf.TacoApi.xdr.XdrLongReadPoints;
import fr.esrf.TacoApi.xdr.XdrStateFloatReadPoint;
import fr.esrf.TacoApi.xdr.XdrStateFloatReadPoints;
import java.io.IOException;
import java.util.Vector;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBoolean;
import org.acplt.oncrpc.XdrBytes;
import org.acplt.oncrpc.XdrDouble;
import org.acplt.oncrpc.XdrDoubles;
import org.acplt.oncrpc.XdrFloat;
import org.acplt.oncrpc.XdrFloats;
import org.acplt.oncrpc.XdrInt;
import org.acplt.oncrpc.XdrLongs;
import org.acplt.oncrpc.XdrOpaque;
import org.acplt.oncrpc.XdrShort;
import org.acplt.oncrpc.XdrShorts;
import org.acplt.oncrpc.XdrString;
import org.acplt.oncrpc.XdrStrings;
import org.acplt.oncrpc.XdrVoid;

public class XdrTacoType
implements TacoConst {
    static final int LONG_NAME_SIZE = 80;
    static final int SHORT_NAME_SIZE = 32;

    public static XdrAble createXdr(int n) throws IOException {
        switch (n) {
            case 0: {
                return new XdrVoid();
            }
            case 1: {
                return new XdrBoolean();
            }
            case 2: 
            case 70: {
                return new XdrShort();
            }
            case 3: 
            case 71: {
                return new XdrInt();
            }
            case 4: {
                return new XdrFloat();
            }
            case 5: {
                return new XdrDouble();
            }
            case 6: {
                return new XdrString();
            }
            case 27: {
                return new XdrIntFloat();
            }
            case 7: {
                return new XdrFloatReadPoint();
            }
            case 8: {
                return new XdrStateFloatReadPoint();
            }
            case 22: {
                return new XdrLongReadPoint();
            }
            case 23: {
                return new XdrDoubleReadPoint();
            }
            case 9: {
                return new XdrBytes();
            }
            case 24: {
                return new XdrStrings();
            }
            case 10: 
            case 72: {
                return new XdrShorts();
            }
            case 11: 
            case 69: {
                return new XdrLongs();
            }
            case 12: {
                return new XdrFloats();
            }
            case 68: {
                return new XdrDoubles();
            }
            case 25: {
                return new XdrFloatReadPoints();
            }
            case 73: {
                return new XdrStateFloatReadPoints();
            }
            case 45: {
                return new XdrLongReadPoints();
            }
            case 47: {
                return new XdrBytes();
            }
        }
        throw new IOException("XdrTacoType.createXdr(" + n + ") : Unsupported type.");
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 0: {
                return "D_VOID_TYPE";
            }
            case 1: {
                return "D_BOOLEAN_TYPE";
            }
            case 70: {
                return "D_USHORT_TYPE";
            }
            case 2: {
                return "D_SHORT_TYPE";
            }
            case 71: {
                return "D_ULONG_TYPE";
            }
            case 3: {
                return "D_LONG_TYPE";
            }
            case 4: {
                return "D_FLOAT_TYPE";
            }
            case 5: {
                return "D_DOUBLE_TYPE";
            }
            case 6: {
                return "D_STRING_TYPE";
            }
            case 27: {
                return "D_INT_FLOAT_TYPE";
            }
            case 7: {
                return "D_FLOAT_READPOINT";
            }
            case 8: {
                return "D_STATE_FLOAT_READPOINT";
            }
            case 22: {
                return "D_LONG_READPOINT";
            }
            case 23: {
                return "D_DOUBLE_READPOINT";
            }
            case 9: {
                return "D_VAR_CHARARR";
            }
            case 24: {
                return "D_VAR_STRINGARR";
            }
            case 72: {
                return "D_VAR_USHORTARR";
            }
            case 10: {
                return "D_VAR_SHORTARR";
            }
            case 69: {
                return "D_VAR_ULONGARR";
            }
            case 11: {
                return "D_VAR_LONGARR";
            }
            case 12: {
                return "D_VAR_FLOATARR";
            }
            case 68: {
                return "D_VAR_DOUBLEARR";
            }
            case 25: {
                return "D_VAR_FRPARR";
            }
            case 73: {
                return "D_VAR_SFRPARR";
            }
            case 45: {
                return "D_VAR_LRPARR";
            }
            case 47: {
                return "D_OPAQUE_TYPE";
            }
        }
        return "TypeCode" + n;
    }

    public static String getStateName(int n) {
        switch (n) {
            case 0: {
                return "DEVUNKNOWN";
            }
            case 1: {
                return "DEVOFF";
            }
            case 2: {
                return "DEVON";
            }
            case 3: {
                return "DEVCLOSE";
            }
            case 4: {
                return "DEVOPEN";
            }
            case 5: {
                return "DEVLOW";
            }
            case 6: {
                return "DEVHIGH";
            }
            case 7: {
                return "DEVINSERTED";
            }
            case 8: {
                return "DEVEXTRACTED";
            }
            case 9: {
                return "DEVMOVING";
            }
            case 10: {
                return "DEVWARMUP";
            }
            case 11: {
                return "DEVINIT";
            }
            case 12: {
                return "DEVSTANDBY";
            }
            case 13: {
                return "DEVSERVICE";
            }
            case 14: {
                return "DEVRUN";
            }
            case 15: {
                return "DEVLOCAL";
            }
            case 16: {
                return "DEVREMOTE";
            }
            case 17: {
                return "DEVAUTOMATIC";
            }
            case 18: {
                return "DEVRAMP";
            }
            case 19: {
                return "DEVTRIPPED";
            }
            case 20: {
                return "DEVHV_ENABLE";
            }
            case 21: {
                return "DEVBEAM_ENABLE";
            }
            case 22: {
                return "DEVBLOCKED";
            }
            case 23: {
                return "DEVFAULT";
            }
            case 24: {
                return "DEVSTARTING";
            }
            case 25: {
                return "DEVSTOPPING";
            }
            case 26: {
                return "DEVSTARTREQUESTED";
            }
            case 27: {
                return "DEVSTOPREQUESTED";
            }
            case 28: {
                return "DEVPOSITIVEENDSTOP";
            }
            case 29: {
                return "DEVNEGATIVEENDSTOP";
            }
            case 30: {
                return "DEVBAKEREQUESTED";
            }
            case 31: {
                return "DEVBAKEING";
            }
            case 32: {
                return "DEVSTOPBAKE";
            }
            case 33: {
                return "DEVFORCEDOPEN";
            }
            case 34: {
                return "DEVFORCEDCLOSE";
            }
            case 35: {
                return "DEVOFFUNAUTHORISED";
            }
            case 36: {
                return "DEVONNOTREGULAR";
            }
            case 37: {
                return "DEVRESETTING";
            }
            case 38: {
                return "DEVFORBIDDEN";
            }
            case 39: {
                return "DEVOPENING";
            }
            case 40: {
                return "DEVCLOSING";
            }
            case 41: {
                return "DEVUNDEFINED";
            }
            case 42: {
                return "DEVCOUNTING";
            }
            case 43: {
                return "STOPPED";
            }
            case 44: {
                return "RUNNING";
            }
            case 45: {
                return "DEVALARM";
            }
            case 46: {
                return "DEVDISABLED";
            }
            case 47: {
                return "DEVSTANDBY_NOT_REACHED";
            }
            case 48: {
                return "DEVON_NOT_REACHED";
            }
        }
        return "StateCode" + n;
    }

    public static String[] toStrArr(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static String opaqueToStr(XdrOpaque xdrOpaque) {
        byte[] byArray = xdrOpaque.opaqueValue();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length && byArray[i] != 0; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }
}

