/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.views.ImageView;
import fable.python.FabioFile;
import fable.python.Sample;
import fable.python.jep.FableJep;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImageUtils {
    public static void Slice2DLine(int _y1, int _z1, int _y2, int _z2, int _width) {
        final int y1 = _y1;
        final int z1 = _z1;
        final int y2 = _y2;
        final int z2 = _z2;
        final int width = _width;
        Job job = new Job("Make 1D Slice"){

            protected IStatus run(IProgressMonitor monitor) {
                final Sample sample = SampleController.getController().getCurrentsample();
                Vector fabioFiles = sample.getFilteredfiles();
                Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
                monitor.beginTask("Make 1D Slice", selectedFiles.size());
                try {
                    FableJep fableJep = new FableJep();
                    final int imageWidth = selectedFiles.size();
                    int lineZLength = Math.abs(z2 - z1);
                    int lineYLength = Math.abs(y2 - y1);
                    final int imageHeight = lineZLength > lineYLength ? lineZLength : lineYLength;
                    float[] sliceImage = new float[imageWidth * imageHeight];
                    int i = 0;
                    while (i < selectedFiles.size()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            float[] line = ImageUtils.SelectLine(((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getImageAsFloat(fableJep), ((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getWidth(), ((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getHeight(), y1, z1, y2, z2, width);
                            int j = 0;
                            while (j < imageHeight) {
                                sliceImage[j * imageWidth + i] = line[j];
                                ++j;
                            }
                        }
                        catch (JepException ex) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)ex);
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    fableJep.getJep().close();
                    final float[] _sliceImage = sliceImage;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ImageView slice2DImageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "200", 1);
                                slice2DImageView.getImage().changeImageRect(new Rectangle(0, 0, imageWidth, imageHeight), _sliceImage, sample.getDirectoryName(), null);
                                slice2DImageView.stopListening();
                                slice2DImageView.setName("Slice 2D " + sample.getDirectoryName());
                            }
                            catch (PartInitException ex) {
                                FableUtils.excMsg((Object)this, (String)"Error opening slice2DImageView", (Throwable)ex);
                            }
                        }
                    });
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)ex);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void Slice2DArea(int _y1, int _z1, int _y2, int _z2) {
        final int y1 = _y1;
        final int z1 = _z1;
        final int y2 = _y2;
        final int z2 = _z2;
        Job job = new Job("Make 2D Slice of Selected Area"){

            protected IStatus run(IProgressMonitor monitor) {
                final Sample sample = SampleController.getController().getCurrentsample();
                Vector fabioFiles = sample.getFilteredfiles();
                Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
                monitor.beginTask("Read " + selectedFiles.size() + " files and select area [" + y1 + "," + z1 + "] to [" + y2 + "," + z2 + "] ...", selectedFiles.size());
                Logger logger = FableLogger.getLogger(ImageUtils.class);
                logger.setLevel(Level.ERROR);
                try {
                    FableJep fableJep = new FableJep();
                    int selectedWidth = Math.abs(y2 - y1);
                    int selectedHeight = Math.abs(z2 - z1);
                    logger.debug((Object)("selected width " + selectedWidth + " height " + selectedHeight));
                    final int imageWidth = selectedFiles.size() * selectedWidth;
                    final int imageHeight = selectedHeight;
                    float[] sliceImage = new float[imageWidth * imageHeight];
                    logger.debug((Object)("image width " + imageWidth + " height " + imageHeight));
                    int i = 0;
                    while (i < selectedFiles.size()) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            monitor.subTask("Reading file " + i + " " + ((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getFileName() + " ...");
                            float[] area = ImageUtils.SelectArea(((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getImageAsFloat(fableJep), ((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getWidth(), ((FabioFile)fabioFiles.elementAt((Integer)selectedFiles.elementAt(i))).getHeight(), y1, z1, y2, z2);
                            int j = 0;
                            while (j < selectedWidth) {
                                int k = 0;
                                while (k < selectedHeight) {
                                    float intensity;
                                    sliceImage[k * imageWidth + i * selectedWidth + j] = intensity = area[k * selectedWidth + j];
                                    ++k;
                                }
                                ++j;
                            }
                        }
                        catch (JepException ex) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)ex);
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    fableJep.getJep().close();
                    final float[] _sliceImage = sliceImage;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ImageView slice2DImageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "200", 1);
                                slice2DImageView.getImage().changeImageRect(new Rectangle(0, 0, imageWidth, imageHeight), _sliceImage, sample.getDirectoryName(), null);
                                slice2DImageView.stopListening();
                                slice2DImageView.setName("Slice 2D " + sample.getDirectoryName());
                            }
                            catch (PartInitException ex) {
                                FableUtils.excMsg((Object)this, (String)"Error opening slice2DImageView", (Throwable)ex);
                            }
                        }
                    });
                }
                catch (JepException ex) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error using Jep", (Throwable)ex);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static float[] SelectArea(float[] imageAsFloat, int imageWidth, int imageHeight, int y1, int z1, int y2, int z2) {
        int temp;
        float[] zoomAreaAsFloat = null;
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 > z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= imageWidth) {
            y1 = imageWidth - 1;
        }
        if (y2 <= y1) {
            y2 = y1 + 1;
        }
        if (y2 >= imageWidth) {
            y2 = imageWidth - 1;
        }
        if (z1 < 0) {
            z1 = 0;
        }
        if (z1 >= imageHeight) {
            z1 = imageHeight - 1;
        }
        if (z2 <= z1) {
            z2 = z1 + 1;
        }
        if (z2 >= imageHeight) {
            z2 = imageHeight - 1;
        }
        int zoomWidth = y2 - y1;
        int zoomHeight = z2 - z1;
        zoomAreaAsFloat = new float[zoomWidth * zoomHeight];
        float areaMinimum = Float.MAX_VALUE;
        float areaMaximum = Float.MIN_VALUE;
        float areaSum = 0.0f;
        int i = 0;
        while (i < zoomWidth) {
            int j = 0;
            while (j < zoomHeight) {
                zoomAreaAsFloat[i + j * zoomWidth] = imageAsFloat[y1 + i + (z1 + j) * imageWidth];
                if (zoomAreaAsFloat[i + j * zoomWidth] < areaMinimum) {
                    areaMinimum = zoomAreaAsFloat[i + j * zoomWidth];
                }
                if (zoomAreaAsFloat[i + j * zoomWidth] > areaMaximum) {
                    areaMaximum = zoomAreaAsFloat[i + j * zoomWidth];
                }
                areaSum += zoomAreaAsFloat[i + j * zoomWidth];
                ++j;
            }
            ++i;
        }
        return zoomAreaAsFloat;
    }

    private static float[] SelectLine(float[] imageAsFloat, int imageWidth, int imageHeight, int y1, int z1, int y2, int z2, int lineWidth) {
        float[] line;
        int temp;
        if (Math.abs(y2 - y1) > Math.abs(z2 - z1)) {
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                temp = z1;
                z1 = z2;
                z2 = temp;
            }
        } else if (z1 > z2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y2 < 0) {
            y2 = 0;
        }
        if (y1 >= imageWidth) {
            y1 = imageWidth - 1;
        }
        if (y2 >= imageWidth) {
            y2 = imageWidth - 1;
        }
        if (z1 < 0) {
            z1 = 0;
        }
        if (z2 < 0) {
            z2 = 0;
        }
        if (z1 >= imageHeight) {
            z1 = imageHeight - 1;
        }
        if (z2 >= imageHeight) {
            z2 = imageHeight - 1;
        }
        float slope = 0.0f;
        if (y2 - y1 > z2 - z1) {
            line = new float[y2 - y1];
            if (y2 - y1 != 0) {
                slope = (float)(z2 - z1) / (float)(y2 - y1);
            }
            int i = 0;
            while (i < y2 - y1) {
                int jMax;
                int y = (int)((float)z1 + slope * (float)i);
                int x = y1 + i;
                int jMin = y - (int)((double)lineWidth / 2.0);
                if (jMin < 0) {
                    jMin = 0;
                }
                if ((jMax = y + (int)((double)lineWidth / 2.0) + 1) > imageHeight) {
                    jMax = imageHeight;
                }
                float jWidth = jMax - jMin;
                int j = jMin;
                while (j < jMax) {
                    int n = i;
                    line[n] = line[n] + imageAsFloat[x + j * imageWidth];
                    ++j;
                }
                line[i] = line[i] / jWidth;
                ++i;
            }
        } else {
            line = new float[z2 - z1];
            if (z2 - z1 != 0) {
                slope = (float)(y2 - y1) / (float)(z2 - z1);
            }
            int i = 0;
            while (i < z2 - z1) {
                int jMax;
                int y = (int)((float)y1 + slope * (float)i);
                int x = z1 + i;
                int jMin = y - (int)((double)lineWidth / 2.0);
                if (jMin < 0) {
                    jMin = 0;
                }
                if ((jMax = y + (int)((double)lineWidth / 2.0) + 1) > imageWidth) {
                    jMax = imageWidth;
                }
                float jWidth = jMax - jMin;
                int j = jMin;
                while (j < jMax) {
                    int n = i;
                    line[n] = line[n] + imageAsFloat[j + x * imageWidth];
                    ++j;
                }
                line[i] = line[i] / jWidth;
                ++i;
            }
        }
        return line;
    }
}

