/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.views;

import fable.framework.internal.ICrystalSymmetryVarKeys;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.ui.dialog.CrystalSymmetryDialog;
import fable.framework.ui.views.JmolView;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.actions.RunAction;
import fable.polyxsim.actions.SaveInputFileAction;
import fable.polyxsim.event.PolyxsimEvent;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.internal.PolyXSim;
import fable.polyxsim.internal.PolyXSimException;
import fable.polyxsim.listener.IPolyxsimEventListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import jep.JepException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;

public class PolyXSimInputView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.polyxsim.views.polyxsiminputview";
    private static Composite parent;
    private static Shell shell;
    public static PolyXSimInputView view;
    private FloatText wavelength;
    private FloatText beamflux;
    private FloatText beampol_factor;
    private FloatText beampol_direct;
    private FloatText detz_center;
    private FloatText dety_center;
    private FloatText z_size;
    private FloatText y_size;
    private FloatText dety_size;
    private FloatText detz_size;
    private FloatText distance;
    private FloatText tilt_x;
    private FloatText tilt_y;
    private FloatText tilt_z;
    private Combo omegaDirectionCombo;
    private FloatText wedge;
    private FloatText omega_start;
    private FloatText omega_end;
    private FloatText omega_step;
    private IntegerText omega_sign;
    private IntegerText no_grains;
    private Button gen_size_phase_flag;
    private FloatText[] gen_size_phase_x;
    private FloatText[] gen_size_phase_x_min;
    private FloatText[] gen_size_phase_x_max;
    private Button grainOrientationButton;
    private FloatText sample_xyz_X;
    private FloatText sample_xyz_Y;
    private FloatText sample_xyz_Z;
    private FloatText[] unit_cell_phase_a;
    private FloatText[] unit_cell_phase_b;
    private FloatText[] unit_cell_phase_c;
    private FloatText[] unit_cell_phase_alpha;
    private FloatText[] unit_cell_phase_beta;
    private FloatText[] unit_cell_phase_gamma;
    private IntegerText[] sgno_phase;
    private Button[] unitCellSpaceGroupHelpBtn;
    private StringText[] structure_phase = null;
    private Button[] structureFileViewButton = null;
    private FileText inputFileFileText;
    private Button imageFlagButton;
    private StringText imageStemFileText;
    private Combo fileFormatCombo;
    private Button addNoiseButton;
    private FloatText bg;
    private Button psfButton;
    private FloatText psf;
    private Button outputFltButton;
    private Button outputGveButton;
    private Button outputUbiButton;
    private Button outputParButton;
    Group sampleBoxGroup;
    Group sampleCylinderGroup;
    public Text inputFileText;
    private TabFolder tabFolder;
    private TabItem[] tabItem = new TabItem[6];
    private static Composite[] container;
    private ScrolledComposite[] scrolledComposite = new ScrolledComposite[6];
    static Button outputFileBrowseButton;
    GridLayout gridLayout;
    private Combo intensityCombo;
    private Button lorentzFactorButton;
    private Button polarisationButton;
    private Combo peakTypeCombo;
    private FloatText gaussianPeakPixelsFloatText;
    private FloatText gaussianPeakDegreesFloatText;
    private Combo odfTypeCombo;
    private StringText odfFileStringText;
    private Button odfFileBrowseButton;
    private FloatText mosaicityFloatText;
    private FloatText sampleHeightFloatText;
    private FloatText sampleDiameterFloatText;
    private String[] structureFiles = null;
    private Float[] unitCell = null;
    private Button addPhaseButton;
    private Button deletePhaseButton;
    private Group grainSizeGroup;
    private Combo sampleShapeCombo;
    private Combo[] phaseDistributionCombo = null;
    private IntegerText phasesNumIntegerText;
    private int numPhases = 1;
    private Group structureFileGroup;
    private Group unitCellGroup;
    private Button structureFileButton;
    private Button structureCellButton;
    private String inputFileDirectory;
    private Button[] structureFileBrowseButton;
    private IntegerText[] phaseNumGrainsIntegerText;
    private Label[] phaseLabel = null;
    private Integer[] phaseGrains = null;
    private Integer[] phases = null;
    private Float[] phaseGrainSize = null;
    private Float[] phaseGrainMinSize = null;
    private Float[] phaseGrainMaxSize = null;
    static final int FILES_TAB = 0;
    static final int CRYSTAL_TAB = 1;
    static final int SAMPLE_TAB = 2;
    static final int REFLECTIONS_TAB = 3;
    static final int INSTRUMENTAL_TAB = 4;
    static final int DETECTOR_TAB = 5;
    private RunAction runAction;
    private SaveInputFileAction saveInputFileAction;
    private Combo spaceGroupTypeCombo;
    private int spaceGroupType = 0;
    private Combo spaceGroupCombo;
    private int spaceGroup = 1;
    private Spinner spaceGroupSpinner;
    private Image helpImg;
    private Combo orientCombo;
    private static int idxOrientation;
    private static String[] orientNames;
    private static int[][] orientParams;
    final Color light_grey = new Color((Device)Display.getCurrent(), 205, 192, 176);
    private PolyXSim polyXSim = null;
    private PolyxsimListener polyxsimListener;
    private StringText spatial;
    public static final String spaceGroupDesc = "spacegroup:\n\nThe space group ID number is needed to transform a \ndetermined orientation into the fundamental region \n(the unique part of the orientation space). This is \ndone so that the same solution will always have the same \nU matrix, not one of the other possible symmetric \norientations allowed by symmetry. Either the space group\n symbol or the number may equivalently be given, but the \nnumber is used in PolyXSim";
    private static final String CYLINDER = "cylinder";
    private static final String BOX = "box";

    static {
        container = new Composite[6];
        idxOrientation = 0;
        orientNames = new String[]{"-1 0 0 -1", "-1 0 0 1", "1 0 0 -1", "1 0 0 1", "0 -1 1 0", "0 1 -1 0", "0 -1 -1 0", "0 1 1 0"};
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[3] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = -1;
        nArray2[3] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArray3[3] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[3] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[1] = -1;
        nArray5[2] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[1] = 1;
        nArray6[2] = -1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[1] = -1;
        nArray7[2] = -1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[1] = 1;
        nArray8[2] = 1;
        nArrayArray[7] = nArray8;
        orientParams = nArrayArray;
    }

    public void createPartControl(Composite _parent) {
        parent = _parent;
        shell = parent.getShell();
        view = this;
        this.polyXSim = new PolyXSim();
        this.saveInputFileAction = new SaveInputFileAction(){

            @Override
            public void run() {
                PolyXSimInputView.this.setInputValues();
            }
        };
        this.makeActions();
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        this.helpImg = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        this.tabFolder = new TabFolder(parent, 2560);
        this.tabFolder.setLayout((Layout)oneColGridLayout);
        int i = 0;
        while (i < container.length) {
            this.scrolledComposite[i] = new ScrolledComposite((Composite)this.tabFolder, 768);
            PolyXSimInputView.container[i] = new Composite((Composite)this.scrolledComposite[i], 20);
            container[i].setLayout((Layout)oneColGridLayout);
            container[i].setLayoutData((Object)new GridData(4, 4, true, true));
            this.scrolledComposite[i].setContent((Control)container[i]);
            this.scrolledComposite[i].setMinSize(800, 500);
            this.scrolledComposite[i].setExpandHorizontal(true);
            this.scrolledComposite[i].setExpandVertical(true);
            ++i;
        }
        i = 0;
        while (i < this.tabItem.length) {
            this.tabItem[i] = new TabItem(this.tabFolder, 20);
            this.tabItem[i].setControl((Control)this.scrolledComposite[i]);
            ++i;
        }
        this.createFileTab();
        this.createCrystalPhasesTab();
        this.createSampleTab();
        this.createReflectionsTab();
        this.createInstrumentalTab();
        this.createDetectorTab();
        this.setHelpContextIDs();
        this.polyxsimListener = new PolyxsimListener();
        this.polyXSim.addPolyXSimListener(this.polyxsimListener);
    }

    private void makeActions() {
        this.runAction = new RunAction(){

            @Override
            public void run() {
                PolyXSimInputView.this.setInputValues();
                PolyXSimInputView.this.polyXSim.run();
            }
        };
        this.saveInputFileAction = new SaveInputFileAction();
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.polyxsim.actions.RunAction", (IAction)this.runAction);
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.polyxsim.actions.SaveInputFileAction", (IAction)this.saveInputFileAction);
    }

    private void createFileTab() {
        this.tabItem[0].setText("Files");
        Group outputFileGroup = LookAndFeel.getGroup((Composite)container[0], (String)"Output", (int)6, (int)1);
        GridLayout outputFileGroupLayout = new GridLayout();
        outputFileGroupLayout.numColumns = 6;
        outputFileGroupLayout.makeColumnsEqualWidth = true;
        outputFileGroup.setLayout((Layout)outputFileGroupLayout);
        this.imageFlagButton = new Button((Composite)outputFileGroup, 32);
        this.imageFlagButton.setText("Images in format");
        this.imageFlagButton.setToolTipText("Generate images during simulation");
        this.imageFlagButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.fileFormatCombo = new Combo((Composite)outputFileGroup, 8);
        this.fileFormatCombo.setLayoutData((Object)new GridData(16, 16, false, false));
        this.fileFormatCombo.setToolTipText("Image file format");
        this.fileFormatCombo.add("tif");
        this.fileFormatCombo.add("tif16bit");
        this.fileFormatCombo.add("edf");
        this.fileFormatCombo.setText("tif");
        this.outputFltButton = new Button((Composite)outputFileGroup, 32);
        this.outputFltButton.setText("Filtered peaks");
        this.outputFltButton.setToolTipText("Filtered peaks .flt file");
        this.outputFltButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputGveButton = new Button((Composite)outputFileGroup, 32);
        this.outputGveButton.setText("Scattering vectors");
        this.outputGveButton.setToolTipText("Scattering vectors .gve file");
        this.outputGveButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputUbiButton = new Button((Composite)outputFileGroup, 32);
        this.outputUbiButton.setText("Grain orientation");
        this.outputUbiButton.setToolTipText("Grain orientation .ubi file");
        this.outputUbiButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.outputParButton = new Button((Composite)outputFileGroup, 32);
        this.outputParButton.setText("Parameters");
        this.outputParButton.setToolTipText("ImageD11 parameters .par file");
        this.outputParButton.setLayoutData((Object)new GridData(4, 16, true, true));
        this.imageStemFileText = new StringText((Composite)outputFileGroup, 0, "File stem");
        GridData imageStemGridData = new GridData(4, 16, true, true);
        imageStemGridData.horizontalSpan = 5;
        this.imageStemFileText.setLayoutData((Object)imageStemGridData);
        Button imageStemBrowseButton = new Button((Composite)outputFileGroup, 8);
        imageStemBrowseButton.setText("Browse");
        imageStemBrowseButton.setToolTipText("Select or enter the image stem directory file");
        imageStemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                directoryDialog.setText("Select an existing directory or enter a new directory name");
                String file = directoryDialog.open();
                if (file != null) {
                    PolyXSimInputView.this.imageStemFileText.set_Text(file);
                }
            }
        });
        Group inputFileGroup = LookAndFeel.getGroup((Composite)container[0], (String)"Input", (int)3, (int)1);
        this.inputFileFileText = new FileText((Composite)inputFileGroup, 0, "Input file");
        this.inputFileFileText.set_isRequiredField(true);
        this.inputFileFileText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.inputFileFileText.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (PolyXSimInputView.this.inputFileFileText.is_bValide() && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
                    File file = new File(PolyXSimInputView.this.inputFileFileText.getText());
                    if (file.exists()) {
                        try {
                            PolyXSimInputView.this.polyXSim.setInputFileDirectory(file.getPath());
                        }
                        catch (JepException e1) {
                            SWTUtils.errMsg((String)e1.getMessage());
                        }
                    }
                } else if (!(PolyXSimInputView.this.inputFileFileText.is_bValide() || e.keyCode != 13 && e.keyCode != 0x1000050)) {
                    SWTUtils.errMsg((String)("Input file : " + PolyXSimInputView.this.inputFileFileText.getErrorMessage()));
                }
            }
        });
        Button inputFileBrowseButton = new Button((Composite)inputFileGroup, 8);
        inputFileBrowseButton.setText("Browse");
        inputFileBrowseButton.setToolTipText("Select or enter an input parameter file");
        inputFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(new Shell(), 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setText("Select an existing Farfield Simulation input file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    FableMessageConsole.console.displayOut("read farfield simulation input file " + file);
                    try {
                        PolyXSimInputView.this.polyXSim.setInputFileDirectory(fileDlg.getFilterPath());
                    }
                    catch (JepException e) {
                        SWTUtils.errMsg((String)e.getMessage());
                    }
                }
            }
        });
        outputFileBrowseButton = new Button((Composite)inputFileGroup, 8);
        outputFileBrowseButton.setText("Save as");
        outputFileBrowseButton.setToolTipText("Select or enter an output parameter file");
        outputFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(new Shell(), 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                fileDlg.setText("Select an existing Farfield Simulation input file");
                String file = fileDlg.open();
                fileDlg.getFilterPath();
                if (file != null) {
                    FableMessageConsole.console.displayOut("write farfield simulation input file " + file);
                }
            }
        });
        outputFileBrowseButton.setEnabled(false);
        GridData inputFileGridData = new GridData(4, 4, true, true);
        this.inputFileText = new Text(container[0], 2890);
        this.inputFileText.setText("Input file contents will be displayed here ...");
        this.inputFileText.setLayoutData((Object)inputFileGridData);
        this.inputFileText.setEditable(false);
        this.inputFileText.setEnabled(true);
    }

    public void createCrystalPhasesTab() {
        this.tabItem[1].setText("Crystal Phases");
        Group grainGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure phases", (int)3, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.phasesNumIntegerText = new IntegerText((Composite)grainGroup, 8, "Number of phases in sample");
        this.phasesNumIntegerText.setToolTipText("Number of structure phases");
        this.phasesNumIntegerText.set_isRequiredField(true);
        this.phasesNumIntegerText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.phasesNumIntegerText.set_Text(Integer.toString(this.numPhases));
        this.phasesNumIntegerText.setEnabled(false);
        this.addPhaseButton = new Button((Composite)grainGroup, 8);
        this.addPhaseButton.setText("Add phase");
        this.addPhaseButton.setToolTipText("Add new phase");
        this.addPhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PolyXSimInputView polyXSimInputView = PolyXSimInputView.this;
                polyXSimInputView.numPhases = polyXSimInputView.numPhases + 1;
                PolyXSimInputView.this.phasesNumIntegerText.set_Text(Integer.toString(PolyXSimInputView.this.numPhases));
                PolyXSimInputView.this.deletePhaseButton.setEnabled(true);
                PolyXSimInputView.this.createPhaseGrains();
                PolyXSimInputView.this.createStructureFileGroup();
                int i = 0;
                while (i < PolyXSimInputView.this.polyXSim.getNumPhases()) {
                    if (PolyXSimInputView.this.polyXSim.getStructureFile(i) != null && PolyXSimInputView.this.structure_phase != null && PolyXSimInputView.this.structure_phase[i] != null) {
                        PolyXSimInputView.this.structure_phase[i].set_Text(PolyXSimInputView.this.polyXSim.getStructureFile(i));
                    }
                    ++i;
                }
                PolyXSimInputView.this.createUnitCellGroup();
            }
        });
        this.deletePhaseButton = new Button((Composite)grainGroup, 8);
        this.deletePhaseButton.setText("Delete phase");
        this.deletePhaseButton.setToolTipText("Delete last phase");
        if (this.numPhases <= 1) {
            this.deletePhaseButton.setEnabled(false);
        }
        this.deletePhaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (PolyXSimInputView.this.numPhases > 1) {
                    PolyXSimInputView polyXSimInputView = PolyXSimInputView.this;
                    polyXSimInputView.numPhases = polyXSimInputView.numPhases - 1;
                    PolyXSimInputView.this.phasesNumIntegerText.set_Text(Integer.toString(PolyXSimInputView.this.numPhases));
                    PolyXSimInputView.this.createStructureFileGroup();
                    PolyXSimInputView.this.createUnitCellGroup();
                    PolyXSimInputView.this.createPhaseGrains();
                    if (PolyXSimInputView.this.numPhases <= 1) {
                        PolyXSimInputView.this.deletePhaseButton.setEnabled(false);
                    }
                }
            }
        });
        this.structureFileButton = new Button((Composite)grainGroup, 16);
        this.structureFileButton.setText("Read structure from file (cif or pdb)");
        this.structureCellButton = new Button((Composite)grainGroup, 16);
        this.structureCellButton.setText("Choose space group and specify unit cell");
        this.structureFileGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Structure file(s)", (int)3, (int)1);
        this.structureCellButton.setSelection(false);
        this.structureFileButton.setSelection(true);
        new Label((Composite)grainGroup, 0);
        this.gridLayout = (GridLayout)this.structureFileGroup.getLayout();
        this.structureFiles = new String[this.numPhases];
        this.createStructureFileGroup();
        this.structureFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PolyXSimInputView.this.enableGroupStructureFileOrUnitCell();
            }
        });
        this.unitCellGroup = LookAndFeel.getGroup((Composite)container[1], (String)"Unit cell(s)", (int)8, (int)1);
        this.gridLayout = (GridLayout)this.unitCellGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.unitCell = new Float[this.numPhases];
        this.createUnitCellGroup();
        this.structureCellButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PolyXSimInputView.this.enableGroupStructureFileOrUnitCell();
            }
        });
        this.enableGroupStructureFileOrUnitCell();
    }

    private void enableGroupStructureFileOrUnitCell() {
        if (this.structureCellButton.getSelection()) {
            PolyXSimInputView.setEnableGroup(this.structureFileGroup, false);
            PolyXSimInputView.setEnableGroup(this.unitCellGroup, true);
        } else {
            PolyXSimInputView.setEnableGroup(this.structureFileGroup, true);
            PolyXSimInputView.setEnableGroup(this.unitCellGroup, false);
        }
        this.createStructureFileGroup();
        this.createUnitCellGroup();
    }

    private void createStructureFileGroup() {
        this.diposeStructureFileGroup();
        if (this.structureFileButton.getSelection()) {
            this.structure_phase = new StringText[this.numPhases];
            this.structureFileViewButton = new Button[this.numPhases];
            this.structureFileBrowseButton = new Button[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                this.structure_phase[i] = new StringText((Composite)this.structureFileGroup, 0, "Structure file for phase " + i);
                if (i < this.structureFiles.length && this.structureFiles[i] != null) {
                    this.structure_phase[i].set_Text(this.structureFiles[i]);
                }
                this.structure_phase[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.structureFileBrowseButton[i] = new Button((Composite)this.structureFileGroup, 8);
                this.structureFileBrowseButton[i].setText("Browse");
                this.structureFileBrowseButton[i].setToolTipText("Browse structure file");
                this.structureFileBrowseButton[i].setData((Object)i);
                this.structureFileBrowseButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        FileDialog fileDialog = new FileDialog(shell, 4096);
                        fileDialog.setText("Select an existing structure file");
                        String file = fileDialog.open();
                        if (file != null) {
                            ((PolyXSimInputView)PolyXSimInputView.this).structureFiles[iStructureFile.intValue()] = file;
                            PolyXSimInputView.this.structure_phase[iStructureFile].set_Text(file);
                        }
                    }
                });
                this.structureFileViewButton[i] = new Button((Composite)this.structureFileGroup, 8);
                this.structureFileViewButton[i].setText("View");
                this.structureFileViewButton[i].setToolTipText("View 3D structure");
                this.structureFileViewButton[i].setData((Object)i);
                this.structureFileViewButton[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Integer iStructureFile = (Integer)event.widget.getData();
                        String structureFile = PolyXSimInputView.this.structure_phase[iStructureFile].getText();
                        PolyXSimInputView.this.openJmolView(structureFile);
                    }
                });
                ++i;
            }
        }
        this.structureFileGroup.pack();
        container[1].pack();
    }

    private void diposeStructureFileGroup() {
        if (this.structure_phase != null) {
            this.structureFiles = new String[this.numPhases];
            int i = 0;
            while (i < this.structure_phase.length) {
                if (i < this.structureFiles.length && !this.structure_phase[i].isDisposed()) {
                    this.structureFiles[i] = this.structure_phase[i].getText();
                }
                this.structure_phase[i].dispose();
                this.structureFileViewButton[i].dispose();
                this.structureFileBrowseButton[i].dispose();
                ++i;
            }
            this.structure_phase = null;
            this.structureFileViewButton = null;
            this.structureFileViewButton = null;
        }
    }

    private void createUnitCellGroup() {
        this.disposeAllUnitCellWidgets();
        if (this.structureCellButton.getSelection()) {
            this.unit_cell_phase_a = new FloatText[this.numPhases];
            this.unit_cell_phase_b = new FloatText[this.numPhases];
            this.unit_cell_phase_c = new FloatText[this.numPhases];
            this.unit_cell_phase_alpha = new FloatText[this.numPhases];
            this.unit_cell_phase_beta = new FloatText[this.numPhases];
            this.unit_cell_phase_gamma = new FloatText[this.numPhases];
            this.sgno_phase = new IntegerText[this.numPhases];
            this.unitCellSpaceGroupHelpBtn = new Button[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                this.unit_cell_phase_a[i] = new FloatText((Composite)this.unitCellGroup, 0, "a (\u00c5)");
                this.unit_cell_phase_a[i].set_isRequiredField(true);
                this.unit_cell_phase_a[i].setToolTipText("Unit cell a axis in Angstroms");
                this.unit_cell_phase_a[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_b[i] = new FloatText((Composite)this.unitCellGroup, 0, "b (\u00c5)");
                this.unit_cell_phase_b[i].set_isRequiredField(true);
                this.unit_cell_phase_b[i].setToolTipText("Unit cell b axis in Angstroms");
                this.unit_cell_phase_b[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_c[i] = new FloatText((Composite)this.unitCellGroup, 0, "c (\u00c5)");
                this.unit_cell_phase_c[i].set_isRequiredField(true);
                this.unit_cell_phase_c[i].setToolTipText("Unit cell c axis in Angstroms");
                this.unit_cell_phase_c[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_alpha[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b1 (\u00b0)");
                this.unit_cell_phase_alpha[i].set_isRequiredField(true);
                this.unit_cell_phase_alpha[i].setToolTipText("Unit cell alpha angle in degrees");
                this.unit_cell_phase_alpha[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_beta[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b2 (\u00b0)");
                this.unit_cell_phase_beta[i].set_isRequiredField(true);
                this.unit_cell_phase_beta[i].setToolTipText("Unit cell beta angle in degrees");
                this.unit_cell_phase_beta[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unit_cell_phase_gamma[i] = new FloatText((Composite)this.unitCellGroup, 0, "\u03b3 (\u00b0)");
                this.unit_cell_phase_gamma[i].set_isRequiredField(true);
                this.unit_cell_phase_gamma[i].setToolTipText("Unit cell gamma angle in degrees");
                this.unit_cell_phase_gamma[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.sgno_phase[i] = new IntegerText((Composite)this.unitCellGroup, 0, "Space\nGroup", 1, 230);
                this.sgno_phase[i].set_isRequiredField(true);
                this.sgno_phase[i].setToolTipText("Unit cell space group number");
                this.sgno_phase[i].setLayoutData((Object)new GridData(4, 16, true, true));
                this.unitCellSpaceGroupHelpBtn[i] = new Button((Composite)this.unitCellGroup, 0x840000);
                this.unitCellSpaceGroupHelpBtn[i].setImage(this.helpImg);
                final int index = i;
                this.unitCellSpaceGroupHelpBtn[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CrystalSymmetryDialog dialog;
                        int value;
                        int oldValue = 0;
                        String strOldValue = PolyXSimInputView.this.sgno_phase[index].getText();
                        try {
                            oldValue = Integer.valueOf(strOldValue);
                        }
                        catch (Exception exception) {
                            oldValue = 1;
                        }
                        if (oldValue < 1) {
                            oldValue = 1;
                        }
                        if (oldValue > 230) {
                            oldValue = 230;
                        }
                        if ((value = (dialog = new CrystalSymmetryDialog(Display.getDefault().getActiveShell(), oldValue)).open()) != 0) {
                            PolyXSimInputView.this.sgno_phase[index].set_Text(String.valueOf(value));
                        }
                    }
                });
                this.unitCellSpaceGroupHelpBtn[i].setToolTipText("");
                if ((i + 1) * 7 <= this.unitCell.length) {
                    if (this.unitCell[i * 7] != null) {
                        this.unit_cell_phase_a[i].set_Text(Float.toString(this.unitCell[i * 7].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 1] != null) {
                        this.unit_cell_phase_b[i].set_Text(Float.toString(this.unitCell[i * 7 + 1].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 2] != null) {
                        this.unit_cell_phase_c[i].set_Text(Float.toString(this.unitCell[i * 7 + 2].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 3] != null) {
                        this.unit_cell_phase_alpha[i].set_Text(Float.toString(this.unitCell[i * 7 + 3].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 4] != null) {
                        this.unit_cell_phase_beta[i].set_Text(Float.toString(this.unitCell[i * 7 + 4].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 5] != null) {
                        this.unit_cell_phase_gamma[i].set_Text(Float.toString(this.unitCell[i * 7 + 5].floatValue()));
                    }
                    if (this.unitCell[i * 7 + 6] != null) {
                        this.sgno_phase[i].set_Text(Integer.toString(this.unitCell[i * 7 + 6].intValue()));
                    }
                }
                ++i;
            }
        }
        this.unitCellGroup.pack();
        container[1].pack();
    }

    private void disposeAllUnitCellWidgets() {
        if (this.unit_cell_phase_a != null) {
            this.unitCell = new Float[this.numPhases * 7];
            int i = 0;
            while (i < this.unit_cell_phase_a.length) {
                if ((i + 1) * 7 <= this.unitCell.length) {
                    this.unitCell[i * 7] = this.unit_cell_phase_a[i].getValue();
                    this.unitCell[i * 7 + 1] = this.unit_cell_phase_b[i].getValue();
                    this.unitCell[i * 7 + 2] = this.unit_cell_phase_c[i].getValue();
                    this.unitCell[i * 7 + 3] = this.unit_cell_phase_alpha[i].getValue();
                    this.unitCell[i * 7 + 4] = this.unit_cell_phase_beta[i].getValue();
                    this.unitCell[i * 7 + 5] = this.unit_cell_phase_gamma[i].getValue();
                    try {
                        if (this.sgno_phase[i].getText() != null) {
                            this.unitCell[i * 7 + 6] = Float.valueOf(this.sgno_phase[i].getText());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.unit_cell_phase_a[i].dispose();
                this.unit_cell_phase_b[i].dispose();
                this.unit_cell_phase_c[i].dispose();
                this.unit_cell_phase_alpha[i].dispose();
                this.unit_cell_phase_beta[i].dispose();
                this.unit_cell_phase_gamma[i].dispose();
                this.sgno_phase[i].dispose();
                this.unitCellSpaceGroupHelpBtn[i].dispose();
                ++i;
            }
            this.unit_cell_phase_a = null;
            this.unit_cell_phase_b = null;
            this.unit_cell_phase_c = null;
            this.unit_cell_phase_alpha = null;
            this.unit_cell_phase_beta = null;
            this.unit_cell_phase_gamma = null;
            this.sgno_phase = null;
            this.unitCellSpaceGroupHelpBtn = null;
        }
    }

    public void createSampleTab() {
        this.tabItem[2].setText("Sample");
        Group sampleGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Sample", (int)2, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Composite sampleShapeComposite = new Composite((Composite)sampleGroup, 0);
        sampleShapeComposite.setLayout((Layout)new GridLayout());
        this.gridLayout = (GridLayout)sampleShapeComposite.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        sampleShapeComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        Label sampleShapeLabel = new Label(sampleShapeComposite, 0);
        sampleShapeLabel.setLayoutData((Object)new GridData(16, 16, true, false));
        sampleShapeLabel.setText("Sample shape");
        this.sampleShapeCombo = new Combo(sampleShapeComposite, 8);
        this.sampleShapeCombo.setLayoutData((Object)new GridData(16, 0x1000000, true, false));
        this.sampleShapeCombo.add("");
        this.sampleShapeCombo.add(CYLINDER);
        this.sampleShapeCombo.add(BOX);
        new Label((Composite)sampleGroup, 0);
        this.sampleBoxGroup = LookAndFeel.getGroup((Composite)sampleGroup, (String)"Box dimensions", (int)3, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.sample_xyz_X = new FloatText((Composite)this.sampleBoxGroup, 0, "X (mm)");
        this.sample_xyz_X.set_isRequiredField(true);
        this.sample_xyz_X.setToolTipText("X sample size in mm");
        this.sample_xyz_X.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sample_xyz_Y = new FloatText((Composite)this.sampleBoxGroup, 0, "Y (mm)");
        this.sample_xyz_Y.set_isRequiredField(true);
        this.sample_xyz_Y.setToolTipText("Y sample size in mm");
        this.sample_xyz_Y.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sample_xyz_Z = new FloatText((Composite)this.sampleBoxGroup, 0, "Z (mm)");
        this.sample_xyz_Z.set_isRequiredField(true);
        this.sample_xyz_Z.setToolTipText("Z sample size in mm");
        this.sample_xyz_Z.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sampleCylinderGroup = LookAndFeel.getGroup((Composite)sampleGroup, (String)"Cylinder dimensions", (int)2, (int)1);
        this.gridLayout = (GridLayout)sampleGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.sampleHeightFloatText = new FloatText((Composite)this.sampleCylinderGroup, 0, "Diameter (mm)");
        this.sampleHeightFloatText.set_isRequiredField(true);
        this.sampleHeightFloatText.setToolTipText("Sample diameter in mm");
        this.sampleHeightFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sampleDiameterFloatText = new FloatText((Composite)this.sampleCylinderGroup, 0, "Height (mm)");
        this.sampleDiameterFloatText.set_isRequiredField(true);
        this.sampleDiameterFloatText.setToolTipText("Sample height in mm");
        this.sampleDiameterFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.sampleShapeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String shape = PolyXSimInputView.this.sampleShapeCombo.getText();
                if (shape.equalsIgnoreCase(PolyXSimInputView.CYLINDER)) {
                    PolyXSimInputView.this.enableSampleShape(false, true);
                } else if (shape.equalsIgnoreCase(PolyXSimInputView.BOX)) {
                    PolyXSimInputView.this.enableSampleShape(true, false);
                } else {
                    PolyXSimInputView.this.enableSampleShape(false, false);
                }
            }
        });
        this.sampleShapeCombo.setText(BOX);
        Group grainGroup = LookAndFeel.getGroup((Composite)container[2], (String)"Grains", (int)3, (int)1);
        this.gridLayout = (GridLayout)grainGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.no_grains = new IntegerText((Composite)grainGroup, 0, "Total number of grains");
        this.no_grains.setToolTipText("Total number of grains");
        this.no_grains.set_isRequiredField(true);
        this.no_grains.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)grainGroup, 0);
        new Label((Composite)grainGroup, 0);
        this.grainSizeGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Size(s)", (int)6, (int)1);
        GridData grainSizeGridData = new GridData(4, 16, true, true);
        grainSizeGridData.horizontalSpan = 4;
        this.grainSizeGroup.setLayoutData((Object)grainSizeGridData);
        this.gen_size_phase_flag = new Button((Composite)this.grainSizeGroup, 32);
        this.gen_size_phase_flag.setText("Generate random size(s)");
        this.gen_size_phase_flag.setToolTipText("Generate grain positions");
        Label dummyLabel6 = new Label((Composite)this.grainSizeGroup, 0);
        GridData dummyLabel6GridData = new GridData(16, 16, true, false);
        dummyLabel6GridData.horizontalSpan = 5;
        dummyLabel6.setLayoutData((Object)dummyLabel6GridData);
        this.createPhaseGrains();
        Group grainOrientationGroup = LookAndFeel.getGroup((Composite)grainGroup, (String)"Orientation(s)", (int)10, (int)1);
        this.gridLayout = (GridLayout)grainOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.grainOrientationButton = new Button((Composite)grainOrientationGroup, 32);
        this.grainOrientationButton.setText("Generate random orientations");
        this.grainOrientationButton.setToolTipText("Generate grain orientations");
        Label dummyLabel5 = new Label((Composite)grainOrientationGroup, 0);
        GridData dummyLabel5GridData = new GridData(16, 16, true, false);
        dummyLabel5GridData.horizontalSpan = 9;
        dummyLabel5.setLayoutData((Object)dummyLabel5GridData);
    }

    private void createPhaseGrains() {
        int i;
        if (this.phaseLabel != null) {
            i = 0;
            while (i < this.phaseLabel.length) {
                this.phaseLabel[i].dispose();
                this.phaseNumGrainsIntegerText[i].dispose();
                this.phaseDistributionCombo[i].dispose();
                this.gen_size_phase_x[i].dispose();
                this.gen_size_phase_x_min[i].dispose();
                this.gen_size_phase_x_max[i].dispose();
                ++i;
            }
        }
        this.phaseLabel = new Label[this.numPhases];
        this.phaseNumGrainsIntegerText = new IntegerText[this.numPhases];
        this.phaseDistributionCombo = new Combo[this.numPhases];
        this.gen_size_phase_x = new FloatText[this.numPhases];
        this.gen_size_phase_x_min = new FloatText[this.numPhases];
        this.gen_size_phase_x_max = new FloatText[this.numPhases];
        i = 0;
        while (i < this.numPhases) {
            this.phaseLabel[i] = new Label((Composite)this.grainSizeGroup, 0);
            this.phaseLabel[i].setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.phaseLabel[i].setText("Phase " + i);
            this.phaseNumGrainsIntegerText[i] = new IntegerText((Composite)this.grainSizeGroup, 0, "Grains");
            this.phaseNumGrainsIntegerText[i].setToolTipText("Number of grains in this phase");
            this.phaseNumGrainsIntegerText[i].set_isRequiredField(true);
            this.phaseNumGrainsIntegerText[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.phaseDistributionCombo[i] = new Combo((Composite)this.grainSizeGroup, 8);
            this.phaseDistributionCombo[i].setLayoutData((Object)new GridData(16, 0x1000000, true, true));
            this.phaseDistributionCombo[i].add("fixed");
            this.phaseDistributionCombo[i].add("lognormal");
            this.phaseDistributionCombo[i].setText("lognormal");
            this.phaseDistributionCombo[i].setToolTipText("Grain size distribution");
            this.gen_size_phase_x[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Median");
            this.gen_size_phase_x[i].setToolTipText("Median grain size for log normal distribution");
            this.gen_size_phase_x[i].set_isRequiredField(true);
            this.gen_size_phase_x[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_min[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Min");
            this.gen_size_phase_x_min[i].setToolTipText("Minimum grain cutoff size");
            this.gen_size_phase_x_min[i].set_isRequiredField(true);
            this.gen_size_phase_x_min[i].setLayoutData((Object)new GridData(4, 16, true, true));
            this.gen_size_phase_x_max[i] = new FloatText((Composite)this.grainSizeGroup, 0, "Max");
            this.gen_size_phase_x_max[i].setToolTipText("Maximum grain cutoff size");
            this.gen_size_phase_x_max[i].set_isRequiredField(true);
            this.gen_size_phase_x_max[i].setLayoutData((Object)new GridData(4, 16, true, true));
            ++i;
        }
        this.grainSizeGroup.pack();
        container[2].pack();
    }

    public void createReflectionsTab() {
        this.tabItem[3].setText("Reflections");
        Group reflectionGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Reflection intensities", (int)5, (int)1);
        this.gridLayout = (GridLayout)reflectionGroup.getLayout();
        this.gridLayout.numColumns = 5;
        this.gridLayout.makeColumnsEqualWidth = true;
        reflectionGroup.setLayout((Layout)this.gridLayout);
        Label intensityLabel = new Label((Composite)reflectionGroup, 0x1000000);
        intensityLabel.setText("Intensity");
        intensityLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.intensityCombo = new Combo((Composite)reflectionGroup, 8);
        this.intensityCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        this.intensityCombo.add("constant");
        this.intensityCombo.add("structure factors");
        this.intensityCombo.setText("structure factors");
        FloatText intensityConstantFloatText = new FloatText((Composite)reflectionGroup, 0, "constant");
        intensityConstantFloatText.setLayoutData((Object)new GridData(16, 16, true, false));
        this.lorentzFactorButton = new Button((Composite)reflectionGroup, 32);
        this.lorentzFactorButton.setText("Apply Lorentz factor");
        this.lorentzFactorButton.setLayoutData((Object)new GridData(16, 16, true, false));
        this.polarisationButton = new Button((Composite)reflectionGroup, 32);
        this.polarisationButton.setText("Apply beam polarisation");
        this.polarisationButton.setLayoutData((Object)new GridData(16, 16, true, false));
        Group diffractionPeaksGroup = LookAndFeel.getGroup((Composite)container[3], (String)"Diffraction peaks", (int)2, (int)1);
        this.gridLayout = (GridLayout)diffractionPeaksGroup.getLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        diffractionPeaksGroup.setLayout((Layout)this.gridLayout);
        new Label((Composite)diffractionPeaksGroup, 0);
        Composite peakTypeComposite = new Composite((Composite)diffractionPeaksGroup, 0);
        this.gridLayout = new GridLayout();
        this.gridLayout.numColumns = 2;
        this.gridLayout.makeColumnsEqualWidth = true;
        peakTypeComposite.setLayout((Layout)this.gridLayout);
        Label peakTypeLabel = new Label(peakTypeComposite, 0x1000000);
        peakTypeLabel.setText("Peak type");
        peakTypeLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.peakTypeCombo = new Combo(peakTypeComposite, 8);
        this.peakTypeCombo.setLayoutData((Object)new GridData(16, 16, true, false));
        this.peakTypeCombo.add("spike 2x2 square");
        this.peakTypeCombo.add("Gaussian");
        this.peakTypeCombo.add("ODF");
        this.peakTypeCombo.setText("spike 2x2 square");
        Group guassianPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Gaussian peak parameters", (int)2, (int)1);
        guassianPeakGroup.setLayoutData((Object)new GridData(16, 16, true, false));
        this.gaussianPeakPixelsFloatText = new FloatText((Composite)guassianPeakGroup, 0, "FWHM (pixels)");
        this.gaussianPeakPixelsFloatText.set_isRequiredField(true);
        this.gaussianPeakPixelsFloatText.setToolTipText("Guassian peak spread in pixels");
        this.gaussianPeakPixelsFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.gaussianPeakDegreesFloatText = new FloatText((Composite)guassianPeakGroup, 0, "FWHM in \u03c9-direction (deg)");
        this.gaussianPeakDegreesFloatText.set_isRequiredField(true);
        this.gaussianPeakDegreesFloatText.setToolTipText("Guassian peak spread in degrees");
        this.gaussianPeakDegreesFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
        Group odfPeakGroup = LookAndFeel.getGroup((Composite)diffractionPeaksGroup, (String)"Orientation distribution function", (int)3, (int)1);
        odfPeakGroup.setLayoutData((Object)new GridData(4, 16, true, false));
        this.odfTypeCombo = new Combo((Composite)odfPeakGroup, 8);
        this.odfTypeCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        this.odfTypeCombo.add("isotropic Gaussian");
        this.odfTypeCombo.add("grid from file");
        this.odfTypeCombo.setText("isotropic Gaussian");
        this.odfTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String odfFunction = PolyXSimInputView.this.odfTypeCombo.getText();
                if (odfFunction.contains("Gaussian")) {
                    PolyXSimInputView.this.odfFileStringText.setEnabled(false);
                    PolyXSimInputView.this.odfFileBrowseButton.setEnabled(false);
                    PolyXSimInputView.this.mosaicityFloatText.setEnabled(true);
                } else {
                    PolyXSimInputView.this.odfFileStringText.setEnabled(true);
                    PolyXSimInputView.this.odfFileBrowseButton.setEnabled(true);
                    PolyXSimInputView.this.mosaicityFloatText.setEnabled(false);
                }
            }
        });
        this.odfFileStringText = new StringText((Composite)odfPeakGroup, 0, "ODF file");
        this.odfFileStringText.set_isRequiredField(true);
        this.odfFileStringText.setToolTipText("ODF file grid");
        this.odfFileStringText.setLayoutData((Object)new GridData(4, 16, true, true));
        this.odfFileBrowseButton = new Button((Composite)odfPeakGroup, 8);
        this.odfFileBrowseButton.setText("Browse");
        this.odfFileBrowseButton.setToolTipText("Browse ODF file");
        this.odfFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(shell, 4096);
                fileDialog.setText("Select an existing structure file");
                String file = fileDialog.open();
                if (file != null) {
                    PolyXSimInputView.this.odfFileStringText.set_Text(file);
                }
            }
        });
        this.odfFileStringText.setEnabled(false);
        this.odfFileBrowseButton.setEnabled(false);
        new Label((Composite)odfPeakGroup, 0);
        this.mosaicityFloatText = new FloatText((Composite)odfPeakGroup, 0, "Mosaicity (degrees)");
        this.mosaicityFloatText.set_isRequiredField(true);
        this.mosaicityFloatText.setToolTipText("Mosaicity in degrees");
        this.mosaicityFloatText.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createInstrumentalTab() {
        this.tabItem[4].setText("Instrumental");
        Group beamGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam", (int)4, (int)1);
        Label wavelengthLabel = new Label((Composite)beamGroup, 0);
        wavelengthLabel.setText("Wavelength (angstrom)");
        this.wavelength = new FloatText((Composite)beamGroup, 0, "");
        this.wavelength.set_isRequiredField(true);
        this.wavelength.setToolTipText("wavelength in Angstrom");
        this.wavelength.setLayoutData((Object)new GridData(4, 16, true, true));
        Label fluxLabel = new Label((Composite)beamGroup, 0);
        fluxLabel.setText("Flux (ph/s/mm2)");
        this.beamflux = new FloatText((Composite)beamGroup, 0, "");
        this.beamflux.set_isRequiredField(true);
        this.beamflux.setLayoutData((Object)new GridData(4, 16, true, true));
        Label polarisationFactorLabel = new Label((Composite)beamGroup, 0);
        polarisationFactorLabel.setText("Polarisation factor (percent)");
        this.beampol_factor = new FloatText((Composite)beamGroup, 0, "");
        this.beampol_factor.set_isRequiredField(true);
        this.beampol_factor.setToolTipText("polarisation factor in percent");
        this.beampol_factor.setLayoutData((Object)new GridData(4, 16, true, true));
        Label polarisationDirectionLabel = new Label((Composite)beamGroup, 0);
        polarisationDirectionLabel.setText("Polarisation direction (degrees)");
        this.beampol_direct = new FloatText((Composite)beamGroup, 0, "");
        this.beampol_direct.set_isRequiredField(true);
        this.beampol_direct.setToolTipText("polarisation direction in degrees");
        this.beampol_direct.setLayoutData((Object)new GridData(4, 16, true, true));
        Group beamCenterGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Beam center on detector", (int)4, (int)1);
        Label beamCenterYLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterYLabel.setText("Y beam (pixels)");
        this.dety_center = new FloatText((Composite)beamCenterGroup, 0, "");
        this.dety_center.set_isRequiredField(true);
        this.dety_center.setToolTipText("Y beamcenter in pixel coordinates");
        this.dety_center.setLayoutData((Object)new GridData(4, 16, true, true));
        Label beamCenterZLabel = new Label((Composite)beamCenterGroup, 0);
        beamCenterZLabel.setText("Z beam (pixels)");
        this.detz_center = new FloatText((Composite)beamCenterGroup, 0, "");
        this.detz_center.set_isRequiredField(true);
        this.detz_center.setToolTipText("Z beamcenter in pixel coordinates");
        this.detz_center.setLayoutData((Object)new GridData(4, 16, true, true));
        Group omegaGroup = LookAndFeel.getGroup((Composite)container[4], (String)"Rotation axis", (int)3, (int)2);
        GridLayout gridLayout = (GridLayout)omegaGroup.getLayout();
        gridLayout.makeColumnsEqualWidth = true;
        Label omegaDirectionLabel = new Label((Composite)omegaGroup, 0x1000000);
        omegaDirectionLabel.setText("Direction (+/-)");
        omegaDirectionLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.omegaDirectionCombo = new Combo((Composite)omegaGroup, 8);
        this.omegaDirectionCombo.setLayoutData((Object)new GridData(16, 16, true, true));
        this.omegaDirectionCombo.add("cw");
        this.omegaDirectionCombo.add("ccw");
        this.omegaDirectionCombo.setText("cw");
        this.wedge = new FloatText((Composite)omegaGroup, 0, "Wedge (degrees)");
        this.wedge.set_isRequiredField(true);
        this.wedge.setToolTipText("angle between beam and rotation axis minus 90 in degrees");
        this.wedge.setLayoutData((Object)new GridData(4, 16, true, true));
        this.omega_start = new FloatText((Composite)omegaGroup, 0, "Start (degrees)");
        this.omega_start.set_isRequiredField(true);
        this.omega_start.setToolTipText("minimum rotation angle in degrees");
        this.omega_start.setLayoutData((Object)new GridData(4, 16, true, true));
        this.omega_end = new FloatText((Composite)omegaGroup, 0, "End (degrees)");
        this.omega_end.set_isRequiredField(true);
        this.omega_end.setToolTipText("maximum rotation angle in degrees");
        this.omega_end.setLayoutData((Object)new GridData(4, 16, true, true));
        this.omega_step = new FloatText((Composite)omegaGroup, 0, "Step (degrees)");
        this.omega_step.set_isRequiredField(true);
        this.omega_step.setToolTipText("rotation angle step size in degrees");
        this.omega_step.setLayoutData((Object)new GridData(4, 16, true, true));
    }

    public void createDetectorTab() {
        this.tabItem[5].setText("Detector");
        Composite detectorDistanceComposite = new Composite(container[5], 0);
        GridLayout detectorDistanceLayout = new GridLayout();
        detectorDistanceLayout.numColumns = 2;
        detectorDistanceLayout.makeColumnsEqualWidth = true;
        detectorDistanceComposite.setLayout((Layout)detectorDistanceLayout);
        detectorDistanceComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        this.distance = new FloatText(detectorDistanceComposite, 16384, "Sample to detector distance (mm)");
        this.distance.set_isRequiredField(true);
        this.distance.setToolTipText("sample-detector distance in mm");
        this.distance.setLayoutData((Object)new GridData(16, 16, true, false));
        new Label(detectorDistanceComposite, 0x1000000);
        Composite detectorSizeComposite = new Composite(container[5], 0);
        detectorSizeComposite.setLayout((Layout)detectorDistanceLayout);
        detectorSizeComposite.setLayoutData((Object)new GridData(4, 16, true, false));
        Group detectorSizeGroup = LookAndFeel.getGroup((Composite)detectorSizeComposite, (String)"Detector size", (int)4, (int)1);
        this.gridLayout = (GridLayout)detectorSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label detSizeYLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeYLabel.setText("Y size (pixels)");
        this.dety_size = new FloatText((Composite)detectorSizeGroup, 0, "");
        this.dety_size.set_isRequiredField(true);
        this.dety_size.setToolTipText("Y detector size in pixels");
        this.dety_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Label detSizeZLabel = new Label((Composite)detectorSizeGroup, 0);
        detSizeZLabel.setText("Z size (pixels)");
        this.detz_size = new FloatText((Composite)detectorSizeGroup, 0, "");
        this.detz_size.set_isRequiredField(true);
        this.detz_size.setToolTipText("Z detector size in pixels");
        this.detz_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Group pixelSizeGroup = LookAndFeel.getGroup((Composite)detectorSizeComposite, (String)"Pixel size", (int)4, (int)1);
        this.gridLayout = (GridLayout)pixelSizeGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label pixelSizeYLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeYLabel.setText("Y pixel (mm)");
        this.y_size = new FloatText((Composite)pixelSizeGroup, 0, "");
        this.y_size.set_isRequiredField(true);
        this.y_size.setToolTipText("Y pixel size in mm");
        this.y_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Label pixelSizeZLabel = new Label((Composite)pixelSizeGroup, 0);
        pixelSizeZLabel.setText("Z pixel (mm)");
        this.z_size = new FloatText((Composite)pixelSizeGroup, 0, "");
        this.z_size.set_isRequiredField(true);
        this.z_size.setToolTipText("Z pixel size in mm");
        this.z_size.setLayoutData((Object)new GridData(4, 16, true, true));
        Group detectorTiltGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector tilt", (int)6, (int)1);
        this.gridLayout = (GridLayout)detectorTiltGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label detTiltXLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltXLabel.setText("X tilt (radians)");
        this.tilt_x = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_x.set_isRequiredField(true);
        this.tilt_x.setToolTipText("detector tilt counterclockwise around lab x axis in radians");
        this.tilt_x.setLayoutData((Object)new GridData(4, 16, true, true));
        Label detTiltYLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltYLabel.setText("Y tilt (radians)");
        this.tilt_y = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_y.set_isRequiredField(true);
        this.tilt_y.setToolTipText("detector tilt counterclockwise around lab y axis in radians");
        this.tilt_y.setLayoutData((Object)new GridData(4, 16, true, false));
        Label detTiltZLabel = new Label((Composite)detectorTiltGroup, 0);
        detTiltZLabel.setText("Z tilt (radians)");
        this.tilt_z = new FloatText((Composite)detectorTiltGroup, 0, "");
        this.tilt_z.set_isRequiredField(true);
        this.tilt_z.setToolTipText("Detector tilt counterclockwise around lab z axis in radians");
        this.tilt_z.setLayoutData((Object)new GridData(4, 16, true, true));
        Group detectorOrientationGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector orientation", (int)6, (int)1);
        this.gridLayout = (GridLayout)detectorOrientationGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        Label orientLabel = new Label((Composite)detectorOrientationGroup, 0);
        orientLabel.setText("O parameters");
        this.orientCombo = new Combo((Composite)detectorOrientationGroup, 12);
        String[] items = new String[8];
        int i = 0;
        while (i < 8) {
            items[i] = orientNames[i];
            ++i;
        }
        this.orientCombo.setItems(items);
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.select(0);
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                idxOrientation = PolyXSimInputView.this.orientCombo.getSelectionIndex();
            }
        });
        Group detectorDefectsGroup = LookAndFeel.getGroup((Composite)container[5], (String)"Detector defects", (int)3, (int)1);
        this.gridLayout = (GridLayout)detectorDefectsGroup.getLayout();
        this.gridLayout.makeColumnsEqualWidth = true;
        this.addNoiseButton = new Button((Composite)detectorDefectsGroup, 32);
        this.addNoiseButton.setText("Noise");
        this.addNoiseButton.setToolTipText("Add Poissonian to images during simulation");
        this.addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        new Label((Composite)detectorDefectsGroup, 0);
        new Label((Composite)detectorDefectsGroup, 0);
        this.addNoiseButton = new Button((Composite)detectorDefectsGroup, 32);
        this.addNoiseButton.setText("Background");
        this.addNoiseButton.setToolTipText("Add background to images during simulation");
        this.addNoiseButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.bg = new FloatText((Composite)detectorDefectsGroup, 0, "Counts");
        this.bg.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)detectorDefectsGroup, 0);
        this.psfButton = new Button((Composite)detectorDefectsGroup, 32);
        this.psfButton.setText("Point spread");
        this.psfButton.setToolTipText("Add point spread function to images during simulation");
        this.psfButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.psf = new FloatText((Composite)detectorDefectsGroup, 0, "FWHM (pixels)");
        this.psf.setLayoutData((Object)new GridData(4, 16, true, true));
        new Label((Composite)detectorDefectsGroup, 0);
        Button spatialDistortionButton = new Button((Composite)detectorDefectsGroup, 32);
        spatialDistortionButton.setText("Spatial distortion");
        spatialDistortionButton.setToolTipText("Add spatial distortion to images during simulation");
        spatialDistortionButton.setLayoutData((Object)new GridData(4, 4, false, true));
        this.spatial = new StringText((Composite)detectorDefectsGroup, 0, "Spline file");
        this.spatial.setLayoutData((Object)new GridData(4, 16, true, true));
        Button spatialDistortionBrowseButton = new Button((Composite)detectorDefectsGroup, 0);
        spatialDistortionBrowseButton.setText("Browse");
        spatialDistortionBrowseButton.setLayoutData((Object)new GridData(4, 16, true, false));
    }

    public void setFocus() {
    }

    public void getInputValues() {
        this.wavelength.set_Text(Float.toString(this.polyXSim.getWavelength()));
        this.beamflux.set_Text(Float.toString(this.polyXSim.getFlux().floatValue()));
        this.beampol_factor.set_Text(Float.toString(this.polyXSim.getPolarisationFactor()));
        this.beampol_direct.set_Text(Float.toString(this.polyXSim.getPolarisationDirection()));
        this.dety_center.set_Text(Float.toString(this.polyXSim.getDetyCenter().floatValue()));
        this.detz_center.set_Text(Float.toString(this.polyXSim.getDetzCenter().floatValue()));
        this.y_size.set_Text(Float.toString(this.polyXSim.getYSize().floatValue()));
        this.z_size.set_Text(Float.toString(this.polyXSim.getZSize().floatValue()));
        this.dety_size.set_Text(Float.toString(this.polyXSim.getDetySize().floatValue()));
        this.detz_size.set_Text(Float.toString(this.polyXSim.getDetzSize().floatValue()));
        this.distance.set_Text(Float.toString(this.polyXSim.getDistance().floatValue()));
        this.tilt_x.set_Text(Float.toString(this.polyXSim.getDetTiltX().floatValue()));
        this.tilt_y.set_Text(Float.toString(this.polyXSim.getDetTiltY().floatValue()));
        this.tilt_z.set_Text(Float.toString(this.polyXSim.getDetTiltZ().floatValue()));
        Integer[] detOrientation = this.polyXSim.getDetOrientation();
        if (detOrientation != null && detOrientation.length < 4 && detOrientation.length > 0 && detOrientation[0] != null && detOrientation[1] != null && detOrientation[2] != null && detOrientation[3] != null) {
            idxOrientation = 0;
        }
        boolean match = false;
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 4) {
                match = true;
                if (detOrientation[j] != orientParams[i][j]) {
                    match = false;
                    break;
                }
                ++j;
            }
            if (match) {
                idxOrientation = i;
            }
            ++i;
        }
        this.orientCombo.select(idxOrientation);
        this.wedge.set_Text(Float.toString(this.polyXSim.getWedge()));
        this.omega_start.set_Text(Float.toString(this.polyXSim.getOmegaStart().floatValue()));
        this.omega_end.set_Text(Float.toString(this.polyXSim.getOmegaEnd().floatValue()));
        this.omega_step.set_Text(Float.toString(this.polyXSim.getOmegaStep().floatValue()));
        int omegaSign = this.polyXSim.getOmegaSign();
        if (omegaSign == -1) {
            this.omegaDirectionCombo.select(1);
        } else {
            this.omegaDirectionCombo.select(0);
        }
        this.no_grains.set_Text(Integer.toString(this.polyXSim.getNoGrains()));
        int grainOrientation = this.polyXSim.getGenGrainOrientation();
        this.grainOrientationButton.setSelection(grainOrientation == 1);
        int grainPosition = this.polyXSim.getGenGrainPosition();
        this.gen_size_phase_flag.setSelection(grainPosition == 1);
        this.enableSampleShape(this.polyXSim.getSampleIsCube(), this.polyXSim.getSampleIsCylinder());
        if (this.polyXSim.getSampleIsCube()) {
            Float[] sampleXyz = this.polyXSim.getSampleXyz();
            if (sampleXyz != null) {
                if (sampleXyz[0] != null) {
                    this.sample_xyz_X.set_Text(Float.toString(sampleXyz[0].floatValue()));
                }
                if (sampleXyz[1] != null) {
                    this.sample_xyz_Y.set_Text(Float.toString(sampleXyz[1].floatValue()));
                }
                if (sampleXyz[2] != null) {
                    this.sample_xyz_Z.set_Text(Float.toString(sampleXyz[2].floatValue()));
                }
            }
            this.sampleShapeCombo.setText(BOX);
        } else if (this.polyXSim.getSampleIsCylinder()) {
            Float[] sampleCyl = this.polyXSim.getSampleCyl();
            if (sampleCyl != null) {
                if (sampleCyl[0] != null) {
                    this.sampleHeightFloatText.set_Text(Float.toString(sampleCyl[0].floatValue()));
                }
                if (sampleCyl[1] != null) {
                    this.sampleDiameterFloatText.set_Text(Float.toString(sampleCyl[1].floatValue()));
                }
            }
            this.sampleShapeCombo.setText(CYLINDER);
        }
        this.numPhases = this.polyXSim.getNumPhases();
        this.phasesNumIntegerText.set_Text(Integer.toString(this.numPhases));
        this.phases = this.polyXSim.getPhases();
        this.phaseGrains = this.polyXSim.getPhaseGrains();
        this.phaseGrainSize = this.polyXSim.getPhaseGrainSize();
        this.phaseGrainMinSize = this.polyXSim.getPhaseGrainMinSize();
        this.phaseGrainMaxSize = this.polyXSim.getPhaseGrainMaxSize();
        this.createPhaseGrains();
        if (this.polyXSim.getStructureFile(0) != null) {
            this.structureFileButton.setSelection(true);
            this.structureCellButton.setSelection(false);
        } else {
            this.structureFileButton.setSelection(false);
            this.structureCellButton.setSelection(true);
        }
        this.createStructureFileGroup();
        this.createUnitCellGroup();
        this.enableGroupStructureFileOrUnitCell();
        this.unitCell = new Float[this.numPhases * 7];
        int i2 = 0;
        while (i2 < this.polyXSim.getNumPhases()) {
            this.unitCell[i2 * 7] = this.polyXSim.getUnitCellA()[i2];
            this.unitCell[i2 * 7 + 1] = this.polyXSim.getUnitCellB()[i2];
            this.unitCell[i2 * 7 + 2] = this.polyXSim.getUnitCellC()[i2];
            this.unitCell[i2 * 7 + 3] = this.polyXSim.getUnitCellAlpha()[i2];
            this.unitCell[i2 * 7 + 4] = this.polyXSim.getUnitCellBeta()[i2];
            this.unitCell[i2 * 7 + 5] = this.polyXSim.getUnitCellGamma()[i2];
            if (this.polyXSim.getUnitCellSpaceGroup()[i2] != null) {
                this.unitCell[i2 * 7 + 6] = Float.valueOf(this.polyXSim.getUnitCellSpaceGroup()[i2].intValue());
            }
            if (this.structureCellButton.getSelection()) {
                if (this.polyXSim.getUnitCellA() != null && this.polyXSim.getUnitCellA()[i2] != null) {
                    this.unit_cell_phase_a[i2].set_Text(Float.toString(this.polyXSim.getUnitCellA()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellB() != null && this.polyXSim.getUnitCellB()[i2] != null) {
                    this.unit_cell_phase_b[i2].set_Text(Float.toString(this.polyXSim.getUnitCellB()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellC() != null && this.polyXSim.getUnitCellC()[i2] != null) {
                    this.unit_cell_phase_c[i2].set_Text(Float.toString(this.polyXSim.getUnitCellC()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellAlpha() != null && this.polyXSim.getUnitCellAlpha()[i2] != null) {
                    this.unit_cell_phase_alpha[i2].set_Text(Float.toString(this.polyXSim.getUnitCellAlpha()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellBeta() != null && this.polyXSim.getUnitCellBeta()[i2] != null) {
                    this.unit_cell_phase_beta[i2].set_Text(Float.toString(this.polyXSim.getUnitCellBeta()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellGamma() != null && this.polyXSim.getUnitCellGamma()[i2] != null) {
                    this.unit_cell_phase_gamma[i2].set_Text(Float.toString(this.polyXSim.getUnitCellGamma()[i2].floatValue()));
                }
                if (this.polyXSim.getUnitCellSpaceGroup() != null && this.polyXSim.getUnitCellSpaceGroup()[i2] != null) {
                    this.sgno_phase[i2].set_Text(Integer.toString(this.polyXSim.getUnitCellSpaceGroup()[i2]));
                }
            }
            if (this.polyXSim.getStructureFile(i2) != null) {
                this.structureFiles[i2] = this.polyXSim.getStructureFile(i2);
                if (this.structureFileButton.getSelection()) {
                    this.structure_phase[i2].set_Text(this.polyXSim.getStructureFile(i2));
                }
            }
            if (this.phases[i2] != null) {
                this.phaseLabel[i2].setText("Phase " + this.phases[i2]);
            }
            if (this.phaseGrains[i2] != null) {
                this.phaseNumGrainsIntegerText[i2].set_Text(Integer.toString(this.phaseGrains[i2]));
            }
            if (this.phaseGrainSize[i2] != null) {
                if (this.phaseGrainSize[i2].floatValue() < 0.0f) {
                    this.phaseDistributionCombo[i2].setText("fixed");
                } else {
                    this.phaseDistributionCombo[i2].setText("lognormal");
                }
            }
            this.gen_size_phase_x[i2].set_Text(Float.toString(Math.abs(this.phaseGrainSize[i2].floatValue())));
            if (this.phaseGrainMinSize[i2] != null) {
                this.gen_size_phase_x_min[i2].set_Text(Float.toString(this.phaseGrainMinSize[i2].floatValue()));
            }
            if (this.phaseGrainMaxSize[i2] != null) {
                this.gen_size_phase_x_max[i2].set_Text(Float.toString(this.phaseGrainMaxSize[i2].floatValue()));
            }
            ++i2;
        }
        int makeImages = this.polyXSim.getMakeImages();
        this.imageFlagButton.setSelection(makeImages == 1);
        String fileFormat = this.polyXSim.getFormat();
        if (fileFormat.indexOf("edf") >= 0) {
            this.fileFormatCombo.setText("edf");
        } else if (fileFormat.indexOf("tif16") >= 0) {
            this.fileFormatCombo.setText("tif16bit");
        } else {
            this.fileFormatCombo.setText("tif");
        }
        String dirName = this.polyXSim.getOutputDirectory();
        dirName = String.valueOf(dirName) + File.separator + this.polyXSim.getPrefix();
        this.imageStemFileText.set_Text(dirName);
        this.inputFileFileText.set_Text(this.polyXSim.getFileName());
        int noise = this.polyXSim.getNoise();
        this.addNoiseButton.setSelection(noise == 1);
        this.psfButton.setSelection(this.polyXSim.getPsf() > 0);
        this.psf.setText(String.valueOf(this.polyXSim.getPsf()));
        this.peakTypeCombo.select(this.polyXSim.getPeakShape().intValue());
        this.bg.set_Text(Integer.toString(this.polyXSim.getBackground()));
        this.outputFltButton.setSelection(this.polyXSim.getOutputFlt());
        this.outputGveButton.setSelection(this.polyXSim.getOutputGve());
        this.outputUbiButton.setSelection(this.polyXSim.getOutputUbi());
        this.outputParButton.setSelection(this.polyXSim.getOutputPar());
        this.mosaicityFloatText.set_Text(Float.toString(this.polyXSim.getMosaicity()));
        this.beampol_direct.set_Text(Float.toString(this.polyXSim.getPolarisationDirection()));
        this.polarisationButton.setSelection(this.polyXSim.getPolarisation());
        this.lorentzFactorButton.setSelection(this.polyXSim.getLorentzFactor());
        Float[] peakParameters = this.polyXSim.getPeakParameters();
        if (peakParameters[0] != null) {
            this.gaussianPeakPixelsFloatText.set_Text(peakParameters[0].toString());
        }
        if (peakParameters[1] != null) {
            this.gaussianPeakDegreesFloatText.set_Text(peakParameters[1].toString());
        }
        this.spatial.set_Text(this.polyXSim.getSpatial());
    }

    private void enableSampleShape(boolean iscube, boolean iscylindrique) {
        this.sample_xyz_X.set_isRequiredField(iscube);
        this.sample_xyz_Y.set_isRequiredField(iscube);
        this.sample_xyz_Z.set_isRequiredField(iscube);
        this.sampleHeightFloatText.set_isRequiredField(iscylindrique);
        this.sampleDiameterFloatText.set_isRequiredField(iscylindrique);
        PolyXSimInputView.setEnableGroup(this.sampleCylinderGroup, iscylindrique);
        PolyXSimInputView.setEnableGroup(this.sampleBoxGroup, iscube);
    }

    private void openJmolView(String structureFile) {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            if (structureFile.indexOf(":") == -1) {
                structureFile = String.valueOf(this.inputFileDirectory) + File.separator + structureFile;
            }
        } else if (!structureFile.startsWith(File.separator)) {
            structureFile = String.valueOf(this.inputFileDirectory) + File.separator + structureFile;
        }
        if (structureFile != null && new File(structureFile).exists()) {
            try {
                JmolView jmolView = null;
                jmolView = (JmolView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.JmolView", Integer.toString(JmolView.viewCount), 1);
                if (jmolView != null) {
                    jmolView.openFile(structureFile);
                }
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public void setInputValues() {
        this.polyXSim.setWavelength(this.wavelength.getValue().floatValue());
        this.polyXSim.setFlux(this.beamflux.getValue().floatValue());
        this.polyXSim.setPolarisation(this.polarisationButton.getSelection());
        this.polyXSim.setLorentzFactor(this.lorentzFactorButton.getSelection());
        this.polyXSim.setPolarisationFactor(this.beampol_factor.getValue().floatValue());
        this.polyXSim.setPolarisationDirection(this.beampol_direct.getValue().floatValue());
        this.polyXSim.setDetyCenter(this.dety_center.getValue().floatValue());
        this.polyXSim.setDetzCenter(this.detz_center.getValue().floatValue());
        this.polyXSim.setYSize(this.y_size.getValue().floatValue());
        this.polyXSim.setZSize(this.z_size.getValue().floatValue());
        this.polyXSim.setDetySize(this.dety_size.getValue().floatValue());
        this.polyXSim.setDetzSize(this.detz_size.getValue().floatValue());
        this.polyXSim.setDistance(this.distance.getValue().floatValue());
        this.polyXSim.setDetTiltX(this.tilt_x.getValue().floatValue());
        this.polyXSim.setDetTiltY(this.tilt_y.getValue().floatValue());
        this.polyXSim.setDetTiltZ(this.tilt_z.getValue().floatValue());
        Integer[] detOrientation = new Integer[]{orientParams[idxOrientation][0], orientParams[idxOrientation][1], orientParams[idxOrientation][2], orientParams[idxOrientation][3]};
        this.polyXSim.setDetOrientation(detOrientation);
        this.polyXSim.setOmegaStart(this.omega_start.getValue().floatValue());
        this.polyXSim.setOmegaEnd(this.omega_end.getValue().floatValue());
        this.polyXSim.setOmegaStep(this.omega_step.getValue().floatValue());
        this.polyXSim.setNoGrains(Integer.valueOf(this.no_grains.getText()));
        int genGrains = 0;
        if (this.grainOrientationButton.getSelection()) {
            genGrains = 1;
        }
        this.polyXSim.setGenGrainOrientation(genGrains);
        if (this.gen_size_phase_flag.getSelection()) {
            genGrains = 1;
        }
        this.polyXSim.setGenGrainPosition(genGrains);
        if (this.sampleShapeCombo.getText().equalsIgnoreCase(BOX)) {
            Float[] sampleXyz = new Float[]{this.sample_xyz_X.getValue(), this.sample_xyz_Y.getValue(), this.sample_xyz_Z.getValue()};
            this.polyXSim.setSampleXyz(sampleXyz);
            this.polyXSim.setSampleIsCube(true);
            this.polyXSim.setSampleIsCylinder(false);
        } else if (this.sampleShapeCombo.getText().equalsIgnoreCase(CYLINDER)) {
            Float[] sampleCyl = new Float[]{this.sampleHeightFloatText.getValue(), this.sampleDiameterFloatText.getValue()};
            this.polyXSim.setSampleCyl(sampleCyl);
            this.polyXSim.setSampleIsCube(false);
            this.polyXSim.setSampleIsCylinder(true);
        } else {
            this.polyXSim.setSampleShapeNone();
        }
        this.polyXSim.setNumPhases(this.numPhases);
        if (this.structureCellButton.getSelection()) {
            Float[] unitCellA = new Float[this.numPhases];
            Float[] unitCellB = new Float[this.numPhases];
            Float[] unitCellC = new Float[this.numPhases];
            Float[] unitCellAlpha = new Float[this.numPhases];
            Float[] unitCellBeta = new Float[this.numPhases];
            Float[] unitCellGamma = new Float[this.numPhases];
            Integer[] unitCellSpaceGroup = new Integer[this.numPhases];
            int i = 0;
            while (i < this.numPhases) {
                if (this.unit_cell_phase_a[i].getValue() != null) {
                    unitCellA[i] = this.unit_cell_phase_a[i].getValue();
                }
                if (this.unit_cell_phase_b[i].getValue() != null) {
                    unitCellB[i] = this.unit_cell_phase_b[i].getValue();
                }
                if (this.unit_cell_phase_c[i].getValue() != null) {
                    unitCellC[i] = this.unit_cell_phase_c[i].getValue();
                }
                if (this.unit_cell_phase_alpha[i].getValue() != null) {
                    unitCellAlpha[i] = this.unit_cell_phase_alpha[i].getValue();
                }
                if (this.unit_cell_phase_beta[i].getValue() != null) {
                    unitCellBeta[i] = this.unit_cell_phase_beta[i].getValue();
                }
                if (this.unit_cell_phase_gamma[i].getValue() != null) {
                    unitCellGamma[i] = this.unit_cell_phase_gamma[i].getValue();
                }
                if (this.sgno_phase[i].getText() != null) {
                    unitCellSpaceGroup[i] = Integer.valueOf(this.sgno_phase[i].getText());
                }
                ++i;
            }
            this.polyXSim.setUnitCellA(unitCellA);
            this.polyXSim.setUnitCellB(unitCellB);
            this.polyXSim.setUnitCellC(unitCellC);
            this.polyXSim.setUnitCellAlpha(unitCellAlpha);
            this.polyXSim.setUnitCellBeta(unitCellBeta);
            this.polyXSim.setUnitCellGamma(unitCellGamma);
            this.polyXSim.setUnitCellSpaceGroup(unitCellSpaceGroup);
        } else {
            int i = 0;
            while (i < this.numPhases) {
                if (this.structure_phase[i].getValue() != null) {
                    this.polyXSim.setStructureFile(this.structure_phase[i].getValue(), i);
                }
                ++i;
            }
        }
        Float[] medGrainSize = new Float[this.numPhases];
        Float[] minGrainSize = new Float[this.numPhases];
        Float[] maxGrainSize = new Float[this.numPhases];
        int i = 0;
        while (i < this.numPhases) {
            if (this.structure_phase != null && this.structure_phase[i].getValue() != null) {
                this.polyXSim.setStructureFile(this.structure_phase[i].getValue(), i);
            }
            if (this.phaseNumGrainsIntegerText[i].getText() != null && this.phaseNumGrainsIntegerText[i].getText().length() > 0) {
                this.phaseGrains[i] = Integer.valueOf(this.phaseNumGrainsIntegerText[i].getText());
            }
            if (this.gen_size_phase_x[i].getValue() != null) {
                medGrainSize[i] = this.phaseDistributionCombo[i].getText().equals("fixed") ? Float.valueOf(-Math.abs(this.gen_size_phase_x[i].getValue().floatValue())) : Float.valueOf(Math.abs(this.gen_size_phase_x[i].getValue().floatValue()));
            }
            if (this.gen_size_phase_x_min[i].getValue() != null) {
                minGrainSize[i] = this.gen_size_phase_x_min[i].getValue();
            }
            if (this.gen_size_phase_x_max[i].getValue() != null) {
                maxGrainSize[i] = this.gen_size_phase_x_max[i].getValue();
            }
            ++i;
        }
        this.polyXSim.setPhaseGrains(this.phaseGrains);
        this.polyXSim.setPhaseGrainSize(medGrainSize);
        this.polyXSim.setPhaseGrainMinSize(minGrainSize);
        this.polyXSim.setPhaseGrainMaxSize(maxGrainSize);
        int makeImages = 0;
        if (this.imageFlagButton.getSelection()) {
            makeImages = 1;
        }
        this.polyXSim.setMakeImages(makeImages);
        String fileFormat = this.fileFormatCombo.getText();
        this.polyXSim.setFormat("." + fileFormat);
        String dirName = "";
        String fileStem = this.imageStemFileText.getText();
        if (fileStem.lastIndexOf(File.separatorChar) != -1) {
            dirName = fileStem.substring(0, fileStem.lastIndexOf(File.separatorChar));
            fileStem = fileStem.substring(fileStem.lastIndexOf(File.separatorChar) + 1);
        }
        this.polyXSim.setOutputDirectory(dirName);
        this.polyXSim.setPrefix(fileStem);
        int noise = 0;
        if (this.addNoiseButton.getSelection()) {
            noise = 1;
        }
        this.polyXSim.setNoise(noise);
        int psf = 0;
        if (this.psfButton.getSelection()) {
            psf = 1;
        }
        this.polyXSim.setPsf(psf);
        this.polyXSim.setPeakShape(this.peakTypeCombo.getSelectionIndex());
        Float[] peakParameters = new Float[]{this.gaussianPeakPixelsFloatText.getValue(), this.gaussianPeakDegreesFloatText.getValue()};
        this.polyXSim.setPeakParameters(peakParameters);
        this.bg.set_Text(Integer.toString(this.polyXSim.getBackground()));
        this.polyXSim.setBackground(this.bg.getValue().intValue());
        this.polyXSim.setOutputFlt(this.outputFltButton.getSelection());
        this.polyXSim.setOutputGve(this.outputGveButton.getSelection());
        this.polyXSim.setOutputUbi(this.outputUbiButton.getSelection());
        this.polyXSim.setOutputPar(this.outputParButton.getSelection());
        this.polyXSim.setFormat("." + this.fileFormatCombo.getText());
        this.polyXSim.setWedge(this.wedge.getValue().floatValue());
        this.polyXSim.setMosaicity(this.mosaicityFloatText.getValue().floatValue());
    }

    public void loadInputFile(String inputFileName) throws PolyXSimException {
        String name = "polyXSim " + FableUtils.getShortName((String)inputFileName);
        view.setPartName(name);
        view.setTitleToolTip(inputFileName);
        this.inputFileDirectory = inputFileName.substring(0, inputFileName.lastIndexOf(File.separatorChar));
        try {
            this.polyXSim.setInputFileDirectory(this.inputFileDirectory);
        }
        catch (JepException e1) {
            SWTUtils.errMsg((String)e1.getMessage());
        }
        File file = new File(inputFileName);
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String text = null;
                while ((text = reader.readLine()) != null) {
                    contents.append(text).append("\r\n");
                }
            }
            catch (FileNotFoundException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", e.getMessage());
            }
            catch (IOException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", e.getMessage());
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new PolyXSimException(PolyXSimInputView.class.getName(), "loadInputFile", "reader.close():" + e.getMessage());
            }
        }
        this.inputFileText.setText(contents.toString());
        outputFileBrowseButton.setEnabled(false);
        this.inputFileText.pack();
        container[0].pack();
    }

    private static void setEnableGroup(Group group, boolean enable) {
        Control[] children = group.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enable);
            ++i;
        }
        group.setEnabled(enable);
    }

    private void setHelpContextIDs() {
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.tabItem[0].getControl(), "fable.polyXSim.files_tab");
    }

    public void setSpaceGroup(int _spaceGroup) {
        int newspaceGroupType = 0;
        this.spaceGroup = _spaceGroup;
        int i = 0;
        while (i < ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (this.spaceGroup <= ICrystalSymmetryVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupType = i;
                break;
            }
            ++i;
        }
        if (newspaceGroupType != this.spaceGroupType) {
            this.spaceGroupCombo.setItems(ICrystalSymmetryVarKeys.SPACE_GROUPS[newspaceGroupType]);
            this.spaceGroupType = newspaceGroupType;
        }
        this.spaceGroupSpinner.setSelection(this.spaceGroup);
        this.spaceGroupTypeCombo.select(this.spaceGroupType);
        this.spaceGroupCombo.select(this.spaceGroup - ICrystalSymmetryVarKeys.SPACE_GROUP_MINIMUM[this.spaceGroupType]);
    }

    public void dispose() {
        if (!this.helpImg.isDisposed()) {
            this.helpImg.dispose();
        }
        this.disposeAllUnitCellWidgets();
        this.diposeStructureFileGroup();
        this.polyXSim.removePolyXSimListener(this.polyxsimListener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("polyXSim")) {
            String val = (String)event.getNewValue();
            if (val.equals("running")) {
                this.setInputValues();
                this.polyXSim.run();
            } else {
                System.out.println("End of running");
            }
        }
    }

    public PolyXSim getPolyXSim() {
        return this.polyXSim;
    }

    public static String getId() {
        return ID;
    }

    public static void setParent(Composite parent) {
        PolyXSimInputView.parent = parent;
    }

    public static void setShell(Shell shell) {
        PolyXSimInputView.shell = shell;
    }

    public static void setView(PolyXSimInputView view) {
        PolyXSimInputView.view = view;
    }

    public void setWavelength(FloatText wavelength) {
        this.wavelength = wavelength;
    }

    public void setBeamflux(FloatText beamflux) {
        this.beamflux = beamflux;
    }

    public void setBeampol_factor(FloatText beampol_factor) {
        this.beampol_factor = beampol_factor;
    }

    public void setBeampol_direct(FloatText beampol_direct) {
        this.beampol_direct = beampol_direct;
    }

    public void setDetz_center(FloatText detz_center) {
        this.detz_center = detz_center;
    }

    public void setDety_center(FloatText dety_center) {
        this.dety_center = dety_center;
    }

    public void setZ_size(FloatText z_size) {
        this.z_size = z_size;
    }

    public void setY_size(FloatText y_size) {
        this.y_size = y_size;
    }

    public void setDety_size(FloatText dety_size) {
        this.dety_size = dety_size;
    }

    public void setDetz_size(FloatText detz_size) {
        this.detz_size = detz_size;
    }

    public void setDistance(FloatText distance) {
        this.distance = distance;
    }

    public void setTilt_x(FloatText tilt_x) {
        this.tilt_x = tilt_x;
    }

    public void setTilt_y(FloatText tilt_y) {
        this.tilt_y = tilt_y;
    }

    public void setTilt_z(FloatText tilt_z) {
        this.tilt_z = tilt_z;
    }

    public void setOmegaDirectionCombo(Combo omegaDirectionCombo) {
        this.omegaDirectionCombo = omegaDirectionCombo;
    }

    public void setWedge(FloatText wedge) {
        this.wedge = wedge;
    }

    public void setOmega_start(FloatText omega_start) {
        this.omega_start = omega_start;
    }

    public void setOmega_end(FloatText omega_end) {
        this.omega_end = omega_end;
    }

    public void setOmega_step(FloatText omega_step) {
        this.omega_step = omega_step;
    }

    public void setOmega_sign(IntegerText omega_sign) {
        this.omega_sign = omega_sign;
    }

    public void setNo_grains(IntegerText no_grains) {
        this.no_grains = no_grains;
    }

    public void setGen_size_phase_flag(Button gen_size_phase_flag) {
        this.gen_size_phase_flag = gen_size_phase_flag;
    }

    public void setGen_size_phase_x(FloatText[] gen_size_phase_x) {
        this.gen_size_phase_x = gen_size_phase_x;
    }

    public void setGen_size_phase_x_min(FloatText[] gen_size_phase_x_min) {
        this.gen_size_phase_x_min = gen_size_phase_x_min;
    }

    public void setGen_size_phase_x_max(FloatText[] gen_size_phase_x_max) {
        this.gen_size_phase_x_max = gen_size_phase_x_max;
    }

    public void setGrainOrientationButton(Button grainOrientationButton) {
        this.grainOrientationButton = grainOrientationButton;
    }

    public void setSample_xyz_X(FloatText sample_xyz_X) {
        this.sample_xyz_X = sample_xyz_X;
    }

    public void setSample_xyz_Y(FloatText sample_xyz_Y) {
        this.sample_xyz_Y = sample_xyz_Y;
    }

    public void setSample_xyz_Z(FloatText sample_xyz_Z) {
        this.sample_xyz_Z = sample_xyz_Z;
    }

    public void setUnit_cell_phase_a(FloatText[] unit_cell_phase_a) {
        this.unit_cell_phase_a = unit_cell_phase_a;
    }

    public void setUnit_cell_phase_b(FloatText[] unit_cell_phase_b) {
        this.unit_cell_phase_b = unit_cell_phase_b;
    }

    public void setUnit_cell_phase_c(FloatText[] unit_cell_phase_c) {
        this.unit_cell_phase_c = unit_cell_phase_c;
    }

    public void setUnit_cell_phase_alpha(FloatText[] unit_cell_phase_alpha) {
        this.unit_cell_phase_alpha = unit_cell_phase_alpha;
    }

    public void setUnit_cell_phase_beta(FloatText[] unit_cell_phase_beta) {
        this.unit_cell_phase_beta = unit_cell_phase_beta;
    }

    public void setUnit_cell_phase_gamma(FloatText[] unit_cell_phase_gamma) {
        this.unit_cell_phase_gamma = unit_cell_phase_gamma;
    }

    public void setSgno_phase(IntegerText[] sgno_phase) {
        this.sgno_phase = sgno_phase;
    }

    public void setUnitCellSpaceGroupHelpBtn(Button[] unitCellSpaceGroupHelpBtn) {
        this.unitCellSpaceGroupHelpBtn = unitCellSpaceGroupHelpBtn;
    }

    public void setStructure_phase(StringText[] structure_phase) {
        this.structure_phase = structure_phase;
    }

    public void setStructureFileViewButton(Button[] structureFileViewButton) {
        this.structureFileViewButton = structureFileViewButton;
    }

    public void setInputFileFileText(FileText inputFileFileText) {
        this.inputFileFileText = inputFileFileText;
    }

    public void setImageFlagButton(Button imageFlagButton) {
        this.imageFlagButton = imageFlagButton;
    }

    public void setImageStemFileText(StringText imageStemFileText) {
        this.imageStemFileText = imageStemFileText;
    }

    public void setFileFormatCombo(Combo fileFormatCombo) {
        this.fileFormatCombo = fileFormatCombo;
    }

    public void setAddNoiseButton(Button addNoiseButton) {
        this.addNoiseButton = addNoiseButton;
    }

    public void setBg(FloatText bg) {
        this.bg = bg;
    }

    public void setPsfButton(Button psfButton) {
        this.psfButton = psfButton;
    }

    public void setPsf(FloatText psf) {
        this.psf = psf;
    }

    public void setOutputFltButton(Button outputFltButton) {
        this.outputFltButton = outputFltButton;
    }

    public void setOutputGveButton(Button outputGveButton) {
        this.outputGveButton = outputGveButton;
    }

    public void setOutputUbiButton(Button outputUbiButton) {
        this.outputUbiButton = outputUbiButton;
    }

    public void setOutputParButton(Button outputParButton) {
        this.outputParButton = outputParButton;
    }

    public void setSampleBoxGroup(Group sampleBoxGroup) {
        this.sampleBoxGroup = sampleBoxGroup;
    }

    public void setSampleCylinderGroup(Group sampleCylinderGroup) {
        this.sampleCylinderGroup = sampleCylinderGroup;
    }

    public void setInputFileText(Text inputFileText) {
        this.inputFileText = inputFileText;
    }

    public void setTabFolder(TabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public void setTabItem(TabItem[] tabItem) {
        this.tabItem = tabItem;
    }

    public static void setContainer(Composite[] container) {
        PolyXSimInputView.container = container;
    }

    public void setScrolledComposite(ScrolledComposite[] scrolledComposite) {
        this.scrolledComposite = scrolledComposite;
    }

    public static void setOutputFileBrowseButton(Button outputFileBrowseButton) {
        PolyXSimInputView.outputFileBrowseButton = outputFileBrowseButton;
    }

    public void setGridLayout(GridLayout gridLayout) {
        this.gridLayout = gridLayout;
    }

    public void setIntensityCombo(Combo intensityCombo) {
        this.intensityCombo = intensityCombo;
    }

    public void setLorentzFactorButton(Button lorentzFactorButton) {
        this.lorentzFactorButton = lorentzFactorButton;
    }

    public void setPolarisationButton(Button polarisationButton) {
        this.polarisationButton = polarisationButton;
    }

    public void setPeakTypeCombo(Combo peakTypeCombo) {
        this.peakTypeCombo = peakTypeCombo;
    }

    public void setGaussianPeakPixelsFloatText(FloatText gaussianPeakPixelsFloatText) {
        this.gaussianPeakPixelsFloatText = gaussianPeakPixelsFloatText;
    }

    public void setGaussianPeakDegreesFloatText(FloatText gaussianPeakDegreesFloatText) {
        this.gaussianPeakDegreesFloatText = gaussianPeakDegreesFloatText;
    }

    public void setOdfTypeCombo(Combo odfTypeCombo) {
        this.odfTypeCombo = odfTypeCombo;
    }

    public void setOdfFileStringText(StringText odfFileStringText) {
        this.odfFileStringText = odfFileStringText;
    }

    public void setOdfFileBrowseButton(Button odfFileBrowseButton) {
        this.odfFileBrowseButton = odfFileBrowseButton;
    }

    public void setMosaicityFloatText(FloatText mosaicityFloatText) {
        this.mosaicityFloatText = mosaicityFloatText;
    }

    public void setSampleHeightFloatText(FloatText sampleHeightFloatText) {
        this.sampleHeightFloatText = sampleHeightFloatText;
    }

    public void setSampleDiameterFloatText(FloatText sampleDiameterFloatText) {
        this.sampleDiameterFloatText = sampleDiameterFloatText;
    }

    public void setStructureFiles(String[] structureFiles) {
        this.structureFiles = structureFiles;
    }

    public void setUnitCell(Float[] unitCell) {
        this.unitCell = unitCell;
    }

    public void setAddPhaseButton(Button addPhaseButton) {
        this.addPhaseButton = addPhaseButton;
    }

    public void setDeletePhaseButton(Button deletePhaseButton) {
        this.deletePhaseButton = deletePhaseButton;
    }

    public void setGrainSizeGroup(Group grainSizeGroup) {
        this.grainSizeGroup = grainSizeGroup;
    }

    public void setSampleShapeCombo(Combo sampleShapeCombo) {
        this.sampleShapeCombo = sampleShapeCombo;
    }

    public void setPhaseDistributionCombo(Combo[] phaseDistributionCombo) {
        this.phaseDistributionCombo = phaseDistributionCombo;
    }

    public void setPhasesNumIntegerText(IntegerText phasesNumIntegerText) {
        this.phasesNumIntegerText = phasesNumIntegerText;
    }

    public void setNumPhases(int numPhases) {
        this.numPhases = numPhases;
    }

    public void setStructureFileGroup(Group structureFileGroup) {
        this.structureFileGroup = structureFileGroup;
    }

    public void setUnitCellGroup(Group unitCellGroup) {
        this.unitCellGroup = unitCellGroup;
    }

    public void setStructureFileButton(Button structureFileButton) {
        this.structureFileButton = structureFileButton;
    }

    public void setStructureCellButton(Button structureCellButton) {
        this.structureCellButton = structureCellButton;
    }

    public void setInputFileDirectory(String inputFileDirectory) {
        this.inputFileDirectory = inputFileDirectory;
    }

    public void setStructureFileBrowseButton(Button[] structureFileBrowseButton) {
        this.structureFileBrowseButton = structureFileBrowseButton;
    }

    public void setPhaseNumGrainsIntegerText(IntegerText[] phaseNumGrainsIntegerText) {
        this.phaseNumGrainsIntegerText = phaseNumGrainsIntegerText;
    }

    public void setPhaseLabel(Label[] phaseLabel) {
        this.phaseLabel = phaseLabel;
    }

    public void setPhaseGrains(Integer[] phaseGrains) {
        this.phaseGrains = phaseGrains;
    }

    public void setPhases(Integer[] phases) {
        this.phases = phases;
    }

    public void setPhaseGrainSize(Float[] phaseGrainSize) {
        this.phaseGrainSize = phaseGrainSize;
    }

    public void setPhaseGrainMinSize(Float[] phaseGrainMinSize) {
        this.phaseGrainMinSize = phaseGrainMinSize;
    }

    public void setPhaseGrainMaxSize(Float[] phaseGrainMaxSize) {
        this.phaseGrainMaxSize = phaseGrainMaxSize;
    }

    public void setRunAction(RunAction runAction) {
        this.runAction = runAction;
    }

    public void setSaveInputFileAction(SaveInputFileAction saveInputFileAction) {
        this.saveInputFileAction = saveInputFileAction;
    }

    public void setSpaceGroupTypeCombo(Combo spaceGroupTypeCombo) {
        this.spaceGroupTypeCombo = spaceGroupTypeCombo;
    }

    public void setSpaceGroupType(int spaceGroupType) {
        this.spaceGroupType = spaceGroupType;
    }

    public void setSpaceGroupCombo(Combo spaceGroupCombo) {
        this.spaceGroupCombo = spaceGroupCombo;
    }

    public void setSpaceGroupSpinner(Spinner spaceGroupSpinner) {
        this.spaceGroupSpinner = spaceGroupSpinner;
    }

    public void setHelpImg(Image helpImg) {
        this.helpImg = helpImg;
    }

    public void setOrientCombo(Combo orientCombo) {
        this.orientCombo = orientCombo;
    }

    public static void setIdxOrientation(int idxOrientation) {
        PolyXSimInputView.idxOrientation = idxOrientation;
    }

    public static void setOrientNames(String[] orientNames) {
        PolyXSimInputView.orientNames = orientNames;
    }

    public static void setOrientParams(int[][] orientParams) {
        PolyXSimInputView.orientParams = orientParams;
    }

    public void setPolyXSim(PolyXSim polyXSim) {
        this.polyXSim = polyXSim;
    }

    public void setPolyxsimListener(PolyxsimListener polyxsimListener) {
        this.polyxsimListener = polyxsimListener;
    }

    public void setSpatial(StringText spatial) {
        this.spatial = spatial;
    }

    class PolyxsimListener
    implements IPolyxsimEventListener {
        PolyxsimListener() {
        }

        @Override
        public void loadInputFileEvent(PolyxsimEvent event) {
            try {
                PolyXSimInputView.this.loadInputFile(((PolyXSim)event.getSource()).getInputFile());
                PolyXSimInputView.this.getInputValues();
            }
            catch (PolyXSimException e) {
                SWTUtils.errMsg((String)e.getMessage());
            }
        }

        @Override
        public void saveInputFileEvent(PolyxsimEvent event) {
            String newInputfilename = ((PolyXSim)event.getSource()).getInputFile();
            try {
                PolyXSimInputView.this.loadInputFile(newInputfilename);
                PolyXSimInputView.this.getInputValues();
            }
            catch (PolyXSimException e) {
                SWTUtils.errMsg((String)e.getMessage());
            }
        }

        @Override
        public void updateInputFileEvent(PolyxsimEvent event) {
        }
    }
}

