/*
 * Decompiled with CFR 0.152.
 */
package fable.polyxsim.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.polyxsim.editors.InputEditor;
import fable.polyxsim.internal.IVarKeys;
import fable.polyxsim.rcp.Activator;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenInputFileAction
implements IWorkbenchWindowActionDelegate {
    private IEditorInput input;
    private IWorkbenchWindow window;

    public void run(IAction action) {
        this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.window != null) {
            try {
                this.window.getWorkbench().showPerspective("fable.polyxsim.perspective", this.window);
                FileDialog fileDialog = new FileDialog(new Shell(), 0);
                fileDialog.setFilterExtensions(IVarKeys.FILTER_EXTS_INPUT);
                fileDialog.setFilterNames(IVarKeys.FILTER_EXTS_INPUT);
                String initialDirectory = Activator.getInitialDirectory();
                fileDialog.setFilterPath(initialDirectory);
                fileDialog.setText("Select an existing PolyXSim input file or enter a new file name");
                String file = fileDialog.open();
                if (file != null) {
                    initialDirectory = fileDialog.getFilterPath();
                    Activator.setInitialDirectory(initialDirectory);
                    FableMessageConsole.console.displayOut("read polyxsim input file " + file);
                    File theInputFile = new File(file);
                    if (theInputFile.exists()) {
                        this.input = SWTUtils.createEditorInput((File)theInputFile);
                        String editorId = InputEditor.getId();
                        try {
                            this.window.getActivePage().openEditor(this.input, editorId);
                        }
                        catch (PartInitException e) {
                            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening input file: " + e.getMessage()));
                        }
                    } else {
                        FableUtils.errMsg((Object)this, (String)("Error opening ini file: " + theInputFile.getName()));
                    }
                }
            }
            catch (WorkbenchException e) {
                FableUtils.excMsg((Object)this, (String)"Error opening loading PolyXSim input file and opening view", (Throwable)e);
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

