/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.grainspotter.editors.GrainSpotterGveFile3D;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GveFileEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private static final String ID = "fable.grainspotter.editors.GveFileEditor";
    private IPartListener2 partListener;
    private TextEditor textEditor;
    private GrainSpotterGveFile3D plot3D;
    private boolean gVectorsSet;

    public GveFileEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.gVectorsSet = false;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.partListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                System.out.println("GveFileEditor: partActivated");
                IWorkbenchPart part = partRef.getPart(false);
                if (part != GveFileEditor.this) {
                    return;
                }
                System.out.println("  " + this);
                if (GveFileEditor.this.plot3D != null) {
                    GveFileEditor.this.plot3D.reset();
                    System.out.println("  useContext called");
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }
        };
        super.init(site, editorInput);
        this.updateTitle();
        this.getSite().getPage().addPartListener(this.partListener);
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
    }

    void createPage0() {
        System.out.println("GveFileEditor: createPage0");
        this.plot3D = new GrainSpotterGveFile3D(this.getContainer(), 0);
        int index = this.addPage((Control)this.plot3D);
        this.setPageText(index, "3D Plot");
    }

    void createPage1() {
        System.out.println("GveFileEditor: createPage1");
        try {
            this.textEditor = new TextEditor();
            int index = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(index, "Text");
        }
        catch (PartInitException ex) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error creating text editor", (Throwable)ex);
        }
    }

    protected void pageChange(int newPageIndex) {
        System.out.println("GveFileEditor: pageChange to " + newPageIndex);
        super.pageChange(newPageIndex);
        if (newPageIndex == 0 && !this.gVectorsSet) {
            String fileName = this.getFullPath();
            if (this.plot3D != null && fileName != null) {
                this.plot3D.loadGVectors(fileName);
                this.gVectorsSet = true;
            }
        }
    }

    public void dispose() {
        IWorkbenchPartSite site;
        if (this.partListener != null && (site = this.getSite()) != null && this.getSite().getPage() != null) {
            this.getSite().getPage().removePartListener(this.partListener);
            this.partListener = null;
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(1).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = GveFileEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((IFileEditorInput)GveFileEditor.this.textEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(GveFileEditor.this.textEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        } else if (event.getType() == 1) {
            IPath path = null;
            IResourceDelta delta = null;
            IResource res = null;
            if (this.getEditorInput() != null && this.getEditorInput() instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
                path = input.getFile().getFullPath();
            }
            if (path != null) {
                delta = event.getDelta().findMember(path);
            }
            if (delta != null) {
                res = delta.getResource();
            }
            if (res != null) {
                SWTUtils.infoMsgAsync((String)("Got POST_CHANGE [" + delta.getKind() + "] for " + path.toOSString()));
            }
        }
    }

    public String getFullPath() {
        IPath iPath = SWTUtils.getPath((IEditorInput)this.getEditorInput());
        if (iPath == null) {
            FableUtils.errMsg((Object)((Object)this), (String)"Cannot find path for .gve file");
            return null;
        }
        String fileName = iPath.toOSString();
        if (fileName == null) {
            FableUtils.errMsg((Object)((Object)this), (String)".gve file name is null");
            return null;
        }
        return fileName;
    }

    protected void updateTitle() {
        IEditorInput input = this.getEditorInput();
        String name = FableUtils.getShortName((String)input.getName());
        name = name == null ? "GrainSpotter .gve" : name;
        this.setPartName(name);
        this.setTitleToolTip(input.getToolTipText());
    }

    public void setLogFile(String fileName) {
        if (this.plot3D != null) {
            this.plot3D.setLogFile(fileName);
        }
    }

    public static String getID() {
        return ID;
    }

    public GrainSpotterGveFile3D getPlot3D() {
        return this.plot3D;
    }
}

