/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.internal;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.views.FableMessageConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerRepository;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.console.ConsolePlugin;

public class TestMenu {
    private static final String[] actionMethods = new String[]{"createExceptionTestAction", "createLoggingTestAction", "createLoggingLevelTestAction"};

    static MenuManager createTestMenu() {
        MenuManager testMenu = new MenuManager("Test");
        int i = 0;
        while (i < actionMethods.length) {
            try {
                Method method = TestMenu.class.getDeclaredMethod(actionMethods[i], null);
                Action action = (Action)method.invoke(null, null);
                testMenu.add((IAction)action);
            }
            catch (Exception exception) {}
            ++i;
        }
        if (testMenu.getItems().length > 0) {
            return testMenu;
        }
        return null;
    }

    private static Action createConsoleTestAction() {
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println("Exist: FableMessageConsole.console: " + FableMessageConsole.console);
        final FableMessageConsole console1 = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        System.out.println("getConsoles[0]: console1: " + console1);
        final FableMessageConsole console2 = new FableMessageConsole("Console 2");
        System.out.println("Created: console2: " + console2);
        System.out.println("getConsoles().length: " + ConsolePlugin.getDefault().getConsoleManager().getConsoles().length);
        System.out.println();
        Action action = new Action("Test Console"){

            public void run() {
                String msg = "FableMessageConsole: " + FableMessageConsole.console;
                System.out.println(msg);
                FableMessageConsole.console.displayInfo(msg);
                msg = "console1: " + console1;
                System.out.println(msg);
                console1.displayInfo(msg);
                msg = "console2: " + console2;
                System.out.println(msg);
                console2.displayInfo(msg);
            }
        };
        return action;
    }

    private static Action createExceptionTestAction() {
        Action action = new Action("Test Exception Messages"){

            public void run() {
                try {
                    Double.parseDouble("garbage");
                }
                catch (NumberFormatException ex) {
                    FableUtils.excTraceMsg((Object)((Object)this), (String)"This operation has used FableUtils.excTraceMsg", (Throwable)ex);
                    FableUtils.excMsg((Object)((Object)this), (String)"This operation has used FableUtils.excMsg", (Throwable)ex);
                    FableUtils.errMsg(((Object)((Object)this)).getClass(), (String)"This operation has used FableUtils.errMsg");
                    FableUtils.warnMsg(TestMenu.class, (String)"This operation has used FableUtils.warnMsg");
                    FableUtils.infoMsg((Object)"XXX", (String)"This operation has used FableUtils.infoMsg");
                }
            }
        };
        return action;
    }

    private static Action createLoggingTestAction() {
        Action action = new Action("Test Logging"){

            public void run() {
                Logger logger = FableLogger.getLogger();
                System.out.println("\nFableLogger.getLogger()");
                URL url = logger.getClass().getResource("/log4j.properties");
                this.printLoggerInfo(logger);
                System.out.println("Properties URL=" + url);
                System.out.println("  path=" + url.getPath());
                System.out.println("  file=" + url.getFile());
                System.out.println("  protocol=" + url.getProtocol());
                System.out.println("  contents=");
                try {
                    InputStream is = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    System.out.println("-------------------------------------");
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                    }
                    System.out.println("-------------------------------------");
                }
                catch (IOException iOException) {
                    System.err.println("Cannot open input stream for " + url);
                }
                String[] props = new String[]{"log4j.rootLogger", "log4j.appender.default", "log4j.appender.default.layout", "log4j.appender.default.layout.ConversionPattern"};
                int i = 0;
                while (i < props.length) {
                    String val = System.getProperty(props[i], "Not found");
                    System.out.println(String.valueOf(props[i]) + "=" + val);
                    ++i;
                }
                System.out.println("\nTests [5 total messages]");
                logger.trace((Object)"Trace Message");
                logger.debug((Object)"Debug Message");
                logger.info((Object)"Info Message");
                logger.warn((Object)"Warning Message");
                logger.error((Object)"Error Message");
                logger.fatal((Object)"Fatal Message");
                System.out.printf("\nClass Logger (%s)\n", ((Object)((Object)this)).getClass().toString());
                logger = FableLogger.getLogger(((Object)((Object)this)).getClass());
                this.printLoggerInfo(logger);
                System.out.println("\nTests [5 total messages]");
                logger.trace((Object)"Trace Message");
                logger.debug((Object)"Debug Message");
                logger.info((Object)"Info Message");
                logger.warn((Object)"Warning Message");
                logger.error((Object)"Error Message");
                logger.fatal((Object)"Fatal Message");
                logger = Logger.getRootLogger();
                System.out.printf("\nRoot Logger\n", new Object[0]);
                this.printLoggerInfo(logger);
            }

            private void printLoggerInfo(Logger logger) {
                System.out.println("logger=" + logger);
                System.out.println("name=" + logger.getName());
                System.out.println("level=" + logger.getLevel());
                System.out.println("effectiveLevel=" + logger.getEffectiveLevel());
                System.out.println("Appenders for " + logger.getName());
                Enumeration e = logger.getAllAppenders();
                while (e.hasMoreElements()) {
                    Appender appender = (Appender)e.nextElement();
                    System.out.println("  name=" + appender.getName());
                    System.out.println("  class=" + appender.getClass());
                    Layout layout = appender.getLayout();
                    System.out.println("    layout class=" + layout.getClass());
                    System.out.println("    layout content type=" + layout.getContentType());
                    System.out.println("    layout header=" + layout.getHeader());
                    System.out.println("    layout footer=" + layout.getFooter());
                    if (!(layout instanceof PatternLayout)) continue;
                    System.out.println("    layout conversion pattern=" + ((PatternLayout)layout).getConversionPattern());
                }
                System.out.println("Repository");
                LoggerRepository repos = logger.getLoggerRepository();
                System.out.println("threshold=" + repos.getThreshold());
                System.out.println("Current loggers");
                e = repos.getCurrentLoggers();
                while (e.hasMoreElements()) {
                    Logger l = (Logger)e.nextElement();
                    System.out.println("  " + l.getName());
                }
            }
        };
        return action;
    }

    private static Action createLoggingLevelTestAction() {
        Action action = new Action("Test Logging Level"){

            public void run() {
                Logger logger = FableLogger.getLogger();
                System.out.println("\nFableLogger.getLogger()");
                System.out.println("logger=" + logger);
                System.out.println("name=" + logger.getName());
                System.out.println("level=" + logger.getLevel());
                System.out.println("effectiveLevel=" + logger.getEffectiveLevel());
                logger = Logger.getRootLogger();
                System.out.println("\nLogger.getRootLogger()");
                System.out.println("logger=" + logger);
                System.out.println("name=" + logger.getName());
                System.out.println("level=" + logger.getLevel());
                System.out.println("effectiveLevel=" + logger.getEffectiveLevel());
                System.out.println("\nException test");
                try {
                    Double.parseDouble("garbage");
                }
                catch (NumberFormatException ex) {
                    FableLogger.error((Object)"Intentional exception generated", (Throwable)ex);
                }
                System.out.println("\nFable Logger Tests [6 total messages]");
                FableLogger.trace((Object)"Fable Logger Trace Message");
                FableLogger.debug((Object)"Fable Logger Debug Message");
                FableLogger.info((Object)"Fable Logger Info Message");
                FableLogger.warn((Object)"Fable Logger Warning Message");
                FableLogger.error((Object)"Fable Logger Error Message");
                FableLogger.fatal((Object)"Fable Logger Fatal Message");
                System.out.println("\nRoot Logger Tests [6 total messages]");
                logger.trace((Object)"Root Logger Trace Message");
                logger.debug((Object)"Root Logger Debug Message");
                logger.info((Object)"Root Logger Info Message");
                logger.warn((Object)"Root Logger Warning Message");
                logger.error((Object)"Root Logger Error Message");
                logger.fatal((Object)"Root Logger Fatal Message");
            }
        };
        return action;
    }
}

