/*
 * Decompiled with CFR 0.152.
 */
package fable.python.actions;

import fable.framework.toolbox.FableUtils;
import fable.python.jep.FableJep;
import fable.python.rcp.Activator;
import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RecordScriptAction
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.python.actions.recordAction";
    private String fileDirectory;
    String[] filterExtension = new String[]{"*.py", "*.*"};
    String[] filterName = new String[]{"*.py", "All(*.*)"};

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_python_script_path")) {
                    RecordScriptAction.this.fileDirectory = Activator.getDefault().getPreferenceStore().getString("pref_python_script_path");
                }
            }
        };
        this.fileDirectory = Activator.getDefault().getPreferenceStore().getString("pref_python_script_path");
    }

    public void run(IAction action) {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fileDialog.setFilterPath(this.fileDirectory);
        fileDialog.setFilterNames(this.filterName);
        fileDialog.setFilterExtensions(this.filterExtension);
        if (action.isChecked()) {
            String filename = fileDialog.open();
            if (filename != null && this.recordInThisFile(filename)) {
                FableJep.record(true);
                FableJep.setScriptFileName(filename);
                action.setToolTipText("Stop recording python actions.");
            } else {
                action.setChecked(false);
                FableJep.record(false);
                action.setToolTipText("Record python actions in a script.");
            }
        } else {
            FableJep.record(false);
            action.setToolTipText("Record python actions in a script.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static String getID() {
        return ID;
    }

    public boolean recordInThisFile(String filename) {
        File f = new File(filename);
        boolean record = true;
        if (f.exists()) {
            record = FableUtils.confirmMsg((Object)this, (String)(String.valueOf(filename) + " already exists. \nDo you want to add your new records in it ?"));
        }
        return record;
    }
}

