/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import java.io.File;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TreeWithAddRemove
extends Composite {
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;
    private Tree tree;

    public TreeWithAddRemove(Composite parent, int style, String initialItems) {
        super(parent, style);
        if (initialItems == null) {
            initialItems = "";
        }
        final Shell shell = parent.getShell();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.tree = new Tree((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tree);
        this.resetTreeItems(initialItems);
        Composite composite = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)composite);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Button button = new Button(composite, 8);
        button.setText("Add Source Folder");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(shell);
                dialog.setFilterPath(lastDirectoryDialogPath);
                String filePath = dialog.open();
                if (filePath != null) {
                    lastDirectoryDialogPath = filePath;
                }
                TreeWithAddRemove.this.addTreeItem(filePath);
            }
        });
        button = new Button(composite, 8);
        button.setText("Add ZIP/JAR/EGG");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(shell);
                dialog.setFilterPath(lastFileDialogPath);
                dialog.open();
                String[] fileNames = dialog.getFileNames();
                if (fileNames != null && fileNames.length > 0) {
                    lastFileDialogPath = dialog.getFilterPath();
                    String[] stringArray = fileNames;
                    int n = fileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        StringBuffer buf = new StringBuffer(lastFileDialogPath);
                        if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                            buf.append(File.separatorChar);
                        }
                        buf.append(fileName);
                        TreeWithAddRemove.this.addTreeItem(buf.toString());
                        ++n2;
                    }
                }
            }
        });
        button = new Button(composite, 8);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        button.setText("Remove");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = TreeWithAddRemove.this.tree.getSelection();
                int i = 0;
                while (i < selection.length) {
                    selection[i].dispose();
                    ++i;
                }
            }
        });
    }

    private static String[] stringToStringArray(String items) {
        String ps = System.getProperty("path.separator", "|");
        return items.split(ps);
    }

    private void addTreeItem(String AsString) {
        if (AsString != null && AsString.trim().length() > 0) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(AsString);
            File file = new File(AsString);
            if (file.isDirectory()) {
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            } else if (file.isFile()) {
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
            } else {
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
            }
        }
    }

    public String getTreeItemsAsString() {
        String ps = System.getProperty("path.separator", "|");
        StringBuffer ret = new StringBuffer();
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            String text = items[i].getText();
            if (text != null && text.trim().length() > 0) {
                if (ret.length() > 0) {
                    ret.append(ps);
                }
                ret.append(text);
            }
            ++i;
        }
        return ret.toString();
    }

    public void resetTreeItems(String items) {
        String[] arrayItems;
        this.tree.removeAll();
        String[] stringArray = arrayItems = TreeWithAddRemove.stringToStringArray(items);
        int n = arrayItems.length;
        int n2 = 0;
        while (n2 < n) {
            String arrayItem = stringArray[n2];
            this.addTreeItem(arrayItem);
            ++n2;
        }
    }
}

