/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.FieldCategory;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Util;

public class TypeMarkerGroup
extends MarkerGroup {
    private String name;

    public TypeMarkerGroup(String name) {
        super(null);
        this.name = name;
    }

    protected void createFields() {
        this.field = new FieldCategory();
        this.markerField = new TypeMarkerField();
    }

    public String getId() {
        return "org.eclipse.ui.ide.type";
    }

    public String getTitle() {
        return this.name;
    }

    class TypeMarkerField
    extends MarkerGroup.GroupMarkerField {
        TypeMarkerField() {
        }

        public String getValue(MarkerItem item) {
            if (item.getMarker() != null) {
                IMarker marker = item.getMarker();
                if (marker == null || !marker.exists()) {
                    return MarkerMessages.FieldCategory_Uncategorized;
                }
                String groupName = MarkerSupportRegistry.getInstance().getCategory(marker);
                if (groupName == null) {
                    String typeId;
                    try {
                        typeId = marker.getType();
                    }
                    catch (CoreException e) {
                        Policy.handle(e);
                        return MarkerMessages.FieldCategory_Uncategorized;
                    }
                    MarkerType type = MarkerTypesModel.getInstance().getType(typeId);
                    groupName = type.getLabel();
                }
                return groupName;
            }
            return Util.EMPTY_STRING;
        }

        public int compare(MarkerItem item1, MarkerItem item2) {
            return this.getValue(item1).compareTo(this.getValue(item2));
        }
    }
}

