/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jmol.util.Logger;

public class ImageSelection
implements Transferable {
    private Image image;
    private String text;

    public static void setClipboard(Image image) {
        ImageSelection imageSelection = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public static void setClipboard(String string) {
        ImageSelection imageSelection = new ImageSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imageSelection, null);
    }

    public ImageSelection(Image image) {
        this.image = image;
    }

    public ImageSelection(String string) {
        this.text = string;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray;
        if (this.text == null) {
            DataFlavor[] dataFlavorArray2 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray2;
            dataFlavorArray2[0] = DataFlavor.imageFlavor;
        } else {
            DataFlavor[] dataFlavorArray3 = new DataFlavor[1];
            dataFlavorArray = dataFlavorArray3;
            dataFlavorArray3[0] = DataFlavor.stringFlavor;
        }
        return dataFlavorArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DataFlavor.imageFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (DataFlavor.imageFlavor.equals(dataFlavor)) {
            return this.image;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.text;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static String getClipboardText() {
        boolean bl;
        String string = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        boolean bl2 = bl = transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.error("Clipboard problem", unsupportedFlavorException);
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                Logger.error("Clipboard problem", iOException);
                iOException.printStackTrace();
            }
        }
        return string;
    }
}

