/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.Monomer;

public class PhosphorusMonomer
extends Monomer {
    private static final byte[] phosphorusOffsets = new byte[]{0};
    private static float MAX_ADJACENT_PHOSPHORUS_DISTANCE = 8.0f;
    protected boolean isPurine;
    protected boolean isPyrimidine;

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        if (n2 != n3 || nArray[13] != n2) {
            return null;
        }
        return new PhosphorusMonomer(chain, string, n, n2, n3, phosphorusOffsets);
    }

    protected PhosphorusMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
        if (string.indexOf(84) >= 0) {
            chain.setIsDna(true);
        }
        if (string.indexOf(85) + string.indexOf(73) > -2) {
            chain.setIsRna(true);
        }
        this.isPurine = string.indexOf(65) + string.indexOf(71) + string.indexOf(73) > -3;
        this.isPyrimidine = string.indexOf(84) + string.indexOf(67) + string.indexOf(85) > -3;
    }

    boolean isPhosphorusMonomer() {
        return true;
    }

    public boolean isDna() {
        return this.chain.isDna();
    }

    public boolean isRna() {
        return this.chain.isRna();
    }

    public boolean isPurine() {
        return this.isPurine;
    }

    public boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof PhosphorusMonomer)) {
            return false;
        }
        float f = this.getLeadAtomPoint().distance(monomer.getLeadAtomPoint());
        return f <= MAX_ADJACENT_PHOSPHORUS_DISTANCE;
    }
}

