/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.FableUtils;
import fable.grainspotter.editors.GrainSpotterInput;
import fable.grainspotter.editors.GrainSpotterInputEditor;
import fable.grainspotter.run.GrainSpotter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RunAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "fable.grainspotter.actions.RunAction";

    public void dispose() {
    }

    public void run(IAction arg0) {
        this.run();
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        GrainSpotterInputEditor editor = RunAction.getActiveEditor();
        if (editor == null) {
            String msg = "The current active editor must be a GrainSpotter Input File Editor";
            FableUtils.errMsg((Object)((Object)this), (String)msg);
            return;
        }
        try {
            GrainSpotterInput gsInput = editor.getGsInput();
            GrainSpotter grainSpotter = gsInput.getGrainSpotter();
            grainSpotter.fireStateChange("launch");
        }
        catch (Exception ex) {
            String msg = "Cannot run GrainSpotter";
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)msg, (Throwable)ex);
        }
    }

    private static GrainSpotterInputEditor getActiveEditor() {
        GrainSpotterInputEditor editor = null;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart part = page.getActiveEditor();
            if (part instanceof GrainSpotterInputEditor) {
                editor = (GrainSpotterInputEditor)part;
            }
        }
        catch (Throwable throwable) {}
        return editor;
    }
}

