/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.ant;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.osgi.framework.BundleContext;

public class CreateCompositeArtifactRepositoryTask
extends Task {
    URI location;
    String name = "Composite Artifact Repository";
    boolean compressed = true;
    boolean failOnExists = false;
    Map properties = new HashMap();
    static /* synthetic */ Class class$0;

    public void execute() {
        IArtifactRepositoryManager manager;
        block12: {
            this.validate();
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
                throw new BuildException("Unable to aquire artifact repository manager service.");
            }
            manager.removeRepository(this.location);
            try {
                IArtifactRepository repository = manager.loadRepository(this.location, null);
                if (repository instanceof CompositeArtifactRepository) {
                    if (this.failOnExists) {
                        throw new BuildException("Composite repository already exists at location: " + this.location);
                    }
                    return;
                }
            }
            catch (ProvisionException e) {
                if (e.getStatus().getCode() == 1000) break block12;
                throw new BuildException("Exception while trying to read repository at: " + this.location, (Throwable)e);
            }
        }
        if (this.compressed) {
            this.properties.put("p2.compressed", Boolean.toString(true));
        }
        try {
            manager.createRepository(this.location, this.name, "org.eclipse.equinox.p2.artifact.repository.compositeRepository", this.properties);
        }
        catch (ProvisionException e) {
            throw new BuildException("Error occurred while creating composite artifact repository.", (Throwable)e);
        }
    }

    private void validate() {
        if (this.location == null) {
            throw new BuildException("Must specify repository location.");
        }
        if (this.name == null) {
            throw new BuildException("Must specify a repository name.");
        }
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setLocation(String value) throws URISyntaxException {
        this.location = URIUtil.fromString((String)value);
    }

    public void setCompressed(boolean value) {
        this.compressed = value;
    }

    public void setFailOnExists(boolean value) {
        this.failOnExists = value;
    }
}

