/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.eclipse.ant.internal.ui.antsupport.logger.util.IDebugBuildLogger;

public class AntDebugState {
    private static final String fgAntTaskName = "ant";
    private static final String fgAntCallTaskName = "antcall";
    private IDebugBuildLogger fLogger;
    private Stack fTasks = new Stack();
    private Map fTaskToProxies = new HashMap();
    private Task fCurrentTask;
    private Task fStepOverTask;
    private Task fStepIntoTask;
    private Task fLastTaskFinished;
    private Map fInitialProperties = null;
    private Map fProperties = null;
    private Map fProjectToTargetNames = null;
    private Map fProjectToMapOfTargetToBuildSequence = null;
    private Stack fTargetsToExecute = new Stack();
    private Stack fTargetsExecuting = new Stack();
    private boolean fConsiderTargetBreakpoints = false;
    private boolean fShouldSuspend;
    private boolean fClientSuspend = false;
    private boolean fStepIntoSuspend = false;
    private boolean fIsAfterTaskEvent = false;

    public AntDebugState(IDebugBuildLogger logger) {
        this.fLogger = logger;
    }

    public void waitIfSuspended() {
        this.fLogger.waitIfSuspended();
    }

    public Task getLastTaskFinished() {
        return this.fLastTaskFinished;
    }

    private void setLastTaskFinished(Task lastTaskFinished) {
        this.fLastTaskFinished = lastTaskFinished;
    }

    public Task getCurrentTask() {
        return this.fCurrentTask;
    }

    public void setCurrentTask(Task currentTask) {
        this.fCurrentTask = currentTask;
    }

    private Map getInitialProperties() {
        return this.fInitialProperties;
    }

    public Task getStepOverTask() {
        return this.fStepOverTask;
    }

    public void setStepOverTask(Task stepOverTask) {
        this.fStepOverTask = stepOverTask;
    }

    private boolean considerTargetBreakpoints() {
        return this.fConsiderTargetBreakpoints;
    }

    private void setConsiderTargetBreakpoints(boolean considerTargetBreakpoints) {
        this.fConsiderTargetBreakpoints = considerTargetBreakpoints;
    }

    private Stack getTasks() {
        return this.fTasks;
    }

    public void setShouldSuspend(boolean shouldSuspend) {
        this.fShouldSuspend = shouldSuspend;
    }

    public boolean shouldSuspend() {
        return this.fShouldSuspend;
    }

    private Map getTargetToBuildSequence(Project project) {
        return (Map)this.fProjectToMapOfTargetToBuildSequence.get(project);
    }

    public void setTargetToExecute(Target target) {
        if (target == null) {
            this.fTargetsToExecute.pop();
        } else {
            this.fTargetsToExecute.push(target);
        }
    }

    public void setTargetExecuting(Target target) {
        if (target == null) {
            this.fTargetsExecuting.pop();
        } else {
            this.fTargetsExecuting.push(target);
        }
    }

    private Target getTargetToExecute() {
        if (this.fTargetsToExecute.isEmpty()) {
            return null;
        }
        return (Target)this.fTargetsToExecute.peek();
    }

    private Target getTargetExecuting() {
        if (this.fTargetsExecuting.isEmpty()) {
            return null;
        }
        return (Target)this.fTargetsExecuting.peek();
    }

    public boolean isStepIntoSuspend() {
        return this.isAfterTaskEvent() && this.fStepIntoSuspend;
    }

    public void setStepIntoSuspend(boolean stepIntoSuspend) {
        this.fStepIntoSuspend = stepIntoSuspend;
    }

    public boolean isClientSuspend() {
        return this.fClientSuspend;
    }

    public void setClientSuspend(boolean clientSuspend) {
        this.fClientSuspend = clientSuspend;
    }

    public Task getStepIntoTask() {
        return this.fStepIntoTask;
    }

    public void setStepIntoTask(Task stepIntoTask) {
        this.fStepIntoTask = stepIntoTask;
    }

    public void resume() {
        this.fLogger.notifyAll();
    }

    public Map getProperties() {
        return this.fProperties;
    }

    public Location getBreakpointLocation() {
        Target targetExecuting;
        if (this.isAfterTaskEvent() && this.getCurrentTask() != null) {
            return this.getCurrentTask().getLocation();
        }
        if (this.considerTargetBreakpoints() && (targetExecuting = this.getTargetExecuting()) != null) {
            return AntDebugState.getLocation(targetExecuting);
        }
        return null;
    }

    private boolean isAfterTaskEvent() {
        return this.fIsAfterTaskEvent;
    }

    private void setAfterTaskEvent(boolean isAfterTaskEvent) {
        this.fIsAfterTaskEvent = isAfterTaskEvent;
    }

    public void taskStarted(BuildEvent event) {
        Task parentTask;
        Object proxy;
        this.setAfterTaskEvent(true);
        if (this.getInitialProperties() == null) {
            this.fInitialProperties = event.getProject().getProperties();
        }
        this.setCurrentTask(event.getTask());
        this.setConsiderTargetBreakpoints(false);
        if (!this.getTasks().isEmpty() && (proxy = (parentTask = (Task)this.getTasks().peek()).getRuntimeConfigurableWrapper().getProxy()) != null) {
            this.fTaskToProxies.put(parentTask, proxy);
        }
        this.getTasks().push(this.getCurrentTask());
        this.waitIfSuspended();
    }

    public void taskFinished() {
        Task lastTask = (Task)this.getTasks().pop();
        this.setLastTaskFinished(lastTask);
        this.setCurrentTask(null);
        String taskName = lastTask.getTaskName();
        if (this.getStepOverTask() != null) {
            if ((fgAntCallTaskName.equals(taskName) || fgAntTaskName.equals(taskName)) && !fgAntCallTaskName.equals(this.getStepOverTask().getTaskName()) && !fgAntTaskName.equals(this.getStepOverTask().getTaskName())) {
                this.setShouldSuspend(true);
            } else if (this.fTaskToProxies.remove(lastTask) instanceof MacroInstance) {
                this.setShouldSuspend(true);
            }
        }
        this.waitIfSuspended();
    }

    public void stepOver() {
        this.setStepOverTask(this.getCurrentTask());
        if (this.getCurrentTask() == null) {
            this.setShouldSuspend(true);
        }
        this.resume();
    }

    public void targetStarted(BuildEvent event) {
        Object ref;
        this.setAfterTaskEvent(false);
        Project eventProject = event.getProject();
        if (this.getInitialProperties() == null) {
            this.fInitialProperties = eventProject.getProperties();
        }
        if (this.fProjectToTargetNames.get(eventProject) == null && (ref = eventProject.getReference("eclipse.ant.targetVector")) != null) {
            this.fProjectToTargetNames.put(eventProject, ref);
            HashMap targetToBuildSequence = new HashMap();
            this.setTargetToExecute(this.initializeBuildSequenceInformation(event, targetToBuildSequence));
            this.fProjectToMapOfTargetToBuildSequence.put(eventProject, targetToBuildSequence);
        }
        this.setTargetExecuting(event.getTarget());
        if (event.getTarget().equals(this.getTargetToExecute())) {
            Vector targets = (Vector)this.fProjectToTargetNames.get(eventProject);
            if (!targets.isEmpty()) {
                this.setTargetToExecute((Target)eventProject.getTargets().get(targets.remove(0)));
            } else {
                this.setTargetToExecute(null);
            }
        }
        this.setConsiderTargetBreakpoints(true);
    }

    public int getLineNumber(Location location) {
        try {
            return location.getLineNumber();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String locationString = location.toString();
            if (locationString.length() == 0) {
                return 0;
            }
            int lastIndex = locationString.lastIndexOf(58);
            int index = locationString.lastIndexOf(58, lastIndex - 1);
            if (index != -1) {
                try {
                    return Integer.parseInt(locationString.substring(index + 1, lastIndex));
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
            return 0;
        }
    }

    public static Location getLocation(Target target) {
        try {
            return target.getLocation();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Location.UNKNOWN_LOCATION;
        }
    }

    public String getFileName(Location location) {
        try {
            return location.getFileName();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            String locationString = location.toString();
            if (locationString.length() == 0) {
                return null;
            }
            int lastIndex = locationString.lastIndexOf(58);
            int index = locationString.lastIndexOf(58, lastIndex - 1);
            if (index == -1) {
                index = lastIndex;
            }
            if (index != -1) {
                return locationString.substring(5, index);
            }
            return null;
        }
    }

    private void appendToStack(StringBuffer stackRepresentation, String targetName, String taskName, Location location) {
        stackRepresentation.append(targetName);
        stackRepresentation.append(",");
        stackRepresentation.append(taskName);
        stackRepresentation.append(",");
        stackRepresentation.append(this.getFileName(location));
        stackRepresentation.append(",");
        stackRepresentation.append(this.getLineNumber(location));
        stackRepresentation.append(",");
    }

    public void marshalStack(StringBuffer stackRepresentation) {
        Stack tasks = this.getTasks();
        stackRepresentation.append("stack");
        stackRepresentation.append(",");
        Target targetToExecute = this.getTargetToExecute();
        Target targetExecuting = this.getTargetExecuting();
        Project projectExecuting = null;
        if (targetExecuting != null) {
            projectExecuting = targetExecuting.getProject();
        } else {
            Task task = (Task)tasks.peek();
            projectExecuting = task.getProject();
        }
        if (!this.isAfterTaskEvent()) {
            this.appendToStack(stackRepresentation, targetExecuting.getName(), "", AntDebugState.getLocation(targetExecuting));
        }
        int i = tasks.size() - 1;
        while (i >= 0) {
            Task task = (Task)tasks.get(i);
            if (task.getProject() == projectExecuting) {
                this.appendToStack(stackRepresentation, task.getOwningTarget().getName(), task.getTaskName(), task.getLocation());
            } else {
                String targetName = task.getOwningTarget().getName();
                if (targetName != null && targetName.length() != 0) {
                    Iterator itr = this.fTargetsToExecute.iterator();
                    while (itr.hasNext()) {
                        Target target = (Target)itr.next();
                        if (target.getProject() != projectExecuting) {
                            targetToExecute = target;
                            continue;
                        }
                        this.marshalTargetDependancyStack(stackRepresentation, target, targetExecuting);
                    }
                }
                projectExecuting = task.getProject();
                targetExecuting = task.getOwningTarget();
                this.appendToStack(stackRepresentation, targetExecuting.getName(), task.getTaskName(), task.getLocation());
            }
            --i;
        }
        this.marshalTargetDependancyStack(stackRepresentation, targetToExecute, targetExecuting);
    }

    private void marshalTargetDependancyStack(StringBuffer stackRepresentation, Target targetToExecute, Target targetExecuting) {
        if (targetToExecute != null) {
            Vector buildSequence = (Vector)this.getTargetToBuildSequence(targetToExecute.getProject()).get(targetToExecute);
            int startIndex = buildSequence.indexOf(targetExecuting) + 1;
            int dependancyStackDepth = buildSequence.indexOf(targetToExecute);
            int i = startIndex;
            while (i <= dependancyStackDepth) {
                Target stackTarget = (Target)buildSequence.get(i);
                if (stackTarget.dependsOn(targetExecuting.getName())) {
                    this.appendToStack(stackRepresentation, stackTarget.getName(), "", AntDebugState.getLocation(stackTarget));
                }
                ++i;
            }
        }
    }

    public void marshallProperties(StringBuffer propertiesRepresentation, boolean escapeLineSep) {
        if (this.getTasks().isEmpty()) {
            return;
        }
        propertiesRepresentation.append("prop");
        propertiesRepresentation.append(",");
        Project project = ((Task)this.getTasks().peek()).getProject();
        Map lastProperties = this.getProperties();
        Hashtable currentProperties = project.getProperties();
        if (lastProperties != null && currentProperties.size() == lastProperties.size()) {
            return;
        }
        Map initialProperties = this.getInitialProperties();
        Hashtable currentUserProperties = project.getUserProperties();
        Iterator iter = currentProperties.keySet().iterator();
        while (iter.hasNext()) {
            String propertyName;
            String originalPropertyName = propertyName = (String)iter.next();
            if (lastProperties != null && lastProperties.get(propertyName) != null) continue;
            if (escapeLineSep) {
                propertyName = this.escapeLineSeparator(propertyName);
            }
            propertiesRepresentation.append(propertyName.length());
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(propertyName);
            propertiesRepresentation.append(",");
            String propertyValue = (String)currentProperties.get(originalPropertyName);
            if (escapeLineSep) {
                propertyValue = this.escapeLineSeparator(propertyValue);
            }
            propertiesRepresentation.append(propertyValue.length());
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(propertyValue);
            propertiesRepresentation.append(",");
            propertiesRepresentation.append(this.getPropertyType(initialProperties, currentUserProperties, originalPropertyName));
            propertiesRepresentation.append(",");
        }
        propertiesRepresentation.deleteCharAt(propertiesRepresentation.length() - 1);
        this.fProperties = currentProperties;
    }

    private int getPropertyType(Map initialProperties, Map currentUserProperties, String propertyName) {
        if (initialProperties.get(propertyName) != null) {
            if (currentUserProperties.get(propertyName) == null) {
                return 1;
            }
            return 0;
        }
        if (currentUserProperties.get(propertyName) == null) {
            return 2;
        }
        return 0;
    }

    private String escapeLineSeparator(String stringToEscape) {
        if (stringToEscape.indexOf(13) == -1 && stringToEscape.indexOf(10) == -1 && stringToEscape.indexOf("\\r") == -1 && stringToEscape.indexOf("\\n") == -1) {
            return stringToEscape;
        }
        StringBuffer escapedValue = new StringBuffer(stringToEscape);
        int i = 0;
        while (i < escapedValue.length()) {
            switch (escapedValue.charAt(i)) {
                case '\r': {
                    escapedValue.replace(i, i + 1, "\\r");
                    ++i;
                    break;
                }
                case '\n': {
                    escapedValue.replace(i, i + 1, "\\n");
                    ++i;
                    break;
                }
                case '\\': {
                    if (escapedValue.charAt(i + 1) != 'r' && escapedValue.charAt(i + 1) != 'n') break;
                    escapedValue.replace(i, i + 1, "\\\\");
                    ++i;
                    break;
                }
            }
            ++i;
        }
        return escapedValue.toString();
    }

    private Target initializeBuildSequenceInformation(BuildEvent event, Map targetToBuildSequence) {
        Project antProject = event.getProject();
        Vector targets = (Vector)antProject.getReference("eclipse.ant.targetVector");
        if (targets == null) {
            return null;
        }
        Iterator itr = targets.iterator();
        Hashtable allTargets = antProject.getTargets();
        while (itr.hasNext()) {
            String targetName = (String)itr.next();
            Vector sortedTargets = antProject.topoSort(targetName, allTargets);
            targetToBuildSequence.put(allTargets.get(targetName), sortedTargets);
        }
        return (Target)allTargets.get(targets.remove(0));
    }

    public void buildStarted() {
        this.fProjectToTargetNames = new HashMap();
        this.fProjectToMapOfTargetToBuildSequence = new HashMap();
    }
}

