/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTWindow;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    NSWindow window;
    SWTWindowDelegate windowDelegate;
    int tooltipOwner;
    int tooltipTag;
    int tooltipUserData;
    boolean opened;
    boolean moved;
    boolean resized;
    boolean fullScreen;
    boolean center;
    Control lastActive;
    Rectangle normalBounds;
    boolean keyInputHappened;
    NSRect currentFrame;
    NSRect fullScreenFrame;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0, false);
    }

    Shell(Display display, Shell parent, int style, int handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        if (!Display.getSheetEnabled()) {
            this.center = parent != null && (style & 0x10000000) != 0;
        }
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0) {
            if (embedded) {
                this.view = new NSView(handle);
            } else {
                this.window = new NSWindow(handle);
                this.state |= 0x20000;
            }
        }
        this.createWidget();
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0, false);
    }

    public static Shell internal_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, false);
    }

    public static Shell cocoa_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, true);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        if (((style &= 0xBFFFFFFF) & 0x10000000) != 0) {
            if (Display.getSheetEnabled()) {
                style &= 0xFFFFFB1F;
                if (parent == null) {
                    style &= 0xEFFFFFFF;
                    style |= 0x4F0;
                }
            } else {
                style &= 0xEFFFFFFF;
                style |= parent == null ? 1264 : 2144;
            }
            if ((style & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    boolean accessibilityIsIgnored(int id2, int sel) {
        if (id2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void becomeKeyWindow(int id2, int sel) {
        Display display = this.display;
        display.keyWindow = this.window;
        super.becomeKeyWindow(id2, sel);
        display.checkFocus();
        display.keyWindow = null;
    }

    void bringToTop(boolean force) {
        if (this.getMinimized()) {
            return;
        }
        if (force) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    boolean canBecomeKeyWindow(int id2, int sel) {
        if (this.window.styleMask() == 0) {
            return true;
        }
        return super.canBecomeKeyWindow(id2, sel);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        NSRect rect = new NSRect();
        rect.x = trim.x;
        rect.y = trim.y;
        rect.width = trim.width;
        rect.height = trim.height;
        if (this.window != null && !this.fixResize()) {
            rect = this.window.frameRectForContentRect(rect);
        }
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    void createHandle() {
        this.state |= 0x10;
        if (this.window == null) {
            this.window = (NSWindow)new SWTWindow().alloc();
            int styleMask = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x20) != 0) {
                    styleMask |= 1;
                }
                if ((this.style & 0x40) != 0) {
                    styleMask |= 2;
                }
                if ((this.style & 0x80) != 0) {
                    styleMask |= 4;
                }
                if ((this.style & 0x400) != 0) {
                    styleMask |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    styleMask |= 8;
                }
            }
            NSScreen screen = null;
            NSScreen primaryScreen = new NSScreen(NSScreen.screens().objectAtIndex(0));
            if (this.parent != null) {
                screen = this.parent.getShell().window.screen();
            }
            if (screen == null) {
                screen = primaryScreen;
            }
            this.window = this.window.initWithContentRect(new NSRect(), styleMask, 2, false, screen);
            if ((this.style & 0xCF8) == 0 || (this.style & 0x10000004) != 0) {
                this.window.setHasShadow(true);
            }
            if ((this.style & 8) == 0) {
                NSSize size = this.window.minSize();
                size.width = NSWindow.minFrameWidthWithTitle(NSString.stringWith(""), styleMask);
                this.window.setMinSize(size);
            }
            if (this.fixResize() && this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.display.cascadeWindow(this.window, screen);
            NSRect screenFrame = screen.frame();
            float width = screenFrame.width * 5.0f / 8.0f;
            float height = screenFrame.height * 5.0f / 8.0f;
            NSRect frame = this.window.frame();
            NSRect primaryFrame = primaryScreen.frame();
            frame.y = primaryFrame.height - (primaryFrame.height - (frame.y + frame.height) + height);
            frame.width = width;
            frame.height = height;
            this.window.setFrame(frame, false);
            if ((this.style & 0x4000) != 0) {
                this.window.setLevel(25);
            }
            super.createHandle();
            this.topView().setHidden(true);
        } else {
            this.state &= 0xFFFFFFEF;
            super.createHandle();
            this.style |= 0x40000;
        }
        this.window.setAcceptsMouseMovedEvents(true);
        this.windowDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.window.setDelegate(this.windowDelegate);
        NSText id2 = this.window.fieldEditor(true, null);
        if (id2 != null) {
            OS.object_setClass(id2.id, OS.objc_getClass("SWTEditorView"));
        }
    }

    void deregister() {
        super.deregister();
        if (this.window != null) {
            this.display.removeWidget(this.window);
        }
        if (this.windowDelegate != null) {
            this.display.removeWidget(this.windowDelegate);
        }
    }

    void destroyWidget() {
        NSWindow window = this.window;
        Display display = this.display;
        boolean sheet = (this.style & 0x10000000) != 0;
        this.releaseHandle();
        if (window != null) {
            if (sheet) {
                NSApplication application = NSApplication.sharedApplication();
                application.endSheet(window, 0);
            }
            window.close();
        }
        if (!display.isDisposed() && display.getShells().length == 0) {
            display.setMenuBar(null);
        }
    }

    void drawBackground(int id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        if (this.regionPath != null && this.background == null) {
            context.saveGraphicsState();
            NSColor.windowBackgroundColor().setFill();
            NSBezierPath.fillRect(rect);
            context.restoreGraphicsState();
            return;
        }
        super.drawBackground(id2, context, rect);
    }

    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    boolean fixResize() {
        return (this.style & 8) == 0 && (this.style & 0x10) != 0 && (this.style & 0x4E0) == 0;
    }

    void fixShell(Shell newShell, Control control) {
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        if (this.window == null) {
            return;
        }
        this.makeKeyAndOrderFront();
        NSApplication application = NSApplication.sharedApplication();
        application.activateIgnoringOtherApps(true);
    }

    public int getAlpha() {
        this.checkWidget();
        if (this.window == null) {
            return 255;
        }
        return (int)(this.window.alphaValue() * 255.0f);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect frame = this.window == null ? this.view.frame() : this.window.frame();
        float y = this.display.getPrimaryFrame().height - (float)((int)(frame.y + frame.height));
        return new Rectangle((int)frame.x, (int)y, (int)frame.width, (int)frame.height);
    }

    public Rectangle getClientArea() {
        NSRect rect;
        this.checkWidget();
        if (this.window != null) {
            rect = this.window.frame();
            if (!this.fixResize()) {
                rect = this.window.contentRectForFrameRect(rect);
            }
        } else {
            rect = this.scrollView != null ? this.scrollView.frame() : this.view.frame();
        }
        int width = (int)rect.width;
        int height = (int)rect.height;
        if (this.scrollView != null) {
            NSSize size = new NSSize();
            size.width = width;
            size.height = height;
            size = NSScrollView.contentSizeForFrameSize(size, (this.style & 0x100) != 0, (this.style & 0x200) != 0, 0);
            width = (int)size.width;
            height = (int)size.height;
        }
        return new Rectangle(0, 0, width, height);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        NSRect frame = this.window != null ? this.window.frame() : this.view.frame();
        float y = this.display.getPrimaryFrame().height - (float)((int)(frame.y + frame.height));
        return new Point((int)frame.x, (int)y);
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (this.window == null) {
            return false;
        }
        return !this.fullScreen && this.window.isZoomed();
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.window.isDocumentEdited();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        if (this.window == null) {
            return false;
        }
        return this.window.isMiniaturized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        if (this.window == null) {
            return new Point(0, 0);
        }
        NSSize size = this.window.minSize();
        return new Point((int)size.width, (int)size.height);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public Point getSize() {
        this.checkWidget();
        NSRect frame = this.window != null ? this.window.frame() : this.view.frame();
        return new Point((int)frame.width, (int)frame.height);
    }

    float getThemeAlpha() {
        return 1.0f;
    }

    boolean hasBorder() {
        return false;
    }

    void helpRequested(int id2, int sel, int theEvent) {
        Control control = this.display.getFocusControl();
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                break;
            }
            control = control.parent;
        }
    }

    void invalidateVisibleRegion() {
        this.resetVisibleRegion();
        this.invalidateChildrenVisibleRegion();
    }

    boolean isDrawing() {
        return this.getDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean makeFirstResponder(int id2, int sel, int responder) {
        Display display = this.display;
        boolean result = super.makeFirstResponder(id2, sel, responder);
        display.checkFocus();
        return result;
    }

    void makeKeyAndOrderFront() {
        if (this.parent != null) {
            Shell shell = (Shell)this.parent;
            if (shell.window.isMiniaturized()) {
                shell.window.deminiaturize(null);
            }
        }
        this.window.makeKeyAndOrderFront(null);
    }

    void noResponderFor(int id2, int sel, int selector) {
        if (selector != OS.sel_keyDown_) {
            super.noResponderFor(id2, sel, selector);
        }
    }

    public void open() {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            this.display.setModalShell(this);
        } else {
            this.updateModal();
        }
        this.bringToTop(false);
        this.setWindowVisible(true, true);
        if (this.isDisposed()) {
            return;
        }
        if (!(this.restoreFocus() || this.traverseGroup(true) || this.parent != null && ((Shell)this.parent).window.isMiniaturized())) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        if (this.window != null) {
            this.display.addWidget(this.window, this);
        }
        if (this.windowDelegate != null) {
            this.display.addWidget(this.windowDelegate, this);
        }
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        if (this.windowDelegate != null) {
            this.windowDelegate.release();
        }
        this.windowDelegate = null;
        super.releaseHandle();
        this.window = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.clearModal(this);
        this.updateParent(false);
        this.display.updateQuitMenu();
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(27, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
    }

    void sendToolTipEvent(boolean enter) {
        if (!this.isVisible()) {
            return;
        }
        if (this.tooltipTag == 0) {
            NSView view = this.window.contentView();
            this.tooltipTag = view.addToolTipRect(new NSRect(), this.window, 0);
            if (this.tooltipTag != 0) {
                NSDictionary userInfo;
                NSTrackingArea trackingArea = new NSTrackingArea(this.tooltipTag);
                id owner = trackingArea.owner();
                if (owner != null) {
                    this.tooltipOwner = owner.id;
                }
                if ((userInfo = trackingArea.userInfo()) != null) {
                    this.tooltipUserData = userInfo.id;
                } else {
                    int[] value = new int[1];
                    OS.object_getInstanceVariable(this.tooltipTag, new byte[]{95, 117, 115, 101, 114, 73, 110, 102, 111}, value);
                    this.tooltipUserData = value[0];
                }
            }
        }
        if (this.tooltipTag == 0 || this.tooltipOwner == 0 || this.tooltipUserData == 0) {
            return;
        }
        NSPoint pt = this.window.convertScreenToBase(NSEvent.mouseLocation());
        NSEvent event = NSEvent.enterExitEventWithType(enter ? 8 : 9, pt, 0, 0.0, this.window.windowNumber(), null, 0, this.tooltipTag, this.tooltipUserData);
        OS.objc_msgSend(this.tooltipOwner, enter ? OS.sel_mouseEntered_ : OS.sel_mouseExited_, event.id);
    }

    public void setActive() {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.makeKeyAndOrderFront();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        this.window.setAlphaValue((float)(alpha &= 0xFF) / 255.0f);
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean sheet;
        if (this.window == null) {
            return;
        }
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if ((sheet = this.window.isSheet()) && move && !resize) {
            return;
        }
        int screenHeight = (int)this.display.getPrimaryFrame().height;
        NSRect frame = this.window.frame();
        if (!move) {
            x = (int)frame.x;
            y = screenHeight - (int)(frame.y + frame.height);
        }
        if (resize) {
            NSSize minSize = this.window.minSize();
            width = Math.max(width, (int)minSize.width);
            height = Math.max(height, (int)minSize.height);
        } else {
            width = (int)frame.width;
            height = (int)frame.height;
        }
        if (sheet) {
            y = screenHeight - (int)(frame.y + frame.height);
            NSRect parentRect = this.parent.getShell().window.frame();
            frame.width = width;
            frame.height = height;
            frame.x = parentRect.x + (parentRect.width - frame.width) / 2.0f;
            frame.y = screenHeight - (int)((float)y + frame.height);
            this.window.setFrame(frame, this.isVisible(), true);
        } else {
            frame.x = x;
            frame.y = screenHeight - (y + height);
            frame.width = width;
            frame.height = height;
            this.window.setFrame(frame, this.isVisible());
        }
    }

    void setClipRegion(float x, float y) {
        if (this.regionPath != null) {
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(-x, -y);
            this.regionPath.transformUsingAffineTransform(transform);
            this.regionPath.addClip();
            transform.translateXBy(2.0f * x, 2.0f * y);
            this.regionPath.transformUsingAffineTransform(transform);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 8) == 0 == enabled) {
            return;
        }
        super.setEnabled(enabled);
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (this.fullScreen == fullScreen) {
            return;
        }
        this.fullScreen = fullScreen;
        if (fullScreen) {
            this.currentFrame = this.window.frame();
            this.window.setShowsResizeIndicator(false);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.fullScreenFrame = NSScreen.mainScreen().frame();
            if (this.getMonitor().equals(this.display.getPrimaryMonitor())) {
                if (this.menuBar != null) {
                    float menuBarHt = this.currentFrame.height - this.contentView().frame().height;
                    this.fullScreenFrame.height -= menuBarHt;
                    OS.SetSystemUIMode(2, 0);
                } else {
                    OS.SetSystemUIMode(3, 0);
                }
            }
            this.window.setFrame(this.fullScreenFrame, true);
            this.window.contentView().setFrame(this.fullScreenFrame);
        } else {
            this.window.setShowsResizeIndicator(true);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 1);
            }
            OS.SetSystemUIMode(0, 0);
            this.window.setFrame(this.currentFrame, true);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (this.window == null) {
            return;
        }
        if (this.window.isZoomed() == maximized) {
            return;
        }
        this.window.zoom(null);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        super.setMinimized(minimized);
        if (this.window == null) {
            return;
        }
        if (minimized) {
            this.window.miniaturize(null);
        } else {
            this.window.deminiaturize(null);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        NSSize size = new NSSize();
        size.width = width;
        size.height = height;
        this.window.setMinSize(size);
        NSRect frame = this.window.frame();
        if ((float)width > frame.width || (float)height > frame.height) {
            width = (int)((float)width > frame.width ? (float)width : frame.width);
            height = (int)((float)height > frame.height ? (float)height : frame.height);
            this.setBounds(0, 0, width, height, false, true);
        }
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.window.setDocumentEdited(modified);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.window == null) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        if (region != null) {
            this.window.setBackgroundColor(NSColor.clearColor());
            this.window.setOpaque(false);
        } else {
            this.window.setBackgroundColor(NSColor.windowBackgroundColor());
            this.window.setOpaque(true);
        }
        this.window.contentView().setNeedsDisplay(true);
        if (this.isVisible() && this.window.hasShadow()) {
            this.window.display();
            this.window.invalidateShadow();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.window == null) {
            return;
        }
        super.setText(string);
        NSString str = NSString.stringWith(string);
        this.window.setTitle(str);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int mask = 229376;
        if ((this.style & mask) != 0) {
            if (visible) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.window == null) {
            super.setVisible(visible);
        } else {
            this.setWindowVisible(visible, false);
        }
    }

    void setWindowVisible(boolean visible, boolean key) {
        if (visible) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (this.window != null && this.window.isVisible() == visible) {
            return;
        }
        if (visible) {
            this.display.clearPool();
            if (this.center && !this.moved) {
                if (this.isDisposed()) {
                    return;
                }
                this.center();
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(false);
            this.invalidateVisibleRegion();
            if ((this.style & 0x10000000) != 0) {
                NSApplication application = NSApplication.sharedApplication();
                application.beginSheet(this.window, ((Shell)this.parent).window, null, 0, 0);
                if (OS.VERSION <= 4192 && this.window.respondsToSelector(OS.sel__setNeedsToUseHeartBeatWindow_)) {
                    OS.objc_msgSend(this.window.id, OS.sel__setNeedsToUseHeartBeatWindow_, 0);
                }
            } else {
                boolean parentMinimized;
                boolean bl = parentMinimized = this.parent != null && ((Shell)this.parent).window.isMiniaturized();
                if (!parentMinimized) {
                    if (key) {
                        this.makeKeyAndOrderFront();
                    } else {
                        this.window.orderFront(null);
                    }
                }
            }
            this.updateParent(visible);
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.updateParent(visible);
            if ((this.style & 0x10000000) != 0) {
                NSApplication application = NSApplication.sharedApplication();
                application.endSheet(this.window, 0);
            }
            this.window.orderOut(null);
            this.topView().setHidden(true);
            this.invalidateVisibleRegion();
            this.sendEvent(23);
        }
        this.display.updateQuitMenu();
    }

    void setZOrder() {
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
        if (this.window == null) {
            return;
        }
        this.window.setContentView(this.scrollView != null ? this.scrollView : this.view);
        if (this.fixResize()) {
            NSRect rect = this.window.frame();
            rect.y = 0.0f;
            rect.x = 0.0f;
            this.window.contentView().setFrame(rect);
        }
    }

    void setZOrder(Control control, boolean above) {
        if (this.window == null) {
            return;
        }
        if (control == null) {
            if (above) {
                this.window.orderFront(null);
            } else {
                this.window.orderBack(null);
            }
        } else {
            NSWindow otherWindow = control.getShell().window;
            this.window.orderWindow(above ? 1 : -1, otherWindow.windowNumber());
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
    }

    void updateParent(boolean visible) {
        if (visible) {
            if (this.parent != null && this.parent.getVisible()) {
                ((Shell)this.parent).window.addChildWindow(this.window, 1);
            }
        } else {
            NSWindow parentWindow = this.window.parentWindow();
            if (parentWindow != null) {
                parentWindow.removeChildWindow(this.window);
            }
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell.parent == this && shell.getVisible()) {
                shell.updateParent(visible);
            }
            ++i;
        }
    }

    void updateSystemUIMode() {
        if (!this.getMonitor().equals(this.display.getPrimaryMonitor())) {
            return;
        }
        if (this.fullScreen) {
            int mode = 3;
            if (this.menuBar != null) {
                mode = 2;
            }
            int[] uiMode = new int[1];
            OS.GetSystemUIMode(uiMode, null);
            if (uiMode[0] != mode) {
                OS.SetSystemUIMode(mode, 0);
            }
            this.window.setFrame(this.fullScreenFrame, true);
        } else {
            int[] uiMode = new int[1];
            OS.GetSystemUIMode(uiMode, null);
            if (uiMode[0] != 0) {
                OS.SetSystemUIMode(0, 0);
            }
        }
    }

    int view_stringForToolTip_point_userData(int id2, int sel, int view, int tag, int point, int userData) {
        NSPoint pt = new NSPoint();
        OS.memmove(pt, point, NSPoint.sizeof);
        Control control = this.display.findControl(false);
        if (control == null) {
            return 0;
        }
        Widget target = control.findTooltip(new NSView(view).convertPoint_toView_(pt, null));
        String string = target.tooltipText();
        if (string == null) {
            return 0;
        }
        char[] chars = new char[string.length()];
        string.getChars(0, chars.length, chars, 0);
        int length = this.fixMnemonic(chars);
        return NSString.stringWithCharacters((char[])chars, (int)length).id;
    }

    void windowDidBecomeKey(int id2, int sel, int notification) {
        super.windowDidBecomeKey(id2, sel, notification);
        Display display = this.display;
        display.setMenuBar(this.menuBar);
        this.sendEvent(26);
        if (this.isDisposed()) {
            return;
        }
        Shell parentShell = this;
        while (parentShell.parent != null) {
            parentShell = (Shell)parentShell.parent;
            if (parentShell.fullScreen) break;
        }
        if (!parentShell.fullScreen || this.menuBar != null) {
            this.updateSystemUIMode();
        } else {
            parentShell.updateSystemUIMode();
        }
    }

    void windowDidMove(int id2, int sel, int notification) {
        this.moved = true;
        this.sendEvent(10);
    }

    void windowDidResize(int id2, int sel, int notification) {
        if (this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
            this.window.contentView().setFrame(this.fullScreenFrame);
        }
        if (this.fixResize()) {
            NSRect rect = this.window.frame();
            rect.y = 0.0f;
            rect.x = 0.0f;
            this.window.contentView().setFrame(rect);
        }
        this.resized = true;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void windowDidResignKey(int id2, int sel, int notification) {
        super.windowDidResignKey(id2, sel, notification);
        this.sendEvent(27);
    }

    void windowSendEvent(int id2, int sel, int event) {
        NSEvent nsEvent = new NSEvent(event);
        int type = nsEvent.type();
        switch (type) {
            case 2: 
            case 4: 
            case 5: 
            case 26: {
                NSView[] hitView = new NSView[1];
                Control control = this.display.findControl(false, hitView);
                if (!(control == null || control.isActive() && control.isEnabled())) {
                    control = null;
                }
                if (type == 5) {
                    Control trimControl = control;
                    if (trimControl != null && trimControl.isTrim(hitView[0])) {
                        trimControl = null;
                    }
                    this.display.checkEnterExit(trimControl, nsEvent, false);
                    if (trimControl != null) {
                        trimControl.sendMouseEvent(nsEvent, type, false);
                    }
                }
                Widget target = null;
                if (control != null) {
                    target = control.findTooltip(nsEvent.locationInWindow());
                }
                if (this.display.tooltipControl != control || this.display.tooltipTarget != target) {
                    Shell shell;
                    Control oldControl = this.display.tooltipControl;
                    Shell oldShell = oldControl != null && !oldControl.isDisposed() ? oldControl.getShell() : null;
                    Shell shell2 = shell = control != null && !control.isDisposed() ? control.getShell() : null;
                    if (oldShell != null) {
                        oldShell.sendToolTipEvent(false);
                    }
                    if (shell != null) {
                        shell.sendToolTipEvent(true);
                    }
                }
                this.display.tooltipControl = control;
                this.display.tooltipTarget = target;
                break;
            }
            case 10: {
                NSString chars;
                if ((nsEvent.modifierFlags() & 0x40000) == 0 || (chars = nsEvent.characters()) == null || chars.length() != 1) break;
                int firstChar = chars.characterAtIndex(0);
                switch (firstChar) {
                    case 9: 
                    case 25: 
                    case 63276: 
                    case 63277: {
                        this.window.firstResponder().keyDown(nsEvent);
                        return;
                    }
                }
            }
        }
        super.windowSendEvent(id2, sel, event);
    }

    boolean windowShouldClose(int id2, int sel, int window) {
        this.closeWidget();
        return false;
    }
}

