/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        String fullPath = null;
        this.fileNames = new String[0];
        int method = 0;
        int methodImpl = 0;
        Callback callback = null;
        if ((this.style & 0x2000) != 0) {
            NSSavePanel savePanel;
            this.panel = savePanel = NSSavePanel.savePanel();
            if (!this.overwrite) {
                callback = new Callback(this, "_overwriteExistingFileCheck", 3);
                int proc = callback.getAddress();
                if (proc == 0) {
                    this.error(3);
                }
                if ((method = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck)) != 0) {
                    methodImpl = OS.method_setImplementation(method, proc);
                }
            }
        } else {
            NSOpenPanel openPanel = NSOpenPanel.openPanel();
            openPanel.setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = openPanel;
        }
        this.panel.setCanCreateDirectories(true);
        OS.objc_msgSend(this.panel.id, OS.sel_setShowsHiddenFiles_, true);
        int jniRef = 0;
        SWTPanelDelegate delegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            jniRef = OS.NewGlobalRef(this);
            if (jniRef == 0) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
            this.panel.setDelegate(delegate);
            NSPopUpButton widget = (NSPopUpButton)new NSPopUpButton().alloc();
            widget.initWithFrame(new NSRect(), false);
            widget.setTarget(delegate);
            widget.setAction(OS.sel_sendSelection_);
            NSMenu menu = widget.menu();
            menu.setAutoenablesItems(false);
            int i = 0;
            while (i < this.filterExtensions.length) {
                String str = this.filterExtensions[i];
                if (this.filterNames != null && this.filterNames.length > i) {
                    str = this.filterNames[i];
                }
                NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
                nsItem.initWithTitle(NSString.stringWith(str), 0, NSString.stringWith(""));
                menu.addItem(nsItem);
                nsItem.release();
                ++i;
            }
            widget.selectItemAtIndex(this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0);
            widget.sizeToFit();
            this.panel.setAccessoryView(widget);
            this.popup = widget;
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        NSApplication application = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            application.beginSheet(this.panel, this.parent.window, null, 0, 0);
        }
        NSString dir = this.filterPath != null ? NSString.stringWith(this.filterPath) : null;
        NSString file = this.fileName != null ? NSString.stringWith(this.fileName) : null;
        int response = this.panel.runModalForDirectory(dir, file);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            application.endSheet(this.panel, 0);
        }
        if (!this.overwrite) {
            if (method != 0) {
                OS.method_setImplementation(method, methodImpl);
            }
            if (callback != null) {
                callback.dispose();
            }
        }
        if (response == 1) {
            NSString filename = this.panel.filename();
            fullPath = filename.getString();
            if ((this.style & 0x2000) == 0) {
                NSArray filenames = ((NSOpenPanel)this.panel).filenames();
                int count = filenames.count();
                this.fileNames = new String[count];
                int i = 0;
                while (i < count) {
                    filename = new NSString(filenames.objectAtIndex(i));
                    NSString filenameOnly = filename.lastPathComponent();
                    NSString pathOnly = filename.stringByDeletingLastPathComponent();
                    if (i == 0) {
                        this.filterPath = pathOnly.getString();
                        this.fileName = this.fileNames[0] = filenameOnly.getString();
                    } else {
                        this.fileNames[i] = pathOnly.getString().equals(this.filterPath) ? filenameOnly.getString() : filename.getString();
                    }
                    ++i;
                }
            }
            this.filterIndex = -1;
        }
        if (this.popup != null) {
            this.filterIndex = this.popup.indexOfSelectedItem();
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (delegate != null) {
            this.panel.setDelegate(null);
            delegate.release();
        }
        if (jniRef != 0) {
            OS.DeleteGlobalRef(jniRef);
        }
        this.panel = null;
        return fullPath;
    }

    int _overwriteExistingFileCheck(int id2, int sel, int str) {
        return 1;
    }

    int panel_shouldShowFilename(int id2, int sel, int arg0, int arg1) {
        NSString path = new NSString(arg1);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager manager = NSFileManager.defaultManager();
            int ptr = OS.malloc(1);
            boolean found = manager.fileExistsAtPath(path, ptr);
            byte[] isDirectory = new byte[1];
            OS.memmove(isDirectory, ptr, 1);
            OS.free(ptr);
            if (found) {
                if (isDirectory[0] != 0) {
                    return 1;
                }
                NSString ext = path.pathExtension();
                if (ext != null) {
                    int filterIndex = this.popup.indexOfSelectedItem();
                    String extension = ext.getString();
                    String extensions = this.filterExtensions[filterIndex];
                    int start = 0;
                    int length = extensions.length();
                    while (start < length) {
                        String filter;
                        int index = extensions.indexOf(59, start);
                        if (index == -1) {
                            index = length;
                        }
                        if ((filter = extensions.substring(start, index).trim()).equals("*") || filter.equals("*.*")) {
                            return 1;
                        }
                        if (filter.startsWith("*.")) {
                            filter = filter.substring(2);
                        }
                        if (filter.toLowerCase().equals(extension.toLowerCase())) {
                            return 1;
                        }
                        start = index + 1;
                    }
                }
                return 0;
            }
        }
        return 1;
    }

    void sendSelection(int id2, int sel, int arg) {
        this.panel.validateVisibleColumns();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

