/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.antsupport.logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.ExternalHyperlink;
import org.eclipse.ant.internal.ui.antsupport.AntSupportMessages;
import org.eclipse.ant.internal.ui.antsupport.logger.NullBuildLogger;
import org.eclipse.ant.internal.ui.antsupport.logger.util.AntDebugState;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.ant.internal.ui.launchConfigurations.TaskLinkManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.console.IHyperlink;

public class AntProcessBuildLogger
extends NullBuildLogger {
    private File fBuildFileParent = null;
    private long fStartTime;
    private Map fFileNameToIFile = new HashMap();
    private AntProcess fProcess = null;

    protected void logMessage(String message, BuildEvent event, int overridePriority) {
        int priority = overridePriority;
        if (priority == -1) {
            priority = event.getPriority();
        }
        if (priority > this.getMessageOutputLevel()) {
            return;
        }
        AntProcess antProcess = this.getAntProcess(this.fProcessId);
        if (antProcess == null) {
            return;
        }
        StringBuffer fullMessage = new StringBuffer();
        if (!this.loggingToLogFile()) {
            fullMessage.append(System.getProperty("line.separator"));
        }
        if (event.getException() == null && event.getTask() != null && !this.fEmacsMode) {
            this.adornMessage(event, fullMessage);
        } else {
            fullMessage.append(message);
        }
        message = fullMessage.toString();
        if (this.loggingToLogFile()) {
            this.logMessageToLogFile(message, priority);
        } else {
            AntStreamMonitor monitor = this.getMonitor(priority);
            monitor.append(message);
        }
    }

    private void adornMessage(BuildEvent event, StringBuffer fullMessage) {
        block6: {
            String name = event.getTask().getTaskName();
            if (name == null) {
                name = "null";
            }
            Location location = event.getTask().getLocation();
            StringBuffer column = new StringBuffer();
            int size = 15 - (name.length() + 3);
            int i = 0;
            while (i < size) {
                column.append(' ');
                ++i;
            }
            StringBuffer labelBuff = new StringBuffer();
            labelBuff.append('[');
            labelBuff.append(name);
            labelBuff.append("] ");
            int offset = Math.max(size, 0) + 1;
            String label = labelBuff.toString();
            if (event.getMessage() == null) {
                return;
            }
            try {
                BufferedReader r = new BufferedReader(new StringReader(event.getMessage()));
                String line = r.readLine();
                fullMessage.append(column);
                this.appendAndLink(fullMessage, location, label, offset, line);
                line = r.readLine();
                while (line != null) {
                    fullMessage.append(System.getProperty("line.separator"));
                    fullMessage.append(column);
                    this.appendAndLink(fullMessage, location, label, offset, line);
                    line = r.readLine();
                }
            }
            catch (IOException iOException) {
                if (event.getMessage() == null) break block6;
                fullMessage.append(label).append(event.getMessage());
            }
        }
    }

    private void appendAndLink(StringBuffer fullMessage, Location location, String label, int offset, String line) {
        fullMessage.append(label);
        fullMessage.append(line);
        if (location != null) {
            String newLine = (String.valueOf(label) + line).trim();
            Region region = new Region(offset, label.length() - 3);
            IHyperlink link = this.getLocationLink(location);
            if (link != null) {
                TaskLinkManager.addTaskHyperlink((IProcess)this.getAntProcess(this.fProcessId), (IHyperlink)link, (IRegion)region, (String)newLine);
            }
        }
    }

    private AntStreamMonitor getMonitor(int priority) {
        AntStreamsProxy proxy = (AntStreamsProxy)this.fProcess.getStreamsProxy();
        AntStreamMonitor monitor = null;
        switch (priority) {
            case 2: {
                monitor = (AntStreamMonitor)proxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                monitor = (AntStreamMonitor)proxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                monitor = (AntStreamMonitor)proxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                monitor = (AntStreamMonitor)proxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                monitor = (AntStreamMonitor)proxy.getVerboseStreamMonitor();
            }
        }
        return monitor;
    }

    private void logMessageToLogFile(String message, int priority) {
        if (priority == 0) {
            this.getErrorPrintStream().println(message);
        } else {
            this.getOutputPrintStream().println(message);
        }
    }

    private IHyperlink getLocationLink(Location location) {
        if (location != null && !location.equals((Object)Location.UNKNOWN_LOCATION)) {
            try {
                String fileName = location.getFileName();
                IFile file = (IFile)this.fFileNameToIFile.get(fileName);
                int lineNumber = location.getLineNumber();
                if (file != null) {
                    return new FileLink(file, null, -1, -1, lineNumber);
                }
                file = AntUtil.getFileForLocation((String)fileName, (File)this.fBuildFileParent);
                if (file != null) {
                    this.fFileNameToIFile.put(fileName, file);
                    return new FileLink(file, null, -1, -1, lineNumber);
                }
                File javaIOFile = FileUtils.newFileUtils().resolveFile(this.fBuildFileParent, fileName);
                if (javaIOFile.exists()) {
                    return new ExternalHyperlink(javaIOFile, lineNumber);
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                return AntUtil.getLocationLink((String)location.toString(), (File)this.fBuildFileParent);
            }
        }
        return null;
    }

    protected AntProcess getAntProcess(String processId) {
        if (this.fProcess == null && processId != null) {
            IProcess[] all = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int i = 0;
            while (i < all.length) {
                IProcess process = all[i];
                if (process instanceof AntProcess && processId.equals(process.getAttribute("org.eclipse.ant.core.ANT_PROCESS_ID"))) {
                    this.fProcess = (AntProcess)process;
                    break;
                }
                ++i;
            }
        }
        return this.fProcess;
    }

    public void buildStarted(BuildEvent event) {
        this.fStartTime = System.currentTimeMillis();
    }

    public void buildFinished(BuildEvent event) {
        String message = this.handleException(event);
        if (message != null) {
            try {
                BufferedReader r = new BufferedReader(new StringReader(message));
                String line = r.readLine();
                this.logMessage(line, event, 0);
                line = r.readLine();
                AntProcess antProcess = this.getAntProcess(this.fProcessId);
                while (line != null) {
                    this.logMessage(line, event, 0);
                    if (!message.startsWith("Total time:")) {
                        AntUtil.linkBuildFailedMessage((String)line, (IProcess)antProcess);
                    }
                    line = r.readLine();
                }
                this.logMessage("", event, 0);
            }
            catch (IOException iOException) {}
        }
        this.fHandledException = null;
        this.fBuildFileParent = null;
        if (!(event.getException() instanceof OperationCanceledException)) {
            this.logMessage(this.getTimeString(System.currentTimeMillis() - this.fStartTime), event, this.fMessageOutputLevel);
        }
        this.fProcess = null;
        event.getProject().removeBuildListener((BuildListener)this);
        this.fFileNameToIFile = null;
    }

    private String getTimeString(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        StringBuffer result = new StringBuffer(AntSupportMessages.AntProcessBuildLogger_Total_time);
        if (minutes > 0L) {
            result.append(minutes);
            if (minutes > 1L) {
                result.append(AntSupportMessages.AntProcessBuildLogger__minutes_2);
            } else {
                result.append(AntSupportMessages.AntProcessBuildLogger__minute_3);
            }
        }
        if (seconds > 0L) {
            if (minutes > 0L) {
                result.append(' ');
            }
            result.append(seconds);
            if (seconds > 1L) {
                result.append(AntSupportMessages.AntProcessBuildLogger__seconds_4);
            } else {
                result.append(AntSupportMessages.AntProcessBuildLogger__second_5);
            }
        }
        if (seconds == 0L && minutes == 0L) {
            result.append(milliseconds);
            result.append(AntSupportMessages.AntProcessBuildLogger__milliseconds_6);
        }
        result.append(System.getProperty("line.separator"));
        return result.toString();
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() > this.getMessageOutputLevel()) {
            return;
        }
        if (event.getMessage() != null && event.getMessage().length() > 0) {
            this.logMessage(event.getMessage(), event, -1);
        }
    }

    public void targetStarted(BuildEvent event) {
        if (2 > this.getMessageOutputLevel()) {
            return;
        }
        Target target = event.getTarget();
        StringBuffer msg = new StringBuffer(System.getProperty("line.separator"));
        String targetName = target.getName();
        msg.append(targetName);
        msg.append(':');
        String message = msg.toString();
        Location location = AntDebugState.getLocation(target);
        if (location != null && location != Location.UNKNOWN_LOCATION) {
            Region region = new Region(0, targetName.length());
            IHyperlink link = this.getLocationLink(location);
            if (link != null) {
                TaskLinkManager.addTaskHyperlink((IProcess)this.getAntProcess(this.fProcessId), (IHyperlink)link, (IRegion)region, (String)message.trim());
            }
        }
        this.logMessage(message, event, 2);
    }

    private boolean loggingToLogFile() {
        return this.getErrorPrintStream() != null && this.getErrorPrintStream() != System.err;
    }
}

